/* Beispiel fr die Einbinden der CoMa-FAX-Treiber-Routinen in eigene Programme */
/* 25.10.93 by SOFTBR */

#include "coma_drv.h"
#include <aes.h>
#include <stdio.h>
#include <string.h>

/**********************************************************/
/*                                                        */
/*           Fax-Seiten erstellen mit foldername          */
/*                                                        */
/**********************************************************/
main ()
  {
  long page, line;
  char pixelline[216]; /* 1728 Pixel pro Zeile */
  
  coma_clear_folder("F:\\FAX\\OUTGOING");
  for (page=0; page<2; page++)
    {
    if (coma_open_file("F:\\FAX\\OUTGOING", "MAGNUM") != 0)
      {
      form_alert(1, "[1][FAX-Datei kann nicht geffnet werden][ OK ]");
      return -1;
      }
    else
      {
      memset(pixelline, 0, 216);
      for (line=0; line < 2200; line++)
        {
        pixelline[line>>4] |= (0x80>>((line>>1) & 0x7)); /* Dialonale erzeugen */
        coma_pixelline(pixelline);
        }
      coma_close_file();
      }
    }
  return 0;
  }

/*
/**********************************************************/
/*                                                        */
/*     Fax-Seiten erstellen mit Envoironmentvariable      */
/*                                                        */
/**********************************************************/
main ()
  {
  int  ret;
  long page, line;
  char pixelline[216]; /* 1728 Pixel pro Zeile */
  
  coma_clear_folder(NULL); 
  for (page=0; page<2; page++)
    {
    if ((ret = coma_open_file(NULL, "MAGNUM")) != 0)
      {
      if (ret == NO_PATH)
        form_alert(1, "[1][COMA_OUT-Variable nicht gesetzt][ OK ]");
      else  
        form_alert(1, "[1][FAX-Datei kann nicht geffnet werden][ OK ]");
      return -1;
      }
    else
      {
      memset(pixelline, 0, 216);
      for (line=0; line < 2200; line++)
        {
        pixelline[line>>4] |= (0x80>>((line>>1) & 0x7)); /* Dialonale erzeugen */
        coma_pixelline(pixelline);
        }
      coma_close_file();
      }
    }
  return 0;
  }
*/
