#ifndef _TAPDEF
#define _TAPDEF
//
// TAP.H
//
// TAP
// File Transfer Data Sharing
// Shared Header
// Revision 1.10
//
// 12/28/94   First created
//  4/24/95   Structures aligned with DWORDS
//            Dynamic extension lists added
//

// #DEFINE for INI Application name
#define TAP_INI_APPNAME "TAP Applications"

// DEFINEs for iFlags of TAPINFO
#define TAP_EMERGENCY_CLOSE  0x0001 // Upon receiving this message the file must be immediately closed
#define TAP_CANCEL           0x0002 // File transfer cancelled, file being transferred is aborted
#define TAP_EOF              0x0004 // End of file, file being transferred is now complete
#define TAP_BOF              0x0008 // Begin of file, this is the first information about a new file
#define TAP_EOB              0x0010 // End of batch, transfer is now complete, Application should close pipe *
#define TAP_NEW_SIZE         0x0020 // Set when the current file size has changed
#define TAP_VERSION     	  0x4000 // Version packet
#define TAP_ACKNOWLEDGE      0x8000 // Set to indicate that acknowledgement is requested
												//
												// * This flag means the pipe should be closed because no more files
												//   will be transferred
// DEFINEs for file size
#define TAP_SIZE_UNKNOWN 	-1    // File size will be -1 if unknown

typedef union _TAPPACKET {

	// This structure is used for TAP_EMERGENCY_CLOSE, TAP_EOF, TAP_EOB, and TAP_ACKNOWLEDGE

	struct {
		USHORT cb;                      // Number of bytes in the structure
		USHORT usFlags;                 // Flags, [ TAP_EMERGENCY_CLOSE, TAP_EOF, TAP_EOB, TAP_ACKNOWLEDGE ]
		} flagPacket;

	// This structure is used for TAP_NEW_SIZE 

	struct {
		USHORT cb;                      // Number of bytes in the structure
		USHORT usFlags;                 // Flags, TAP_NEW_SIZE | [ TAP_EMERGENCY_CLOSE, TAP_EOF, TAP_EOB, TAP_ACKNOWLEDGE, ]
		LONG   lCurrentFileSize;        // Partial current size of the file
		LONG   lCompleteFileSize;       // Size the file will be when complete (-1 if unknown)
		} newSizePacket;

	// This structure is used for TAP_BOF

	struct {
		USHORT cb;                      // Number of bytes in the structure
		USHORT usFlags;                 // Flags, TAP_BOF | [ TAP_ACKNOWLEDGE, ]
		LONG   lCurrentFileSize;        // Partial current size of the file
		LONG   lCompleteFileSize;       // Size the file will be when complete (-1 if unknown)
		USHORT usFileNameLength;		  // Length of file name string
		UCHAR  szFileName[1];           // Fully qualified file name
		} beginFilePacket;

	// This structure is used for TAP_VERSION

	struct {
		USHORT  cb;                      // Number of bytes in the structure
		USHORT  usFlags;                 // Flags, TAP_VERSION | [ TAP_ACKNOWLEDGE, ]
		USHORT  usVersionLength;			// Length of version string	
		UCHAR   szVersion[1];            // Version string
		} versionPacket;

} TAPPACKET, *PTAPPACKET;

typedef struct _EXTENSIONLIST
{
   ULONG cb;                      // Number of bytes in the structure

   UCHAR szExtension[1];         // Extension handled by this application (of variable size)
                                 // Here, a size of 1 is used to compensate for the NULL
                                 // terminator.
} EXTENSIONLIST, *PEXTENSIONLIST;

typedef struct _TAPAPPENTRY
{
	ULONG cb;	   					// Number of bytes in this structure,
                                 // including following EXTENSIONLISTs

	UCHAR szDescription[256];     // Description of this TAP application
	UCHAR szProgram[CCHMAXPATH];  // Fully qualified path and executable
	UCHAR szParams[84];           // Command line parameters
	ULONG ulExtensions;           // Number of EXTENSIONLISTs that follow

   // Extensions handled by this application
	// will follow in memory
} TAPAPPENTRY, *PTAPAPPENTRY;

#endif
