/* REXX script to automatically call BBS, log on, download OS2NEW.ZIP, then log off. */

/* clear screen  */
'CLS'

/* set variables */

USER_NAME="XXXXX XXXXXXX"       /* your name as registered with the BBS (put in quotes) */
PASSWORD="XXXX"                 /* your password as registered with the BBS (put in quotes) */
BBS_NUM="#-###-###-####"        /* the BBS phone number (put in quotes) */
MIN_SPEED=#####                 /* minimum connect speed you'll accept (NO QUOTES) */
MAX_ATTEMPTS=#                  /* maximum number of times to retry the call (NO QUOTES) */

DO CALL_BBS=1 TO MAX_ATTEMPTS

  /* clear screen */
  'CLS'

  /* initialize modem */
  SEND 'ATZ1^M'
  DELAY 1

  SAY "Attempt # " CALL_BBS 

  SAY "Calling the OS/2 Shareware BBS to download OS2NEW.ZIP.  Dialing...." BBS_NUM

  'TIMEOUT 60'

  DIAL BBS_NUM '^IOS/2 Shareware'

      /* let's see what kind of response we get */
      DO RESULT_TYPE=1 TO 6

         /* receive next line of text */
         'GETLINE'

         /* if no answer, try again (leave loop) */
         IF RC=640 THEN 
         DO
            HANGUP
            LEAVE RESULT_TYPE
         END
         
         /* if BUSY was received, try again (leave loop) */
         IF ZOCLASTLINE()=="BUSY" THEN
         DO
	    DELAY 1
	    SAY "The line is busy.  We'll try again."
            LEAVE RESULT_TYPE
         END

         /* if NO DIAL TONE was received, end with error message */
         IF ZOCLASTLINE()=="NO DIAL TONE" THEN 
         DO
	    DELAY 1
            SAY "Possible hardware or software trouble.  Aborting attempt."
            EXIT
         END

         /* if NO CARRIER was received, end with error message */
         IF ZOCLASTLINE()=="NO CARRIER" THEN 
         DO
            HANGUP
            SAY "Possible dialing error.  Check phone number."
            EXIT
         END

         /* determine the connect speed */
         DO B=9 TO 15
           IF SUBSTR(ZOCLASTLINE(),B,1)="/" THEN
           DO 
              B=B-9
              LEAVE B
           END
         END B
         SPEED=SUBSTR(ZOCLASTLINE(),9,B)
         IF SPEED<MIN_SPEED THEN 
         DO
            HANGUP
            ASK '"Connect speed is too slow!"' '"Do you want to try again?"'
            IF ZOCRESULT()="##CANCEL##" THEN
            DO              
               EXIT
            END
            ELSE LEAVE RESULT_TYPE
         END
         ELSE LEAVE CALL_BBS

      END RESULT_TYPE

      NOTIFY "Pausing for 30 seconds."
      DELAY 30

END CALL_BBS

IF CALL_BBS=MAX_ATTEMPTS+1 THEN
DO
   NOTIFY "Can't get through now.....try again later."
   'CLS'
   EXIT
END

WAIT 'your name:'
SEND USER_NAME '^M'

WAIT SUBSTR(USER_NAME,LENGTH(USER_NAME)-2,3)' [Y,n]?'
SEND 'y^M'

WAIT 'Password:'
SEND PASSWORD '^M'

WAIT 'o continue'
SEND '^M'

WAIT 'e [Y,n,=]?'
SEND 'N^M'

WAIT 'Select: '
SEND 'F^M'

WAIT 'Select: '
SEND 'D^M'

WAIT 'load (#1):'
SEND 'OS2NEW.ZIP^M'

WAIT 'load (#2):'
SEND '/G^M'

WAIT '<esc> to abort:'
SEND '^M'