/**************************************************************
 *                                                            *
 *                   MainActor Rexx Script                    *
 *                                                            *
 *  Selects every xth frame. The interval is requested from   *
 *  the user                                                  *
 *                                                            *
 *  Example: If x=4, frames 1,4,8,12,16 ... will be selected  *
 *                                                            *
 *  Last modified: 10/10/97, Written by: Markus Moenig        *
 *                                                            *
 **************************************************************/

  say "This script selects every xth frame in the currently loaded project."

  IF GetGlobalInfo("LOADEDPROJECTS")= "0" THEN DO     /* Check if there are */
   BEGIN                                              /* any projects loaded */
    say "No project loaded! Exiting ..."              /* Failed, exiting ... */
    exit
   END

  DeselectAll()                                       /* Deselects all frames */

  say "Please enter the interval:"
  pull x                                              /* Request X to be entered */

  frames=GetProjectInfo("FRAMES")                     /* Total number of frames */

  i=1; SelectFrame( i )                               /* Select the first frame */
  say "Selecting frames ..."
  DO WHILE i*x <= frames                              /* Select the frames ... */
   BEGIN
     SelectFrame( i * x )
     i=i+1
   END
  say "finished!"