# Makefile for DIMP version 0.9
# Look at the comments after *** to generate the statistical version of the
# player.

# C Compiler
CC            = icc

# C Compiler flags
#*** Add /DANALYSIS to gather stats ***
CFLAGS =        /Q+ /W3 /G4 /Ge+d-m+ /J- /Gf+ /Ss /Gi+ 

.c.obj:
		$(CC) /C+ $(CFLAGS) $*.c

# Source
SRCS          = dimp.c

# Object files
OBJS =          $(SRCS:.c=.obj)

# Final executable
dimp.exe:  dimp.res video.lib dither.lib $(OBJS) dimp.def
		link386  /NOI /BATCH /NOLOGO /DE /MAP /BASE:0x10000 /ALIGN:16 \
		/EXEPACK $(OBJS:.obj=),dimp.exe,, \
		os2386.lib+mmpm2.lib+video.lib+dither.lib,dimp.def

#*** Add -dANALYSIS to gather stats ***
	   rc  dimp.res dimp.exe

# Resources
dimp.res:
#*** Add -dANALYSIS to gather stats ***
	   rc -r dimp.rc

# Import libraries
#*** Replace video.def by video2.def to gather stats ***
video.lib:  
            implib video.lib video.def

dither.lib:  
            implib dither.lib dither.def