/* DIMP version 0.9, a multithreaded MPEG-player for OS/2 Warp 3.0 using DIVE
 * written by:
 *
 * Peter Van Geit
 * vg@iris.elis.rug.ac.be
 *
 * See the accompanying readme.txt file for more information
 */

#define INCL_DOS
#define INCL_GPI
#define INCL_WIN
#include <os2.h>
#include <sys/types.h>

#include <stdio.h>
#include <stdlib.h>
#define  _MEERROR_H_
#include <mmioos2.h>
#include <dive.h>
#include <fourcc.h>

#include "dimp.h"
#include "pvgdith.h"
#include "pvgvideo.h"

#define WM_USER_POSITION    WM_USER + 1
#define WM_SHOWSTAT         WM_USER + 2
#define WM_SHOWALL          WM_USER + 3
#define WM_NEWTEXT          WM_USER + 4
#define WM_NOSHOW           WM_USER + 5
#define WM_DOSHOW           WM_USER + 6
#define WM_NOLOOP           WM_USER + 7
#define WM_DOLOOP           WM_USER + 8

/* needed for drawing about dialog box */
#define DB_RAISED       0x0400
#define DB_DEPRESSED    0x0800

/* Define buffer length. */

#define BUF_LENGTH 80000

/* Function return type declarations */
void usage();

/* PVG */
static int ditherType;
static int oldDitherType;
static int lum_range, cr_range, cb_range;
static VidStream *theVidStream;
static char fileName[80];
static FILE *fin;
static int h_size, v_size;
static unsigned char * frame;
static char * ditherFlags; /* used when ditherType == MBORDERED_DITHER */
static int nob=0, nop=0;

static int condition = ID_NONE;

/* Loop flag. */
static int loop = 0;

/* Quiet flag. */
static int quiet = 0;

/* Display image on screen ? */
static int noDisplay = 0;

DIVE_CAPS DiveCaps = {0};
FOURCC    fccFormats[100] = {0};

MRESULT EXPENTRY MyWindowProc ( HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY ToolBarDlgProc (HWND,ULONG,MPARAM,MPARAM);
MRESULT EXPENTRY DiveDlgProc ( HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY MpegDlgProc ( HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY UsageDlgProc ( HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY AboutDlgProc (HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2);

#ifdef ANALYSIS

MRESULT EXPENTRY OneStatDlgProc ( HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY AllStatDlgProc ( HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2 );

static void ShowOneStat();
static void ShowAllStats();

#endif


/* Global definitions */

HAB   hab;                             /* PM anchor block handle            */
ULONG ulImage;                         /* Image buffer numbers from Dive    */
PBYTE pPalette=NULL, pPal2=NULL;       /* Pointer to bitmap palette area    */
PSZ   pszMyWindow = "MyWindow";        /* Window class name                 */
CHAR   pszTitleText [64];              /* Title bar text                    */
ULONG ulToEnd = 0;                     /*                                   */
PWINDATA  pwinData;                    /* Pointer to window data            */

/* Needed for DIVE-calls */

   ULONG ulNumBytes;            /* output for number of bytes actually read */
   PBYTE pbBuffer;              /* pointer to the image/ temp. palette data */
   ULONG ulScanLineBytes;       /* output for number of bytes a scan line   */
   ULONG ulScanLines;           /* output for height of the buffer          */
   PBYTE pbTmp1, pbTmp2;

/******************* usage() *****************/
void usage(s)
char *s;        /* program name */
{
   WinDlgBox ( HWND_DESKTOP, pwinData->hwndClient,
	      UsageDlgProc, (HMODULE)0,
	      IDD_USAGE, (PVOID)pwinData );

}

/********************************************/


VOID APIENTRY Decode ( ULONG parm1 )
   {
   ULONG    ulTime0, ulTime1;     /* output buffer for DosQierySysInfo      */
   ULONG    ulFramesToTime=8;     /* Interval of frames to get time         */
   ULONG    ulNumFrames=0;        /* Frame counter                          */
   CHAR     achFrameRate[32];     /* string buffer for WinSetWindowText     */
   int      status;

   PWINDATA pwinData;             /* pointer to window data                 */


   pwinData =(PWINDATA)parm1;

   do
      {
     do {
      /* Check if it's time to start the blit-time counter. */

      if ( !ulNumFrames )
	 DosQuerySysInfo ( QSV_MS_COUNT, QSV_MS_COUNT, &ulTime0, 4L );

      /* PVG: decode next frame & transfer to DIVE-allocated buffer */
      status = mpegVidRsrc(0, theVidStream, &ditherFlags); /* decode next picture */
      
      switch (status) {
      case MPEG_MB_QUANTUM: break;
      case MPEG_SLICE: break;
      case MPEG_FRAME_SKIP: break;
      case MPEG_FRAME_DISP:
	ulNumFrames++;
      if (ditherType != NO_DITHER) {
	DiveBeginImageBufferAccess(pwinData->hDive, ulImage,
		  &pbBuffer, &ulScanLineBytes, &ulScanLines);
	DoDitherImage(theVidStream->current->luminance, theVidStream->current->Cr,
		      theVidStream->current->Cb, (unsigned char*) pbBuffer,
		      theVidStream->mb_height*16, theVidStream->mb_width*16, ditherFlags);
	DiveEndImageBufferAccess(pwinData->hDive, ulImage);

	if (!noDisplay) {
	  DiveBlitImage ( pwinData->hDive,  ulImage, DIVE_BUFFER_SCREEN );
	}
      }
	break;
      case MPEG_FRAME_NODISP: break;
      case MPEG_ERROR: break;
      case MPEG_DONE_DISP:
	ulNumFrames++;
      if (ditherType != NO_DITHER) {
	DiveBeginImageBufferAccess(pwinData->hDive, ulImage,
		  &pbBuffer, &ulScanLineBytes, &ulScanLines);
	DoDitherImage(theVidStream->current->luminance, theVidStream->current->Cr,
		      theVidStream->current->Cb, (unsigned char*) pbBuffer,
		      theVidStream->mb_height * 16, theVidStream->mb_width * 16, ditherFlags);
	DiveEndImageBufferAccess(pwinData->hDive, ulImage);

	if (!noDisplay) {
	  DiveBlitImage ( pwinData->hDive,  ulImage, DIVE_BUFFER_SCREEN );
	}
      }
	/* no break */
      case MPEG_DONE_NODISP:
	  DestroyVidStream(theVidStream);
	  if (!loop) {
	    condition = ID_END;
	    return; /* this was the last frame */
	  }
	  else { /* if looping */
	    ResetVidStream();
	    theVidStream = NewVidStream(fileName, BUF_LENGTH, loop, quiet, noDisplay,
			      ditherType);
	    mpegVidRsrc(0, theVidStream, &ditherFlags);
	  }

	break;

      } /* switch */

      /* Check to see if we have enough frames for a fairly accurate read. */

      if ( ulNumFrames>=ulFramesToTime )
	 {
	 DosQuerySysInfo ( QSV_MS_COUNT, QSV_MS_COUNT, &ulTime1, 4L );
	 ulTime1 -= ulTime0;
	 if ( ulTime1 )
	    sprintf ( achFrameRate, "%5.2f frames per second.",
			(float)ulFramesToTime * 1000.0 / (float)ulTime1 );
	 else
	    sprintf ( achFrameRate, "Lots of frames per second.");
	 WinPostMsg ( pwinData->hwndFrame, WM_NEWTEXT,
			achFrameRate, 0L);
	 ulNumFrames = 0;

	 /* Adjust number of frames to time based on last set. */

	 if ( ulTime1 < 250 )
	    ulFramesToTime <<= 1;
	 if ( ulTime1 > 3000 )
	    ulFramesToTime >>= 1;
	 }

      /* Let other threads and processes have some time. */

      DosSleep ( 0 );
     }
     while((status != MPEG_FRAME_DISP) && (status != MPEG_DONE_DISP)
	    && (status != MPEG_DONE_NODISP) );
    }
    while ( (!ulToEnd)  );

   return;
   }


main ( int argc, char *argv[] )
   {
   TID       tidBlitThread;        /* Thread ID for DirectMemMove          */
   HMQ       hmq;                  /* Message queue handle                 */
   QMSG      qmsg;                 /* Message from message queue           */
   ULONG     flCreate;             /* Window creation control flags        */
   PLONG     pPal;


  char *name;
  int mark;
  int i;

#ifdef ANALYSIS
int showEachFlg = 1; /* default statistics each decoded frame */
#endif

  mark = 1;
  argc--;

  /* default values */
  name = "";
  ditherType = ORDERED2_DITHER;
  lum_range = 8;
  cr_range = cb_range = 4;
  noDisplay = 0;


   /* Initialize the presentation manager, and create a message queue. */
   hab = WinInitialize ( 0 );
   hmq = WinCreateMsgQueue ( hab, 0 );

   /* Allocate a buffer for the window data */
   pwinData = (PWINDATA) malloc (sizeof(WINDATA));


    if (argc < 1) {
      WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
	  (PSZ)"usage: must specify a MPEG file",
	  (PSZ)"DIMP.EXE - DIVE MPEG Player", 0, MB_OK | MB_INFORMATION );

    usage(argv[0]);

   /* free allocated structures */
    free ( pwinData );
    WinDestroyMsgQueue ( hmq );
    WinTerminate ( hab );
    exit(-1);

      }

  while (argc) {
    if (strcmp(argv[mark], "-nop") == 0) {
      TogglePFlag();
      nop = 1;
      argc--; mark++;
    } else if (strcmp(argv[mark], "-nob") == 0) {
      ToggleBFlag();
      nob = 1;
      argc--; mark++;
    } else if (strcmp(argv[mark], "-display") == 0) {
      name = argv[++mark];
      argc -= 2; mark++;
    } else if (strcmp(argv[mark], "-dither") == 0) {
      argc--; mark++;

    if (argc < 1) {
      WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
	  (PSZ)"usage: must specify dither option after -dither flag.",
	  (PSZ)"DIMP.EXE - DIVE MPEG Player", 0, MB_OK | MB_INFORMATION );

    usage(argv[0]);

   /* free allocated structures */
    free ( pwinData );
    WinDestroyMsgQueue ( hmq );
    WinTerminate ( hab );
    exit(-1);

      }
      if (strcmp(argv[mark], "hybrid") == 0) {
	argc--; mark++;
	ditherType = HYBRID_DITHER;
      } else if (strcmp(argv[mark], "hybrid2") == 0) {
	argc--; mark++;
	ditherType = HYBRID2_DITHER;
      } else if (strcmp(argv[mark], "fs4") == 0) {
	argc--; mark++;
	ditherType = FS4_DITHER;
      } else if (strcmp(argv[mark], "fs2") == 0) {
	argc--; mark++;
	ditherType = FS2_DITHER;
      } else if (strcmp(argv[mark], "fs2fast") == 0) {
	argc--; mark++;
	ditherType = FS2FAST_DITHER;
      } else if (strcmp(argv[mark], "hybrid2") == 0) {
	argc--; mark++;
	ditherType = HYBRID2_DITHER;
      /* }  else if (strcmp(argv[mark], "2x2") == 0) {
	argc--; mark++;
    ditherType = Twox2_DITHER; */
    /* PVG: not implemented */

      } else if (strcmp(argv[mark], "gray") == 0) {
	argc--; mark++;
	ditherType = GRAY_DITHER;
     /* } else if (strcmp(argv[mark], "color") == 0) {
	argc--; mark++;
    ditherType = FULL_COLOR_DITHER; */
    /* PVG: not implemented */

      } else if (strcmp(argv[mark], "none") == 0) {
	argc--; mark++;
	ditherType = NO_DITHER;
    noDisplay = 1;
      } else if (strcmp(argv[mark], "ordered") == 0) {
	argc--; mark++;
	ditherType = ORDERED_DITHER;
      } else if (strcmp(argv[mark], "ordered2") == 0) {
	argc--; mark++;
	ditherType = ORDERED2_DITHER;
      } else if (strcmp(argv[mark], "mbordered") == 0) {
	argc--; mark++;
	ditherType = MBORDERED_DITHER;
    /*  } else if (strcmp(argv[mark], "mono") == 0) {
	argc--; mark++;
    ditherType = MONO_DITHER; **/
    /* PVG: not implemented */

    /*  } else if (strcmp(argv[mark], "threshold") == 0) {
	argc--; mark++;
    ditherType = MONO_THRESHOLD; */
    /* PVG: not implemented */

      } else {
      WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
	  (PSZ)"usage: illegal dither option.",
	  (PSZ)"DIMP.EXE - DIVE MPEG Player", 0, MB_OK | MB_INFORMATION );
    usage(argv[0]);


   /* free allocated structures */
    free ( pwinData );
    WinDestroyMsgQueue ( hmq );
    WinTerminate ( hab );
    exit(-1);

      }
    } 
    else if (strcmp(argv[mark], "-no_eachstat") == 0) {
      argc--; mark++;

#ifdef ANALYSIS
      showEachFlg = 0;
#else
      WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
	  (PSZ)"usage: to use -eachstat, recompile with -DANALYSIS in CFLAGS.",
	  (PSZ)"DIMP.EXE - DIVE MPEG Player", 0, MB_OK | MB_INFORMATION );

   /* free allocated structures */
      free ( pwinData );
      WinDestroyMsgQueue ( hmq );
      WinTerminate ( hab );

   /* Terminate program */
      exit(1);
#endif
/*    }
    else if (strcmp(argv[mark], "-quiet") == 0) {
      argc--; mark++;
      quiet = 1; */
  /* PVG: not implemented */


    }
    else if (strcmp(argv[mark], "-loop") == 0) {
      argc--; mark++;
      loop = 1;
    }
    else if (strcmp(argv[mark], "-no_display") == 0) {
      argc--; mark++;
      noDisplay = 1;
    }
    else if (strcmp(argv[mark], "-l_range") == 0) {
      argc--; mark++;
      lum_range = atoi(argv[mark]);
      if (lum_range < 1) {

      WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
	  (PSZ)"usage: illegal luminance range value.",
	  (PSZ)"DIMP.EXE - DIVE MPEG Player", 0, MB_OK | MB_INFORMATION );

   /* free allocated structures */
      free ( pwinData );
      WinDestroyMsgQueue ( hmq );
      WinTerminate ( hab );

	exit(1);
      }
      argc--; mark++;
    }
    else if (strcmp(argv[mark], "-cr_range") == 0) {
      argc--; mark++;
      cr_range = atoi(argv[mark]);
      if (cr_range < 1) {

      WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
	  (PSZ)"usage: illegal cr range value.",
	  (PSZ)"DIMP.EXE - DIVE MPEG Player", 0, MB_OK | MB_INFORMATION );

   /* free allocated structures */
      free ( pwinData );
      WinDestroyMsgQueue ( hmq );
      WinTerminate ( hab );

      exit(1);
      }
      argc--; mark++;
    }
    else if (strcmp(argv[mark], "-cb_range") == 0) {
      argc--; mark++;
      cb_range = atoi(argv[mark]);
      if (cb_range < 1) {
      WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
	  (PSZ)"usage: illegal cb range value.",
	  (PSZ)"DIMP.EXE - DIVE MPEG Player", 0, MB_OK | MB_INFORMATION );

   /* free allocated structures */
      free ( pwinData );
      WinDestroyMsgQueue ( hmq );
      WinTerminate ( hab );

      exit(1);
      }
      argc--; mark++;
    }
    else if (argv[mark][0] == '-') {

      WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
	  (PSZ)"usage: un-recognized flag.",
	  (PSZ)"DIMP.EXE - DIVE MPEG Player", 0, MB_OK | MB_INFORMATION );
      usage(argv[0]);

   /* free allocated structures */
    free ( pwinData );
    WinDestroyMsgQueue ( hmq );
    WinTerminate ( hab );
    exit(-1);
    }
    else {
      strcpy(fileName, argv[mark]);
      fin = fopen(fileName, "rb");

      if (fin == NULL) {
      WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
	  (PSZ)"usage: could not open file.",
	  (PSZ)"DIMP.EXE - DIVE MPEG Player", 0, MB_OK | MB_INFORMATION );
	usage(argv[0]);

   /* free allocated structures */
    free ( pwinData );
    WinDestroyMsgQueue ( hmq );
    WinTerminate ( hab );
    exit(-1);

      }
      argc--; mark++;
      fclose(fin);
    }
  }
/****************** Real start of the main program ***********************/

/* Get the screen capabilities, and if the system support only 16 colors
   the sample should be terminated. */

   DiveCaps.pFormatData = fccFormats;
   DiveCaps.ulFormatLength = 120;
   DiveCaps.ulStructLen = sizeof(DIVE_CAPS);

   if ( DiveQueryCaps ( &DiveCaps, DIVE_BUFFER_SCREEN ))
      {
      WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
	  (PSZ)"usage: This program can not run on this system environment.",
	  (PSZ)"DIMP.EXE - DIVE MPEG Player", 0, MB_OK | MB_INFORMATION );
      free ( pwinData );
      WinDestroyMsgQueue ( hmq );
      WinTerminate ( hab );
      return ( 1 );
      }

   /* if no more than 16 colors supported -> abort program */
   if ( DiveCaps.ulDepth < 8 )
      {
      WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
	  (PSZ)"usage: This program can not run on this system environment.",
	  (PSZ)"DIMP.EXE - DIVE MPEG Player", 0, MB_OK | MB_INFORMATION );
      free ( pwinData );
      WinDestroyMsgQueue ( hmq );
      WinTerminate ( hab );
      return ( 1 );
      }

   /* Get a linear address to the screen. */
   if ( DiveOpen ( &(pwinData->hDive), FALSE, 0 ) )
      {
      WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
		       (PSZ)"usage: This program can not run on this system environment.",
		       (PSZ)"DIMP.EXE - DIVE MPEG Player", 0, MB_OK | MB_INFORMATION );
      free ( pwinData );
      WinDestroyMsgQueue ( hmq );
      WinTerminate ( hab );
      return ( 1 );
      }


  /* Initialize Huffman tables */
  init_tables();

#ifdef ANALYSIS
  /* Set stats flag */
  PassStats(showEachFlg, ShowOneStat, ShowAllStats);
#endif

  /* Initialize Dithering + make an appropiate palette */
  if (ditherType != NO_DITHER)
    InitDither(ditherType, lum_range, cr_range, cb_range, &pPalette, &pPal2);

  /* Create a new VidStream */
  theVidStream = NewVidStream(fileName, BUF_LENGTH, loop, quiet, noDisplay,
			      ditherType);

  /* Try to get info about the VidStream */
  if (mpegVidRsrc(0, theVidStream, &ditherFlags) == MPEG_INVALID) {
    DestroyVidStream(theVidStream);

    WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, (PSZ) "Invalid mpeg file",
    (PSZ) "DIMP.EXE - DIVE MPEG Player", 0, MB_OK | MB_MOVEABLE);

   /* free allocated structures */

      TerminateDither(pPalette, pPal2);
      free ( pwinData );
      WinDestroyMsgQueue ( hmq );
      WinTerminate ( hab );
    exit(1);
  }

   /* Register a window class, and create a standard window.
   */
   WinRegisterClass ( hab, pszMyWindow, MyWindowProc, 0, sizeof(ULONG) );
   WinLoadString(hab, 0, ID_APPNAME, sizeof(pszTitleText), pszTitleText);


   flCreate = FCF_TASKLIST | FCF_SYSMENU  | FCF_TITLEBAR |
		  FCF_SIZEBORDER | FCF_MINMAX | FCF_MENU | FCF_SHELLPOSITION;
   pwinData->hwndFrame = WinCreateStdWindow ( HWND_DESKTOP,
					      WS_VISIBLE, &flCreate,
					      pszMyWindow,
					      pszTitleText,
					      WS_SYNCPAINT | WS_VISIBLE,
					      0, ID_MAINWND,
					      &(pwinData->hwndClient));

   WinSetWindowULong (pwinData->hwndClient, 0, (ULONG)pwinData);

   /* load toolbar dialog from resource */
   pwinData->hwndToolBar = WinLoadDlg(HWND_DESKTOP, pwinData->hwndClient,
     ToolBarDlgProc, 0L, IDD_TOOLBAR, NULL);

#ifdef ANALYSIS
   pwinData->hwndOneStat = WinLoadDlg(HWND_DESKTOP, pwinData->hwndClient,
     OneStatDlgProc, 0L, IDD_ONESTAT, NULL);

   pwinData->hwndAllStat = WinLoadDlg(HWND_DESKTOP, pwinData->hwndClient,
     AllStatDlgProc, 0L, IDD_ALLSTAT, NULL);
#endif

   /* set window data */
   WinSetWindowULong (pwinData->hwndToolBar, 0, (ULONG)pwinData);

   /* set on its initial position */
   WinPostMsg(pwinData->hwndToolBar, WM_USER_POSITION, 0L, 0L);

   /* Turn on visible region notification. */
   WinSetVisibleRegionNotify ( pwinData->hwndClient, TRUE );

   DiveSetSourcePalette ( pwinData->hDive, 0, 256, pPalette );

   /* Query the physical palette and tell DIVE */
   {
   HPS hps= WinBeginPaint ( pwinData->hwndFrame, NULLHANDLE, NULL );

   pPal = (PLONG) malloc (sizeof(LONG) * 256);
   GpiQueryRealColors ( hps, 0L, 0L, 256, pPal );

   DiveSetDestinationPalette ( pwinData->hDive, 0,256, (PBYTE)pPal );
   free ( pPal );
   WinEndPaint ( hps );
   }

   /* Allocate a buffer for image data */

   if
   (DiveAllocImageBuffer(pwinData->hDive,&(ulImage), FOURCC_LUT8,
		      theVidStream->h_size, theVidStream->v_size,
			    theVidStream->h_size,0))
      {
   /* free allocated structures */

      DestroyVidStream(theVidStream);
      DosFreeMem( (PVOID)pPalette );
      free ( pwinData );
      WinDestroyMsgQueue ( hmq );
      WinTerminate ( hab );
      return( 1 );
      }

   /* Send an invlaidation message to the client. */

   WinPostMsg ( pwinData->hwndFrame, WM_VRNENABLED, 0L, 0L );


   /* Start up the blitting thread. */
   if ( DosCreateThread ( &(pwinData->tidBlitThread),
			    (PFNTHREAD) Decode,
			    (ULONG)pwinData, 0L, 4096L))
      {
   /* free allocated structures */
      DestroyVidStream(theVidStream);
      WinSetVisibleRegionNotify ( pwinData->hwndClient, FALSE );

      DiveFreeImageBuffer ( pwinData->hDive, ulImage );

      DiveClose ( pwinData->hDive );
      WinDestroyWindow ( pwinData->hwndFrame );

      DosFreeMem( (PVOID)pPalette );
      free ( pwinData);
      WinDestroyMsgQueue ( hmq );
      WinTerminate ( hab );

      return ( 1 );
      }

   /* player will start to play by default */
   condition = ID_PLAY;

   /* Set the proiroty of the blitting thread */
   DosSetPriority ( PRTYS_THREAD, PRTYC_IDLETIME,
		      0, pwinData->tidBlitThread );


   /* While there are still messages, dispatch them. */
   while ( WinGetMsg ( hab, &qmsg, 0, 0, 0 ) )
      WinDispatchMsg ( hab, &qmsg );

   /* Set the variable to end the running thread, and wait for it to end. */
   ulToEnd = 1;
   DosWaitThread ( &(pwinData->tidBlitThread), DCWW_WAIT );

   DestroyVidStream(theVidStream);

   /* Turn off visible region notificationm tidy up, and terminate.
   */
   WinSetVisibleRegionNotify ( pwinData->hwndClient, FALSE );

   /* Free the buffers allocated by DIVE and close DIVE */
   DiveFreeImageBuffer ( pwinData->hDive, ulImage );
   DiveClose ( pwinData->hDive );

   TerminateDither(pPalette, pPal2);

   /* Process for termination  */
   WinDestroyWindow ( pwinData->hwndFrame );
   free ( pwinData );
   WinDestroyMsgQueue ( hmq );
   WinTerminate ( hab );
   return ( 0 );
}


MRESULT EXPENTRY MyWindowProc ( HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
   {
   POINTL    pointl;                /* Point to offset from Desktop         */
   SWP       swp;                   /* Window position                      */
   HRGN      hrgn;                  /* Region handle                        */
   HPS       hps;                   /* Presentation Space handle            */
   RECTL     rcls[50];              /* Rectangle coordinates                */
   RGNRECT   rgnCtl;                /* Processing control structure         */
   PWINDATA  pwinData;              /* Pointer to window data               */
   SETUP_BLITTER SetupBlitter;      /* structure for DiveSetupBlitter       */
   PLONG     pPal;
   HWND      hwndDialog;

   /* Get the pointer to window data
   */
   if ( pwinData = (PWINDATA)WinQueryWindowULong (hWnd, 0))
      {
      switch( msg )
	 {
	 case WM_NEWTEXT:
	   /* Write new text string to the title bar */
	     WinSetWindowText ( pwinData->hwndFrame, (PSZ)mp1 );
	     break;

	 case WM_COMMAND:
	    switch ( SHORT1FROMMP ( mp1 ) )
	       {
	       case ID_EXIT:
		  /* Post to quit the dispatch message loop.
		  */
		  WinPostMsg ( hWnd, WM_QUIT, 0L, 0L );
		  break;
	       case ID_SNAP1:
		  {
		  /* Find the total width and height of the window such that
		  ** the actual video area equals the source width and height.
		  */
		  ULONG ulHeight = theVidStream->v_size;
		  ULONG ulWidth = theVidStream->h_size;
		  ulHeight +=
		       WinQuerySysValue ( HWND_DESKTOP, SV_CYSIZEBORDER ) * 2;
		  ulHeight +=
		       WinQuerySysValue ( HWND_DESKTOP, SV_CYBORDER ) * 2;
		  ulHeight +=
		       WinQuerySysValue ( HWND_DESKTOP, SV_CYMENU );
		  ulHeight +=
		       WinQuerySysValue ( HWND_DESKTOP, SV_CYTITLEBAR );
		  ulWidth +=
		       WinQuerySysValue ( HWND_DESKTOP, SV_CXSIZEBORDER ) * 2;

		  /* Set the new size of the window, but don't move it.
		  */
		  WinSetWindowPos ( pwinData->hwndFrame, HWND_TOP,
				    100, 100, ulWidth, ulHeight,
				    SWP_SIZE | SWP_ACTIVATE | SWP_SHOW );
		  }
		  break;
	       case ID_SNAP2:
		  {
		  /* Find the total width and height of the window such that
		  ** the actual video area equals the source width and height.
		  */
		  ULONG ulHeight = theVidStream->v_size*2;
		  ULONG ulWidth = theVidStream->h_size*2;
		  ulHeight +=
		       WinQuerySysValue ( HWND_DESKTOP, SV_CYSIZEBORDER ) * 2;
		  ulHeight +=
		       WinQuerySysValue ( HWND_DESKTOP, SV_CYBORDER ) * 2;
		  ulHeight +=
		       WinQuerySysValue ( HWND_DESKTOP, SV_CYMENU );
		  ulHeight +=
		       WinQuerySysValue ( HWND_DESKTOP, SV_CYTITLEBAR );
		  ulWidth +=
		       WinQuerySysValue ( HWND_DESKTOP, SV_CXSIZEBORDER ) * 2;

		  /* Set the new size of the window, but don't move it.
		  */
		  WinSetWindowPos ( pwinData->hwndFrame, HWND_TOP,
				    100, 100, ulWidth, ulHeight,
				    SWP_SIZE | SWP_ACTIVATE | SWP_SHOW );
		  }
		  break;
	       case ID_SNAP3:
		  {
		  /* Find the total width and height of the window such that
		  ** the actual video area equals the source width and height.
		  */
		  ULONG ulHeight = theVidStream->v_size*3;
		  ULONG ulWidth = theVidStream->h_size*3;
		  ulHeight +=
		       WinQuerySysValue ( HWND_DESKTOP, SV_CYSIZEBORDER ) * 2;
		  ulHeight +=
		       WinQuerySysValue ( HWND_DESKTOP, SV_CYBORDER ) * 2;
		  ulHeight +=
		       WinQuerySysValue ( HWND_DESKTOP, SV_CYMENU );
		  ulHeight +=
		       WinQuerySysValue ( HWND_DESKTOP, SV_CYTITLEBAR );
		  ulWidth +=
		       WinQuerySysValue ( HWND_DESKTOP, SV_CXSIZEBORDER ) * 2;

		  /* Set the new size of the window, but don't move it.
		  */
		  WinSetWindowPos ( pwinData->hwndFrame, HWND_TOP,
				    100, 100, ulWidth, ulHeight,
				    SWP_SIZE | SWP_ACTIVATE | SWP_SHOW );
		  }
		  break;
 
	       case ID_PAUSE:

		  ulToEnd = 1;
		  condition = ID_PAUSE;
		  break;

	       case ID_PLAY:
		 if (condition == ID_PAUSE) {
		    ulToEnd = 0;
		    DosWaitThread ( &(pwinData->tidBlitThread), DCWW_WAIT );
		    DosCreateThread ( &(pwinData->tidBlitThread),
			    (PFNTHREAD) Decode,
			    (ULONG)pwinData, 0L, 4096L);
		    condition = ID_PLAY;
		    DosSetPriority ( PRTYS_THREAD, PRTYC_IDLETIME,
		      0, pwinData->tidBlitThread );
		 }
		 break;

	       case ID_ADVANCE: /* PVG: what if condition == ID_END ? */

		 if (condition == ID_PAUSE) {
		   ulToEnd = 1;

		 DosCreateThread ( &(pwinData->tidBlitThread),
			    (PFNTHREAD) Decode,
			    (ULONG)pwinData, 0L, 4096L);
		 condition = ID_PAUSE;
		 DosSetPriority ( PRTYS_THREAD, PRTYC_IDLETIME,
		      0, pwinData->tidBlitThread );
		 }
		 break;
	       case ID_RESET:
		 if (condition == ID_PLAY) {
		    ulToEnd = 1;
		    DosWaitThread ( &(pwinData->tidBlitThread), DCWW_WAIT );
		 }
		 DestroyVidStream(theVidStream);
		 ResetVidStream();
		 theVidStream = NewVidStream(fileName, BUF_LENGTH, loop, quiet, noDisplay,
				ditherType);

		 /* display first frame */
		 DosCreateThread ( &(pwinData->tidBlitThread),
			    (PFNTHREAD) Decode,
			    (ULONG)pwinData, 0L, 4096L);
		 DosSetPriority ( PRTYS_THREAD, PRTYC_IDLETIME,
		      0, pwinData->tidBlitThread );
		 ulToEnd = 1;
		 DosWaitThread ( &(pwinData->tidBlitThread), DCWW_WAIT );
		 condition = ID_PAUSE;
		 break;

	       case ID_ORDERED_DITHER:
	       if (condition == ID_PLAY) {
		 ulToEnd = 1;
		 DosWaitThread ( &(pwinData->tidBlitThread), DCWW_WAIT );
		 ulToEnd = 0;
	       }

		 ditherType = ORDERED_DITHER;
		 InitDither(ditherType, lum_range, cr_range, cb_range,
		 &pPalette, &pPal2);
		 DiveSetSourcePalette ( pwinData->hDive, 0, 256, pPalette );
		 VidStreamFlags(ditherType, loop, noDisplay);
		 DosCreateThread ( &(pwinData->tidBlitThread),
			    (PFNTHREAD) Decode,
			    (ULONG)pwinData, 0L, 4096L);
		 DosSetPriority ( PRTYS_THREAD, PRTYC_IDLETIME,
		      0, pwinData->tidBlitThread );

		 break;

	       case ID_ORDERED2_DITHER:
	       if (condition == ID_PLAY) {
		 ulToEnd = 1;
		 DosWaitThread ( &(pwinData->tidBlitThread), DCWW_WAIT );
		 ulToEnd = 0;
	       }
		 ditherType = ORDERED2_DITHER;
		 InitDither(ditherType, lum_range, cr_range, cb_range,
		 &pPalette,&pPal2);
		 DiveSetSourcePalette ( pwinData->hDive, 0, 256, pPalette );
		 VidStreamFlags(ditherType, loop, noDisplay);
		 DosCreateThread ( &(pwinData->tidBlitThread),
			    (PFNTHREAD) Decode,
			    (ULONG)pwinData, 0L, 4096L);
		 DosSetPriority ( PRTYS_THREAD, PRTYC_IDLETIME,
		      0, pwinData->tidBlitThread );

		 break;

	       case ID_HYBRID_DITHER:
	       if (condition == ID_PLAY) {
		 ulToEnd = 1;
		 DosWaitThread ( &(pwinData->tidBlitThread), DCWW_WAIT );
		 ulToEnd = 0;
	       }
		 ditherType = HYBRID_DITHER;
		 InitDither(ditherType, lum_range, cr_range, cb_range,
		 &pPalette,&pPal2);
		 DiveSetSourcePalette ( pwinData->hDive, 0, 256, pPalette );
		 VidStreamFlags(ditherType, loop, noDisplay);
		 DosCreateThread ( &(pwinData->tidBlitThread),
			    (PFNTHREAD) Decode,
			    (ULONG)pwinData, 0L, 4096L);
		 DosSetPriority ( PRTYS_THREAD, PRTYC_IDLETIME,
		      0, pwinData->tidBlitThread );

		 break;

	       case ID_HYBRID2_DITHER:
	       if (condition == ID_PLAY) {
		 ulToEnd = 1;
		 DosWaitThread ( &(pwinData->tidBlitThread), DCWW_WAIT );
		 ulToEnd = 0;
	       }
		 ditherType = HYBRID2_DITHER;
		 InitDither(ditherType, lum_range, cr_range, cb_range,
		 &pPalette,&pPal2);
		 DiveSetSourcePalette ( pwinData->hDive, 0, 256, pPalette );
		 VidStreamFlags(ditherType, loop, noDisplay);
		 DosCreateThread ( &(pwinData->tidBlitThread),
			    (PFNTHREAD) Decode,
			    (ULONG)pwinData, 0L, 4096L);
		 DosSetPriority ( PRTYS_THREAD, PRTYC_IDLETIME,
		      0, pwinData->tidBlitThread );

		 break;

	       case ID_FS4_DITHER:
	       if (condition == ID_PLAY) {
		 ulToEnd = 1;
		 DosWaitThread ( &(pwinData->tidBlitThread), DCWW_WAIT );
		 ulToEnd = 0;
	       }
		 ditherType = FS4_DITHER;
		 InitDither(ditherType, lum_range, cr_range, cb_range,
		 &pPalette,&pPal2);
		 DiveSetSourcePalette ( pwinData->hDive, 0, 256, pPalette );
		 VidStreamFlags(ditherType, loop, noDisplay);
		 DosCreateThread ( &(pwinData->tidBlitThread),
			    (PFNTHREAD) Decode,
			    (ULONG)pwinData, 0L, 4096L);
		 DosSetPriority ( PRTYS_THREAD, PRTYC_IDLETIME,
		      0, pwinData->tidBlitThread );

		 break;

	       case ID_FS2_DITHER:
	       if (condition == ID_PLAY) {
		 ulToEnd = 1;
		 DosWaitThread ( &(pwinData->tidBlitThread), DCWW_WAIT );
		 ulToEnd = 0;
	       }
		 ditherType = FS2_DITHER;
		 InitDither(ditherType, lum_range, cr_range, cb_range,
		 &pPalette,&pPal2);
		 DiveSetSourcePalette ( pwinData->hDive, 0, 256, pPalette );
		 VidStreamFlags(ditherType, loop, noDisplay);
		 DosCreateThread ( &(pwinData->tidBlitThread),
			    (PFNTHREAD) Decode,
			    (ULONG)pwinData, 0L, 4096L);
		 DosSetPriority ( PRTYS_THREAD, PRTYC_IDLETIME,
		      0, pwinData->tidBlitThread );

		 break;

	       case ID_FS2FAST_DITHER:
	       if (condition == ID_PLAY) {
		 ulToEnd = 1;
		 DosWaitThread ( &(pwinData->tidBlitThread), DCWW_WAIT );
		 ulToEnd = 0;
	       }
		 ditherType = FS2FAST_DITHER;
		 InitDither(ditherType, lum_range, cr_range, cb_range,
		 &pPalette,&pPal2);
		 DiveSetSourcePalette ( pwinData->hDive, 0, 256, pPalette );
		 VidStreamFlags(ditherType, loop, noDisplay);
		 DosCreateThread ( &(pwinData->tidBlitThread),
			    (PFNTHREAD) Decode,
			    (ULONG)pwinData, 0L, 4096L);
		 DosSetPriority ( PRTYS_THREAD, PRTYC_IDLETIME,
		      0, pwinData->tidBlitThread );

		 break;

	       case ID_MBORDERED_DITHER:
	       if (condition == ID_PLAY) {
		 ulToEnd = 1;
		 DosWaitThread ( &(pwinData->tidBlitThread), DCWW_WAIT );
		 ulToEnd = 0;
	       }
		 ditherType = MBORDERED_DITHER;
		 InitDither(ditherType, lum_range, cr_range, cb_range,
		 &pPalette,&pPal2);
		 DiveSetSourcePalette ( pwinData->hDive, 0, 256, pPalette );
		 /* Start from beginning because video.c needs to initialize
		 vars needed for this type of dither */
		 DestroyVidStream(theVidStream);
		 ResetVidStream();
		 theVidStream = NewVidStream(fileName, BUF_LENGTH, loop, quiet, noDisplay,
			      ditherType);
		 mpegVidRsrc(0, theVidStream, &ditherFlags);
		 DosCreateThread ( &(pwinData->tidBlitThread),
			    (PFNTHREAD) Decode,
			    (ULONG)pwinData, 0L, 4096L);
		 DosSetPriority ( PRTYS_THREAD, PRTYC_IDLETIME,
		      0, pwinData->tidBlitThread );

		 break;

	       case ID_GRAY_DITHER:
	       if (condition == ID_PLAY) {
		 ulToEnd = 1;
		 DosWaitThread ( &(pwinData->tidBlitThread), DCWW_WAIT );
		 ulToEnd = 0;
	       }
		 ditherType = GRAY_DITHER;
		 InitDither(ditherType, lum_range, cr_range, cb_range,
		 &pPalette,&pPal2);
		 DiveSetSourcePalette ( pwinData->hDive, 0, 256, pPalette );
		 VidStreamFlags(ditherType, loop, noDisplay);

		 DosCreateThread ( &(pwinData->tidBlitThread),
			    (PFNTHREAD) Decode,
			    (ULONG)pwinData, 0L, 4096L);
		 DosSetPriority ( PRTYS_THREAD, PRTYC_IDLETIME,
		      0, pwinData->tidBlitThread );
		 break;

	       case ID_LOOP:
		 if (loop == 1)
		   WinPostMsg(pwinData->hwndToolBar, WM_DOLOOP, 0L, 0L);
		 else
		   WinPostMsg(pwinData->hwndToolBar, WM_NOLOOP, 0L, 0L);
		 loop = (loop? 0: 1);
		 VidStreamFlags(ditherType, loop, noDisplay);
		 if (condition == ID_END) { /* play-thread has done playing */
		   ResetVidStream();
		   theVidStream = NewVidStream(fileName, BUF_LENGTH, loop, quiet, noDisplay,
				  ditherType);
		   mpegVidRsrc(0, theVidStream, &ditherFlags);
		   DosCreateThread ( &(pwinData->tidBlitThread),
			      (PFNTHREAD) Decode,
			      (ULONG)pwinData, 0L, 4096L);
		   DosSetPriority ( PRTYS_THREAD, PRTYC_IDLETIME,
			0, pwinData->tidBlitThread );
		   condition = ID_PLAY;
		 }
		 break;

	       case ID_NO_DISPLAY: /* show / don't show video sequence */
		 if (noDisplay == 1)
		   WinPostMsg(pwinData->hwndToolBar, WM_DOSHOW, 0L, 0L);
		 else
		   WinPostMsg(pwinData->hwndToolBar, WM_NOSHOW, 0L, 0L);

		 noDisplay = (noDisplay?0:1); /* PVG: noDisplay can also be acessed
							   in play !!! */
		 VidStreamFlags(ditherType, loop, noDisplay);
		 break;

	       case ID_NO_DITHER:
		 WinPostMsg(pwinData->hwndToolBar, WM_NOSHOW, 0L, 0L);
		 noDisplay = 1;
		 ditherType = NO_DITHER;
		 VidStreamFlags(ditherType, loop, noDisplay);
		 break;

	       case ID_DIVE_INFO:
		  /* Get the screen capabilities, and display them
		  in the dialog box. */

		  DiveCaps.pFormatData = fccFormats;
		  DiveCaps.ulFormatLength = 120;
		  DiveCaps.ulStructLen = sizeof(DIVE_CAPS);

		  if ( DiveQueryCaps ( &DiveCaps, DIVE_BUFFER_SCREEN ))
		     {
		     WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
			 (PSZ)"usage: DIMP failed to get screen capabilities.",
			 (PSZ)"Error!", 0, MB_OK | MB_MOVEABLE );
		     break;
		     }

		  WinDlgBox ( HWND_DESKTOP, pwinData->hwndClient,
			       DiveDlgProc, (HMODULE)0,
			       ID_DIALOG, (PVOID)pwinData );

		  break;

	       case ID_MPEG_INFO:

		  WinDlgBox ( HWND_DESKTOP, pwinData->hwndClient,
			       MpegDlgProc, (HMODULE)0,
			       ID_DIALOG2, (PVOID)pwinData );
		  break;

	       case ID_PROG_USAGE:
		  WinDlgBox ( HWND_DESKTOP, pwinData->hwndClient,
			       UsageDlgProc, (HMODULE)0,
			       IDD_USAGE, (PVOID)pwinData );
		  break;

	       case ID_ABOUT:
		 WinDlgBox (HWND_DESKTOP, pwinData->hwndClient, AboutDlgProc,
		   (HMODULE) 0, IDD_ABOUT, (PVOID) pszTitleText);
		 break;

	       default:
		  /* Let PM handle this message.
		  */
		  return WinDefWindowProc ( hWnd, msg, mp1, mp2 );
	       }
	    break;


	 case WM_VRNDISABLED:

	    DiveSetupBlitter ( pwinData->hDive, 0 );
	    break;

	 case WM_VRNENABLED:
	    hps = WinGetPS ( hWnd );
	    if ( !hps )
	       break;
	    hrgn = GpiCreateRegion ( hps, 0L, NULL );
	    if ( hrgn )
	       {
	       /* NOTE: If mp1 is zero, then this was just a move message.
	       ** Illustrate the visible region on a WM_VRNENABLE.
	       */
	       WinQueryVisibleRegion ( hWnd, hrgn );
	       rgnCtl.ircStart     = 0;
	       rgnCtl.crc          = 50;
	       rgnCtl.ulDirection  = 1;

	       /* Get the all ORed rectangles
	       */
	       if ( GpiQueryRegionRects ( hps, hrgn, NULL, &rgnCtl, rcls) )
		  {
		  /* Now find the window position and size, relative to parent.
		  */
		  WinQueryWindowPos ( pwinData->hwndClient, &swp );

		  /* Convert the point to offset from desktop lower left.
		  */
		  pointl.x = swp.x;
		  pointl.y = swp.y;
		  WinMapWindowPoints ( pwinData->hwndFrame,
				       HWND_DESKTOP, &pointl, 1 );

		  /* Tell DIVE about the new settings.
		  */
		  SetupBlitter.ulStructLen = sizeof ( SETUP_BLITTER );
		  SetupBlitter.fccSrcColorFormat = FOURCC_LUT8;
		  SetupBlitter.ulSrcWidth = theVidStream->h_size;
		  SetupBlitter.ulSrcHeight = theVidStream->v_size;
		  SetupBlitter.ulSrcPosX = 0;
		  SetupBlitter.ulSrcPosY = 0;
		  SetupBlitter.fInvert = FALSE;
		  SetupBlitter.ulDitherType = 0;

		  SetupBlitter.fccDstColorFormat = FOURCC_SCRN;
		  SetupBlitter.ulDstWidth = swp.cx;
		  SetupBlitter.ulDstHeight = swp.cy;
		  SetupBlitter.lDstPosX = 0;
		  SetupBlitter.lDstPosY = 0;
		  SetupBlitter.lScreenPosX = pointl.x;
		  SetupBlitter.lScreenPosY = pointl.y;
		  SetupBlitter.ulNumDstRects = rgnCtl.crcReturned;
		  SetupBlitter.pVisDstRects = rcls;
		  DiveSetupBlitter ( pwinData->hDive, &SetupBlitter );

		  }
	       else
		  DiveSetupBlitter ( pwinData->hDive, 0 );

	       GpiDestroyRegion( hps, hrgn );
	       }
	    WinReleasePS( hps );
	    break;

	 case WM_CHAR:
	    /* Character input: first two byte of message is the character code.
	    */
	    if ( SHORT2FROMMP ( mp2 ) == VK_F4 )
	       WinPostMsg ( hWnd, WM_QUIT, 0L, 0L );
	    else if ( SHORT2FROMMP ( mp2 ) == VK_F1 )
	       WinPostMsg ( hWnd, WM_COMMAND, (PVOID)ID_SNAP1, 0L );
	    else if ( SHORT2FROMMP ( mp2 ) == VK_F2 )
	       WinPostMsg ( hWnd, WM_COMMAND, (PVOID)ID_SNAP2, 0L );
	    else if ( SHORT2FROMMP ( mp2 ) == VK_F3 )
	       WinPostMsg ( hWnd, WM_COMMAND, (PVOID)ID_SNAP3, 0L );
	    break;

	 case WM_REALIZEPALETTE:

	    hps= WinBeginPaint ( pwinData->hwndFrame, NULLHANDLE, NULL );

	    pPal = (PLONG) malloc (sizeof(LONG) * 256);
	    GpiQueryRealColors ( hps, 0L, 0L, 256, pPal );

	    DiveSetDestinationPalette (pwinData->hDive,0,256,(PBYTE)pPal );
	    free ( pPal );

	    WinEndPaint ( hps );

	    break;

	 case WM_CLOSE:
	    /* Post to quit the dispatch message loop.
	    */
	    WinPostMsg ( hWnd, WM_QUIT, 0L, 0L );
	    break;

	 default:
	    /* Let PM handle this message.
	    */
	    return WinDefWindowProc ( hWnd, msg, mp1, mp2 );
	 }
      }
   else
      /* Let PM handle this message.
      */
      return WinDefWindowProc ( hWnd, msg, mp1, mp2 );

   return ( FALSE );
   }


MRESULT EXPENTRY ToolBarDlgProc (HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    MRESULT mReturn  = 0L;
    BOOL    bHandled = TRUE;
    RECTL   Rectl;
    PWINDATA pwinData;

   /* Get the pointer to window data
   */
    pwinData = (PWINDATA)WinQueryWindowULong (hWnd, 0);
 
    switch (msg)
    {
	case WM_INITDLG:
	    WinSendDlgItemMsg (hWnd, IDC_RED, SPBM_SETTEXTLIMIT, 
		(MPARAM)3, (MPARAM)0);
	    WinSendDlgItemMsg (hWnd, IDC_RED, SPBM_SETLIMITS,
		(MPARAM)200L, (MPARAM)0L);
	    WinSendDlgItemMsg (hWnd, IDC_BLUE, SPBM_SETTEXTLIMIT, 
		(MPARAM)3, (MPARAM)0);
	    WinSendDlgItemMsg (hWnd, IDC_BLUE, SPBM_SETLIMITS,
		(MPARAM)200L, (MPARAM)0L);
	    WinSendDlgItemMsg (hWnd, IDC_GREEN, SPBM_SETTEXTLIMIT, 
		(MPARAM)3, (MPARAM)0);
	    WinSendDlgItemMsg (hWnd, IDC_GREEN, SPBM_SETLIMITS,
		(MPARAM)200L, (MPARAM)0L);
	    WinSendDlgItemMsg (hWnd, IDC_BRIGHTNESS, SPBM_SETTEXTLIMIT,
		(MPARAM)3, (MPARAM)0);
	    WinSendDlgItemMsg (hWnd, IDC_BRIGHTNESS, SPBM_SETLIMITS,
		(MPARAM)200L, (MPARAM)0L);
	    WinSendDlgItemMsg (hWnd, IDC_CONTRAST, SPBM_SETTEXTLIMIT,
		(MPARAM)3, (MPARAM)0);
	    WinSendDlgItemMsg (hWnd, IDC_CONTRAST, SPBM_SETLIMITS,
		(MPARAM)400L, (MPARAM)0L);

	    WinSendDlgItemMsg(hWnd, IDC_RED, SPBM_SETCURRENTVALUE, (MPARAM) 100L,
	    (MPARAM) 0L);
	    WinSendDlgItemMsg(hWnd, IDC_GREEN, SPBM_SETCURRENTVALUE, (MPARAM) 100L,
	    (MPARAM) 0L);
	    WinSendDlgItemMsg(hWnd, IDC_BLUE, SPBM_SETCURRENTVALUE, (MPARAM) 100L,
	    (MPARAM) 0L);
	    WinSendDlgItemMsg(hWnd, IDC_BRIGHTNESS, SPBM_SETCURRENTVALUE, (MPARAM) 100L,
	    (MPARAM) 0L);
	    WinSendDlgItemMsg(hWnd, IDC_CONTRAST, SPBM_SETCURRENTVALUE, (MPARAM) 100L,
	    (MPARAM) 0L);

	    /* set all five check-buttons */
	      WinCheckButton(hWnd, IDC_SHOW, 1);
	    if (nop !=1)
	      WinCheckButton(hWnd, IDC_PFRAME, 1);
	    if (nob !=1)
	      WinCheckButton(hWnd, IDC_BFRAME, 1);
	    if (noDisplay == 0)
	      WinCheckButton(hWnd, IDC_SHOW, 1);
	    else
	      WinCheckButton(hWnd, IDC_SHOW, 0);
	    if (loop == 1)
	      WinCheckButton(hWnd, IDC_LOOP, 1);


	    break;

	case WM_USER_POSITION:
	    WinQueryWindowRect (HWND_DESKTOP, &Rectl);
	    WinSetWindowPos (hWnd, 0, Rectl.xRight-150, Rectl.yBottom+10, 0L, 0L,
		SWP_MOVE | SWP_SHOW);
	    break;
	case WM_NOSHOW:
	    WinCheckButton(hWnd, IDC_SHOW, 0);
	    break;
	case WM_DOSHOW:
	    WinCheckButton(hWnd, IDC_SHOW, 1);
	    break;
	case WM_NOLOOP:
	    WinCheckButton(hWnd, IDC_LOOP, 0);
	    break;
	case WM_DOLOOP:
	    WinCheckButton(hWnd, IDC_LOOP, 1);
	    break;

	case WM_CONTROL:
	      {
		BOOL bChecked;
		switch (SHORT1FROMMP(mp1))
		{
		    case IDC_SHOW:
			if (SHORT2FROMMP(mp1) == BN_CLICKED)
			{
			   noDisplay = (noDisplay==0?1:0);
			   VidStreamFlags(ditherType, loop, noDisplay);
			}
			break;
		    case IDC_LOOP:
			if (SHORT2FROMMP(mp1) == BN_CLICKED)
			{
			   loop = (loop==0?1:0);
			   VidStreamFlags(ditherType, loop, noDisplay);
			   if (condition == ID_END) { /* play-thread has done playing */
			     ResetVidStream();
			     theVidStream = NewVidStream(fileName, BUF_LENGTH, loop, quiet, noDisplay,
					    ditherType);
			     mpegVidRsrc(0, theVidStream, &ditherFlags);
			     DosCreateThread ( &(pwinData->tidBlitThread),
			       (PFNTHREAD) Decode,
			       (ULONG)pwinData, 0L, 4096L);
			     DosSetPriority ( PRTYS_THREAD, PRTYC_IDLETIME,
				 0, pwinData->tidBlitThread );
			     condition = ID_PLAY;
			   }
			}
			break;

		    case IDC_BFRAME:
			if (SHORT2FROMMP(mp1) == BN_CLICKED)
			{
			   ToggleBFlag();
			   nob = (nob==0?1:0);
			}
			break;

		    case IDC_PFRAME:
			if (SHORT2FROMMP(mp1) == BN_CLICKED)
			{
			   TogglePFlag();
			   nop = (nop==0?1:0);
			}
			break;

		    case IDC_RED:

			if (SHORT2FROMMP(mp1) == SPBN_ENDSPIN)
			{
			    ULONG ulRed;
			    USHORT i;
			    int p;
			    PBYTE pTemp = pPalette, pTmp2 = pPal2;

			    WinSendDlgItemMsg (hWnd, IDC_RED,
				SPBM_QUERYVALUE, (MPARAM)&ulRed, 0L);

			    for(i=0;i<256;i++) {
			      p=(int) *pTmp2;
			      if (p<0) p+=256; /* if sign bit was 1 */
			      p += p*(((int)ulRed)-100)/100;
			      if (p<0) p=0;
			      if (p>255) p=255;

			      *pTemp = (BYTE) p;
			      pTemp++; pTmp2++;
			      pTemp++; pTmp2++;
			      pTemp++; pTmp2++;
			      pTemp++; pTmp2++;
			    }
			    DiveSetSourcePalette ( pwinData->hDive,0, 256, (PBYTE) pPalette );
			  }
		      break;
		    case IDC_GREEN:

			if (SHORT2FROMMP(mp1) == SPBN_ENDSPIN)
			{
			    ULONG  ulGreen;
			    USHORT i;
			    int p;
			    PBYTE pTemp = pPalette, pTmp2 = pPal2;

			    WinSendDlgItemMsg (hWnd, IDC_GREEN,
				SPBM_QUERYVALUE, (MPARAM)&ulGreen, 0L);

			    for(i=0;i<256;i++) {
			      pTmp2++;
			      p=(int) *pTmp2;
			      if (p<0) p+=256; /* if sign bit was 1 */
			      p += p*(((int)ulGreen)-100)/100;
			      if (p<0) p=0;
			      if (p>255) p=255;

			      pTemp++;
			      *pTemp = (BYTE) p;
			      pTemp++; pTmp2++;
			      pTemp++; pTmp2++;
			      pTemp++; pTmp2++;
			    }
			    DiveSetSourcePalette ( pwinData->hDive,0, 256, (PBYTE) pPalette );
			  }
		      break;

		    case IDC_BLUE:

			if (SHORT2FROMMP(mp1) == SPBN_ENDSPIN)
			{
			    ULONG  ulBlue;
			    USHORT i;
			    int p;
			    PBYTE pTemp = pPalette, pTmp2 = pPal2;

			    WinSendDlgItemMsg (hWnd, IDC_BLUE,
				SPBM_QUERYVALUE, (MPARAM)&ulBlue, 0L);

			    for(i=0;i<256;i++) {
			      pTmp2++;
			      pTmp2++;
			      p=(int) *pTmp2;
			      if (p<0) p+=256; /* if sign bit was 1 */
			      p += p*(((int)ulBlue)-100)/100;
			      if (p<0) p=0;
			      if (p>255) p=255;

			      pTemp++;
			      pTemp++;
			      *pTemp = (BYTE) p;
			      pTemp++; pTmp2++;
			      pTemp++; pTmp2++;
			    }
			    DiveSetSourcePalette ( pwinData->hDive,0, 256, (PBYTE) pPalette );
			  }
		      break;

		    case IDC_BRIGHTNESS:
			if (SHORT2FROMMP(mp1) == SPBN_ENDSPIN)
			{
			    ULONG ulBright;
			    USHORT i;
			    int p;
			    PBYTE pTemp = pPalette, pTmp2 = pPal2;

			    WinSendDlgItemMsg (hWnd, IDC_BRIGHTNESS,
				SPBM_QUERYVALUE, (MPARAM)&ulBright, 0L);

			    for(i=0;i<256;i++) {
			      p=(int) *pTmp2;
			      if (p<0) p+=256; /* if sign bit was 1 */
			      p += p*(((int)ulBright)-100)/100;
			      if (p<0) p=0;
			      if (p>255) p=255;
			      *pTemp = (BYTE) p;

			      pTemp++; pTmp2++;
			      p=(int) *pTmp2;
			      if (p<0) p+=256; /* if sign bit was 1 */
			      p += p*(((int)ulBright)-100)/100;
			      if (p<0) p=0;
			      if (p>255) p=255;
			      *pTemp = (BYTE) p;

			      pTemp++; pTmp2++;
			      p=(int) *pTmp2;
			      if (p<0) p+=256; /* if sign bit was 1 */
			      p += p*(((int)ulBright)-100)/100;
			      if (p<0) p=0;
			      if (p>255) p=255;
			      *pTemp = (BYTE) p;

			      pTemp++; pTmp2++;
			      pTemp++; pTmp2++;
			    }
			    DiveSetSourcePalette ( pwinData->hDive,0, 256, (PBYTE) pPalette );
			  }
		      break;

		    case IDC_CONTRAST:

			if (SHORT2FROMMP(mp1) == SPBN_ENDSPIN)
			{
			    ULONG ulCont;
			    USHORT i;
			    int p;
			    PBYTE pTemp = pPalette, pTmp2 = pPal2;

			    WinSendDlgItemMsg (hWnd, IDC_CONTRAST,
				SPBM_QUERYVALUE, (MPARAM)&ulCont, 0L);

			    for(i=0;i<256;i++) {
			      p=(int) *pTmp2;
			      if (p<0) p+=256; /* if sign bit was 1 */

			      if (p<128) {
				p -= p*(((int)ulCont)-100)/100;
				if (p<0) p=0;
				if (p>127) p=127;
			      }
			      else {
				p += p*(((int)ulCont)-100)/100;
				if (p>255) p=255;
				if (p<128) p=128;
			      }
			      *pTemp = (BYTE) p;
			      pTemp++; pTmp2++;

			      p=(int) *pTmp2;
			      if (p<0) p+=256; /* if sign bit was 1 */

			      if (p<128) {
				p -= p*(((int)ulCont)-100)/100;
				if (p<0) p=0;
				if (p>127) p=127;
			      }
			      else {
				p += p*(((int)ulCont)-100)/100;
				if (p>255) p=255;
				if (p<128) p=128;
			      }
			      *pTemp = (BYTE) p;
			      pTemp++; pTmp2++;

			      p=(int) *pTmp2;
			      if (p<0) p+=256; /* if sign bit was 1 */
			      if (p<128) {
				p -= p*(((int)ulCont)-100)/100;
				if (p<0) p=0;
				if (p>127) p=127;
			      }
			      else {
				p += p*(((int)ulCont)-100)/100;
				if (p>255) p=255;
				if (p<128) p=128;
			      }
			      *pTemp = (BYTE) p;

			      pTemp++; pTmp2++;
			      pTemp++; pTmp2++;
			    }

			    DiveSetSourcePalette ( pwinData->hDive,0, 256, (PBYTE) pPalette );
			  }
		      break;
		      }
	    }
	    break;

		  case WM_COMMAND:
		      switch (LOUSHORT(mp1))
	    {
		case IDC_PLAY:

		  WinPostMsg (pwinData->hwndFrame, WM_COMMAND,
			(PVOID)ID_PLAY, 0L );
		    /*    WinEnableWindow (hWndFrame, FALSE);
			WinDlgBox (HWND_DESKTOP, hWnd, WinInfoDlgProc,
			    0L, IDD_WININFO, NULL);
			WinEnableWindow (hWndFrame, TRUE);
		    */
		    break;

		case IDC_PAUSE:
		  WinPostMsg (pwinData->hwndFrame, WM_COMMAND,
			(PVOID)ID_PAUSE, 0L );
		  break;

		case IDC_RESET:
		  WinPostMsg (pwinData->hwndFrame, WM_COMMAND,
			(PVOID)ID_RESET, 0L );
		  break;

		case IDC_ADVANCE:
		  WinPostMsg (pwinData->hwndFrame, WM_COMMAND,
			(PVOID)ID_ADVANCE, 0L );
		  break;

		case IDC_UNDO:
		  memcpy(pPalette, pPal2, 256*sizeof(ULONG));
		  DiveSetSourcePalette ( pwinData->hDive,0, 256, (PBYTE) pPalette );
	     WinSendDlgItemMsg(hWnd, IDC_RED, SPBM_SETCURRENTVALUE, (MPARAM) 100L,
	    (MPARAM) 0L);
	    WinSendDlgItemMsg(hWnd, IDC_GREEN, SPBM_SETCURRENTVALUE, (MPARAM) 100L,
	    (MPARAM) 0L);
	    WinSendDlgItemMsg(hWnd, IDC_BLUE, SPBM_SETCURRENTVALUE, (MPARAM) 100L,
	    (MPARAM) 0L);
	    WinSendDlgItemMsg(hWnd, IDC_BRIGHTNESS, SPBM_SETCURRENTVALUE, (MPARAM) 100L,
	    (MPARAM) 0L);
	    WinSendDlgItemMsg(hWnd, IDC_CONTRAST, SPBM_SETCURRENTVALUE, (MPARAM) 100L,
	    (MPARAM) 0L);
		  break;


	       case IDC_DIVEINFO:

		  /* Get the screen capabilities, and display them
		  ** in the dialog box.
		  */
		  DiveCaps.pFormatData = fccFormats;
		  DiveCaps.ulFormatLength = 120;
		  DiveCaps.ulStructLen = sizeof(DIVE_CAPS);

		  if ( DiveQueryCaps ( &DiveCaps, DIVE_BUFFER_SCREEN ))
		     {
		     WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
			 (PSZ)"usage: DIMP failed to get screen capabilities.",
			 (PSZ)"Error!", 0, MB_OK | MB_MOVEABLE );
		     break;
		     }

		  WinDlgBox ( HWND_DESKTOP, pwinData->hwndClient,
			       DiveDlgProc, (HMODULE)0,
			       ID_DIALOG, (PVOID)pwinData );


		  break;

	       case IDC_MPEGINFO:

		  WinDlgBox ( HWND_DESKTOP, pwinData->hwndClient,
			       MpegDlgProc, (HMODULE)0,
			       ID_DIALOG2, (PVOID)pwinData );

		  break;
	    }
	    break;

	default:
	   bHandled = FALSE;
	   break;
    }


    if (!bHandled)
	mReturn = WinDefDlgProc (hWnd, msg, mp1, mp2);

    return (mReturn);
}


MRESULT EXPENTRY UsageDlgProc ( HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2 )
   {
   switch( msg )
      {
      case WM_INITDLG:
	 WinSetFocus(HWND_DESKTOP,hwndDlg);
	 break;

      case WM_COMMAND:
	 switch ( SHORT1FROMMP ( mp1 ) )
	    {
	    case DID_OK:

	       WinDismissDlg ( hwndDlg, TRUE );
	       break;
	    }
      default:
	 return ( WinDefDlgProc (hwndDlg, msg, mp1, mp2) );

      }
   }

MRESULT EXPENTRY DiveDlgProc ( HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2 )
   {
   CHAR      string[10];
   CHAR      *pString;

   switch( msg )
      {
      case WM_INITDLG:

	 if ( !DiveCaps.fScreenDirect )
	    WinSetDlgItemText ( hwndDlg, ID_EF_11, "NO" );
	 else
	    WinSetDlgItemText ( hwndDlg, ID_EF_11, "YES" );

	 if ( !DiveCaps.fBankSwitched )
	    WinSetDlgItemText ( hwndDlg, ID_EF_12, "NO" );
	 else
	    WinSetDlgItemText ( hwndDlg, ID_EF_12, "YES" );

	 pString = _ultoa ( DiveCaps.ulDepth, string, 10 );
	 WinSetDlgItemText ( hwndDlg, ID_EF_13, pString );

	 pString = _ultoa ( DiveCaps.ulHorizontalResolution,
			     string, 10 );
	 WinSetDlgItemText ( hwndDlg, ID_EF_14, pString );

	 pString = _ultoa ( DiveCaps.ulVerticalResolution, string, 10 );
	 WinSetDlgItemText ( hwndDlg, ID_EF_15, pString );

	 pString = _ultoa ( DiveCaps.ulScanLineBytes, string, 10 );
	 WinSetDlgItemText ( hwndDlg, ID_EF_16, pString );

	 switch (DiveCaps.fccColorEncoding)
	    {
	    case FOURCC_LUT8:
	       WinSetDlgItemText ( hwndDlg, ID_EF_17, "256" );
	       break;
	    case FOURCC_R565:
	       WinSetDlgItemText ( hwndDlg, ID_EF_17, "64K" );
	       break;
	    case FOURCC_R555:
	       WinSetDlgItemText ( hwndDlg, ID_EF_17, "32K" );
	       break;
	    case FOURCC_R664:
	       WinSetDlgItemText ( hwndDlg, ID_EF_17, "64K" );
	       break;
	    case FOURCC_RGB3:
	       WinSetDlgItemText ( hwndDlg, ID_EF_17, "16M" );
	       break;
	    case FOURCC_BGR3:
	       WinSetDlgItemText ( hwndDlg, ID_EF_17, "16M" );
	       break;
	    case FOURCC_RGB4:
	       WinSetDlgItemText ( hwndDlg, ID_EF_17, "16M" );
	       break;
	    case FOURCC_BGR4:
	       WinSetDlgItemText ( hwndDlg, ID_EF_17, "16M" );
	       break;
	    default:
	       WinSetDlgItemText ( hwndDlg, ID_EF_17, "???" );
	    } /* endswitch */

	 pString = _ultoa ( DiveCaps.ulApertureSize, string, 10 );
	 WinSetDlgItemText ( hwndDlg, ID_EF_18, pString );

	 pString = _ultoa ( DiveCaps.ulInputFormats, string, 10 );
	 WinSetDlgItemText ( hwndDlg, ID_EF_19, pString );

	 pString = _ultoa ( DiveCaps.ulOutputFormats, string, 10 );
	 WinSetDlgItemText ( hwndDlg, ID_EF_20, pString );
	 WinSetFocus(HWND_DESKTOP,hwndDlg);
	 break;

      case WM_COMMAND:
	 switch ( SHORT1FROMMP ( mp1 ) )
	    {
	    case DID_OK:

	       WinDismissDlg ( hwndDlg, TRUE );
	       break;
	    }

      default:
	 return ( WinDefDlgProc (hwndDlg, msg, mp1, mp2) );

      }
   }

MRESULT EXPENTRY MpegDlgProc ( HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2 )
   {
   CHAR      string[10];
   CHAR      *pString;

   switch( msg )
      {
      case WM_INITDLG:
	 pString = _ultoa (theVidStream->h_size, string, 10 );
	 WinSetDlgItemText ( hwndDlg, ID_EF_21, pString );
	 pString = _ultoa (theVidStream->v_size, string, 10 );
	 WinSetDlgItemText ( hwndDlg, ID_EF_22, pString );
	 pString = _ultoa (theVidStream->mb_height, string, 10 );
	 WinSetDlgItemText ( hwndDlg, ID_EF_23, pString );
	 pString = _ultoa (theVidStream->mb_width, string, 10 );
	 WinSetDlgItemText ( hwndDlg, ID_EF_24, pString );
	 pString = _ultoa (theVidStream->aspect_ratio, string, 10 );
	 WinSetDlgItemText ( hwndDlg, ID_EF_25, pString );
	 pString = _ultoa (theVidStream->picture_rate, string, 10 );
	 WinSetDlgItemText ( hwndDlg, ID_EF_26, pString );
	 pString = _ultoa (theVidStream->bit_rate, string, 10 );
	 WinSetDlgItemText ( hwndDlg, ID_EF_27, pString );
	 pString = _ultoa (theVidStream->vbv_buffer_size, string, 10 );
	 WinSetDlgItemText ( hwndDlg, ID_EF_28, pString );
	 WinSetFocus(HWND_DESKTOP,hwndDlg);
	 break;

      case WM_COMMAND:
	 switch ( SHORT1FROMMP ( mp1 ) )
	    {
	    case DID_OK:

	       WinDismissDlg ( hwndDlg, TRUE );
	       break;
	    }
      default:
	 return ( WinDefDlgProc (hwndDlg, msg, mp1, mp2) );

      }
   }


MRESULT EXPENTRY AboutDlgProc (HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    BOOL    bHandled = TRUE;
    MRESULT mReturn  = 0;
    ULONG   ulScrWidth, ulScrHeight;
    RECTL   Rectl;
    SWP     Swp;
    HPS     hps;

    switch (msg)
    {           
	case WM_INITDLG:

	    /* Center dialog on screen */
	    ulScrWidth  = WinQuerySysValue (HWND_DESKTOP, SV_CXSCREEN);
	    ulScrHeight = WinQuerySysValue (HWND_DESKTOP, SV_CYSCREEN);
	    WinQueryWindowRect (hWnd, &Rectl);
	    WinSetWindowPos (hWnd, HWND_TOP, (ulScrWidth-Rectl.xRight)/2,
		(ulScrHeight-Rectl.yTop)/2, 0, 0, SWP_MOVE | SWP_ACTIVATE);

	    /* Set application title */
	    WinSetDlgItemText (hWnd, 10001, (PSZ)mp2);
	    break;

	case WM_PAINT:

	    hps = WinBeginPaint (hWnd,0,0);
	    WinQueryWindowRect (hWnd, &Rectl);
	    WinFillRect (hps, &Rectl, CLR_PALEGRAY);
	    WinDrawBorder (hps, &Rectl, 
		WinQuerySysValue(HWND_DESKTOP,SV_CXDLGFRAME), 
		WinQuerySysValue(HWND_DESKTOP,SV_CYDLGFRAME), 
		CLR_DARKGRAY, CLR_WHITE, DB_RAISED);
	    GpiMove (hps, (PPOINTL)&Rectl);
	    Rectl.xRight--;
	    Rectl.yTop--;
	    GpiBox (hps, DRO_OUTLINE, (PPOINTL)&Rectl.xRight, 0L, 0L);
	    WinQueryWindowPos (WinWindowFromID (hWnd, 10002), &Swp);
	    Rectl.xLeft   = Swp.x-1;
	    Rectl.yBottom = Swp.y-1;
	    Rectl.xRight  = Swp.x + Swp.cx + 1;
	    Rectl.yTop    = Swp.y + Swp.cy + 1;
	    WinDrawBorder (hps, &Rectl, 1L, 1L,
		CLR_DARKGRAY, CLR_WHITE, DB_DEPRESSED);
	    WinQueryWindowPos (WinWindowFromID (hWnd, 10003), &Swp);
	    Rectl.xLeft   = Swp.x-1;
	    Rectl.yBottom = Swp.y-1;
	    Rectl.xRight  = Swp.x + Swp.cx + 1;
	    Rectl.yTop    = Swp.y + Swp.cy + 1;
	    WinDrawBorder (hps, &Rectl, 1L, 1L,
		CLR_DARKGRAY, CLR_WHITE, DB_DEPRESSED);
	    WinEndPaint (hps);
	    break;

		  case WM_COMMAND:
	    WinDismissDlg (hWnd, DID_OK);
	    break;

	default:
	    bHandled = FALSE;
	    break;
    }

    if (!bHandled)
	mReturn = WinDefDlgProc (hWnd, msg, mp1, mp2);

    return (mReturn);
}


#ifdef ANALYSIS

MRESULT EXPENTRY OneStatDlgProc ( HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2 )
   {
   CHAR      string[10];
   CHAR      *pString;
   switch( msg )
      {
      case WM_INITDLG:
       {
	 RECTL   Rectl;
	 WinQueryWindowRect (HWND_DESKTOP, &Rectl);
	 WinSetWindowPos (hwndDlg, 0, Rectl.xLeft+5, Rectl.yBottom, 0L, 0L,
	      SWP_MOVE | SWP_SHOW);
      }
      break;
      case WM_SHOWSTAT:
{  int i;
   static Statval *stat_a;
   GetStats(&stat_a);

  switch (stat_a[0].frametype) {
  case I_TYPE:
    WinSetDlgItemText ( hwndDlg, IE_FRAME, "I FRAME" );
    break;
  case P_TYPE:
    WinSetDlgItemText ( hwndDlg, IE_FRAME, "P FRAME" );
    break;
  case B_TYPE:
    WinSetDlgItemText ( hwndDlg, IE_FRAME, "B FRAME" );
    break;
  }

  pString = _ultoa (stat_a[0].totsize /8, string, 10 );
  WinSetDlgItemText ( hwndDlg, IE_BYTES, pString );
  pString = _ultoa (stat_a[0].totsize % 8, string, 10 );
  WinSetDlgItemText ( hwndDlg, IE_BITS, pString );

  if (stat_a[0].i_mbnum > 0) {
  pString = _ultoa (stat_a[0].i_mbnum, string, 10 );
  WinSetDlgItemText ( hwndDlg, IE_I, pString );

  pString = _ultoa (stat_a[0].i_mbsize / (8 * stat_a[0].i_mbnum), string, 10 );
  WinSetDlgItemText ( hwndDlg, IE_IBYTES, pString );
  pString = _ultoa ( (stat_a[0].i_mbsize * stat_a[0].i_mbnum) % 8, string, 10 );
  WinSetDlgItemText ( hwndDlg, IE_IBITS, pString );

  }
  else {
  WinSetDlgItemText ( hwndDlg, IE_I, "0" );
  WinSetDlgItemText ( hwndDlg, IE_IBYTES, "" );
  WinSetDlgItemText ( hwndDlg, IE_IBITS, "" );
  }
  if (stat_a[0].p_mbnum > 0) {

  pString = _ultoa (stat_a[0].p_mbnum, string, 10 );
  WinSetDlgItemText ( hwndDlg, IE_P, pString );

  pString = _ultoa (stat_a[0].p_mbsize / (8 * stat_a[0].p_mbnum), string, 10 );
  WinSetDlgItemText ( hwndDlg, IE_PBYTES, pString );
  pString = _ultoa ( (stat_a[0].p_mbsize * stat_a[0].p_mbnum) % 8, string, 10 );
  WinSetDlgItemText ( hwndDlg, IE_PBITS, pString );

  }

  else {
  WinSetDlgItemText ( hwndDlg, IE_P, "0" );
  WinSetDlgItemText ( hwndDlg, IE_PBYTES, "" );
  WinSetDlgItemText ( hwndDlg, IE_PBITS, "" );
  }
  if (stat_a[0].b_mbnum > 0) {

  pString = _ultoa (stat_a[0].b_mbnum, string, 10 );
  WinSetDlgItemText ( hwndDlg, IE_B, pString );

  pString = _ultoa (stat_a[0].b_mbsize / (8 * stat_a[0].b_mbnum), string, 10 );
  WinSetDlgItemText ( hwndDlg, IE_BBYTES, pString );
  pString = _ultoa ( (stat_a[0].b_mbsize * stat_a[0].b_mbnum) % 8, string, 10 );
  WinSetDlgItemText ( hwndDlg, IE_BBITS, pString );

  }

  else {
  WinSetDlgItemText ( hwndDlg, IE_B, "0" );
  WinSetDlgItemText ( hwndDlg, IE_BBYTES, "" );
  WinSetDlgItemText ( hwndDlg, IE_BBITS, "" );
  }
  if (stat_a[0].bi_mbnum > 0) {
  pString = _ultoa (stat_a[0].bi_mbnum, string, 10 );
  WinSetDlgItemText ( hwndDlg, IE_BI, pString );

  pString = _ultoa (stat_a[0].bi_mbsize / (8 * stat_a[0].bi_mbnum), string, 10 );
  WinSetDlgItemText ( hwndDlg, IE_BIBYTES, pString );
  pString = _ultoa ( (stat_a[0].bi_mbsize * stat_a[0].bi_mbnum) % 8, string, 10 );
  WinSetDlgItemText ( hwndDlg, IE_BIBITS, pString );

  }

  else {
  WinSetDlgItemText ( hwndDlg, IE_BI, "0" );
  WinSetDlgItemText ( hwndDlg, IE_BIBYTES, "" );
  WinSetDlgItemText ( hwndDlg, IE_BIBITS, "" );
  }
  sprintf(string,"%2.3g",(double)stat_a[0].tottime);
  WinSetDlgItemText ( hwndDlg, IE_TIME, (CHAR*)string );

  printf("\nTime to Decode: %g secs.\n", stat_a[0].tottime);
  printf("****************\n");
}
	 break;

      default:
	 return ( WinDefDlgProc (hwndDlg, msg, mp1, mp2) );

      }
   }


MRESULT EXPENTRY AllStatDlgProc ( HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2 )
   {
   CHAR      string[10];
   CHAR      *pString;
   switch( msg )
      {
      case WM_INITDLG:
       {
	 RECTL   Rectl;
	 WinQueryWindowRect (HWND_DESKTOP, &Rectl);
	 WinSetWindowPos (hwndDlg, 0, Rectl.xLeft+5, Rectl.yBottom+290, 0L, 0L,
	      SWP_MOVE);
      }
      break;
      case WM_SHOWALL:
{
  int i, j;
  unsigned int supertot, supernum;
  double supertime;

  static Statval *stat_a;
  GetStats(&stat_a);

  /* I-frames */
  pString = _ultoa (stat_a[1].number, string, 10 );
  WinSetDlgItemText ( hwndDlg, IA_I, pString );

  if (stat_a[1].number != 0) {
    pString = _ultoa ( stat_a[1].totsize / (8 * stat_a[1].number), string, 10 );
    WinSetDlgItemText ( hwndDlg, IA_IBYTES, pString );
    pString = _ultoa ( (stat_a[1].totsize / stat_a[1].number) % 8, string, 10 );
    WinSetDlgItemText ( hwndDlg, IA_IBITS, pString );
  }
  /* P-frames */
  pString = _ultoa (stat_a[2].number, string, 10 );
  WinSetDlgItemText ( hwndDlg, IA_P, pString );

  if (stat_a[2].number != 0) {
    pString = _ultoa ( stat_a[2].totsize / (8 * stat_a[2].number), string, 10 );
    WinSetDlgItemText ( hwndDlg, IA_PBYTES, pString );
    pString = _ultoa ( (stat_a[2].totsize / stat_a[2].number) % 8, string, 10 );
    WinSetDlgItemText ( hwndDlg, IA_PBITS, pString );
  }
  /* B-frames */
  pString = _ultoa (stat_a[3].number, string, 10 );
  WinSetDlgItemText ( hwndDlg, IA_B, pString );

  if (stat_a[3].number != 0) {
    pString = _ultoa ( stat_a[3].totsize / (8 * stat_a[3].number), string, 10 );
    WinSetDlgItemText ( hwndDlg, IA_BBYTES, pString );
    pString = _ultoa ( (stat_a[3].totsize / stat_a[3].number) % 8, string, 10 );
    WinSetDlgItemText ( hwndDlg, IA_BBITS, pString );
  }

  supertot = stat_a[1].totsize + stat_a[2].totsize + stat_a[3].totsize;
  supernum = stat_a[1].number + stat_a[2].number + stat_a[3].number;
  supertime = stat_a[1].tottime + stat_a[2].tottime + stat_a[3].tottime;

  pString = _ultoa ( supernum, string, 10 );
  WinSetDlgItemText ( hwndDlg, IA_TOTFRAMES, pString );

  pString = _ultoa ( supertot / (8 * supernum), string, 10 );
  WinSetDlgItemText ( hwndDlg, IA_TOTBYTES, pString );

  pString = _ultoa (( supertot / supernum) % 8, string, 10 );
  WinSetDlgItemText ( hwndDlg, IA_TOTBITS, pString );

  sprintf(string,"%2.3g",supertime );
  WinSetDlgItemText ( hwndDlg, IA_TOTTIME, string );

  sprintf(string,"%2.3g",supertime / ((double) supernum));
  WinSetDlgItemText ( hwndDlg, IA_DECTIME, string );

  sprintf(string,"%2.3g",((double) supernum) / supertime);
  WinSetDlgItemText ( hwndDlg, IA_DECFRAMES, string );


  }
       break;

      default:
	 return ( WinDefDlgProc (hwndDlg, msg, mp1, mp2) );

      }
   }

static void ShowOneStat()
{
   WinPostMsg(pwinData->hwndOneStat, WM_SHOWSTAT, 0L, 0L);
}


static void ShowAllStats()
{
   WinPostMsg(pwinData->hwndAllStat, WM_SHOWALL, 0L, 0L);
}

#endif
