/* Install.Cmd -- REXX */
/*
           ***************************************************************************************
           ***************************************************************************************
           ***                          Install IconEase 2.02                                  ***
           ***       For syntax, see the SelfDocExit procedure at the end of this file.        ***
           ***                                                                                 ***
           ***************************************************************************************
           ***************************************************************************************
*/
  
 parse ARG Arg1
 if ("" == Arg1) | (WordPos( Arg1, "/H /h /? -H -h -?") > 0) then 
     call SelfDocExit 
 
 call RxFuncAdd SysLoadFuncs, RexxUtil, SysLoadFuncs 
 call SysLoadFuncs 
 
 TgtPath = Arg1 
 '@IF NOT EXIST 'TgtPath'\*  @MD 'TgtPath
 call SysFileTree  TgtPath, FileTree, 'DT'
 if FileTree.0 <> 1 then 
 do 
     say "Can't find or create directory "TgtPath || D2C( 7)
     call SelfDocExit 
 end 
 call SysFileTree  TgtPath'\IconEase.Dat', FileTree, 'F'
 if FileTree.0 > 0 then 
 do 
    exti = 0
    do while FileTree.0 <> 0
        exti = exti + 1
        call SysFileTree  TgtPath'\iconease.'right(exti,3,'0'), FileTree, 'F'
    end /* do */
    beep(1000,100)
    beep(500,100)
    say "."
    say "."
    say 'Existing file IconEase.Dat in directory' TgtPath
    say '         renamed to IconEase.'right(exti,3,'0')
    '@ren 'TgtPath'\IconEase.Dat IconEase.'right(exti,3,'0')
    say '.'
    say '.'
    '@pause'
 end 
 '@COPY ICONEASE.EXE 'TgtPath' >NUL'
 '@EAUTIL 'TgtPath'\ICONEASE.EXE IEPGM.EA /J /P /O >NUL'
 '@COPY ICONESOM.DLL 'TgtPath' >NUL'
 '@COPY ICONEASE.HLP 'TgtPath' >NUL'
 '@COPY ICONEASE.DAT 'TgtPath' >NUL'
 '@EAUTIL 'TgtPath'\ICONEASE.DAT IEDB.EA /J /P /O >NUL'
 
 /* Create object on Desktop */
 Setup = 'EXENAME='TgtPath'\ICONEASE.EXE'
 Setup = Setup';STARTUPDIR='TgtPath
 rc = SysCreateObject( "WPPROGRAM", "IconEase", "<WP_DESKTOP>", Setup, "replace" ) 

 SAY ""
 SAY ""
 SAY ""
 SAY "   IconEase software installation is complete."
 SAY "   Double click the IconEase icon that is on your desktop."
 SAY "   Thank you for trying IconEase."
 SAY ""
 SAY ""
 SAY ""
 
 EXIT  rc
 
 /* ------------------------------------------------------------------------- */
 
 SelfDocExit:        procedure           expose SrcPath BootSetMax 
 
 SAY "Install.Cmd"
 SAY "This little REXX command will copy the IconEase 2.0 shareware distribution"  
 SAY "files to a target directory that you need to specify.  (see syntax below)"
 SAY ""
 SAY "An icon will be placed on your desktop for IconEase.  You may move this icon"
 SAY "to another folder if you wish.  OS/2 will create a template in your template"
 SAY "folder called, IconEase Database.  Templates make creating new icon databases"
 SAY "a breeze.  Please see the help topic, Creating New Icon Databases."        
 SAY ""
 SAY "NOTE:       You need at least 405k bytes available on the target drive."
 SAY ""
 SAY "USAGE:      INSTALL  target_dir_fullpathname"
 SAY "EXAMPLE:    Install  D:\PGMS\ICONEASE"
 
 EXIT  1
 
 /* ------------------------------------------------------------------------- */
 /* end file Install.Cmd */
 


