// Tutor2.CPP
// This Programming Tutorial show how to display and rotate
// a 3D Object created with the Citigrade 3D Editor, but using
// Page Swapping for smooth animation

#include <wgt4.h>
#include <stdlib.h>
#include <conio.h>
#include <iostream.h>
#include "Object3D.HPP"

// Rotation increments
const X_Rot = 1;
const Y_Rot = 1;
const Z_Rot = 1;

// The 3D Object
a3DObject Boat;

// A block of memory for Page Swapping
block Swap;

void main()
{
 // Description of Tutorial1
 clrscr();
 cout << "This is a Programming Tutorial for the Citigrade 3D Editor, version 1.01\n\n"
      << "Tuturial 2:\n"
      << "This Tutorial shows how easy it is to use 3D Objects in your own programs.\n"
      << "A 3D Boat will be rotated on the screen, but this time Page Swapping will\n"
      << "be used to make the animation smoother.\n\n"
      << "Press any key to continue...";
 getch();

 // Initialize Graphics with WGT
 int OldMode = wgetmode();
 vga256();

 // Initialize 3D Graphics, for Sin and Cos lookup tables
 Init3D();

 // Get the block of memory for Page Swapping
 Swap = wnewblock(0,0,319,199);

 // Load and set Object Data
 Boat.Load ("Boat2.3d");
 Boat.SetPage (Swap);

 // Rotate Object until key is pressed
 do
 {
  Boat.Show();
  Boat.Rotate (X_Rot,Y_Rot,Z_Rot);
 } while (!kbhit());
 getch();

 // Restore Text Mode
 wfreeblock (Swap);
 wsetmode (OldMode);
}