/*
 * TextFX2 Copyright (c) 1998 Jari Komppa aka Sol/Trauma
 * <mailto:solar@compart.fi>
 *
 * Textmode low-level functions
 *
 * This sourcefile is kinda long-ish, and should be split into several
 * sources, but I have wanted to keep it in one file since everything
 * here is kinda small and.. well, I wanted to keep it as a single .obj
 * file.
 *
 * If you make improvements, send me a copy!
 * If you use this for something, let me know!
 */

#include <math.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <i86.h>
#include <dos.h>

/*************************************************************************
 * Compilation options
 *
 */

//#define __USE_178NOT176
 /* uncomment to use 75% char instead of 25% char */

#define __USE_REALIBMPAL
 /* comment out to use 'clean' truecolor palette for calculations */

#define COLORMAP_DEPTH 4
 /* Normally, build 1<<4, ie. 16x16x16 colormap.
  * If you require bigger map, increase the value.
  * (5 will mean 32x32x32 etc).
  * 8 is max for dump_80x and _320x, 6 is max for _160x.
  * If you make your own routines, well, nothing is too much :)
  */

/* Don't touch the rest of the defines. */

#define COLMAPDIM (1<<COLORMAP_DEPTH)
#define TRUCOLBITS (8-COLORMAP_DEPTH)

/*************************************************************************
 * Global data & variables
 *
 */

#ifdef __USE_REALIBMPAL

char palette[16*3]={ /* IBM basic palette, 16c */
 0, 0, 0,  0, 0,42,  0,42, 0,  0,42,42, 42, 0, 0, 42, 0,42, 42,21, 0, 42,42,42,
21,21,21, 21,21,63, 21,63,21, 21,63,63, 63,21,21, 63,21,63, 63,63,21, 63,63,63};

#else

char palette[16*3]={ /* 'clean' RGB palette */
 0, 0, 0,  0, 0,32,  0,32, 0,  0,32,32, 32, 0, 0, 32, 0,32, 32,32, 0, 32,32,32,
32,32,32,  0, 0,63,  0,63, 0,  0,63,63, 63, 0, 0, 63, 0,63, 63,63, 0, 63,63,63};

#endif

/*
 * Charsets in 'lightness' order. First byte = num of chars
 *
 * Please note that these don't work with the current calcpal
 * strategy :)
 *
 */

char charset_b8ibm[]= /* all imbscii characters */
{ 254, 32, 96, 39, 250, 95, 126, 46, 94, 34, 249, 248, 44, 58, 45,
196, 59, 253, 167, 61, 166, 252, 47, 28, 217, 192, 169, 205, 246, 7,
170, 27, 190, 43, 212, 62, 60, 124, 26, 226, 193, 40, 243, 242, 240,
63, 41, 37, 139, 191, 55, 91, 207, 218, 200, 176, 9, 105, 241, 92,
141, 33, 125, 238, 102, 161, 231, 123, 211, 202, 247, 108, 99, 168,
188, 73, 93, 67, 29, 175, 174, 106, 114, 189, 140, 24, 76, 116, 194,
208, 49, 115, 50, 70, 228, 13, 84, 80, 156, 51, 120, 122, 179, 173,
184, 53, 89, 155, 244, 213, 90, 25, 135, 223, 57, 42, 83, 118, 128,
101, 245, 127, 171, 74, 19, 159, 4, 1, 180, 110, 137, 230, 195, 209,
18, 97, 111, 117, 86, 229, 31, 138, 69, 144, 22, 148, 130, 16, 132,
181, 129, 36, 157, 198, 136, 12, 214, 71, 239, 133, 160, 162, 149,
163, 151, 52, 54, 98, 107, 251, 104, 224, 197, 183, 154, 235, 164,
112, 131, 85, 147, 121, 236, 150, 232, 134, 153, 11, 210, 225, 79,
172, 145, 227, 152, 100, 23, 21, 88, 17, 48, 119, 75, 68, 113, 30, 72,
15, 233, 56, 103, 65, 142, 234, 5, 82, 109, 216, 201, 254, 66, 38,
158, 143, 237, 203, 187, 77, 221, 146, 14, 78, 35, 81, 64, 20, 177,
87, 6, 165, 3, 204, 186, 222, 199, 206, 185, 182, 215, 220, 2, 178,
10, 8, 219 };

char charset_b7asc[]= /* 7b ascii (chars 32 - 126) */
{ 94, 32, 96, 39, 95, 126, 46, 94, 34, 44, 58, 45, 59, 61, 47, 43, 62,
60, 40, 63, 41, 37, 55, 91, 105, 92, 33, 125, 102, 123, 108, 99, 73,
93, 67, 106, 114, 76, 116, 49, 115, 50, 70, 84, 80, 51, 120, 122, 53,
89, 90, 57, 42, 83, 118, 101, 74, 110, 97, 111, 117, 86, 69, 36, 71,
52, 54, 98, 107, 104, 112, 85, 121, 79, 100, 88, 48, 119, 75, 68, 113,
72, 56, 103, 65, 82, 109, 66, 38, 77, 78, 35, 81, 64, 87};

char charset_b7sml[]= /* " crsxzvenaouwm" dark->light. */
{ 14, 32, 99, 114, 115, 120, 122, 118, 101, 110, 97, 111, 117, 119,
109 };

char charset_b8gry[]= /* 8b ibm grayscale characters */
{ 5, 32, 176, 177, 178, 219 };

char charset_b7nws[]= /* 7b grayscale 'newschool' askee chars*/
{ 6, ' ', '.', 'o', 'm', 'W', 'M' };

char * use_charset=charset_b7asc;
  /* Character set to use. Can be changed run-time. */


short int * colmap=NULL;

#define COLMAP(r,g,b) *(colmap+((r)<<(COLORMAP_DEPTH*2))+((g)<<COLORMAP_DEPTH)+(b))

/*************************************************************************
 * Prototypes
 *
 */

void set80x43(void); /* Sets up 80x43, no blink, no cursor. */
void set80x50(void); /* Sets up 80x50, no blink, no cursor. */
void set80x25(void); /* Resets 80x25, blink, cursor. */
void border(char color); /* _ONLY_ for debugging! */
void vrc(void); /* Although all should be timer-synced instead.. */

/*
 * calc_ functions are pretty *S*L*O*W* so use them to precalculate
 * color tables and then use those tables instead.
 */

short int calcpal_colorbase(float red, float green, float blue);
short int calcpal_lightbase(float red, float green, float blue);
short int calcpal_lightbase_g(float red, float green, float blue);
short int (*calcpal)(float red, float green, float blue)=calcpal_colorbase;
    /* Finds the closest color/char combo for any 0:63,0:63,0:63 value.
     *
     * calcpal_colorbase is the 'old' calcpal, only "a bit" optimized.
     * (takes about sqrt(n) time compared to the old one).
     * calcpal is now function pointer so calcpal function can be changed
     * run-time. Use the functions directly if you need speed (and
     * compile with -oe256 or something to force inlining)
     */

short int calc_gscale(float light);
short int calc_gscale2(float light);
    /* Finds the closes gscale color/char combo for 0..1 range
     * gscale2 uses colors 8,7,15, normal just uses 7.
     */

void build_colormap(int dots);
    /* Used to calculate colormap for dump_nnx() -functions.
     * if dots=0, will output nothing.
     *         1, will cprintf .:s as process.
     *         2, will cprintf rolling wheel as process.
     */

void dump_80x(int y0, int y1, int * buffer);
    /* Dumps 80-pixel wide 0bgr-truecolor buffer from y0 to y1.
     * (For fullscreen dump in 80x43 use dump_80x(0,43,buf);
     */

void dump_160x(int y0, int y1, int * buffer);
    /* Dumps 160-pixel wide 0bgr-truecolor buffer from y0 to y1
     * with 4-to-1 pixel averaging.
     */

void dump_320x(int y0, int y1, int * buffer);
    /* Dumps 160-pixel wide 0bgr-truecolor buffer from y0 to y1
     * with 16-to-1 pixel averaging. (this is tad bit slow :)
     */

/*************************************************************************
 * Functions
 *
 * 1. VGA stuff
 */

void vrc(void) {
    while ((inp(0x3da)&8)==0) {}
    while ((inp(0x3da)&8)!=0) {}
}

void border(char color) {
    inp(0x3da);
    outp(0x3c0,17+32);
    outp(0x3c0,color);
}

void set80x43(void) {
union REGS regs;
  regs.w.ax=0x1201; /* Set scanlines */
  regs.h.bl=0x30;
  int386(0x10,&regs,&regs);
  regs.w.ax=0x3;    /* Set text mode */
  int386(0x10,&regs,&regs);
  regs.w.ax=0x1112; /* Set font */
  regs.w.bx=0;
  int386(0x10,&regs,&regs);
  regs.h.bh=0;      /* Kill cursor - doesn't seem to work.. */
  regs.h.ah=3;
  int386(0x10,&regs,&regs);
  regs.w.cx=0x2000;
  regs.h.ah=1;
  int386(0x10,&regs,&regs);
  regs.w.ax=0x1003; /* Kill blink */
  regs.h.bl=0;
  int386(0x10,&regs,&regs);
  regs.w.ax=0x0200;   /* Position cursor to 51,80 - better way to kill. */
  regs.w.bx=0x0033;
  regs.w.dx=0x004f;
  int386(0x10,&regs,&regs);
}

void set80x50(void) {
union REGS regs;
  regs.w.ax=0x1202; /* Set 400 scanlines */
  regs.h.bl=0x30;
  int386(0x10,&regs,&regs);
  regs.w.ax=0x3;    /* Set text mode */
  int386(0x10,&regs,&regs);
  regs.w.ax=0x1112; /* Set font */
  regs.w.bx=0;
  int386(0x10,&regs,&regs);
  regs.h.bh=0;      /* Kill cursor - doesn't seem to work.. */
  regs.h.ah=3;
  int386(0x10,&regs,&regs);
  regs.w.cx=0x2000;
  regs.h.ah=1;
  int386(0x10,&regs,&regs);
  regs.w.ax=0x1003; /* Kill blink */
  regs.h.bl=0;
  int386(0x10,&regs,&regs);
  regs.w.ax=0x0200;   /* Position cursor to 51,80 - better way to kill. */
  regs.w.bx=0x0033;
  regs.w.dx=0x004f;
  int386(0x10,&regs,&regs);
}

void set80x25(void) {
union REGS regs;
  regs.w.ax=0x1202; /* Set 350 scanlines */
  regs.h.bl=0x30;
  int386(0x10,&regs,&regs);
  regs.w.ax=0x3;    /* Set text mode */
  int386(0x10,&regs,&regs);
  regs.w.ax=0x1114; /* Set font */
  regs.w.bx=0;
  int386(0x10,&regs,&regs);
  regs.h.bh=0;      /* Ressurrect cursor */
  regs.h.ah=3;
  int386(0x10,&regs,&regs);
  regs.w.cx&=0xdfff;
  regs.h.ah=1;
  int386(0x10,&regs,&regs);
  regs.w.ax=0x1003; /* Enable blink */
  regs.h.bl=1;
  int386(0x10,&regs,&regs);
}

/*************************************************************************
 * Functions
 *
 * 2. Color calculations
 */

/*
 * static double exp(double p1) {
 *   return (p1*p1);
 * }
 *  Now then. Why that ^^ is darn slow and doesn't even work?!
 *  as far as I can think, it should be faster, and I can't see
 *  any reason why it wouldn't work.
 */
#define exp(a) ((a)*(a))

short int calcpal_colorbase(float red, float green, float blue) {
int a,b,c,d,ch,co;
double lastdist, dist;
  red*=1.2;
  green*=1.2;
  blue*=1.2;
  lastdist=1e242;
  for (c=0,d=0;c<16;c++,d+=3) {
    dist=exp(palette[d+0]-red)+
         exp(palette[d+1]-green)+
         exp(palette[d+2]-blue);
    if (dist<lastdist) {
      lastdist=dist;
      co=c;
      ch=219; /* 100% block in IBMSCII */
    }
  }
  c=co;
  d=c*3;
  for (b=0,a=0;b<16;b++,a+=3) {
    dist=exp(((palette[a+0]+palette[d+0])/2.0)-red)+
         exp(((palette[a+1]+palette[d+1])/2.0)-green)+
         exp(((palette[a+2]+palette[d+2])/2.0)-blue);
    if (dist<lastdist) {
      lastdist=dist;
      co=b+(c<<4);
      ch=177; /* 50% block in IBMSCII */
    }
#ifdef __USE_178NOT176
    dist=exp((palette[a+0]*0.75+palette[d+0]*0.25)-red)+
         exp((palette[a+1]*0.75+palette[d+1]*0.25)-green)+
         exp((palette[a+2]*0.75+palette[d+2]*0.25)-blue);
    if (dist<lastdist) {
      lastdist=dist;
      co=b+(c<<4);
      ch=178; /* 75% block in IBMSCII */
    }
    dist=exp((palette[a+0]*0.25+palette[d+0]*0.75)-red)+
         exp((palette[a+1]*0.25+palette[d+1]*0.75)-green)+
         exp((palette[a+2]*0.25+palette[d+2]*0.75)-blue);
    if (dist<lastdist) {
      lastdist=dist;
      co=c+(b<<4);
      ch=178; /* 75% block in IBMSCII */
    }
#else
    dist=exp((palette[a+0]*0.25+palette[d+0]*0.75)-red)+
         exp((palette[a+1]*0.25+palette[d+1]*0.75)-green)+
         exp((palette[a+2]*0.25+palette[d+2]*0.75)-blue);
    if (dist<lastdist) {
      lastdist=dist;
      co=b+(c<<4);
      ch=176; /* 25% block in IBMSCII */
    }
    dist=exp((palette[a+0]*0.75+palette[d+0]*0.25)-red)+
         exp((palette[a+1]*0.75+palette[d+1]*0.25)-green)+
         exp((palette[a+2]*0.75+palette[d+2]*0.25)-blue);
    if (dist<lastdist) {
      lastdist=dist;
      co=c+(b<<4);
      ch=176; /* 25% block in IBMSCII */
    }
#endif
  }
  return((co<<8)+ch);
}

/*
 * Unlike _colorbase, _lightbase and _gscale calculations are
 * based on some trivial assumptions, such as that the character
 * tables have linear grayscale ramps and stuff like that.
 *
 * ie: they are *not* accurate!
 *
 * The tables were generated by calculating the dot distance from
 * center of character, ((xdistmax-xdist)^2)+((ydistmax-ydist)^2),
 * and sorting by this value. (HOW are you supposed to calculate
 * random pattern lightness value anyway?! =)
 *
 * Bright and dark color values are just thrown in without any
 * math background. (How could there be some? At this point you
 * should realize we have thrown all accurancy out the window).
 *
 * So. They work - kinda. They don't work correctly, but there
 * you go.
 *
 * color ramp= (dark color) [0 .. 1] + (light color) [0.3 .. 1]
 *
 * (didn't bother to rip AAlib :)
 */

short int calcpal_lightbase(float red, float green, float blue) {
int light,col,a,a3;
float lastdist,dist;
  lastdist=1e24;
  for (a=1,a3=3;a<16;a++,a3+=3) {
    dist=exp(palette[a*3+0]-red)+
         exp(palette[a*3+1]-green)+
         exp(palette[a*3+2]-blue);
    if (dist<lastdist) {
      lastdist=dist;
      col=a;
    }
  }
  light=floor(((0.2990*red+0.5870*green+0.1140*blue)/63)*64);
  if (light<32)
    light=floor(((0.2990*red+0.5870*green+0.1140*blue)/63)*1.5 * (*use_charset));
  else
    light=floor((((0.2990*red+0.5870*green+0.1140*blue)/63)) * (*use_charset));
  return (col<<8)+*(use_charset+light+1);
}

short int calcpal_lightbase_g(float red, float green, float blue) {
int light;
  light=floor((((0.2990*red+0.5870*green+0.1140*blue)/63)) * (*use_charset));
  return (7<<8)+*(use_charset+light +1);
}

short int calc_gscale(float light) {
  return (7<<8)+*(use_charset+(int)(light* (*use_charset+1)));
}

short int calc_gscale2(float light) {
  if (light<0.3)
    return (8<<8)+*(use_charset+(int)(light*3* (*use_charset+1)));
  if (light<0.6)
    return (7<<8)+*(use_charset+(int)((light+0.3)* (*use_charset+1)));
  return (15<<8)+*(use_charset+(int)(light* (*use_charset+1)));
}

void build_colormap(int dots) {
char wheel[]="-\\|/";
int r,g,b;
double f;
  if (dots==2) cprintf(" ");
  if (colmap!=NULL) free(colmap);
  f=64.0/COLMAPDIM;
  colmap=malloc(sizeof(short int)*COLMAPDIM*COLMAPDIM*COLMAPDIM);
  for (r=0;r<COLMAPDIM;r++) {
    for (g=0;g<COLMAPDIM;g++)
      for (b=0;b<COLMAPDIM;b++)
        COLMAP(r,g,b)=calcpal(r*f,g*f,b*f);
    if (dots==1) cprintf(".");
    if (dots==2) cprintf("\b%c",wheel[r&3]);
  }
}

void dump_80x(int y0, int y1, int * buffer) {
int x,y,yd;
short int * scr;
char * buf=(char*)buffer;
  scr=(short int*)((char*)0xb8000+(y0*160));
  yd=y1-y0;
  for (y=0;y<yd;y++)
    for (x=0;x<80;x++,scr++,buf+=4)
      *scr=COLMAP(*(buf+0)>>TRUCOLBITS,
                  *(buf+1)>>TRUCOLBITS,
                  *(buf+2)>>TRUCOLBITS);
}

void dump_160x(int y0, int y1, int * buffer) {
int x,y,yd;
unsigned long i;
short int * scr;
char * buf=(char*)&i;
  scr=(short int*)((char*)0xb8000+(y0*160));
  yd=y1-y0;
  for (y=0;y<yd;y++,buffer+=160)
    for (x=0;x<80;x++,scr++,buffer+=2) {
      i=(*(buffer+0)&0xfcfcfcfc)+
        (*(buffer+1)&0xfcfcfcfc)+
        (*(buffer+160)&0xfcfcfcfc)+
        (*(buffer+161)&0xfcfcfcfc);
      i>>=2;
      i&=0xfcfcfcfc;
      *scr=COLMAP(*(buf+0)>>TRUCOLBITS,
                  *(buf+1)>>TRUCOLBITS,
                  *(buf+2)>>TRUCOLBITS);
    }
}

void dump_320x(int y0, int y1, int * buffer) {
int x,y,yd,r,g,b,xx,yy;
char * buf=(char*)buffer;
short int * scr;
  scr=(short int*)((char*)0xb8000+(y0*160));
  yd=y1-y0;
  for (y=0;y<yd;y++,buf+=80*4*4*3)
    for (x=0;x<80;x++,scr++,buf+=4*4) {
      r=g=b=0;
      for (xx=0;xx<4*4;xx+=4)
        for (yy=0;yy<4*4*320;yy+=320*4) {
          r+=*(buf+xx+yy+0);
          g+=*(buf+xx+yy+1);
          b+=*(buf+xx+yy+2);
        }
      *scr=COLMAP(r>>(TRUCOLBITS+4),
                  g>>(TRUCOLBITS+4),
                  b>>(TRUCOLBITS+4));
    }
}
