import java.lang.*;
import java.awt.*;

class Matrix
{
  static void identity(float a[][])
  {
    int i, j;
    
    for (j = 0; j < 4; j++) {
      for (i = 0; i < 4; i++) {
        a[j][i] = 0;
      }
    }
    a[0][0] = 1;
    a[1][1] = 1;
    a[2][2] = 1;
    a[3][3] = 1;
  }

  static void mul(float a[][], float b[][])
  {
    float r[][] = new float[4][4];
    int i, j;
        
    r[0][0] = a[0][0]*b[0][0] + a[0][1]*b[1][0] + a[0][2]*b[2][0];
    r[0][1] = a[0][0]*b[0][1] + a[0][1]*b[1][1] + a[0][2]*b[2][1];
    r[0][2] = a[0][0]*b[0][2] + a[0][1]*b[1][2] + a[0][2]*b[2][2];
    r[0][3] = 0;

    r[1][0] = a[1][0]*b[0][0] + a[1][1]*b[1][0] + a[1][2]*b[2][0];
    r[1][1] = a[1][0]*b[0][1] + a[1][1]*b[1][1] + a[1][2]*b[2][1];
    r[1][2] = a[1][0]*b[0][2] + a[1][1]*b[1][2] + a[1][2]*b[2][2];
    r[1][3] = 0;

    r[2][0] = a[2][0]*b[0][0] + a[2][1]*b[1][0] + a[2][2]*b[2][0];
    r[2][1] = a[2][0]*b[0][1] + a[2][1]*b[1][1] + a[2][2]*b[2][1];
    r[2][2] = a[2][0]*b[0][2] + a[2][1]*b[1][2] + a[2][2]*b[2][2];
    r[2][3] = 0;

    r[3][0] = a[3][0]*b[0][0] + a[3][1]*b[1][0] + a[3][2]*b[2][0] + b[3][0];
    r[3][1] = a[3][0]*b[0][1] + a[3][1]*b[1][1] + a[3][2]*b[2][1] + b[3][1];
    r[3][2] = a[3][0]*b[0][2] + a[3][1]*b[1][2] + a[3][2]*b[2][2] + b[3][2];
    r[3][3] = 1;
    
    for (j = 0; j < 4; j++) {
      for (i = 0; i < 4; i++) {
        a[j][i]= r[j][i];
      }
    }
  }

  public static void rotate(float mx[][], float ax, float ay, float az)
  {
    float my[][] = new float[4][4];
    float mz[][] = new float[4][4];
    
    identity(mx);
    mx[1][1] = (float) Math.cos(ax); mx[1][2] = (float) Math.sin(ax);
    mx[2][1] =-(float) Math.sin(ax); mx[2][2] = (float) Math.cos(ax);

    identity(my);
    my[0][0] = (float) Math.cos(ay); my[0][2] =-(float) Math.sin(ay);
    my[2][0] = (float) Math.sin(ay); my[2][2] = (float) Math.cos(ay);

    identity(mz);
    mz[0][0] = (float) Math.cos(az); mz[0][1] = (float) Math.sin(az);
    mz[1][0] =-(float) Math.sin(az); mz[1][1] = (float) Math.cos(az);

    mul(mx, my);
    mul(mx, mz);
  }
}

public class KolmeDee
{
  public float    points[];
  public int      rpoints[];
  public float    normals[];
  public int      rnormals[];
  public int      faces[];
  public int      npoints, nfaces;
  public float    kx, ky, kz;
  public float    x, y, z;
  public float    matrix[][] = new float[4][4];

  private Color   pal[];

         int      sfaces[];
         int      nsfaces;

         int      stable1[][], stable1z[][], stable2[][], stable2z[][];

  public int      maxs, mins, avgs, minz, maxz;

  public KolmeDee(int np, float p[], int nf, int f[], Color c[])
  {
    int n;
    
    rpoints = new int[np*3];
    normals = new float[nf*3];
    rnormals = new int[nf];
    npoints = np;
    points = p;
    nfaces = nf;
    faces = f;
    sfaces = new int[1024];

    stable1 = new int[1024][16];
    stable1z = new int[1024][16];
    calcNormals();
    pal = new Color[64];
    for (n = 0; n < 32; n++) {
      pal[n] = Color.black;
    }
    for (n = 0; n < 32; n++) {
      pal[n+32] = c[n];
    }
  }

  void calcNormals()
  {
    int   n;
    int   p1, p2, p3;
    float x, y, z, d;
    
    for (n = 0; n < nfaces; n++) {
      p1 = faces[n*4]*3;
      p2 = faces[n*4+1]*3;
      p3 = faces[n*4+2]*3;
      x = (points[p1+1] - points[p2+1]) * (points[p1+2] - points[p3+2]) -
          (points[p1+2] - points[p2+2]) * (points[p1+1] - points[p3+1]);
      y = (points[p1+2] - points[p2+2]) * (points[p1+0] - points[p3+0]) -
          (points[p1+0] - points[p2+0]) * (points[p1+2] - points[p3+2]);
      z = (points[p1+0] - points[p2+0]) * (points[p1+1] - points[p3+1]) -
          (points[p1+1] - points[p2+1]) * (points[p1+0] - points[p3+0]);
      d = (float) Math.sqrt(x*x + y*y + z*z);
      normals[n*3] = x/d;
      normals[n*3+1] = y/d;
      normals[n*3+2] = z/d;
    }
  }

  private final void sort(int top, int bottom)
  {
    int i, j;
    int x, tmp;
    
    i = top;
    j = bottom;
    
    x = sfaces[(top+bottom)/2];
    do {
      while (sfaces[i] < x) i++;
      while (x < sfaces[j]) j--;
      if (i < j) {
        tmp = sfaces[i];
        sfaces[i] = sfaces[j];
        sfaces[j] = tmp;
      }
      if (i <= j) {
        i++;
        j--;
      }
    } while (i <= j);
    if (top < j) sort(top, j);
    if (i < bottom) sort(i, bottom);
  }

/*  private final void sort(int nf)
  {
    int i, j, k, n, z, f;
    int scount[];
    
    maxs = 0;
    mins = 100000;
    minz = 64000;
    maxz = 0;
    scount = new int[1024];
    for (i = 0; i < nf; i++) {
      z = sfacesz[i];
      if (z < minz) minz = z;
      else if (z > maxz) maxz = z;
      f = sfaces[i];
      j = z & 255;
      k = scount[j];
      stable1[j][k] = f;
      stable1z[j][k] = z;
      scount[j]++;
    }
    j = 0;
    avgs = 0;
    for (n = 0; n < 256; n++) {
      i = scount[n];
      if (i > 0) {
        if (i < mins) mins = i;
        if (i > maxs) maxs = i;
        avgs += i;
        j++;
      }
    }
    avgs = avgs/j;
  }
*/
  public void rotate()
  {
    float m00, m01, m02;
    float m10, m11, m12;
    float m20, m21, m22;
    float m30, m31, m32;
    float x, y, z;
    float rx, ry, rz;
 
    int   np, n;

    Matrix.rotate(matrix, kx, ky, kz);
    matrix[3][0] += this.x;
    matrix[3][1] += this.y;
    matrix[3][2] += this.z;
        
    m00 = matrix[0][0];
    m01 = matrix[0][1];
    m02 = matrix[0][2];
    m10 = matrix[1][0];
    m11 = matrix[1][1];
    m12 = matrix[1][2];
    m20 = matrix[2][0];
    m21 = matrix[2][1];
    m22 = matrix[2][2];
    m30 = matrix[3][0];
    m31 = matrix[3][1];
    m32 = matrix[3][2];
    
    np = npoints;
    for (n = 0; n < np; n++) {
      x = points[n*3];
      y = points[n*3+1];
      z = points[n*3+2];
      rz = x*m02 + y*m12 + z*m22 + m32;
      rpoints[n*3+2] = (int) rz;
      rpoints[n*3] = (int) ((x*m00 + y*m10 + z*m20 + m30)*200/rz+160);
      rpoints[n*3+1] = (int) (100-(x*m01 + y*m11 + z*m21 + m31)*200/rz);
    }
  }

  public void rotateNormals()
  {
    float m00, m01, m02;
    float m10, m11, m12;
    float m20, m21, m22;
    float m30, m31, m32;
    float x, y, z;
    float rx, ry, rz;
 
    int   nf, n;

    Matrix.rotate(matrix, kx, ky, kz);
        
    m00 = matrix[0][0];
    m01 = matrix[0][1];
    m02 = matrix[0][2];
    m10 = matrix[1][0];
    m11 = matrix[1][1];
    m12 = matrix[1][2];
    m20 = matrix[2][0];
    m21 = matrix[2][1];
    m22 = matrix[2][2];
    
    nf = nfaces;
    for (n = 0; n < nf; n++) {
      x = normals[n*3];
      y = normals[n*3+1];
      z = normals[n*3+2];
      rnormals[n] = ((int) (31.0*(x*m02 + y*m12 + z*m22)));
    }
  }

  public void render(Graphics buf)
  {
    int   nf, n, i;
    int   p1, p2, p3;
    int   x1, y1, x2, y2, x3, y3;
    int   xp[] = new int[3], yp[] = new int[3];
    int   col;
    int   nsf;
    int   f;

/*    for (n = 0; n < 8; n++) cols[n] = new Color(n*36, 0, 0);
    for (n = 0; n < 8; n++) cols[n+8] = new Color(0, n*36, 0);
    for (n = 0; n < 8; n++) cols[n+16] = new Color(0, 0, n*36); */

    nf = nfaces;
    i = 0;
    nsf = 0;
    for (n = 0; n < nf; n++) {
      p1 = faces[n*4]*3;
      p2 = faces[n*4+1]*3;
      p3 = faces[n*4+2]*3;
      x1 = rpoints[p1];
      y1 = rpoints[p1+1];
      x2 = rpoints[p2];
      y2 = rpoints[p2+1];
      x3 = rpoints[p3];
      y3 = rpoints[p3+1];
      if ((x1 - x2) * (y3 - y2) -
      (y1 - y2) * (x3 - x2) >= 0) {
        sfaces[nsf] = ((rpoints[p1+2]+rpoints[p2+2]+rpoints[p3+2]) << 16)+n;
        nsf++;
      }
    }
    sort(0, nsf-1);
    for (n = nsf-1; n >= 0; n--) {
      f = sfaces[n] & 65535;
      p1 = faces[f*4]*3;
      p2 = faces[f*4+1]*3;
      p3 = faces[f*4+2]*3;
      xp[0] = rpoints[p1];
      yp[0] = rpoints[p1+1];
      xp[1] = rpoints[p2];
      yp[1] = rpoints[p2+1];
      xp[2] = rpoints[p3];
      yp[2] = rpoints[p3+1];
      buf.setColor(pal[rnormals[f]+32]);
      buf.fillPolygon(xp, yp, 3);
    }
  }
}
