#ifndef __OGL2_TYPES__
#define __OGL2_TYPES__

#ifdef WIN32
#include <windows.h>
#endif

#ifndef WIN32
#define APIENTRY
#define CALLBACK
#endif

#include <GL/gl.h>
#include "List.h"

#include "vector2.h"
#include "vector3.h"
#include "vector4.h"

extern "C++" {

typedef struct {
  GLfloat x, y;
} InterleavedArrayElement_V2F;

typedef struct {
  GLfloat x, y, z;
} InterleavedArrayElement_V3F;

typedef struct {
  GLubyte R, G, B, A;
  GLfloat x, y;
} InterleavedArrayElement_C4UB_V2F;

typedef struct {
  GLubyte R, G, B, A;
  GLfloat x, y, z;
} InterleavedArrayElement_C4UB_V3F;

typedef struct {
  GLfloat R, G, B;
  GLfloat x, y, z;
} InterleavedArrayElement_C3F_V3F;

typedef struct {
  GLfloat i, j, k;
  GLfloat x, y, z;
} InterleavedArrayElement_N3F_V3F;

typedef struct {
  GLfloat R, G, B, A;
  GLfloat i, j, k;
  GLfloat x, y, z;
} InterleavedArrayElement_C4F_N3F_V3F;

typedef struct {
  GLfloat s, t;
  GLfloat x, y, z;
} InterleavedArrayElement_T2F_V3F;

typedef struct {
  GLfloat s, t, r, q;
  GLfloat x, y, z, w;
} InterleavedArrayElement_T4F_V4F;

typedef struct {
  GLfloat s, t;
  GLubyte A, R, G, B;
  GLfloat x, y, z;
} InterleavedArrayElement_T2F_C4UB_V3F;

typedef struct {
  GLfloat s, t;
  GLfloat R, G, B;
  GLfloat x, y, z;
} InterleavedArrayElement_T2F_C3F_V3F;

typedef struct
{
  GLfloat s, t;
  GLfloat i, j, k;
  GLfloat x, y, z;
} InterleavedArrayElement_T2F_N3F_V3F;

typedef struct {
  GLfloat s, t;
  GLfloat R, G, B, A;
  GLfloat i, j, k;
  GLfloat x, y, z;
} InterleavedArrayElement_T2F_C4F_N3F_V3F;

typedef struct {
  GLfloat s, t, r, q;
  GLfloat R, G, B, A;
  GLfloat i, j, k;
  GLfloat x, y, z, w;
} InterleavedArrayElement_T4F_C4F_N3F_V4F;

// GLvertex is an alias to InterleavedArrayElement_T4F_C4F_N3F_V4F
typedef InterleavedArrayElement_T4F_C4F_N3F_V4F GLvertex;

// instantations of vertex lists from the templates

template class List<GLvertex>;
typedef List<GLvertex> GLvertex_list;

} // extern "C++"

#endif

