/*
 * Useful macros.
 */

#ifndef __OGL2_MACROS_H__
#define __OGL2_MACROS_H__

#define UBYTE_TO_FLOAT(B)	((GLfloat) (B) * (1.0F / 255.0F))
#define BYTE_TO_FLOAT(B)	((2.0F * (B) + 1.0F) * (1.0F/255.0F))
#define USHORT_TO_FLOAT(S)	((GLfloat) (S) * (1.0F / 65535.0F))
#define SHORT_TO_FLOAT(S)	((2.0F * (S) + 1.0F) * (1.0F/65535.0F))
#define UINT_TO_FLOAT(U)	((GLfloat) (U) * (1.0F / 4294967295.0F))
#define INT_TO_FLOAT(I)		((2.0F * (I) + 1.0F) * (1.0F/4294967294.0F))

inline void SetVector3 (GLfloat* v, GLfloat x, GLfloat y, GLfloat z) {
  v[0] = x;  v[1] = y;  v[2] = z;
}
inline void SetVector4 (GLfloat* v, GLfloat x, GLfloat y, GLfloat z, GLfloat w) {
  v[0] = x;  v[1] = y;  v[2] = z;  v[3] = w;
}
inline void SetVector3 (GLfloat* v, GLubyte x, GLubyte y, GLubyte z) {
  v[0] = UBYTE_TO_FLOAT(x);  v[1] = UBYTE_TO_FLOAT(y);
  v[2] = UBYTE_TO_FLOAT(z);
}
inline void SetVector4 (GLfloat* v, GLubyte x, GLubyte y, GLubyte z, GLubyte w) {
  v[0] = UBYTE_TO_FLOAT(x);  v[1] = UBYTE_TO_FLOAT(y);
  v[2] = UBYTE_TO_FLOAT(z);  v[3] = UBYTE_TO_FLOAT(w);
}


#endif
