/*

layere

return:
  0 - doslo k chybe
  1 - este nezacal
  2 - prebehol v poriadku
  3 - uz skoncil
*/

#include <iostream>
#include "api3ds.h"
#include "efekt.h"
#include "efekt_11.h"
#include "syncs.h"

extern int sync_id;

void efekt_11::draw_layer(int i)
{
  float timer=counter/refresh;

  if (timer>(l[i].k[l[i].kijnum-1]).time) return;
  if (timer<(l[i].k[0]).time) return;
  
  while (timer>(l[i].k[l[i].kij+1]).time) l[i].kij++;
  
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  glEnable(GL_TEXTURE_2D);
  glDisable(GL_LIGHTING);
  glDisable(GL_DEPTH_TEST);
  glDisable(GL_CULL_FACE);
  glEnable(GL_BLEND);
  if (l[i].type==0) glBlendFunc(GL_ONE,GL_ONE);
  if (l[i].type==1) glBlendFunc(GL_ZERO, GL_ONE_MINUS_SRC_COLOR);
  if (l[i].type==2) glDisable(GL_BLEND);

  l[i].tex->GL();
  int j=l[i].kij;

  float tm=(timer-(l[i].k[j]).time)/((l[i].k[j+1]).time-(l[i].k[j]).time);
  float c=(l[i].k[j]).color+ tm*((l[i].k[j+1]).color-(l[i].k[j]).color);
  float px=(l[i].k[j]).posx+ tm*((l[i].k[j+1]).posx-(l[i].k[j]).posx);
  float py=(l[i].k[j]).posy+ tm*((l[i].k[j+1]).posy-(l[i].k[j]).posy);
  float sc=(l[i].k[j]).scale+ tm*((l[i].k[j+1]).scale-(l[i].k[j]).scale);
  float sx=l[i].px*sc;
  float sy=l[i].py*sc;

  glBegin(GL_QUADS);
    glColor3f(c,c,c);
    glTexCoord2f( 1.0, 1.0);
    glVertex2f  ( px + sx, py + sy);
    glTexCoord2f( 0.001, 1.0);                                          
    glVertex2f  ( px - sx, py + sy);
    glTexCoord2f( 0.001, 0.001);                                          
    glVertex2f  ( px - sx, py - sy);
    glTexCoord2f( 1.0, 0.0);                                          
    glVertex2f  ( px + sx, py - sy);
  glEnd();
  if (l[i].type==2) glEnable(GL_BLEND);
}


int  efekt_11::init()
{
    cout << "Efekt 11 init ... ";
    start=TRUE;
    counter=ZACIATOK11*refresh;
//->init

//<-
    cout << "ok" << endl;
    return 1;
}

int  efekt_11::load()
{
    cout << "Loading efekt11 ... ";
// -> load

    float tt,tx,ty,tc,ts;
    char name[30];
    int typ;

    FILE *stream; 
    stream=fopen(CFGNAME11,"r");
    if (!stream) return 0;
    if (stream)
      {
      fscanf(stream,"layer type           %i\n",&typ);
      cout << "typ: " << typ << endl;

      lnum=0;
      while ((typ!=-1)&&(lnum<laymax))
        {
        l[lnum].type=typ;
        fscanf(stream,"layer name           %s\n",name);        	       	     
        cout << "Name: " << name << endl;
        l[lnum].tex=texture_library->GetOrCreate(name);
        fscanf(stream,"projected size       %f x %f\n",&l[lnum].px,&l[lnum].py);


        fscanf(stream,"key: %f %f %f %f %f\n",&tt,&tx,&ty,&tc,&ts);
	l[lnum].kijnum=0;
        l[lnum].kij=-1;
        while ((tt!=-1.0)&&(l[lnum].kijnum<kijmax))
          {
          (l[lnum].k[l[lnum].kijnum]).time =tt;
          (l[lnum].k[l[lnum].kijnum]).posx =tx;
          (l[lnum].k[l[lnum].kijnum]).posy =ty;
          (l[lnum].k[l[lnum].kijnum]).color=tc;
          (l[lnum].k[l[lnum].kijnum]).scale=ts;
          l[lnum].kijnum++;
	  fscanf(stream,"key: %f %f %f %f %f\n",&tt,&tx,&ty,&tc,&ts);
          }      	       		 
        lnum++;
        fscanf(stream,"\nlayer type           %i\n",&typ);
        }
        fclose(stream);
      }

    for (int j=0;j<lnum;j++)
      {
      cout << "layer " << j+1<< "/" << lnum << ": ";
      cout  << l[j].kijnum << " keys"<< endl;
      }

// <-
    cout << "ok!"<<endl;
    return 1;
}

int  efekt_11::free()  //vrati 3 ako ok, 0 ak doslo k chybe
{
    end=true;
    cout << "Efekt 08 free ... ";
// -> free

// <-
    cout << "ok!" << endl;
    return 3;
}

int  efekt_11::update()
{
    id=Sync[GetSyncNum(float(counter)/float(refresh))].id;
// -> update

// <-
    return 1;
}

int efekt_11::go(double t)
{
if (t<ZACIATOK11) return 1;
if (end) return 3;
if (counter>=KONIEC11*refresh) return free();

if (!start) if (!init()) return 0;
int cur_frm=(int)(t*refresh);
if (cur_frm>KONIEC11*refresh) cur_frm=int(KONIEC11*refresh);
if (cur_frm>counter)
  while (counter<cur_frm)
    {
    counter++;
    if (counter<KONIEC11*refresh) update();
    }
if (counter>=KONIEC11*refresh) return free();
//tu sa kresli->

for (int i=0;i<lnum;i++)
  draw_layer(i);

//<-
return 2;
}