/*

valec

return:
  0 - doslo k chybe
  1 - este nezacal
  2 - prebehol v poriadku
  3 - uz skoncil
*/

#include <iostream>
#include "api3ds.h"
#include "efekt.h"
#include "efekt_09.h"

extern int sync_num;

#define valec_strany 20
#define valec_polomer 25
#define vr (valec_polomer/sin(PI/4))
#define valec_dlzka 50
#define c1 0.7
#define c3 0.2

void efekt_09::RenderValec(float f, float pos_x, float pos_y, float size, float inte) {
  float d3=c3*inte;
  float d1=c1*inte;

  glBegin(GL_TRIANGLE_FAN);
  glColor3f(d1,d1,d1);
  glTexCoord2f(pos_x,pos_y);
  glVertex3f(valec_dlzka,0,0);
  glColor3f(d3,d3,d3);
  for(int i=0; i<=valec_strany; i++) {
    GLfloat a = ((PI*2.0)/(double)valec_strany)*i;
    GLfloat x = valec_polomer*cos(a);
    GLfloat y = valec_polomer*sin(a);

    glTexCoord2f(pos_x + size*cos(a-f), pos_y + size*sin(a-f));
    glVertex3f(valec_dlzka,x, y);
  }
  glEnd();

  glBegin(GL_TRIANGLE_FAN);
  glColor3f(d1,d1,d1);
  glTexCoord2f(pos_x,pos_y);
  glVertex3f(-valec_dlzka,0,0);
  glColor3f(d3,d3,d3);
  for(int i=0; i<=valec_strany; i++) {
    GLfloat a = ((PI*2.0)/(double)valec_strany)*i;
    GLfloat x = valec_polomer*cos(a);
    GLfloat y = valec_polomer*sin(a);

    glTexCoord2f(pos_x + size*cos(a-f), pos_y + size*sin(a-f));
    glVertex3f(-valec_dlzka,x, y);
  }
  glEnd();

  glBegin(GL_QUAD_STRIP);
  for(int i=0; i<=valec_strany; i++) {
    GLfloat a = ((PI*2.0)/(double)valec_strany)*i;
    GLfloat x = valec_polomer*cos(a);
    GLfloat y = valec_polomer*sin(a);

    glTexCoord2f(pos_x + size*cos(a-f), pos_y + size*sin(a-f));

    glVertex3f(valec_dlzka,x, y);
    glVertex3f(-valec_dlzka,x, y);
  }
  glEnd();
}


int efekt_09::init()
{
  start=TRUE;
  counter=ZACIATOK09*refresh;
  f_counter1=0.0;
  f_counter2=0.0;
  int1=1.0;
  int2=1.0;
return 1;
}

int efekt_09::load()
{
   cout << "Loading efekt09 ... ";
   FILE *stream=fopen(CFGNAME09,"r");
   if (stream==NULL) return 0;
   fscanf(stream,"file name            %s\n",scene_name);
   fscanf(stream,"camera name          %s\n",camera_name);
   fscanf(stream,"begin                %f\n",&begin3d);
   fscanf(stream,"end                  %f\n",&end3d);
   fscanf(stream,"background color     %f,%f,%f\n",&cl_r,&cl_g,&cl_b);
   fscanf(stream,"visibility           %f\n",&vis);
   fscanf(stream,"minvisibility        %f\n",&minvis);
   fclose(stream);

   tex1=texture_library->GetOrCreate("VALEC.JPG");

   Loader3DS loader;
   sce = loader.Load(scene_name,texture_library);
   if (sce==NULL) return 0;

   kam=sce->GetCamera(camera_name);
   kam->HorizontalFOV(2.26672);
   kam->VerticalFOV  (1.98626);

   cout << "ok!"<<endl;
return 1;
}

int efekt_09::free()
{
return 1;
}

int efekt_09::update()
{
  f_counter1+=0.005;
  f_counter2-=0.003;
return 1;
}

int efekt_09::go(double t)
{
if (t<ZACIATOK09) return 1;
if (t<begin3d) return 1;
if (end) return 3;
if (counter>=KONIEC09*refresh) return free();

if (!start) if (!init()) return 0;

int cur_frm=(int)(t*refresh);
if (cur_frm>KONIEC09*refresh) cur_frm=int(KONIEC09*refresh);
if (cur_frm>counter)
  while (counter<cur_frm)
    {
    counter++;
    if (counter<KONIEC09*refresh) update();
    }
if (counter>=KONIEC09*refresh) return free();


//tu sa kresli->

  glEnable(GL_TEXTURE_2D);
  glDisable(GL_DEPTH_TEST);
  glDisable(GL_CULL_FACE);
  glDisable(GL_LIGHTING);
  glDisable(GL_FOG);

  float frejm=(t-begin3d)/(end3d-begin3d);
  while (t>1.0) t-=1.0;

  kam->FarClipplane(vis);
  kam->NearClipplane(minvis);
  kam->GL(frejm);
  tex1->GL();

  glDisable(GL_BLEND);
  RenderValec(10*f_counter1, 0.3+0.8*sin(f_counter1*3), 0.3+0.8*cos(f_counter1*2), 0.2, int1);

  float frejm2=frejm+0.3;
  if (frejm2>1.0) frejm2-=1.0;
  kam->GL(frejm2);

  glEnable(GL_BLEND);
  glBlendFunc(GL_ONE,GL_ONE);
  RenderValec(10*f_counter2, 0.3+0.8*sin(f_counter2*3), 0.3+0.8*cos(f_counter2*2), 0.3+0.15*sin(f_counter1), int2);

//<-
return 2;
}
