/*

chodby,reaktor - 3ds viewer

return:
  0 - doslo k chybe
  1 - este nezacal
  2 - prebehol v poriadku
  3 - uz skoncil
*/

#include <iostream>
#include "api3ds.h"
#include "efekt.h"
#include "efekt_05.h"

extern int sync_num;
extern BOOL usefog;

int efekt_05::init()
{
  cout << "Efekt 5 init ... ";
  start=TRUE;
  counter=ZACIATOK05*refresh;
  glClearColor (cl_r, cl_g, cl_b, 1.0);
  uhol_counter=0.003*58;
  uhol=0.3*58;

  angel_counter=-0.001*58;
  angel=-0.3*58;

  dmat2=new DmatrixOrientation<GLmatrix,GLfloat>;
  dmat1=new DmatrixOrientation<GLmatrix,GLfloat>;


  dmat1->Pivot(-116.071,25276.918,57.4357);
  dmat2->Pivot(-116.071,25276.918,57.4357);
//  Material3DS* ma = sce->GetMaterial("Material #23");
//  ma->Diffuse(0.5F, 0.5F, 0.5F);
  cout << "ok!" << endl;
return 1;
}

int efekt_05::load()
{
   cout << "Loading efekt05 ... ";
   FILE *stream=fopen(CFGNAME05,"r");
   if (stream==NULL) return 0;
   fscanf(stream,"file name            %s\n",scene_name);
   fscanf(stream,"camera name          %s\n",camera_name);
   fscanf(stream,"begin                %f\n",&begin3d);
   fscanf(stream,"end                  %f\n",&end3d);
   fscanf(stream,"background color     %f,%f,%f\n",&cl_r,&cl_g,&cl_b);
   fscanf(stream,"lightning            %i\n",&lgt);
   fscanf(stream,"fog                  %i\n",&fog);
   fscanf(stream,"fog color            %f,%f,%f\n",&fg_r,&fg_g,&fg_b);
   fscanf(stream,"fog density          %f\n",&fgd);
   fscanf(stream,"visibility           %f\n",&vis);
   fscanf(stream,"minvisibility        %f\n",&minvis);
   fscanf(stream,"hfov,vfov (PI/x)     %f,%f\n",&hfov,&vfov);
   fscanf(stream,"render               %i\n",&render);
   fscanf(stream,"rays                 %i\n",&rays);
   fscanf(stream,"outline              %i\n",&obrysy);
   fscanf(stream,"outline color        %f,%f,%f\n",&ob_r,&ob_g,&ob_b);
   fscanf(stream,"outline width        %i\n",&ob_wdt);
   fscanf(stream,"object name          %s\n",object_name);
   fclose(stream);
   fog&=usefog;
   Loader3DS loader;
   sce = loader.Load(scene_name,texture_library);
   if (sce==NULL) return 0;
   gula1=dynamic_cast<Object3DS*>(sce->GetObject("Sphere01"));
   gula2=dynamic_cast<Object3DS*>(sce->GetObject("Sphere02"));
   cout << "ok!"<<endl;
return 1;
}

int efekt_05::free() //vrati 3 ak ok, 0 ak doslo k chybe
{
end=true;
return 1;
}

int efekt_05::update()
{
uhol+=0.3;
uhol_counter+=0.003;

angel-=0.3;
angel_counter-=0.001;

return 1;
}

int efekt_05::go(double t)
{
if (t<ZACIATOK05) return 1;
if (t<begin3d) return 1;
if (end) return 3;
if (counter>=KONIEC05*refresh) return free();

if (!start) if (!init()) return 0;

int cur_frm=(int)(t*refresh);
if (cur_frm>KONIEC05*refresh) cur_frm=int(KONIEC05*refresh);
if (cur_frm>counter)
  while (counter<cur_frm)
    {
    counter++;
    if (counter<KONIEC05*refresh) update();
    }
if (counter>=KONIEC05*refresh) return free();

//tu sa kresli->
  if (lgt) 
    {
    glEnable(GL_LIGHTING);    
    glLightModeli(GL_LIGHT_MODEL_LOCAL_VIEWER, 1);
    }
   else 
    glDisable(GL_LIGHTING);    

  if (fog) 
    {
    GLfloat fc[4] = {fg_r,fg_g,fg_b, 1.0};
    glEnable(GL_FOG);
    glFogi(GL_FOG_MODE, GL_EXP2);
    glFogfv(GL_FOG_COLOR, fc);
    glFogf(GL_FOG_DENSITY, fgd);
    }
   else glDisable(GL_FOG);    

  float frejm=(t-begin3d)/(end3d-begin3d);
  kam = sce->GetCamera(camera_name);
  kam->FarClipplane(vis);
  kam->NearClipplane(minvis);
  kam->HorizontalFOV(PI/hfov);
  kam->VerticalFOV(PI/vfov);
  kam->GL(frejm);

//vyrata os, okolo ktorej sa otaca
   float alfa=PI*sin(uhol_counter);
   float beta=PI*cos(uhol_counter);
   float gama=PI*sin(PI*cos(uhol_counter));
   float sa=sin(alfa),sb=sin(beta),sg=sin(gama);
   float ca=cos(alfa),cb=cos(beta),cg=cos(gama);
   Vector3f os(ca*cg+sa*sb*sg , ca*cb , cb*cg);
   float osl = (1.0/sqrt(os.x*os.x + os.y*os.y + os.z*os.z));
   os*=osl;

   dmat1->Orientation(uhol*PI/180, os.x,os.y,os.z);
   gula1->CoordinateSystem(dmat1);

   alfa=PI*sin(angel_counter);
   beta=PI*cos(angel_counter);
   gama=PI*sin(PI*cos(angel_counter));
   sa=sin(alfa),sb=sin(beta),sg=sin(gama);
   ca=cos(alfa),cb=cos(beta),cg=cos(gama);
   os(ca*cg+sa*sb*sg , ca*cb , cb*cg);
   osl = (1.0/sqrt(os.x*os.x + os.y*os.y + os.z*os.z));
   os*=osl;

   dmat2->Orientation(angel*PI/180, os.x,os.y,os.z);
   gula2->CoordinateSystem(dmat2);


  if (render) sce->Render(frejm);

  if (obrysy||rays)
    {
    Object3DS* object = dynamic_cast<Object3DS*>(sce->GetObject(object_name));
    if(object)
      {
      Vector3f S( 0.0, 200.0, 0.0);
      Vector3f C=kam->Origin(frejm);
      if (rays)   object->Rays(C, S, 420, GL_ONE, GL_ONE);
      if (obrysy) object->Outline (C, 8, 1.0,1.0,1.0);
      }
    }
//<-
return 2;
}
