#define KONIEC_DEMA 218.0

#include <iostream>
#include "api3ds.h"
#include "efekt.h"
#include "efekt_03.h"
#include "efekt_04.h"
#include "efekt_05.h"
#include "efekt_06.h"
#include "efekt_07.h"
#include "efekt_08.h"
#include "efekt_09.h"
#include "efekt_10.h"
#include "efekt_11.h"
#include "efekt_12.h"
#include "efekt_13.h"
#include "efekt_14.h"
#include "efekt_15.h"
#include "efekt_16.h"
#include "efekt_17.h"
#include "efekt_18.h"
#include "sync.h" //synchronizacne znacky
#include "bass.h"
 
efekt_03 e3;      //Efekty
efekt_04 e4;      //Efekty
efekt_05 e5;      //Efekty
efekt_06 e6;      //Efekty
efekt_07 e7;      //Efekty
efekt_08 e8;      //Efekty
efekt_09 e9;      //Efekty
efekt_10 e10;     //Efekty
efekt_11 e11;     //Efekty
efekt_12 e12;     //Efekty
efekt_13 e13;     //Efekty
efekt_14 e14;     //Efekty
efekt_15 e15;     //Efekty
efekt_16 e16;     //Efekty
efekt_17 e17;     //Efekty
efekt_18 e18;     //Efekty

struct {          //zoznam Efektov 
    EFEKT *fx;    // poradie urcuje prioritu:
} Efekty[] = {    // kreslia sa v poradi, v akom su zoradene (FIFO)
    {&e3},   // waving tunel
    {&e12},  //tesly na zaciatku
    {&e4},   // 3ds steny
    {&e5},   // 3ds chodby a reaktor
    {&e7},   // vlaciky
    {&e8},   // 2nd tesla
    {&e9},   // valce
    {&e6},   // fullscreen layere - ide skoro ako posledne
//    {&e17},  // twirl
    {&e10},  // deform
    {&e11},  // layere (small)
    {&e13},  // rayobjekt
    {&e14},  // greetsy
    {&e15},  // gula
    {&e18},  // endpic
    {&e16}   // layere (small)
    };

extern HSTREAM str;
extern Textures3DS *texture_library;
int n_of_ef=sizeof(Efekty)/sizeof(Efekty[0]);  //pocet Efektov

int sync_num=-1;   //cislo aktualnej synchronizacnej znacky
int sync_id=0;

int demo_init()
{
for (int i=0;i<n_of_ef;i++) 
  {
  if (!(Efekty[i].fx)->load()) return 0;
  }
cout << "Textures ... ";
EFEKT::texture_library->GL();
cout << "ok!"<<endl;
return 1;
}

int demo_go(double a)
{
  if (a>=KONIEC_DEMA) return 0;      //demo skoncilo, tak sa vypne

  int old_sync_num = sync_num;       //zisti aktualny sync, a jeho ID
  sync_num = GetSyncNum(a);
  sync_id = Sync[sync_num].id;

  if(old_sync_num!=sync_num)         // ak sa zmenil sync tak vypis info
    {
    SyncInfo(sync_num);
    cout <<  "  mzx pos: " << BASS_ChannelGetPosition((unsigned int)str) <<endl;
    cout <<  "  timer:   " << a << endl;
    }

  int retval = 1;
  for (int i=0; i<n_of_ef; i++) {    //pustia sa vsetky Efekty,
    retval = (Efekty[i].fx)->go(a);  //tu sa demo vypne iba ak doslo k chybe
    if(!retval)
      break;
  }
  return retval;
}
