#include <conio.h>
#include <stdlib.h>

//pointer to video-ram
char far * screenptr = (char far *) ((long)0xa000 << 16);

//putpixel-function
void pset13h(unsigned int x,unsigned int y,unsigned char col,char far *where)
{
  *(where+320*y+x)=col;
}

//draw a filled rectangle with the given co-ordinates and colour
void drawblock(unsigned int startx,unsigned int starty,unsigned char clr)
{
  unsigned char i,
                j;

  for(i=0;i<100;i++)
  {
    for(j=0;j<160;j++)
    {
      pset13h(startx+j,starty+i,clr,screenptr);
    }
  }
}

void main()
{
  unsigned char nbb,
                clr;
  unsigned int startx,
               starty;

  //get nbb - mustn't equal 0, mustn't be greater than 5
  nbb=getch();
  nbb-=48;
  if( (nbb==0) || (nbb>5) ) exit(0);

  //get clr - mustn't equal 0
  clr=getch();
  clr-=48;
  if(clr==0) exit(0);

  //switch to mode 13h
  asm {
    mov ax,0x13
    int 0x10
  }

  //draw which block?
  switch(nbb)
  {
    case 1: startx=0;
            starty=0;
            break;
    case 2: startx=160;
            starty=0;
            break;
    case 3: startx=0;
            starty=100;
            break;
    case 4: startx=160;
            starty=100;
            break;
    case 5: startx=80;
            starty=50;
  }

  //draw block
  drawblock(startx,starty,clr);

  //clear center if it's not block 5
  if(nbb!=5) drawblock(80,50,0);

  //wait for keypress
  getch();

  //return to mode 3
  asm {
    mov ax,3
    int 0x10
  }
}
