{}
{                                                       }
{      Virtual Pascal Runtime Library.  Version 1.0.    }
{      Exception handling unit                          }
{      }
{      Copyright (C) 1995 B&M&T Corporation             }
{      }
{      Written by Vitaly Miryanov                       }
{                                                       }
{}
{$S-,R-,Q-,I-,Cdecl-,OrgName-,AlignRec-}

unit Xcpt;

interface

function SetExceptionHandler(Handler: Pointer): Boolean;

implementation

uses Os2Base, Use32;

type
  PXcptHandlers = ^TXcptHandlers;
  TXcptHandlers = array [1..25] of ExceptionRegistrationRecord;

{ Setups OS/2 exception handler. OS/2 DosSetExceptionHandler function   }
{ should not be used directly because exception registration record     }
{ must be on stack all time the thread's code is executed. Multiple     }
{ threads are not yet supported so this procedure cares about thread 1. }
{ Startup code of the SYSTEM unit allocates space on stack for 25       }
{ exception registration records and setups system exception handler,   }
{ so space for 24 user exception handlers is available. Array of        }
{ exception registration records grows backward (from last element to   }
{ first), because each handler's exception registration record must have}
{ a lower address than exception registration record of the previously  }
{ installed handler.                                                    }

{ For a example of SetExceptionHandler usage see source file of the     }
{ CRT unit (CRT.PAS).                                                   }

function SetExceptionHandler(Handler: Pointer): Boolean;
var
  I: Integer;
  P: PExceptionRegistrationRecord;
begin
  SetExceptionHandler := False;
  if (XcptHandlers <> nil) and (XcptHandlerCount < High(TXcptHandlers)) then
  begin
    for I := High(TXcptHandlers) downto
             High(TXcptHandlers) - XcptHandlerCount + 1 do
      if @PXcptHandlers(XcptHandlers)^[I].ExceptionHandler = Handler
        then Exit;
    P := @PXcptHandlers(XcptHandlers)^[High(TXcptHandlers)-XcptHandlerCount];
    Inc(XcptHandlerCount);
    P^.ExceptionHandler := Err(Handler);
    P^.Prev_Structure := nil;
    DosSetExceptionHandler(P^);
    SetExceptionHandler := True;
  end;
end;

end.
