@ECHO OFF
REM ***********************
REM * Builds Turbo Vision *
REM ***********************

IF "%1" == "/?" GOTO HELP
IF "%1" == "-?" GOTO HELP

IF EXIST "\VP\SOURCE\TV\TV20.PAS" GOTO DRIVEOK
ECHO **Error**  Change to the drive where VP is installed and run BLDTV again.
GOTO EXIT

:DRIVEOK
CD \VP\SOURCE\TV
IF EXIST "DRIVERS.PAS" GOTO BUILD
ECHO **Error**  You should apply TV4VP patch before running BLDTV.
GOTO EXIT

:BUILD
ECHO  Creating Turbo Vision DLL ...
\VP\BIN\VPC TV20 /M /O\VP\UNITS /$SmartLink- /$Speed+ /$D+ %1 %2 %3 %4 %5 %6 %7 %8 %9
IF ERRORLEVEL 1 GOTO ERROR
SET LIB=\VP\LIB
REM *** if you have LINK386 2.02.001+ you may use
REM *** /NOSECTORALIGN to shrink DLL in size
SET LINK386=/BAT /NOL /PM:NOVIO /A:4 /EXEPACK
ECHO  Linking, please wait ...
LINK386 @\VP\UNITS\TV20.LNK;
IF ERRORLEVEL 1 GOTO ERROR
\VP\BIN\IMPLIB \VP\LIB\TVISION.LIB \VP\SOURCE\TV\TV20.DEF
IF ERRORLEVEL 1 GOTO ERROR
COPY \VP\UNITS\TV20.DLL \VP\BIN > NUL
DEL  \VP\UNITS\TV20.*
CD \VP
GOTO EXIT

:ERROR
ECHO !!! ERROR !!!
GOTO EXIT

:HELP
ECHO Builds 32-bit Turbo Vision for OS/2. Generates DLL version of TV.
ECHO Usage: BLDTV [VPC Options]
ECHO Where:
ECHO   VPC Options is the options to the command line compiler
ECHO By default, BLDTV compiles all units to object files ($SmartLink-).
ECHO It enables source level debugging for TV units. To enable smart
ECHO linking, specify /$SmartLink+ as a parameter to BLDTV.

:EXIT
