/*
   Virtual Pascal Run-time library. Version 1.0.
   OS/2 Resource Compiler support.

   This file contains standard styles, flags and other Presentation
   Manager defines. Since resource compiler uses C-style syntax,
   interface units of the Virtual Pascal cannot be used. Instead, this
   file can be included into resource script file by using #include
   resource compiler directive. More defines can be added if required.
*/

/* From PMWIN.H */

/* Standard Window Styles */

#define WS_VISIBLE              0x80000000L
#define WS_DISABLED             0x40000000L
#define WS_CLIPCHILDREN         0x20000000L
#define WS_CLIPSIBLINGS         0x10000000L
#define WS_PARENTCLIP           0x08000000L
#define WS_SAVEBITS             0x04000000L
#define WS_SYNCPAINT            0x02000000L
#define WS_MINIMIZED            0x01000000L
#define WS_MAXIMIZED            0x00800000L
#define WS_ANIMATE              0x00400000L

/* Standard Window Classes */

#define WC_FRAME                0xffff0001L
#define WC_COMBOBOX             0xffff0002L
#define WC_BUTTON               0xffff0003L
#define WC_MENU                 0xffff0004L
#define WC_STATIC               0xffff0005L
#define WC_ENTRYFIELD           0xffff0006L
#define WC_LISTBOX              0xffff0007L
#define WC_SCROLLBAR            0xffff0008L
#define WC_TITLEBAR             0xffff0009L
#define WC_MLE                  0xffff000AL
#define WC_APPSTAT              0xffff0010L
#define WC_KBDSTAT              0xffff0011L
#define WC_PECIC                0xffff0012L
#define WC_DBE_KKPOPUP          0xffff0013L
#define WC_SPINBUTTON           0xffff0020L
#define WC_CONTAINER            0xffff0025L
#define WC_SLIDER               0xffff0026L
#define WC_VALUESET             0xffff0027L
#define WC_NOTEBOOK             0xffff0028L

/* Dialog manager styles */

#define WS_GROUP                0x00010000L
#define WS_TABSTOP              0x00020000L
#define WS_MULTISELECT          0x00040000L

/* Static Control styles */

#define SS_TEXT                 0x0001L
#define SS_GROUPBOX             0x0002L
#define SS_ICON                 0x0003L
#define SS_BITMAP               0x0004L
#define SS_FGNDRECT             0x0005L
#define SS_HALFTONERECT         0x0006L
#define SS_BKGNDRECT            0x0007L
#define SS_FGNDFRAME            0x0008L
#define SS_HALFTONEFRAME        0x0009L
#define SS_BKGNDFRAME           0x000aL
#define SS_SYSICON              0x000bL
#define SS_AUTOSIZE             0x0040L

/* List box styles */

#define LS_MULTIPLESEL          0x00000001L
#define LS_OWNERDRAW            0x00000002L
#define LS_NOADJUSTPOS          0x00000004L
#define LS_HORZSCROLL           0x00000008L
#define LS_EXTENDEDSEL          0x00000010L

/* Menu item styles & attributes */

#define MIS_TEXT                0x0001
#define MIS_BITMAP              0x0002
#define MIS_SEPARATOR           0x0004
#define MIS_OWNERDRAW           0x0008
#define MIS_SUBMENU             0x0010
#define MIS_MULTMENU            0x0020
#define MIS_SYSCOMMAND          0x0040
#define MIS_HELP                0x0080
#define MIS_STATIC              0x0100
#define MIS_BUTTONSEPARATOR     0x0200
#define MIS_BREAK               0x0400
#define MIS_BREAKSEPARATOR      0x0800
#define MIS_GROUP               0x1000
#define MIS_SINGLE              0x2000
#define MIA_NODISMISS           0x0020
#define MIA_FRAMED              0x1000
#define MIA_CHECKED             0x2000
#define MIA_DISABLED            0x4000
#define MIA_HILITED             0x8000

/* Button control styles */

#define BS_PUSHBUTTON           0x0000L
#define BS_CHECKBOX             0x0001L
#define BS_AUTOCHECKBOX         0x0002L
#define BS_RADIOBUTTON          0x0003L
#define BS_AUTORADIOBUTTON      0x0004L
#define BS_3STATE               0x0005L
#define BS_AUTO3STATE           0x0006L
#define BS_USERBUTTON           0x0007L
#define BS_PRIMARYSTYLES        0x000fL
#define BS_BITMAP               0x0040L
#define BS_ICON                 0x0080L
#define BS_HELP                 0x0100L
#define BS_SYSCOMMAND           0x0200L
#define BS_DEFAULT              0x0400L
#define BS_NOPOINTERFOCUS       0x0800L
#define BS_NOBORDER             0x1000L
#define BS_NOCURSORSELECT       0x2000L
#define BS_AUTOSIZE             0x4000L

/* Entry field  styles */

#define ES_LEFT                 0x00000000L
#define ES_CENTER               0x00000001L
#define ES_RIGHT                0x00000002L
#define ES_AUTOSCROLL           0x00000004L
#define ES_MARGIN               0x00000008L
#define ES_AUTOTAB              0x00000010L
#define ES_READONLY             0x00000020L
#define ES_COMMAND              0x00000040L
#define ES_UNREADABLE           0x00000080L
#define ES_AUTOSIZE             0x00000200L
#define ES_ANY                  0x00000000L
#define ES_SBCS                 0x00001000L
#define ES_DBCS                 0x00002000L
#define ES_MIXED                0x00003000L

/* combo box styles */

#define CBS_SIMPLE              0x0001L
#define CBS_DROPDOWN            0x0002L
#define CBS_DROPDOWNLIST        0x0004L
#define CBS_COMPATIBLE          0x0008L

/* Frame window styles */

#define FS_ICON                 0x00000001L
#define FS_ACCELTABLE           0x00000002L
#define FS_SHELLPOSITION        0x00000004L
#define FS_TASKLIST             0x00000008L
#define FS_NOBYTEALIGN          0x00000010L
#define FS_NOMOVEWITHOWNER      0x00000020L
#define FS_SYSMODAL             0x00000040L
#define FS_DLGBORDER            0x00000080L
#define FS_BORDER               0x00000100L
#define FS_SCREENALIGN          0x00000200L
#define FS_MOUSEALIGN           0x00000400L
#define FS_SIZEBORDER           0x00000800L
#define FS_AUTOICON             0x00001000L
#define FS_DBE_APPSTAT          0x00008000L
     /* FS_ICON | FS_ACCELTABLE | FS_SHELLPOSITION | FS_TASKLIST */
#define FS_STANDARD             0x0000000FL

/* Frame window flags */

#define FCF_TITLEBAR            0x00000001L
#define FCF_SYSMENU             0x00000002L
#define FCF_MENU                0x00000004L
#define FCF_SIZEBORDER          0x00000008L
#define FCF_MINBUTTON           0x00000010L
#define FCF_MAXBUTTON           0x00000020L
#define FCF_MINMAX              0x00000030L
#define FCF_VERTSCROLL          0x00000040L
#define FCF_HORZSCROLL          0x00000080L
#define FCF_DLGBORDER           0x00000100L
#define FCF_BORDER              0x00000200L
#define FCF_SHELLPOSITION       0x00000400L
#define FCF_TASKLIST            0x00000800L
#define FCF_NOBYTEALIGN         0x00001000L
#define FCF_NOMOVEWITHOWNER     0x00002000L
#define FCF_ICON                0x00004000L
#define FCF_ACCELTABLE          0x00008000L
#define FCF_SYSMODAL            0x00010000L
#define FCF_SCREENALIGN         0x00020000L
#define FCF_MOUSEALIGN          0x00040000L
#define FCF_HIDEBUTTON          0x01000000L
#define FCF_HIDEMAX             0x01000020L
#define FCF_DBE_APPSTAT         0x80000000L
#define FCF_AUTOICON            0x40000000L
     /* FCF_TITLEBAR | FCF_SYSMENU | FCF_MENU | FCF_SIZEBORDER | FCF_MINMAX |
        FCF_ICON | FCF_ACCELTABLE | FCF_SHELLPOSITION | FCF_TASKLIST */
#define FCF_STANDARD            0x0000CC3FL

/* Static styles */

#define DT_LEFT                 0x0000
#define DT_QUERYEXTENT          0x0002
#define DT_UNDERSCORE           0x0010
#define DT_STRIKEOUT            0x0020
#define DT_TEXTATTRS            0x0040
#define DT_EXTERNALLEADING      0x0080
#define DT_CENTER               0x0100
#define DT_RIGHT                0x0200
#define DT_TOP                  0x0000
#define DT_VCENTER              0x0400
#define DT_BOTTOM               0x0800
#define DT_HALFTONE             0x1000
#define DT_MNEMONIC             0x2000
#define DT_WORDBREAK            0x4000
#define DT_ERASERECT            0x8000

/* Special item IDs */

#define DID_OK                  1
#define DID_CANCEL              2
#define DID_ERROR               0xffff

/* Presentation parameter types */

#define PP_FOREGROUNDCOLOR              1L
#define PP_FOREGROUNDCOLORINDEX         2L
#define PP_BACKGROUNDCOLOR              3L
#define PP_BACKGROUNDCOLORINDEX         4L
#define PP_HILITEFOREGROUNDCOLOR        5L
#define PP_HILITEFOREGROUNDCOLORINDEX   6L
#define PP_HILITEBACKGROUNDCOLOR        7L
#define PP_HILITEBACKGROUNDCOLORINDEX   8L
#define PP_DISABLEDFOREGROUNDCOLOR      9L
#define PP_DISABLEDFOREGROUNDCOLORINDEX 10L
#define PP_DISABLEDBACKGROUNDCOLOR      11L
#define PP_DISABLEDBACKGROUNDCOLORINDEX 12L
#define PP_BORDERCOLOR                  13L
#define PP_BORDERCOLORINDEX             14L
#define PP_FONTNAMESIZE                 15L
#define PP_FONTHANDLE                   16L
#define PP_RESERVED                     17L
#define PP_ACTIVECOLOR                  18L
#define PP_ACTIVECOLORINDEX             19L
#define PP_INACTIVECOLOR                20L
#define PP_INACTIVECOLORINDEX           21L
#define PP_ACTIVETEXTFGNDCOLOR          22L
#define PP_ACTIVETEXTFGNDCOLORINDEX     23L
#define PP_ACTIVETEXTBGNDCOLOR          24L
#define PP_ACTIVETEXTBGNDCOLORINDEX     25L
#define PP_INACTIVETEXTFGNDCOLOR        26L
#define PP_INACTIVETEXTFGNDCOLORINDEX   27L
#define PP_INACTIVETEXTBGNDCOLOR        28L
#define PP_INACTIVETEXTBGNDCOLORINDEX   29L
#define PP_SHADOW                       30L
#define PP_MENUFOREGROUNDCOLOR          31L
#define PP_MENUFOREGROUNDCOLORINDEX     32L
#define PP_MENUBACKGROUNDCOLOR          33L
#define PP_MENUBACKGROUNDCOLORINDEX     34L
#define PP_MENUHILITEFGNDCOLOR          35L
#define PP_MENUHILITEFGNDCOLORINDEX     36L
#define PP_MENUHILITEBGNDCOLOR          37L
#define PP_MENUHILITEBGNDCOLORINDEX     38L
#define PP_MENUDISABLEDFGNDCOLOR        39L
#define PP_MENUDISABLEDFGNDCOLORINDEX   40L
#define PP_MENUDISABLEDBGNDCOLOR        41L
#define PP_MENUDISABLEDBGNDCOLORINDEX   42L
#define PP_USER                         0x8000L

/* Accelerator functions */

#define AF_CHAR                 0x0001
#define AF_VIRTUALKEY           0x0002
#define AF_SCANCODE             0x0004
#define AF_SHIFT                0x0008
#define AF_CONTROL              0x0010
#define AF_ALT                  0x0020
#define AF_LONEKEY              0x0040
#define AF_SYSCOMMAND           0x0100
#define AF_HELP                 0x0200

/* Virtual key values */

#define VK_BUTTON1              0x01
#define VK_BUTTON2              0x02
#define VK_BUTTON3              0x03
#define VK_BREAK                0x04
#define VK_BACKSPACE            0x05
#define VK_TAB                  0x06
#define VK_BACKTAB              0x07
#define VK_NEWLINE              0x08
#define VK_SHIFT                0x09
#define VK_CTRL                 0x0A
#define VK_ALT                  0x0B
#define VK_ALTGRAF              0x0C
#define VK_PAUSE                0x0D
#define VK_CAPSLOCK             0x0E
#define VK_ESC                  0x0F
#define VK_SPACE                0x10
#define VK_PAGEUP               0x11
#define VK_PAGEDOWN             0x12
#define VK_END                  0x13
#define VK_HOME                 0x14
#define VK_LEFT                 0x15
#define VK_UP                   0x16
#define VK_RIGHT                0x17
#define VK_DOWN                 0x18
#define VK_PRINTSCRN            0x19
#define VK_INSERT               0x1A
#define VK_DELETE               0x1B
#define VK_SCRLLOCK             0x1C
#define VK_NUMLOCK              0x1D
#define VK_ENTER                0x1E
#define VK_SYSRQ                0x1F
#define VK_F1                   0x20
#define VK_F2                   0x21
#define VK_F3                   0x22
#define VK_F4                   0x23
#define VK_F5                   0x24
#define VK_F6                   0x25
#define VK_F7                   0x26
#define VK_F8                   0x27
#define VK_F9                   0x28
#define VK_F10                  0x29
#define VK_F11                  0x2A
#define VK_F12                  0x2B
#define VK_F13                  0x2C
#define VK_F14                  0x2D
#define VK_F15                  0x2E
#define VK_F16                  0x2F
#define VK_F17                  0x30
#define VK_F18                  0x31
#define VK_F19                  0x32
#define VK_F20                  0x33
#define VK_F21                  0x34
#define VK_F22                  0x35
#define VK_F23                  0x36
#define VK_F24                  0x37
#define VK_ENDDRAG              0x38
#define VK_MENU                 VK_F10
#define VK_DBCSFIRST            0x0080
#define VK_DBCSLAST             0x00ff
#define VK_USERFIRST            0x0100
#define VK_USERLAST             0x01ff

/* From PMMLE.H */

/* MLE Window styles (in addition to WS_*) */

#define MLS_WORDWRAP            0x00000001L
#define MLS_BORDER              0x00000002L
#define MLS_VSCROLL             0x00000004L
#define MLS_HSCROLL             0x00000008L
#define MLS_READONLY            0x00000010L
#define MLS_IGNORETAB           0x00000020L
#define MLS_DISABLEUNDO         0x00000040L

/* From PMSTDDLG.H */

/* SPINBUTTON Creation Flags */

#define SPBS_ALLCHARACTERS      0x00000000L
#define SPBS_NUMERICONLY        0x00000001L
#define SPBS_READONLY           0x00000002L
#define SPBS_MASTER             0x00000010L
#define SPBS_SERVANT            0x00000000L
#define SPBS_JUSTDEFAULT        0x00000000L
#define SPBS_JUSTLEFT           0x00000008L
#define SPBS_JUSTRIGHT          0x00000004L
#define SPBS_JUSTCENTER         0x0000000CL
#define SPBS_NOBORDER           0x00000020L
#define SPBS_FASTSPIN           0x00000100L
#define SPBS_PADWITHZEROS       0x00000080L

/* Slider control style flag definition */

#define SLS_HORIZONTAL          0x00000000L
#define SLS_VERTICAL            0x00000001L
#define SLS_CENTER              0x00000000L
#define SLS_BOTTOM              0x00000002L
#define SLS_TOP                 0x00000004L
#define SLS_LEFT                0x00000002L
#define SLS_RIGHT               0x00000004L
#define SLS_SNAPTOINCREMENT     0x00000008L
#define SLS_BUTTONSBOTTOM       0x00000010L
#define SLS_BUTTONSTOP          0x00000020L
#define SLS_BUTTONSLEFT         0x00000010L
#define SLS_BUTTONSRIGHT        0x00000020L
#define SLS_OWNERDRAW           0x00000040L
#define SLS_READONLY            0x00000080L
#define SLS_RIBBONSTRIP         0x00000100L
#define SLS_HOMEBOTTOM          0x00000000L
#define SLS_HOMETOP             0x00000200L
#define SLS_HOMELEFT            0x00000000L
#define SLS_HOMERIGHT           0x00000200L
#define SLS_PRIMARYSCALE1       0x00000000L
#define SLS_PRIMARYSCALE2       0x00000400L

/* Value set control style flag definition */

#define VS_BITMAP               0x0001
#define VS_ICON                 0x0002
#define VS_TEXT                 0x0004
#define VS_RGB                  0x0008
#define VS_COLORINDEX           0x0010
#define VS_BORDER               0x0020
#define VS_ITEMBORDER           0x0040
#define VS_SCALEBITMAPS         0x0080
#define VS_RIGHTTOLEFT          0x0100
#define VS_OWNERDRAW            0x0200

/* From PMGPI.H */

/* default color table indices */

#define CLR_FALSE                 (-5L)
#define CLR_TRUE                  (-4L)
#define CLR_ERROR               (-255L)
#define CLR_DEFAULT               (-3L)
#define CLR_WHITE                 (-2L)
#define CLR_BLACK                 (-1L)
#define CLR_BACKGROUND              0L
#define CLR_BLUE                    1L
#define CLR_RED                     2L
#define CLR_PINK                    3L
#define CLR_GREEN                   4L
#define CLR_CYAN                    5L
#define CLR_YELLOW                  6L
#define CLR_NEUTRAL                 7L
#define CLR_DARKGRAY                8L
#define CLR_DARKBLUE                9L
#define CLR_DARKRED                10L
#define CLR_DARKPINK               11L
#define CLR_DARKGREEN              12L
#define CLR_DARKCYAN               13L
#define CLR_BROWN                  14L
#define CLR_PALEGRAY               15L
