{$AlignCode+,AlignData+,AlignRec-,Asm-,B-,D+,Delphi-,Frame+,G3+,I+,LocInfo+}
{$Optimise+,OrgName-,P-,Q+,R+,S+,SmartLink+,Speed+,T-,V+,W-,X+,Z-,ZD-}
{$M 16384}

Unit UltraDev;

(*
UltraDev.Pas
*****************************************************************************
  OS/2 device driver interface to the Gravis Ultrasound family of soundcards
                               10-12-1995
                      Written by Sander van Leeuwen
                   email: s509475@dutiws.twi.tudelft.nl
              Ported to Pascal (VirtualPascal/2) by Timo Maier
                               13.01.1996
                 email: thunder@freiburg.netsurf.de
                          fido: 2:2476/830.10
                         gernet: 21:498/100.10
*****************************************************************************
                           Standard Disclaimer
*****************************************************************************
This code is provided as is. The author (Timo Maier) isn't responsible for
any damage that may result from using this code. So don't mail me with claims
about damaged ears/stereo's or crashed computers.
*****************************************************************************
I would like to thank Sander for developing great software for a really great
soundcard. Happy GUSing!
This source isn't still perfect, but it should work nice. I'll do my very
best to keep this unit uptodate. For comments, suggestions ... please contact
me or Sander.
-=> Timo
*****************************************************************************
*)

{
UpDates + Bugfixes:

01.04.96 - My email address changed (see above) (:
         - Fixed UltraDownLoad
         - Workarround for GetManleyVersion
         - Added some Const = ...

08.10.96 - My email address changed AGAIN! (see above) (:
         - Added
           Function UltraGetUltraType
           Function UltraGetUltraTypeStr
           Function UltraRemoveEffectFromVoice
           Function UltraAddEffectToVoice
           Function UltraStartEffectVoice
01.12.96 - Fixes
}

Interface

Uses Os2Base;

Function UltraSizeDram : LongInt;
Function UltraSetNVoices(NumVoices : Byte) : LongInt;
Function UltraGetAccess : LongInt;
Function UltraReleaseAccess : LongInt;
Function UltraEnableOutput : LongInt;
Function UltraDisableOutput : LongInt;
Function UltraGetDriverVersion : Word;
Function UltraDownload(DataPtr : Pointer; Control : Byte; DRam_Loc,
                       Size : LongInt; Wait : Boolean) : LongInt;
Function UltraMemInit : LongInt;
Function UltraStartVoice(GusVoice : Integer; begin_,start,end_ : LongInt;
                         Mode : Byte) : LongInt;
Function UltraMemAlloc(Size : LongInt; var Location : LongInt; Typ : Byte) : LongInt;
Function UltraStopVoice(Voice : Integer) : LongInt;
Function UltraSetAll(Voice: Integer; Balance : Byte; freq : LongInt;
                     Volume : Word; Rate,Mode : Byte) : LongInt;
Function UltraVoiceStopped(Voice : LongInt) : Boolean;
Function UltraSetBalance(Voice: Integer; Data : Byte) : LongInt;
Function UltraSetFrequency(Voice : Integer; Freq : LongInt) : LongInt;
Function UltraSetLoopMode(Voice,Mode : LongInt) : LongInt;
Function UltraMemFree(Size,Location : LongInt) : LongInt;
Function UltraVectorLinearVolume(Voice : Integer; End_Idx : LongInt; Rate,
                                 Mode : Byte): LongInt;

Function UltraGetUltraType : LongInt;
Function UltraGetUltraTypeStr : String;

Function UltraAddEffectToVoice(Voice,Effect : LongInt) : LongInt;
Function UltraRemoveEffectFromVoice(Voice,Effect : LongInt) : LongInt;
Function UltraStartEffectVoice(Voice,_Begin,_End,Distance,
                               Balance,Volume,Rate,Mode : LongInt) : LongInt;

Function GetManleyVersion : String;
Procedure CloseUltraSound;
Function OpenUltraSound : Boolean;

//***************************************************************************
CONST {Balance : use values from 0 to 15 }
      BalanceLeft = 0;
      BalanceCenter = 7;
      BalanceRight = 15;

      { Common frequencies for sounds }
      KHz_11 = 11025;
      KHz_22 = 22050;
      KHz_44 = 44100;

      { Here are the volume ramp control bit definitions: }
      LoopDisable = $00;
      LoopEnable = $08;
      BiDirLoop = $10;
      EnableVolRampIRQ = $20;

      { Here are the voice control bit definitions: }
      Voice8Bit = $00;
      Voice16Bit = $04;
      { LoopEnable = $08; BiDirLoop = $10; see ramp control }
      EnableWavtableIRQ = $20;
      DirectionDec = $40;

      { Here are the dma to/from DRAM control bit definitions: }
      DramRead = $02;
      Dram16Bit = $40;
      Dram8Bit = $80;

Implementation

var GusHandle : HFile;

//***************************************************************************
type VolumeStruct = record
                      Voice   : Integer;
                      End_idx : LongInt;
                      Rate    : byte;
                      Mode    : byte;
                    end;

     FreqStruct = record
                    Voice     : Integer;
                    Speed_Khz : LongInt;
                  end;

     BalanceStruct = record
                       Voice : Integer;
                       Data  : Byte;
                     end;
     VoiceStruct  = record
                       Voice : Integer;
                       Begin_,          { voice to start }
                       Start ,          { start loop location in ultra DRAM }
                       End_  : LongInt; { end location in ultra DRAM }
                       Mode  : Byte;    { mode to run the voice (loop etc) }
                     end;
     TimerStruct = record
                       Timer : Integer;
                       Time  : Byte;
                     end;
     AllocStruct = record
                     Size     : LongInt;
                     Location : LongInt;
                     Typ      : Byte;
                   end;
     FreeStruct = record
                    Size     : LongInt;
                    Location : LongInt;
                  end;
     PokeStruct = record
                    Address : LongInt;
                    Data    : Byte;
                  end;
     XferStruct = record
                    Control  : Byte;
                    DRam_Loc : LongInt;
                  end;

     AllStruct = record
                   Freq    : LongInt;
                   Voice   : Integer;
                   Balance : Byte;
                   Volume  : Word;     { Volumerange : 0..4095 }
                   Rate,
                   Mode    : Byte;
                 end;

//***************************************************************************
Const  Gus_Commands = $0F;

       UltraDevStartEffectVoice = $4B;
       UltraDevAddEffectToVoice = $4C;
       UltraDevRemoveEffectFromVoice = $4D;
       UltraDevGetUltraType = $4E;

       UltraDevSetNVoices = $50;
       UltraDevEnableOutput = $51;
       UltraDevDisableOutput = $52;
       UltraDevPokeData = $53;
       UltraDevPeekData = $54;
       UltraDevMemAlloc = $55;
       UltraDevMemFree = $56;
       UltraDevMemInit = $57;
       UltraDevStartTimer = $58;
       UltraDevStopTimer = $59;
       UltraDevBlockTimerHandler1 = $5A;
       UltraDevBlockTimerHandler2 = $5B;
       UltraDevStartVoice = $5C;
       UltraDevStopVoice = $5D;
       UltraDevSetBalance = $5E;
       UltraDevSetFrequency = $5F;
       UltraDevVectorLinearVolume = $60;
       UltraDevPrepare4DMAXfer = $61;
       UltraDevUnblockAll = $62;
       UltraDevSetAll = $63;

       UltraDevGetAccess = $6A;
       UltraDevReleaseAccess = $6B;
       UltraDevSizeDRAM = $6D;
       UltraDevGetRegStatus = $6C;
       UltraDevGetDriverVersion = $6E;
       UltraDevStopAll = $6F;

       UltraDevSetLoopMode = $73;
       UltraDevVoiceStopped = $74;

       UltraDevSetLoopStart = $78;

//***************************************************************************
Function GetManleyVersion : String;
Var Version    : Word;
    VersionStr : String[5];
begin
  Version := UltraGetDriverVersion;
  Str(Version,VersionStr);
  While Length(VersionStr) < 4 do
    VersionStr := ' ' + VersionStr;
  GetManleyVersion := Copy(VersionStr,1,2) + '.' + Copy(VersionStr,3,2);
end;

//***************************************************************************
Function UltraGetAccess : LongInt;
var ParmLength,DataLength : LongInt;
    rc                    : LongInt;
begin
  DataLength := 0;
  ParmLength := 0;
  rc := DosDevIOCtl(GUSHandle,Gus_Commands,UltraDevGetAccess,NIL,0,
                    @ParmLength,NIL,0,@DataLength);
  UltraGetAccess := rc;
end;

//***************************************************************************
Function OpenUltraSound : Boolean;
{ true if successful }
var Status : LongInt;
    Action : LongInt;
begin
  Os2Base.DosError(fErr_DisableHardErr);
  Status := DosOpen('ULTRA1$',GUSHandle,Action,0,FILE_NORMAL,
                     FILE_OPEN,OPEN_ACCESS_READWRITE or
                     OPEN_SHARE_DENYNONE or OPEN_FLAGS_WRITE_THROUGH,
                     NIL );
  if Status <> 0 then
    OpenUltraSound := FALSE
  else begin
    if UltraGetAccess > 0 then begin
      DosClose(GUSHandle);
      OpenUltraSound := FALSE;  { not only owner }
    end
    else
      OpenUltraSound := true;   { GUS access ok }
  end;
  Os2Base.DosError(fErr_EnableHardErr);
end;

//***************************************************************************
Procedure CloseUltraSound;
begin
  UltraDisableOutPut;
  UltraReleaseAccess;
  DosClose(GusHandle);
end;

//***************************************************************************
Function UltraSetNVoices(NumVoices : Byte) : LongInt;
var ParmLength,DataLength : LongInt;
    rc                    : LongInt;
begin
  ParmLength := 0;
  DataLength := 4;
  if NumVoices < 14 then       { 14 >= voices <= 32 }
    NumVoices := 14
  else if NumVoices > 32 then
    NumVoices := 32;
  rc := DosDevIOCtl(GUSHandle,Gus_Commands,UltraDevSetNVoices,NIL,0,
                    @ParmLength,@NumVoices,DataLength,@DataLength);
  UltraSetNVoices := rc;
end;

//***************************************************************************
Function UltraReleaseAccess : LongInt;
var ParmLength,DataLength : LongInt;
    rc                     : LongInt;
begin
  DataLength := 0;
  ParmLength := 0;
  rc := DosDevIOCtl(GUSHandle,Gus_Commands,UltraDevReleaseAccess,NIL,0,
                    @ParmLength,NIL,DataLength,@DataLength);
  UltraReleaseAccess := rc;
end;

//***************************************************************************
Function UltraEnableOutput : LongInt;
var ParmLength,DataLength : LongInt;
    rc                     : LongInt;
begin
  DataLength := 0;
  ParmLength := 0;
  rc := DosDevIOCtl(GUSHandle,Gus_Commands,UltraDevEnableOutput,NIL,0,
                    @ParmLength,NIL,DataLength,@DataLength);
  UltraEnableOutput := rc;
end;

//***************************************************************************
Function UltraDisableOutput : LongInt;
var ParmLength,DataLength : LongInt;
    rc                    : LongInt;
begin
  DataLength := 0;
  ParmLength := 0;
  rc := DosDevIOCtl(GUSHandle,Gus_Commands,UltraDevDisableOutput,NIL,0,
                 @ParmLength,NIL,DataLength,@DataLength);
  UltraDisableOutput := rc;
end;

//***************************************************************************
Function UltraBlockTimerHandler1 : LongInt;
var ParmLength,DataLength : LongInt;
    rc                    : LongInt;
begin
  DataLength := 0;
  ParmLength := 0;
  { block until timer interrupt }
  rc := DosDevIOCtl(GUSHandle,Gus_Commands,UltraDevBlockTimerHandler1,NIL,0,
                    @ParmLength,NIL,DataLength,@DataLength);
  UltraBlockTimerHandler1 := rc;
end;

//***************************************************************************
Function UltraBlockTimerHandler2 : LongInt;
var ParmLength,DataLength : LongInt;
    rc                    : LongInt;
begin
  DataLength := 0;
  ParmLength := 0;
  { block until timer interrupt }
  rc := DosDevIOCtl(GUSHandle,Gus_Commands,UltraDevBlockTimerHandler2,NIL,0,
                    @ParmLength,NIL,DataLength,@DataLength);
  UltraBlockTimerHandler2 := rc;
end;

//***************************************************************************
Function UltraStartTimer(Timer,Time : LongInt) : LongInt;
var ParmLength,DataLength : LongInt;
    rc                    : LongInt;
    tBuffer               : TimerStruct;
begin
  ParmLength := 0;
  DataLength := SizeOf(TimerStruct);
  tBuffer.Timer := Timer;
  tBuffer.Time := Time;
  rc := DosDevIOCtl(GUSHandle,Gus_Commands,UltraDevStartTimer,NIL,0,
                    @ParmLength,@tBuffer,DataLength,@DataLength);
  UltraStartTimer := rc;
end;

//***************************************************************************
Function UltraStopTimer(Timer : LongInt) : LongInt;
var ParmLength,DataLength : LongInt;
    rc                    : LongInt;
begin
  ParmLength := 0;
  DataLength := SizeOf(Timer);
  rc := DosDevIOCtl(GUSHandle,Gus_Commands,UltraDevStopTimer,NIL,0,
                    @ParmLength,@Timer,DataLength,@DataLength);
  UltraStopTimer := rc;
end;

//***************************************************************************
Function UltraSetBalance(Voice : Integer; Data : Byte) : LongInt;
var ParmLength,DataLength : LongInt;
    rc                    : LongInt;
    bBuffer               : BalanceStruct;
begin
  ParmLength := 0;
  DataLength := SizeOf(BalanceStruct);
  bBuffer.Voice := Voice;
  bBuffer.Data := Data;
  rc := DosDevIOCtl(GUSHandle,Gus_Commands,UltraDevSetBalance,NIL,0,
                    @ParmLength,@bBuffer,DataLength,@DataLength);
  UltraSetBalance := rc;
end;

//***************************************************************************
Function UltraSetFrequency(Voice : Integer; Freq : LongInt) : LongInt;
var ParmLength,DataLength : LongInt;
    rc                    : LongInt;
    fBuffer               : FreqStruct;
begin
  ParmLength := 0;
  DataLength := SizeOf(FreqStruct);
  fBuffer.Voice := Voice;
  fBuffer.Speed_Khz := Freq;
  rc := DosDevIOCtl(GUSHandle,Gus_Commands,UltraDevSetFrequency,NIL,0,
                    @ParmLength,@fBuffer,DataLength,@DataLength);
  UltraSetFrequency := rc;
end;

//***************************************************************************
Function UltraMemFree(Size,Location : LongInt) : LongInt;
var ParmLength,DataLength : LongInt;
    rc                    : LongInt;
    aBuffer               : AllocStruct;
begin
  ParmLength := 0;
  DataLength := SizeOf(AllocStruct);
  aBuffer.Size := Size;
  aBuffer.Location := Location;
  rc := DosDevIOCtl(GUSHandle,Gus_Commands,UltraDevMemFree,NIL,0,
                    @ParmLength,@aBuffer,DataLength,@DataLength);
  UltraMemFree := aBuffer.Size;
end;

//***************************************************************************
Function UltraMemAlloc(Size : LongInt; var Location : LongInt; Typ : Byte) : LongInt;
{
  Voice control bit definitions for "Typ"
  - Voice8Bit = $00;
  - Voice16Bit = $04;
}
var ParmLength,DataLength : LongInt;
    rc                    : LongInt;
    aBuffer               : AllocStruct;
begin
  ParmLength := 0;
  DataLength := SizeOf(AllocStruct);
  if (Size MOD 32) <> 0 then
    inc(Size,32 - (Size MOD 32)); { bring Size up TO a 32 BYTE boundary }
  aBuffer.Size := Size;
  aBuffer.Location := Location;
  aBuffer.Typ := Typ;
  rc := DosDevIOCtl(GUSHandle,Gus_Commands,UltraDevMemAlloc,NIL,0,
                    @ParmLength,@aBuffer,DataLength,@DataLength);
  Location := aBuffer.Location; { location in DRAM GUS }
  UltraMemAlloc := rc;
end;

//***************************************************************************
Function UltraMemInit : LongInt;
var ParmLength,DataLength : LongInt;
    rc                    : LongInt;
begin
  ParmLength := 0;
  DataLength := 0;
  rc := DosDevIOCtl(GUSHandle,Gus_Commands,UltraDevMemInit,NIL,0,
                    @ParmLength,NIL,DataLength,@DataLength);
  UltraMemInit := rc;
end;

//***************************************************************************
Function UltraDownload(DataPtr : Pointer; Control : Byte; DRam_Loc,Size : LongInt; Wait : Boolean) : LongInt;
{ Version >= 1.10 }
Const Max = 64*1000;
var ParmLength,DataLength : LongInt;
    rc                    : LongInt;
    Written               : LongInt;
    xBuffer               : XferStruct;
    Buffer64k             : pointer;
begin
  ParmLength := 0;
  DataLength := SizeOf(XferStruct);
  xBuffer.Control := Control;
  xBuffer.DRam_Loc := DRam_Loc;
  rc := 0;
  { NEED to allocate a buffer to transfer samples > 64 kb !!! }
  rc := DosAllocMem(Buffer64k,64*1024,PAG_COMMIT or PAG_WRITE);
  if rc = 0 then begin
    while (Size > Max) and (rc = 0) do begin {16 bit segments in a 32 bit world 8( }
      Move(DataPtr^,Buffer64k^,Max);
      rc := DosDevIOCtl(GUSHandle,GUS_COMMANDS,UltraDevPrepare4DMAXfer,NIL,
                        0,@ParmLength,@xBuffer,DataLength,@DataLength);
      if rc = 0 then begin
        rc := DosWrite(GUSHandle,Buffer64k^,Max,Written);
        if rc = 0 then begin
          inc(Dram_Loc,Max);
          xBuffer.Dram_Loc := Dram_Loc;
          xBuffer.Control := Control;
          Dec(Size,Max);
          inc(LongInt(DataPtr),Max);
        end;
      end;
    end;
    if (Size > 0) and (rc = 0) then begin
      Move(DataPtr^,Buffer64k^,Size);
      rc := DosDevIOCtl(GUSHandle,GUS_COMMANDS,UltraDevPrepare4DMAXfer,NIL,
                        0,@ParmLength,@xBuffer,DataLength,@DataLength);
      if rc = 0 then
         rc := DosWrite(GUSHandle,Buffer64k^,Size,Written); {last transfer}
    end;
    DosFreeMem(Buffer64k);
  end;
  UltraDownLoad := rc;
end;

//***************************************************************************
Function UltraPokeData(Address : LongInt; Data : Byte) : LongInt;
var ParmLength,DataLength : LongInt;
    rc                    : LongInt;
    pBuffer               : PokeStruct;
begin
  ParmLength := 0;
  pBuffer.Address := Address;
  pBuffer.Data := Data;
  DataLength := SizeOf(pBuffer);
  rc := DosDevIOCtl(GUSHandle,Gus_Commands,UltraDevPokeData,NIL,0,
                    @ParmLength,@pBuffer,DataLength,@DataLength);
  UltraPokeData := rc;
end;

//***************************************************************************
Function UltraPeekData(Address : LongInt) : LongInt;
var ParmLength,DataLength : LongInt;
    rc                    : LongInt;
begin
  ParmLength := 0;
  DataLength := SizeOf(Address);
  rc := DosDevIOCtl(GUSHandle,Gus_Commands,UltraDevPeekData,NIL,0,
                    @ParmLength,@Address,DataLength,@DataLength);
  UltraPeekData := rc;
end;

//***************************************************************************
Function UltraUnblockAll : LongInt;
var ParmLength,DataLength : LongInt;
    rc                    : LongInt;
begin
  ParmLength := 0;
  DataLength := 0;
  rc := DosDevIOCtl(GUSHandle,Gus_Commands,UltraDevUnblockAll,NIL,0,
                    @ParmLength,NIL,0,@DataLength);
  UltraUnblockAll := rc;
end;

//***************************************************************************
Function UltraStopVoice(Voice : Integer) : LongInt;
var ParmLength,DataLength : LongInt;
    rc                    : LongInt;
begin
  ParmLength := 0;
  DataLength := SizeOf(Voice);
  rc := DosDevIOCtl(GUSHandle,Gus_Commands,UltraDevStopVoice,NIL,0,
                    @ParmLength,@Voice,DataLength,@DataLength);
  UltraStopVoice := rc;
end;

//***************************************************************************
Function UltraVectorLinearVolume(Voice : Integer; End_Idx : LongInt; Rate,
                                 Mode : Byte): LongInt;
(*
End_Idx;   end location in ultra DRAM
Rate;      0 to 63
Mode;      mode to run the volume ramp in ...
*)
var ParmLength,DataLength : LongInt;
    rc                    : LongInt;
    vBuffer               : VolumeStruct;
begin
  vBuffer.Voice := Voice;
  vBuffer.End_Idx := End_Idx;
  vBuffer.Rate := Rate;
  vBuffer.Mode := Mode;
  DataLength := SizeOf(VolumeStruct);
  ParmLength := 0;
  rc :=  DosDevIOCtl(GUSHandle,Gus_Commands,UltraDevVectorLinearVolume,NIL,0,
                     @ParmLength,@vBuffer,DataLength,@DataLength);
  UltraVectorLinearVolume := rc;
end;

//***************************************************************************
Function UltraSetAll(Voice: Integer; Balance : Byte; Freq : LongInt;
                     Volume : Word; Rate,Mode : Byte) : LongInt;
var ParmLength,DataLength : LongInt;
    rc                    : LongInt;
    aBuffer               : AllStruct;
begin
  ParmLength := 0;
  DataLength := SizeOf(AllStruct);
  aBuffer.Voice := Voice;
  aBuffer.Balance := Balance;
  aBuffer.Freq := Freq;
  aBuffer.Volume := Volume;
  aBuffer.Rate := Rate;
  aBuffer.Mode := Mode;
  rc :=  DosDevIOCtl(GUSHandle,Gus_Commands,UltraDevSetAll,NIL,0,
                     @ParmLength,@aBuffer,DataLength,@DataLength);
  UltraSetAll := rc;
end;

//***************************************************************************
Function UltraStartVoice(GusVoice : Integer; begin_,start,end_ : LongInt;
                         Mode : Byte) : LongInt;
{
gusvoice  voice to start
begin_    start location in ultra DRAM
start     start loop location in ultra DRAM
end_      end location in ultra DRAM
mode      mode to run the voice (loop etc)
}
var ParmLength,DataLength : LongInt;
    rc                    : LongInt;
    Voice                 : VoiceStruct;
begin
  ParmLength := 0;
  Voice.Voice := GusVoice;
  Voice.Begin_ := Begin_; { start in DRAM  }
  Voice.Start := Start;   { start loop }
  Voice.End_ := End_;
  Voice.Mode := Mode;
  DataLength := SizeOf(VoiceStruct);
  rc :=  DosDevIOCtl(GUSHandle,Gus_Commands,UltraDevStartVoice,NIL,0,
                    @ParmLength,@Voice,DataLength,@DataLength);
  UltraStartVoice := rc;
end;

//***************************************************************************
Function UltraSizeDram : LongInt;
var ParmLength,DataLength : LongInt;
    rc                    : LongInt;
    Size                  : LongInt;
begin
  ParmLength := 0;
  DataLength := SizeOf(LongInt);
  rc := DosDevIOCtl(GUSHandle,Gus_Commands,UltraDevSizeDRAM,NIL,0,
                    @ParmLength,@Size,DataLength,@DataLength);
  UltraSizeDram := Size;
end;

//***************************************************************************
Function UltraGetDriverVersion : Word;
var ParmLength,DataLength : LongInt;
    rc                    : LongInt;
    aBuffer               : AllocStruct;
    Version               : Word;
begin
  ParmLength := 0;
  DataLength := SizeOf(Version);
  { High byte Contains major version,low byte minor version }
  rc := DosDevIOCtl(GUSHandle,Gus_Commands,UltraDevGetDriverVersion,NIL,0,
                    @ParmLength,@Version,DataLength,@DataLength);
  UltraGetDriverVersion := Version;
end;

//***************************************************************************
Function UltraSetLoopMode(Voice,Mode : LongInt) : LongInt;
var ParmLength,DataLength : LongInt;
    rc                    : LongInt;
    bBuffer               : BalanceStruct;
begin
  ParmLength := 0;
  DataLength := SizeOf(BalanceStruct);
  bBuffer.Voice := Voice;
  bBuffer.Data := Mode;
  rc :=  DosDevIOCtl(GUSHandle,Gus_Commands,UltraDevSetLoopMode,NIL,0,
                     @ParmLength,@bBuffer,DataLength,@DataLength);
  UltraSetLoopMode := rc;
end;

//***************************************************************************
Function UltraVoiceStopped(Voice : LongInt) : Boolean;
{ false while playing Voice }
var ParmLength,DataLength : LongInt;
    rc                    : LongInt;
begin
  ParmLength := 0;
  DataLength := SizeOf(Voice);
  rc := DosDevIOCtl(GUSHandle,Gus_Commands,UltraDevVoiceStopped,NIL,0,
                    @ParmLength,@Voice,DataLength,@DataLength);
  UltraVoiceStopped := Voice > 0;
end;

//***************************************************************************
Function UltraGetUltraType : LongInt;
var ParmLength,DataLength : LongInt;
    rc                    : LongInt;
    Typ                   : LongInt;
begin
  ParmLength := 0;
  DataLength := sizeof(Typ);
  rc := DosDevIOCtl(GUSHandle, GUS_COMMANDS, UltraDevGetUltraType, NIL, 0,
        @ParmLength,@Typ, DataLength,@DataLength);
  UltraGetUltraType := Typ;
end;

//***************************************************************************
Function UltraGetUltraTypeStr : String;
Type Str50 = String[50];
const TypStr : Array[1..11] of Str50 = (
      ('PLAIN'),('ICS2101FLR'),('ICS2101'),('CS4231'),('ACE'),('CD3'),
      ('ICS2102'),('MAX23'),('CS4231_DB'),('?'),('PNP')
      );
var Typ : LongInt;
begin
  Typ := UltraGetUltraType;
  if (Typ >=1) and (Typ <= 11) then
    UltraGetUltraTypeStr := TypStr[Typ]
  else
    UltraGetUltraTypeStr := 'Sorry! Unkown GUS';
end;

//***************************************************************************
Function UltraAddEffectToVoice(Voice,Effect : LongInt) : LongInt;
var ParmLength,DataLength : LongInt;
    rc                    : LongInt;
    EffData               : LongInt;
begin
  ParmLength := 0;
  DataLength := 4;
  EffData    := (Effect shl 16) + voice;

  rc := DosDevIOCtl(GUSHandle, GUS_COMMANDS, UltraDevAddEffectToVoice,NIL,0,
                    @ParmLength,@EffData, DataLength, @DataLength);
  UltraAddEffectToVoice := rc;
end;

//***************************************************************************
Function UltraRemoveEffectFromVoice(Voice,Effect : LongInt) : LongInt;
var ParmLength,DataLength : LongInt;
    rc                    : LongInt;
    EffData               : LongInt;
begin
  ParmLength := 0;
  DataLength := 4;
  EffData    := (effect shl 16) + voice;

   rc := DosDevIOCtl(GUSHandle, GUS_COMMANDS, UltraDevRemoveEffectFromVoice, NIL,0,
                     @ParmLength,@EffData, DataLength, @DataLength);
  UltraRemoveEffectFromVoice := rc;
end;

//***************************************************************************
Function UltraStartEffectVoice(Voice,_Begin,_End,Distance,
                               Balance,Volume,Rate,Mode : LongInt) : LongInt;
Type EffectStruct = Record
       voice,
       _begin,
       _end,
       distance,
       balance,
       volume,
       rate,
       mode     : Integer;
     end;

var ParmLength,DataLength : LongInt;
    rc                    : LongInt;
    Eff_Buffer            : EffectStruct;
begin
  ParmLength := 0;
  DataLength := SizeOf(EffectStruct);
  Eff_Buffer.Voice    := Voice;
  Eff_Buffer._Begin   := _Begin;
  Eff_Buffer._End     := _End;
  Eff_Buffer.Distance := Distance;
  Eff_Buffer.Balance  := Balance;
  Eff_Buffer.Volume   := Volume;
  Eff_Buffer.Rate     := Rate;
  Eff_Buffer.Mode     := Mode;
  rc := DosDevIOCtl(GUSHandle, GUS_COMMANDS, UltraDevStartEffectVoice, NIL,0,
                    @ParmLength,@Eff_Buffer, DataLength, @DataLength);
  UltraStartEffectVoice := rc;
end;
{ ... to be continued }
end.

