{ Renders the WormHole Picture. Saves in WORM.RAW file. }
program RenderWormHole;
uses crt;

const
  XDOTS   = 320;
  YDOTS   = 200;
  XCENTER = 160;
  YCENTER = 50;
  DIVS    = 1000;
  SPOKES  = 20*16*5;
  FACTOR  = 65536;
var
  costable,sintable: array [0..SPOKES-1] of longint;
  functable: array [1..DIVS-1] of longint;

procedure initgraph; assembler;
asm
   mov  ax,13h
   int  10h
end;

procedure deinit; assembler;
asm
   mov  ax,03h
   int  10h
end;

procedure setpalettecol(color,red,green,blue: byte); assembler;
asm
   mov  dx,3C8h
   mov  al,[color]
   out  dx,al
   inc  dx
   mov  al,[red]
   out  dx,al
   mov  al,[green]
   out  dx,al
   mov  al,[blue]
   out  dx,al
end;

procedure putpixel(x,y:integer; color:byte);
begin Mem[$A000:x+XDOTS*y]:=color;
end;

procedure setpalette;
var k,l:integer;
begin
  for l:=0 to 14 do
    for k:=0 to 15 do
      setpalettecol(16+k+16*l, 4*(k and 15),4*(l mod 15),63);
end;

procedure render;
var
  x,y,i,j,color:integer;
begin
  for i := 0 to SPOKES-1 do begin
    costable[i] := round(FACTOR * 320/DIVS*cos(2*Pi*i/SPOKES));
    sintable[i] := round(FACTOR * 240/DIVS*sin(2*Pi*i/SPOKES));
  end;

  for j := 1 to DIVS-1 do begin
    functable[j] := {round(FACTOR * 30*(-1.0+ln(2.0*j/DIVS)));}
      round(FACTOR * 200*(-0.6+0.6*sin(Pi*j/DIVS)));
  end;

  for j:=1 to DIVS-1 do begin
    color := {16+16*(14-((abs(functable[j]) div (FACTOR div 2)) mod 15));}
      16+16*((j div 5) mod 15);
    for i:=0 to SPOKES-1 do begin
      x := XCENTER + (j*costable[i]) div FACTOR;
      y := YCENTER + ((j*sintable[i]) - functable[j]) div FACTOR;
      if (x>=0) and (x<XDOTS) and (y>=0) and (y<YDOTS) then begin
        putpixel(x,y,color + ((i div 5) mod 16));
      end;
    end;
  end;
end;

procedure savepic;
var F:file;
begin
  assign(f,'WORM.RAW');
  rewrite(f,1);
  blockwrite(f,mem[$a000:0],xdots*ydots);
  close(f);
end;

begin
  initgraph;
  setpalette;
  render;
  savepic;
  sound(1000); delay(50); nosound; {readkey;}
  deinit;
end.
