diff -urPBb ..\v101qc/ai.qc diff/ai.qc
--- ..\v101qc/ai.qc	Wed Jul 24 23:51:22 1996
+++ diff/ai.qc	Wed Aug 14 09:32:00 1996
@@ -13,7 +13,7 @@
 The next path spot to walk toward.  If .enemy, ignore .movetarget.
 When an enemy is killed, the monster will try to return to it's path.
 
-.huntt_ime
+.hunt_time
 Set to time + something when the player is in sight, but movement straight for
 him is blocked.  This causes the monster to use wall following code for
 movement direction instead of sighting on the player.
@@ -326,12 +326,40 @@
 		sight_entity_time = time;
 	}
 	
+	if(self.enemy!=self.pet) 
 	self.show_hostile = time + 1;		// wake up other monsters
+//      else {
+//              dprint(self.classname);
+//              dprint(" has a pet ");
+//              dprint(self.pet.classname);
+//              dprint(".\n");
+//      }
 
 	SightSound ();
 	HuntTarget ();
 };
 
+void() PetMove = 
+{
+//Modified by J. Faske -- try to make the pet move out of the way
+	local vector dtemp;
+	local float dir;
+	if(other != self.pet) return; // We don't want someone else pushing
+	dtemp = vectoangles(self.pet.velocity);
+	dir = vectoyaw(dtemp);
+	dir = dir + 90;
+	dir = anglemod(dir);
+	if (walkmove(dir, 7))
+		return;
+	dir = dir + 180 ;
+	dir = anglemod(dir);
+	if (walkmove(dir, 7))
+		return;
+	dir = dir + 90;
+	dir = anglemod(dir);
+	walkmove(dir, 7);
+};
+
 /*
 ===========
 FindTarget
@@ -349,9 +377,11 @@
 slower noticing monsters.
 ============
 */
+void(entity newpet) player_addpet;
+
 float() FindTarget =
 {
-	local entity	client;
+	local entity    client, oldself;
 	local float		r;
 
 // if the first spawnflag bit is set, the monster will only wake up on
@@ -413,6 +443,15 @@
 		}
 	}
 	
+	if ((self.flags & FL_FRIENDLY) & (!self.pet)) {
+		self.touch=PetMove;
+		self.pet=self.enemy;
+		oldself=self;
+		self=self.pet;
+		player_addpet(oldself);
+		self=oldself;
+	}
+
 	FoundTarget ();
 
 	return TRUE;
@@ -497,13 +536,26 @@
 The monster is staying in one place for a while, with slight angle turns
 =============
 */
+void() PetMove ;
 void() ai_stand =
 {
+	local float r;
 	if (FindTarget ())
 		return;
 	
 	if (time > self.pausetime)
 	{
+		if(self.pet) {
+			self.touch = PetMove ;
+			r=range(self.pet);
+			if(r==RANGE_MELEE)
+				return;
+			else if(r==RANGE_MID)
+				self.th_walk ();
+			else
+				self.th_run ();
+		}
+		else
 		self.th_walk ();
 		return;
 	}
@@ -677,12 +729,22 @@
 void(float dist) ai_run =
 {
 	local	vector	delta;
+	local   float   test;
 	local	float	axis;
 	local	float	direct, ang_rint, ang_floor, ang_ceil;
 	
 	movedist = dist;
 // see if the enemy is dead
-	if (self.enemy.health <= 0)
+	if (self.classname == "monster_dog"
+		|| self.classname == "monster_shambler"
+		|| self.classname == "monster_demon") 
+		// Those guys are viscious
+			test=1;
+	else {
+		test = (self.enemy.flags & FL_MONSTER) == FL_MONSTER;
+		test = test + (self.enemy.classname == "player");
+	}
+	if (!test || self.enemy.health <= 0)
 	{
 		self.enemy = world;
 	// FIXME: look all around for other targets
@@ -693,7 +755,14 @@
 		}
 		else
 		{
-			if (self.movetarget)
+			if (self.pet)
+				if(self.pet.health > 0) {
+					self.enemy = self.pet;
+					HuntTarget();
+				} else {
+					self.pet=world;
+				}
+			else if (self.movetarget)
 				self.th_walk ();
 			else
 				self.th_stand ();
@@ -701,13 +770,25 @@
 		}
 	}
 
-	self.show_hostile = time + 1;		// wake up other monsters
 
 // check knowledge of enemy
 	enemy_vis = visible(self.enemy);
 	if (enemy_vis)
 		self.search_time = time + 5;
 
+// Okay, just find our pet
+	if(self.enemy == self.pet) {
+		// head straight in
+		if(range(self.pet) == RANGE_MELEE) {
+			self.pausetime=time+1;
+			self.th_stand();
+		} else
+			movetogoal (dist);              // done in C code...
+		return;
+	}
+		
+	self.show_hostile = time + 1;           // wake up other monsters
+
 // look for other coop players
 	if (coop && self.search_time < time)
 	{
diff -urPBb ..\v101qc/client.qc diff/client.qc
--- ..\v101qc/client.qc	Wed Jul 24 23:51:22 1996
+++ diff/client.qc	Mon Aug 12 15:23:08 1996
@@ -2,7 +2,7 @@
 // prototypes
 void () W_WeaponFrame;
 void() W_SetCurrentAmmo;
-void() player_pain;
+void(entity e, float f) player_pain;
 void() player_stand1;
 void (vector org) spawn_tfog;
 void (vector org, entity death_owner) spawn_tdeath;
@@ -57,7 +57,7 @@
 
 void() SetNewParms =
 {
-	parm1 = IT_SHOTGUN | IT_AXE;
+	parm1 = IT_SHOTGUN | IT_AXE | IT_EXTRA_WEAPON;
 	parm2 = 100;
 	parm3 = 0;
 	parm4 = 25;
@@ -70,6 +70,7 @@
 
 void() DecodeLevelParms =
 {
+	local entity pettemp;
 	if (serverflags)
 	{
 		if (world.model == "maps/start.bsp")
@@ -85,6 +86,14 @@
 	self.ammo_cells = parm7;
 	self.weapon = parm8;
 	self.armortype = parm9 * 0.01;
+//Added by J. Faske -- can't take your pets with you between levels
+	while (self.petlist)
+	{        
+		pettemp = self.petlist;
+		self.petlist = pettemp.petlist;
+		remove(pettemp);
+	}
+//End addition                
 };
 
 /*
diff -urPBb ..\v101qc/combat.qc diff/combat.qc
--- ..\v101qc/combat.qc	Wed Jul 24 23:51:22 1996
+++ diff/combat.qc	Mon Aug 12 12:59:30 1996
@@ -149,7 +149,7 @@
 
 // check for godmode or invincibility
 	if (targ.flags & FL_GODMODE)
-		return;
+		take=0;
 	if (targ.invincible_finished >= time)
 	{
 		if (self.invincible_sound < time)
diff -urPBb ..\v101qc/defs.qc diff/defs.qc
--- ..\v101qc/defs.qc	Wed Jul 24 23:51:22 1996
+++ diff/defs.qc	Mon Aug 12 14:44:10 1996
@@ -240,6 +240,7 @@
 float	FL_PARTIALGROUND		= 1024;	// not all corners are valid
 float	FL_WATERJUMP			= 2048;	// player jumping out of water
 float	FL_JUMPRELEASED			= 4096;	// for jump debouncing
+float	FL_FRIENDLY			= 8192;
 
 // edict.movetype values
 float	MOVETYPE_NONE			= 0;	// never moves
@@ -690,4 +691,5 @@
 
 float(entity targ, entity inflictor) CanDamage;
 
-
+.entity	pet;
+.entity	petlist;
diff -urPBb ..\v101qc/demon.qc diff/demon.qc
--- ..\v101qc/demon.qc	Wed Jul 24 23:51:22 1996
+++ diff/demon.qc	Mon Aug 12 14:45:06 1996
@@ -145,26 +145,32 @@
 void()	demon1_die4		=[	$death4,		demon1_die5	] {};
 void()	demon1_die5		=[	$death5,		demon1_die6	] {};
 void()	demon1_die6		=[	$death6,		demon1_die7	]
-{self.solid = SOLID_NOT;};
+{};
 void()	demon1_die7		=[	$death7,		demon1_die8	] {};
 void()	demon1_die8		=[	$death8,		demon1_die9	] {};
 void()	demon1_die9		=[	$death9,		demon1_die9 ] {};
 
 void() demon_die =
 {
+//Added by J. Faske -- removes the link for self from the petlist
+RemovePet(self);
+//End addition
 // check for gib
 	if (self.health < -80)
 	{
 		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
-		ThrowHead ("progs/h_demon.mdl", self.health);
-		ThrowGib ("progs/gib1.mdl", self.health);
-		ThrowGib ("progs/gib1.mdl", self.health);
-		ThrowGib ("progs/gib1.mdl", self.health);
+//		ThrowHead ("progs/h_demon.mdl", self.health);
+//		ThrowGib ("progs/gib1.mdl", self.health);
+//		ThrowGib ("progs/gib1.mdl", self.health);
+//		ThrowGib ("progs/gib1.mdl", self.health);
+		monster_gib("progs/h_demon.mdl");
 		return;
 	}
 
 // regular death
 	demon1_die1 ();
+
+	monster_corpse_setup('-16 -16 -24', '16 16 -12', "progs/h_demon.mdl");
 };
 
 
@@ -177,23 +183,8 @@
 /*QUAKED monster_demon1 (1 0 0) (-32 -32 -24) (32 32 64) Ambush
 
 */
-void() monster_demon1 =
+void() _monster_demon1 =
 {
-	if (deathmatch)
-	{
-		remove(self);
-		return;
-	}
-	precache_model ("progs/demon.mdl");
-	precache_model ("progs/h_demon.mdl");
-
-	precache_sound ("demon/ddeath.wav");
-	precache_sound ("demon/dhit2.wav");
-	precache_sound ("demon/djump.wav");
-	precache_sound ("demon/dpain1.wav");
-	precache_sound ("demon/idle1.wav");
-	precache_sound ("demon/sight2.wav");
-
 	self.solid = SOLID_SLIDEBOX;
 	self.movetype = MOVETYPE_STEP;
 
@@ -213,6 +204,24 @@
 	walkmonster_start();
 };
 
+void () monster_demon1 =
+{
+	if (deathmatch)
+	{
+		remove(self);
+		return;
+	}
+	precache_model ("progs/demon.mdl");
+	precache_model ("progs/h_demon.mdl");
+
+	precache_sound ("demon/ddeath.wav");
+	precache_sound ("demon/dhit2.wav");
+	precache_sound ("demon/djump.wav");
+	precache_sound ("demon/dpain1.wav");
+	precache_sound ("demon/idle1.wav");
+	precache_sound ("demon/sight2.wav");
+	_monster_demon1();
+};
 
 /*
 ==============================================================================
diff -urPBb ..\v101qc/dog.qc diff/dog.qc
--- ..\v101qc/dog.qc	Wed Jul 24 23:51:22 1996
+++ diff/dog.qc	Mon Aug 12 14:45:42 1996
@@ -228,25 +228,35 @@
 
 void() dog_die =
 {
+// added by J. Faske -- removes the monster from his petlist
+	RemovePet(self);
+// end addition
+
 // check for gib
 	if (self.health < -35)
 	{
 		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
-		ThrowGib ("progs/gib3.mdl", self.health);
-		ThrowGib ("progs/gib3.mdl", self.health);
-		ThrowGib ("progs/gib3.mdl", self.health);
-		ThrowHead ("progs/h_dog.mdl", self.health);
+//		ThrowGib ("progs/gib3.mdl", self.health);
+//		ThrowGib ("progs/gib3.mdl", self.health);
+//		ThrowGib ("progs/gib3.mdl", self.health);
+//		ThrowHead ("progs/h_dog.mdl", self.health);
+		monster_gib("progs/h_dog.mdl");
 		return;
 	}
 
 // regular death
 	sound (self, CHAN_VOICE, "dog/ddeath.wav", 1, ATTN_NORM);
-	self.solid = SOLID_NOT;
+//	self.solid = SOLID_NOT;
 
 	if (random() > 0.5)
 		dog_die1 ();
 	else
 		dog_dieb1 ();
+
+// We want a corpse:  No actions, a little health, and a new .th_die
+// Frob some flags so we're damagable as well
+
+	monster_corpse_setup('-32 -32 -24', '32 32 -12',"progs/h_dog.mdl"); 
 };
 
 //============================================================================
@@ -327,22 +337,9 @@
 /*QUAKED monster_dog (1 0 0) (-32 -32 -24) (32 32 40) Ambush
 
 */
-void() monster_dog =
-{
-	if (deathmatch)
-	{
-		remove(self);
-		return;
-	}
-	precache_model ("progs/h_dog.mdl");
-	precache_model ("progs/dog.mdl");
-
-	precache_sound ("dog/dattack1.wav");
-	precache_sound ("dog/ddeath.wav");
-	precache_sound ("dog/dpain1.wav");
-	precache_sound ("dog/dsight.wav");
-	precache_sound ("dog/idle.wav");
 
+void() _monster_dog =
+{
 	self.solid = SOLID_SLIDEBOX;
 	self.movetype = MOVETYPE_STEP;
 
@@ -360,4 +357,22 @@
 	self.th_missile = dog_leap1;
 
 	walkmonster_start();
+};
+
+void() monster_dog = {
+	if (deathmatch)
+	{
+		remove(self);
+		return;
+	}
+
+	precache_model ("progs/h_dog.mdl");
+	precache_model ("progs/dog.mdl");
+
+	precache_sound ("dog/dattack1.wav");
+	precache_sound ("dog/ddeath.wav");
+	precache_sound ("dog/dpain1.wav");
+	precache_sound ("dog/dsight.wav");
+	precache_sound ("dog/idle.wav");
+	_monster_dog();
 };
diff -urPBb ..\v101qc/enforcer.qc diff/enforcer.qc
--- ..\v101qc/enforcer.qc	Wed Jul 24 23:51:22 1996
+++ diff/enforcer.qc	Mon Aug 12 12:59:38 1996
@@ -256,7 +256,7 @@
 void()	enf_die1	=[	$death1,	enf_die2	] {};
 void()	enf_die2	=[	$death2,	enf_die3	] {};
 void()	enf_die3	=[	$death3,	enf_die4	]
-{self.solid = SOLID_NOT;self.ammo_cells = 5;DropBackpack();};
+{self.ammo_cells = 5;DropBackpack();};
 void()	enf_die4	=[	$death4,	enf_die5	] {ai_forward(14);};
 void()	enf_die5	=[	$death5,	enf_die6	] {ai_forward(2);};
 void()	enf_die6	=[	$death6,	enf_die7	] {};
@@ -274,7 +274,7 @@
 };
 void()	enf_fdie2	=[	$fdeath2,	enf_fdie3	] {};
 void()	enf_fdie3	=[	$fdeath3,	enf_fdie4	] 
-{self.solid = SOLID_NOT;self.ammo_cells = 5;DropBackpack();};
+{self.ammo_cells = 5;DropBackpack();};
 void()	enf_fdie4	=[	$fdeath4,	enf_fdie5	] {};
 void()	enf_fdie5	=[	$fdeath5,	enf_fdie6	] {};
 void()	enf_fdie6	=[	$fdeath6,	enf_fdie7	] {};
@@ -291,10 +291,11 @@
 	if (self.health < -35)
 	{
 		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
-		ThrowHead ("progs/h_mega.mdl", self.health);
-		ThrowGib ("progs/gib1.mdl", self.health);
-		ThrowGib ("progs/gib2.mdl", self.health);
-		ThrowGib ("progs/gib3.mdl", self.health);
+//		ThrowHead ("progs/h_mega.mdl", self.health);
+//		ThrowGib ("progs/gib1.mdl", self.health);
+//		ThrowGib ("progs/gib2.mdl", self.health);
+//		ThrowGib ("progs/gib3.mdl", self.health);
+		monster_gib("progs/h_mega.mdl");
 		return;
 	}
 
@@ -304,6 +305,8 @@
 		enf_die1 ();
 	else
 		enf_fdie1 ();
+
+	monster_corpse_setup('-16 -16 -24', '16 16 -8', "progs/h_mega.mdl");
 };
 
 
diff -urPBb ..\v101qc/hknight.qc diff/hknight.qc
--- ..\v101qc/hknight.qc	Wed Jul 24 23:51:24 1996
+++ diff/hknight.qc	Mon Aug 12 12:59:38 1996
@@ -175,7 +175,7 @@
 void()	hknight_die1	=[	$death1,	hknight_die2	] {ai_forward(10);};
 void()	hknight_die2	=[	$death2,	hknight_die3	] {ai_forward(8);};
 void()	hknight_die3	=[	$death3,	hknight_die4	]
-{self.solid = SOLID_NOT; ai_forward(7);};
+{ai_forward(7);};
 void()	hknight_die4	=[	$death4,	hknight_die5	] {};
 void()	hknight_die5	=[	$death5,	hknight_die6	] {};
 void()	hknight_die6	=[	$death6,	hknight_die7	] {};
@@ -188,8 +188,7 @@
 
 void()	hknight_dieb1	=[	$deathb1,	hknight_dieb2	] {};
 void()	hknight_dieb2	=[	$deathb2,	hknight_dieb3	] {};
-void()	hknight_dieb3	=[	$deathb3,	hknight_dieb4	]
-{self.solid = SOLID_NOT;};
+void()	hknight_dieb3	=[	$deathb3,	hknight_dieb4	] {};
 void()	hknight_dieb4	=[	$deathb4,	hknight_dieb5	] {};
 void()	hknight_dieb5	=[	$deathb5,	hknight_dieb6	] {};
 void()	hknight_dieb6	=[	$deathb6,	hknight_dieb7	] {};
@@ -203,10 +202,11 @@
 	if (self.health < -40)
 	{
 		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
-		ThrowHead ("progs/h_hellkn.mdl", self.health);
-		ThrowGib ("progs/gib1.mdl", self.health);
-		ThrowGib ("progs/gib2.mdl", self.health);
-		ThrowGib ("progs/gib3.mdl", self.health);
+//		ThrowHead ("progs/h_hellkn.mdl", self.health);
+//		ThrowGib ("progs/gib1.mdl", self.health);
+//		ThrowGib ("progs/gib2.mdl", self.health);
+//		ThrowGib ("progs/gib3.mdl", self.health);
+		monster_gib("progs/h_hellkn.mdl");
 		return;
 	}
 
@@ -216,6 +216,7 @@
 		hknight_die1 ();
 	else
 		hknight_dieb1 ();
+	monster_corpse_setup ( '-16 -16 -24', '16 16 -12', "progs/h_hellkn.mdl");
 };
 
 
diff -urPBb ..\v101qc/jsubs.qc diff/jsubs.qc
--- ..\v101qc/jsubs.qc	Thu Jan  1 00:00:00 1970
+++ diff/jsubs.qc	Mon Aug 12 12:59:40 1996
@@ -0,0 +1,18 @@
+void(string gibname, float dm) ThrowGib;
+float() random;
+
+void() SUB_Gib =
+{
+	local vector x,y,v;
+	x='1 0 0';
+	y='0 1 0';
+	v=x*(50-random()*100)+y*(50-random()*100);
+	if (random() < 0.8)  // Meat spray only, most of the time
+		SpawnMeatSpray(self.origin, v);
+        else if (random() < 0.3)
+                ThrowGib("progs/gib1.mdl", self.health);
+        else if (random() < 0.5)
+                ThrowGib("progs/gib2.mdl", self.health);
+        else
+                ThrowGib("progs/gib3.mdl", self.health);
+};
diff -urPBb ..\v101qc/knight.qc diff/knight.qc
--- ..\v101qc/knight.qc	Wed Jul 24 23:51:24 1996
+++ diff/knight.qc	Mon Aug 12 12:59:40 1996
@@ -185,8 +185,7 @@
 
 void()	knight_die1	=[	$death1,	knight_die2	] {};
 void()	knight_die2	=[	$death2,	knight_die3	] {};
-void()	knight_die3	=[	$death3,	knight_die4	] 
-{self.solid = SOLID_NOT;};
+void()	knight_die3	=[	$death3,	knight_die4	] {};
 void()	knight_die4	=[	$death4,	knight_die5	] {};
 void()	knight_die5	=[	$death5,	knight_die6	] {};
 void()	knight_die6	=[	$death6,	knight_die7	] {};
@@ -198,8 +197,7 @@
 
 void()	knight_dieb1	=[	$deathb1,	knight_dieb2	] {};
 void()	knight_dieb2	=[	$deathb2,	knight_dieb3	] {};
-void()	knight_dieb3	=[	$deathb3,	knight_dieb4	] 	
-{self.solid = SOLID_NOT;};
+void()	knight_dieb3	=[	$deathb3,	knight_dieb4	] {};
 void()	knight_dieb4	=[	$deathb4,	knight_dieb5	] {};
 void()	knight_dieb5	=[	$deathb5,	knight_dieb6	] {};
 void()	knight_dieb6	=[	$deathb6,	knight_dieb7	] {};
@@ -216,10 +214,11 @@
 	if (self.health < -40)
 	{
 		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
-		ThrowHead ("progs/h_knight.mdl", self.health);
-		ThrowGib ("progs/gib1.mdl", self.health);
-		ThrowGib ("progs/gib2.mdl", self.health);
-		ThrowGib ("progs/gib3.mdl", self.health);
+//		ThrowHead ("progs/h_knight.mdl", self.health);
+//		ThrowGib ("progs/gib1.mdl", self.health);
+//		ThrowGib ("progs/gib2.mdl", self.health);
+//		ThrowGib ("progs/gib3.mdl", self.health);
+		monster_gib("progs/h_knight.mdl");
 		return;
 	}
 
@@ -229,6 +228,7 @@
 		knight_die1 ();
 	else
 		knight_dieb1 ();
+	monster_corpse_setup('-16 -16 -24', '16 16 -12', "progs/h_knight.mdl");
 };
 
 
diff -urPBb ..\v101qc/llsubs.qc diff/llsubs.qc
--- ..\v101qc/llsubs.qc	Thu Jan  1 00:00:00 1970
+++ diff/llsubs.qc	Mon Aug 12 12:59:40 1996
@@ -0,0 +1,40 @@
+entity(float size) SUB_Llinit =
+{
+	local float i=0;
+	local entity head, current;
+	head=world;
+	while(i<size) {
+		current=spawn();
+		current.chain=head;
+		head=current;
+	}
+	return head;
+};
+
+		
+entity(entity list, float index) SUB_Llaccess =
+{
+	local float i=0;
+	local entity here;
+	here=list;
+	while(i<index&&here!=world) {
+		here=here.chain;
+	}
+	return here.ent;
+};
+	
+void(void (entity e) f, entity list) SUB_Lliter =
+{
+	while(list!=world) {
+		f(list.ent);
+		list=list.chain;
+	}
+};
+
+entity(float (entity e) f, entity list) SUB_Llfind =
+{
+	while(list!=world) {
+		if (f(list.ent)) return list.ent;
+		list=list.chain;
+	}
+};
diff -urPBb ..\v101qc/monsters.qc diff/monsters.qc
--- ..\v101qc/monsters.qc	Wed Jul 24 23:51:24 1996
+++ diff/monsters.qc	Mon Aug 12 14:47:30 1996
@@ -38,6 +38,53 @@
 	self.think = FoundTarget;
 };
 
+void() monster_dead_push =
+{
+	local float dir;
+	dir = vectoyaw(other.velocity);
+	self.origin = self.origin + '0 0 1'; // Now we can be lifted, pushed off ledges, &c
+	walkmove(dir, 7);
+};
+
+void(string headmdl) monster_gib =
+{
+	ThrowGib ("progs/gib3.mdl", self.health);
+	ThrowGib ("progs/gib3.mdl", self.health);
+	ThrowGib ("progs/gib3.mdl", self.health);
+	ThrowHead (headmdl, self.health);
+};
+	
+void() monster_corpse_gib =
+{
+	monster_gib(self.weaponmodel);
+};
+
+void(vector bb1, vector bb2, string headmdl) monster_corpse_setup =
+{
+	setsize(self, bb1, bb2);
+	self.weaponmodel=headmdl; // This should be unused in monsters
+	self.health=35;
+	self.th_stand = SUB_Null;
+	self.th_walk = SUB_Null;
+	self.th_run = SUB_Null;
+      self.th_pain = SUB_Gib;
+      self.th_die = monster_corpse_gib;
+	self.th_melee = SUB_Null;
+	self.th_missile = SUB_Null;
+	// self.touch = monster_dead_push; // This does funny things
+	self.takedamage= DAMAGE_AIM; // grenades explode 
+	self.flags = self.flags &! FL_MONSTER;  // Next "death" isn't counted
+//Added by J. Faske
+	if (self.classname == "monster_dog")
+		self.classname = "dog_corpse";
+	if (self.classname == "monster_army")
+		self.classname = "army_corpse";
+	if (self.classname == "monster_demon1")
+		self.classname = "demon1_corpse";
+	if (self.classname == "monster_shambler")
+		self.classname = "shambler_corpse";
+};
+
 /*
 ================
 monster_death_use
@@ -76,9 +123,18 @@
 	
 	if (!walkmove(0,0))
 	{
-		dprint ("walkmonster in wall at: ");
-		dprint (vtos(self.origin));
-		dprint ("\n");
+//              dprint ("walkmonster in wall at: ");
+//              dprint (vtos(self.origin));
+//              dprint ("\n");
+		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
+		ThrowGib ("progs/gib1.mdl", self.health);
+		ThrowGib ("progs/gib2.mdl", self.health);
+		ThrowGib ("progs/gib3.mdl", self.health);
+//Added by J. Faske -- removes self from petlist               
+		RemovePet(self);
+//End addition                
+		remove(self);
+		return;
 	}
 	
 	self.takedamage = DAMAGE_AIM;
@@ -145,9 +201,15 @@
 
 	if (!walkmove(0,0))
 	{
-		dprint ("flymonster in wall at: ");
-		dprint (vtos(self.origin));
-		dprint ("\n");
+//              dprint ("flymonster in wall at: ");
+//              dprint (vtos(self.origin));
+//              dprint ("\n");
+		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
+		ThrowGib ("progs/gib1.mdl", self.health);
+		ThrowGib ("progs/gib2.mdl", self.health);
+		ThrowGib ("progs/gib3.mdl", self.health);
+		remove(self);
+		return;
 	}
 
 	if (self.target)
diff -urPBb ..\v101qc/ogre.qc diff/ogre.qc
--- ..\v101qc/ogre.qc	Wed Jul 24 23:51:24 1996
+++ diff/ogre.qc	Mon Aug 12 12:59:42 1996
@@ -354,8 +354,7 @@
 void()	ogre_die1	=[	$death1,	ogre_die2	] {};
 void()	ogre_die2	=[	$death2,	ogre_die3	] {};
 void()	ogre_die3	=[	$death3,	ogre_die4	]
-{self.solid = SOLID_NOT;
-self.ammo_rockets = 2;DropBackpack();};
+{self.ammo_rockets = 2;DropBackpack();};
 void()	ogre_die4	=[	$death4,	ogre_die5	] {};
 void()	ogre_die5	=[	$death5,	ogre_die6	] {};
 void()	ogre_die6	=[	$death6,	ogre_die7	] {};
@@ -371,8 +370,7 @@
 void()	ogre_bdie1	=[	$bdeath1,	ogre_bdie2	] {};
 void()	ogre_bdie2	=[	$bdeath2,	ogre_bdie3	] {ai_forward(5);};
 void()	ogre_bdie3	=[	$bdeath3,	ogre_bdie4	]
-{self.solid = SOLID_NOT;
-self.ammo_rockets = 2;DropBackpack();};
+{self.ammo_rockets = 2;DropBackpack();};
 void()	ogre_bdie4	=[	$bdeath4,	ogre_bdie5	] {ai_forward(1);};
 void()	ogre_bdie5	=[	$bdeath5,	ogre_bdie6	] {ai_forward(3);};
 void()	ogre_bdie6	=[	$bdeath6,	ogre_bdie7	] {ai_forward(7);};
@@ -387,10 +385,11 @@
 	if (self.health < -80)
 	{
 		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
-		ThrowHead ("progs/h_ogre.mdl", self.health);
-		ThrowGib ("progs/gib3.mdl", self.health);
-		ThrowGib ("progs/gib3.mdl", self.health);
-		ThrowGib ("progs/gib3.mdl", self.health);
+//		ThrowHead ("progs/h_ogre.mdl", self.health);
+//		ThrowGib ("progs/gib3.mdl", self.health);
+//		ThrowGib ("progs/gib3.mdl", self.health);
+//		ThrowGib ("progs/gib3.mdl", self.health);
+		monster_gib("progs/h_ogre.mdl");
 		return;
 	}
 
@@ -400,6 +399,10 @@
 		ogre_die1 ();
 	else
 		ogre_bdie1 ();
+// We want a corpse:  No actions, a little health, and a new .th_die
+// Frob some flags so we're damagable as well
+
+	monster_corpse_setup('-16 -16 -24', '16 16 -8', "progs/h_ogre.mdl");
 };
 
 void() ogre_melee =
diff -urPBb ..\v101qc/player.qc diff/player.qc
--- ..\v101qc/player.qc	Wed Jul 24 23:51:24 1996
+++ diff/player.qc	Mon Aug 12 14:49:06 1996
@@ -334,8 +334,21 @@
 void()	player_axpain5 =	[	$axpain5,	player_axpain6	] {};
 void()	player_axpain6 =	[	$axpain6,	player_run	] {};
 
-void() player_pain =
+void(entity attacker, float take) player_pain =
 {
+	local entity list, previous, onepet;
+	local entity oldself;
+
+	onepet=self.petlist;
+	while(onepet) {
+		onepet.enemy=attacker;
+		oldself=self;
+		self=onepet;
+		FoundTarget();
+		self=oldself;
+		onepet = onepet.petlist;
+	}
+
 	if (self.weaponframe)
 		return;
 
@@ -525,6 +538,9 @@
 {
 	local	float	i;
 	
+//Added by J. Faske -- if you die, so do your pets
+	KillPets();
+//End addition
 	self.items = self.items - (self.items & IT_INVISIBILITY);
 	self.invisible_finished = 0;	// don't die as eyes
 	self.invincible_finished = 0;
@@ -589,6 +605,12 @@
 	self.nextthink = -1;
 };
 
+void(entity e) player_addpet = {
+	e.flags = e.flags | FL_FRIENDLY;
+	e.petlist=self.petlist;
+	e.pet = self;
+	self.petlist=e;
+};
 
 void()	player_diea1	=	[	$deatha1,	player_diea2	] {};
 void()	player_diea2	=	[	$deatha2,	player_diea3	] {};
diff -urPBb ..\v101qc/progs.src diff/progs.src
--- ..\v101qc/progs.src	Wed Jul 24 23:51:28 1996
+++ diff/progs.src	Mon Aug 12 15:07:24 1996
@@ -7,6 +7,7 @@
 combat.qc
 items.qc
 weapons.qc
+jsubs.qc
 world.qc
 client.qc
 player.qc
diff -urPBb ..\v101qc/shalrath.qc diff/shalrath.qc
--- ..\v101qc/shalrath.qc	Wed Jul 24 23:51:24 1996
+++ diff/shalrath.qc	Mon Aug 12 12:59:44 1996
@@ -103,17 +103,19 @@
 	if (self.health < -90)
 	{
 		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
-		ThrowHead ("progs/h_shal.mdl", self.health);
-		ThrowGib ("progs/gib1.mdl", self.health);
-		ThrowGib ("progs/gib2.mdl", self.health);
-		ThrowGib ("progs/gib3.mdl", self.health);
+//		ThrowHead ("progs/h_shal.mdl", self.health);
+//		ThrowGib ("progs/gib1.mdl", self.health);
+//		ThrowGib ("progs/gib2.mdl", self.health);
+//		ThrowGib ("progs/gib3.mdl", self.health);
+		monster_gib("progs/h_shal.mdl");
 		return;
 	}
 
 	sound (self, CHAN_VOICE, "shalrath/death.wav", 1, ATTN_NORM);
 	shal_death1();
-	self.solid = SOLID_NOT;
+//	self.solid = SOLID_NOT;
 	// insert death sounds here
+	monster_corpse_setup('-16 -16 -24', '16 16 -10', "progs/h_shal.mdl");
 };
 
 /*
diff -urPBb ..\v101qc/shambler.qc diff/shambler.qc
--- ..\v101qc/shambler.qc	Wed Jul 24 23:51:24 1996
+++ diff/shambler.qc	Mon Aug 12 14:49:28 1996
@@ -293,7 +293,7 @@
 
 void() sham_death1      =[      $death1,       sham_death2     ] {};
 void() sham_death2      =[      $death2,       sham_death3     ] {};
-void() sham_death3      =[      $death3,       sham_death4     ] {self.solid = SOLID_NOT;};
+void() sham_death3      =[      $death3,       sham_death4     ] {};
 void() sham_death4      =[      $death4,       sham_death5     ] {};
 void() sham_death5      =[      $death5,       sham_death6     ] {};
 void() sham_death6      =[      $death6,       sham_death7     ] {};
@@ -305,20 +305,25 @@
 
 void() sham_die =
 {
+// Added by J. Faske -- removes monster from his petlist
+	RemovePet(self);
 // check for gib
 	if (self.health < -60)
 	{
 		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
-		ThrowHead ("progs/h_shams.mdl", self.health);
-		ThrowGib ("progs/gib1.mdl", self.health);
-		ThrowGib ("progs/gib2.mdl", self.health);
-		ThrowGib ("progs/gib3.mdl", self.health);
+//		ThrowHead ("progs/h_shams.mdl", self.health);
+//		ThrowGib ("progs/gib1.mdl", self.health);
+//		ThrowGib ("progs/gib2.mdl", self.health);
+//		ThrowGib ("progs/gib3.mdl", self.health);
+		monster_gib("progs/h_shams.mdl");
 		return;
 	}
 
 // regular death
 	sound (self, CHAN_VOICE, "shambler/sdeath.wav", 1, ATTN_NORM);
 	sham_death1 ();
+      self.health=300;
+	monster_corpse_setup ('-16 -16 -24', '42 42 -4', "progs/h_shams.mdl");
 };
 
 //============================================================================
@@ -326,6 +331,27 @@
 
 /*QUAKED monster_shambler (1 0 0) (-32 -32 -24) (32 32 64) Ambush
 */
+void() _monster_shambler =
+{
+
+	self.solid = SOLID_SLIDEBOX;
+	self.movetype = MOVETYPE_STEP;
+	setmodel (self, "progs/shambler.mdl");
+
+	setsize (self, VEC_HULL2_MIN, VEC_HULL2_MAX);
+	self.health = 600;
+
+	self.th_stand = sham_stand1;
+	self.th_walk = sham_walk1;
+	self.th_run = sham_run1;
+	self.th_die = sham_die;
+	self.th_melee = sham_melee;
+	self.th_missile = sham_magic1;
+	self.th_pain = sham_pain;
+	
+	walkmonster_start();
+};
+
 void() monster_shambler =
 {
 	if (deathmatch)
@@ -347,21 +373,5 @@
 	precache_sound ("shambler/melee1.wav");
 	precache_sound ("shambler/melee2.wav");
 	precache_sound ("shambler/smack.wav");
-
-	self.solid = SOLID_SLIDEBOX;
-	self.movetype = MOVETYPE_STEP;
-	setmodel (self, "progs/shambler.mdl");
-
-	setsize (self, VEC_HULL2_MIN, VEC_HULL2_MAX);
-	self.health = 600;
-
-	self.th_stand = sham_stand1;
-	self.th_walk = sham_walk1;
-	self.th_run = sham_run1;
-	self.th_die = sham_die;
-	self.th_melee = sham_melee;
-	self.th_missile = sham_magic1;
-	self.th_pain = sham_pain;
-	
-	walkmonster_start();
+	_monster_shambler();
 };
diff -urPBb ..\v101qc/soldier.qc diff/soldier.qc
--- ..\v101qc/soldier.qc	Wed Jul 24 23:51:24 1996
+++ diff/soldier.qc	Mon Aug 12 14:49:50 1996
@@ -195,7 +195,7 @@
 void()	army_die1	=[	$death1,	army_die2	] {};
 void()	army_die2	=[	$death2,	army_die3	] {};
 void()	army_die3	=[	$death3,	army_die4	]
-{self.solid = SOLID_NOT;self.ammo_shells = 5;DropBackpack();};
+{self.ammo_shells = 5;DropBackpack();};
 void()	army_die4	=[	$death4,	army_die5	] {};
 void()	army_die5	=[	$death5,	army_die6	] {};
 void()	army_die6	=[	$death6,	army_die7	] {};
@@ -207,7 +207,7 @@
 void()	army_cdie1	=[	$deathc1,	army_cdie2	] {};
 void()	army_cdie2	=[	$deathc2,	army_cdie3	] {ai_back(5);};
 void()	army_cdie3	=[	$deathc3,	army_cdie4	]
-{self.solid = SOLID_NOT;self.ammo_shells = 5;DropBackpack();ai_back(4);};
+{self.ammo_shells = 5;DropBackpack();ai_back(4);};
 void()	army_cdie4	=[	$deathc4,	army_cdie5	] {ai_back(13);};
 void()	army_cdie5	=[	$deathc5,	army_cdie6	] {ai_back(3);};
 void()	army_cdie6	=[	$deathc6,	army_cdie7	] {ai_back(4);};
@@ -220,14 +220,17 @@
 
 void() army_die =
 {
+// Added by J. Faske -- removes soldier from his petlist
+	RemovePet(self);
 // check for gib
 	if (self.health < -35)
 	{
 		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
-		ThrowHead ("progs/h_guard.mdl", self.health);
-		ThrowGib ("progs/gib1.mdl", self.health);
-		ThrowGib ("progs/gib2.mdl", self.health);
-		ThrowGib ("progs/gib3.mdl", self.health);
+//		ThrowHead ("progs/h_guard.mdl", self.health);
+//		ThrowGib ("progs/gib1.mdl", self.health);
+//		ThrowGib ("progs/gib2.mdl", self.health);
+//		ThrowGib ("progs/gib3.mdl", self.health);
+		monster_gib("progs/h_guard.mdl");
 		return;
 	}
 
@@ -237,13 +240,38 @@
 		army_die1 ();
 	else
 		army_cdie1 ();
+	
+// We want a corpse:  No actions, a little health, and a new .th_die
+// Frob some flags so we're damagable as well
+
+	monster_corpse_setup('-16 -16 -24', '16 16 -10', "progs/h_guard.mdl");
 };
 
 
 /*QUAKED monster_army (1 0 0) (-16 -16 -24) (16 16 40) Ambush
 */
-void() monster_army =
+void() _monster_army =
 {	
+
+	self.solid = SOLID_SLIDEBOX;
+	self.movetype = MOVETYPE_STEP;
+
+	setmodel (self, "progs/soldier.mdl");
+
+	setsize (self, '-16 -16 -24', '16 16 40');
+	self.health = 30;
+
+	self.th_stand = army_stand1;
+	self.th_walk = army_walk1;
+	self.th_run = army_run1;
+	self.th_missile = army_atk1;
+	self.th_pain = army_pain;
+	self.th_die = army_die;
+
+	walkmonster_start ();
+};
+
+void() monster_army = {
 	if (deathmatch)
 	{
 		remove(self);
@@ -263,22 +291,5 @@
 	precache_sound ("soldier/sight1.wav");
 
 	precache_sound ("player/udeath.wav");		// gib death
-
-
-	self.solid = SOLID_SLIDEBOX;
-	self.movetype = MOVETYPE_STEP;
-
-	setmodel (self, "progs/soldier.mdl");
-
-	setsize (self, '-16 -16 -24', '16 16 40');
-	self.health = 30;
-
-	self.th_stand = army_stand1;
-	self.th_walk = army_walk1;
-	self.th_run = army_run1;
-	self.th_missile = army_atk1;
-	self.th_pain = army_pain;
-	self.th_die = army_die;
-
-	walkmonster_start ();
+	_monster_army();
 };
diff -urPBb ..\v101qc/weapons.qc diff/weapons.qc
--- ..\v101qc/weapons.qc	Wed Jul 24 23:51:24 1996
+++ diff/weapons.qc	Thu Aug 15 09:04:44 1996
@@ -22,6 +22,7 @@
 	precache_sound ("weapons/grenade.wav");	// grenade launcher
 	precache_sound ("weapons/bounce.wav");		// grenade bounce
 	precache_sound ("weapons/shotgn2.wav");	// super shotgun
+	precache_sound ("zombie/z_hit.wav");    // Axe
 };
 
 float() crandom =
@@ -48,6 +49,8 @@
 
 	if (trace_ent.takedamage)
 	{
+		sound (self, CHAN_WEAPON, "zombie/z_hit.wav", 1, ATTN_NORM);
+		// Some sort of thunking sound ...
 		trace_ent.axhitme = 1;
 		SpawnBlood (org, '0 0 0', 20);
 		T_Damage (trace_ent, self, self, 20);
@@ -1152,6 +1155,269 @@
 	dprint ("quad cheat\n");
 };
 
+void() _monster_dog;
+void() _monster_army;
+void() _monster_shambler;
+void() _monster_demon1;
+void(string model, float health) ThrowGib;
+void() walkmonster_start_go;
+void() walkmonster_start;
+void() PetMove;
+
+/*
+  RemovePet relinks the petlist for self by removing the links for 
+  entity e
+  Note:  It does not remove the pet itself; this is left up to the calling program
+*/
+void(entity e) RemovePet =
+{
+local entity current;
+
+if (!e.pet)
+	return;
+current = e.pet;
+while (current.petlist)
+{
+	if (current.petlist == e)
+	{
+		current.petlist = e.petlist;
+		return;
+	}
+	current = current.petlist;
+}
+};
+/*
+  KillPets -- by J. Faske
+  Sometimes a pet is so dumb, euthanasia is the only way to go.
+  This routine gibs all your current pets
+  Note: this does not remove the petlist entity, it is removed by 
+	the th_die routine for the monster
+*/
+void() KillPets =
+{
+	local entity oldpet, tmppet;
+	if (!self.petlist)
+	{
+		sprint(self,"Sorry, you have no pets.\n");
+		return;
+	}
+	oldpet = self.petlist;
+	while (oldpet)
+	{
+//              oldpet.health = -100 ;
+//              oldpet.think = oldpet.th_die;
+//              oldpet.nextthink = time + random()*0.5;
+		tmppet = oldpet;
+		oldpet = oldpet.petlist;
+		T_Damage(tmppet,self,self,300);
+	}
+};
+/*
+  FindMonster -- added by J. Faske
+  This routine finds the nearest enemy monster to you.  By the way, it will 
+  find corpses too.  The monster must be in front of you and in direct sight.
+*/
+
+entity() FindMonster =
+{
+	local entity head, selected;
+	local float dist;
+	dist = 10000;
+	selected = world;
+	head = findradius(self.origin, 10000);
+	while(head)
+	{
+	  if( (head.health > 1) && (head != self) && (head != self.owner) && !( (teamplay == 1) && (head.team > 0)&&(head.team == self.owner.team) ) && (head.classname != "door") && (head.classname != "misc_explobox") && !(head.items & IT_INVISIBILITY) && (head.pet != self))
+		 {
+
+			traceline(self.origin,head.origin,TRUE,self);
+			if ( (trace_fraction >= 1) && (vlen(head.origin - self.origin) < dist) && (infront(head)))
+			{
+				selected = head;
+				dist = vlen(head.origin - self.origin);
+			}
+		}
+		head = head.chain;
+	}
+
+	return selected;
+};
+/*
+  FindDead -- Added by J. Faske
+  This routine finds the nearest dead corpse that is a Dog, a Grunt, a
+  Fiend (demon) or a Shambler (cool having a pet Shambler, don't ya think?)
+  Note: you must save your current health before this is run because it
+  deducts the penalty from it automatically.  If you do not have enough
+  health, too bad, no pet.
+*/
+entity() FindDead =
+{
+	local entity head, selected;
+	local float dist, temp, hlth;
+	
+	hlth = 0;
+	dist = 1000;
+	selected = world;
+	head = findradius(self.origin, 200);
+	while(head)
+	{
+	  temp = 0;
+	  if ((head.classname == "dog_corpse")&&(self.health > 25))
+		temp = 25;
+	  if ((head.classname == "army_corpse")&&(self.health > 50))
+		temp = 50;
+	  if ((head.classname == "demon1_corpse")&&(self.health > 90))
+		temp = 90;
+	  if ((head.classname == "shambler_corpse")&&(self.health > 99))
+		temp = 99;
+	  if (temp!=0)
+		 {
+			traceline(self.origin,head.origin,TRUE,self);
+			if ( (trace_fraction >= 1) && (vlen(head.origin - self.origin) < dist) && (infront(head)))
+			{
+				selected = head;
+				dist = vlen(head.origin - self.origin);
+				hlth = temp;
+			}
+		}
+		head = head.chain;
+	}
+	self.health = self.health - hlth;
+	return selected;
+};
+/*
+  Resurrect -- added by J. Faske
+  This routine resurrects the entity f into the owner's pet.
+*/
+void(vector org) spawn_tfog;
+void(entity f) Resurrect =
+{
+	local entity myself;
+
+	player_addpet(f);
+	f.touch=PetMove;
+	f.pet=f.enemy=f.movetarget=f.goalentity=self;
+	f.angles=self.angles;
+	f.owner=world;
+	f.flags=f.flags|FL_MONSTER;
+	myself = self;
+	self = f;
+	spawn_tfog (self.origin);
+	if(f.classname == "dog_corpse"){
+		f.classname = "monster_dog";
+		f.origin = f.origin + '0 0 41';
+		//setorigin (self, self.origin + '0 0 91');
+		_monster_dog();
+	} else if(f.classname == "army_corpse") {
+		f.classname = "monster_army";
+		f.origin = f.origin + '0 0 41';
+		//setorigin (self, self.origin + '0 0 91');
+		_monster_army();
+	} else if(f.classname == "demon1_corpse") {
+		f.classname = "monster_demon1";
+		f.origin = f.origin + '0 0 64';
+		_monster_demon1();
+	} else if (f.classname == "shambler_corpse") {
+		f.classname = "monster_shambler";
+		f.origin = f.origin + '0 0 64';
+		_monster_shambler();
+	}
+	else
+	{
+		self = myself;
+		RemovePet(f);
+		return;
+	}
+	walkmonster_start_go();
+	sprint(myself,"You have a new pet ");
+	sprint(myself,self.classname);
+	sprint(myself,"\n");
+	FoundTarget();
+	self = myself;
+};
+
+/*
+  ResurrectPet -- Added by J. Faske
+  This routine resurrects the closest corpse into a pet.  You can then order
+  your pet to attack or come.
+*/
+void() ResurrectPet =
+{
+	local entity monster;
+	local float oldhlth, dodmg;
+	if (self.petlist)    //Sorry, only one pet per customer
+		return;
+	oldhlth = self.health;
+	monster = FindDead();
+	if (monster == world)
+	{
+		sprint(self,"No dead guys to resurrect as pets\n");
+		return;
+	}
+	dodmg = oldhlth - self.health;
+	self.health = oldhlth;
+	if(!(deathmatch || coop || (self.flags & FL_GODMODE)))
+		T_Damage(self,self,self,dodmg);
+	Resurrect(monster);
+};
+/*
+  GoMaul -- added by J. Faske
+  This routine tells your pet (we'll just call him Spot, ok?) to attack a
+  monster you are looking at.
+*/
+void() GoMaul =
+{
+local entity spot,monster,oldself;
+
+spot = self.petlist;
+if (!spot)
+{
+	sprint(self,"Damn that dog... he's run away again!\n");
+	return;
+}
+monster = FindMonster();
+if (monster == world)
+{
+	sprint(self, "Sorry Spot. There's no one to play with.\n");
+	return ;
+}
+sprint(self,"Spot! Attack the ");
+sprint(self,monster.classname);
+sprint(self,"\n");
+
+while (spot)
+{
+	spot.enemy = spot.movetarget=spot.goalentity=monster;
+	spot.think = FoundTarget;
+	spot.nextthink = time + 0.1;
+	spot = spot.petlist;
+}
+};
+/*
+  HereBoy -- added by J. Faske
+  This routine calls off the attack and has your pet return to you.
+*/
+void() HereBoy =
+{
+local entity spot,oldself;
+
+spot = self.petlist;
+if (!spot)
+{
+	sprint(self,"Damn that dog... he's run away again!\n");
+	return;
+}
+sprint(self,"Spot! Here boy!!\n");
+
+while (spot)
+{
+	spot.enemy = spot.movetarget=spot.goalentity=self;
+	spot.nextthink = time + 0.1;
+	spot.think = FoundTarget;
+	spot = spot.petlist;
+}
+};
+
 /*
 ============
 ImpulseCommands
@@ -1170,6 +1436,14 @@
 	if (self.impulse == 11)
 		ServerflagsCommand ();
 
+	if (self.impulse == 250)
+		ResurrectPet ();
+	if (self.impulse == 55)
+		KillPets ();
+	if (self.impulse == 56)
+		GoMaul ();
+	if (self.impulse == 57)
+		HereBoy ();
 	if (self.impulse == 255)
 		QuadCheat ();
 		
diff -urPBb ..\v101qc/wizard.qc diff/wizard.qc
--- ..\v101qc/wizard.qc	Wed Jul 24 23:51:24 1996
+++ diff/wizard.qc	Mon Aug 12 12:59:50 1996
@@ -331,7 +331,7 @@
 sound (self, CHAN_VOICE, "wizard/wdeath.wav", 1, ATTN_NORM);
 };
 void()	wiz_death2	=[	$death2,		wiz_death3	] {};
-void()	wiz_death3	=[	$death3,		wiz_death4	]{self.solid = SOLID_NOT;};
+void()	wiz_death3	=[	$death3,		wiz_death4	] {};
 void()	wiz_death4	=[	$death4,		wiz_death5	] {};
 void()	wiz_death5	=[	$death5,		wiz_death6	] {};
 void()	wiz_death6	=[	$death6,		wiz_death7	] {};
@@ -344,14 +344,18 @@
 	if (self.health < -40)
 	{
 		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
-		ThrowHead ("progs/h_wizard.mdl", self.health);
-		ThrowGib ("progs/gib2.mdl", self.health);
-		ThrowGib ("progs/gib2.mdl", self.health);
-		ThrowGib ("progs/gib2.mdl", self.health);
+//		ThrowHead ("progs/h_wizard.mdl", self.health);
+//		ThrowGib ("progs/gib2.mdl", self.health);
+//		ThrowGib ("progs/gib2.mdl", self.health);
+//		ThrowGib ("progs/gib2.mdl", self.health);
+		monster_gib("progs/h_wizard.mdl");
+		sound(self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
 		return;
 	}
 
 	wiz_death1 ();
+      self.health=135;
+	monster_corpse_setup('-16 -16 -24', '16 16 -10', "progs/h_wizard.mdl");
 };
 
 
diff -urPBb ..\v101qc/world.qc diff/world.qc
--- ..\v101qc/world.qc	Wed Jul 24 23:51:24 1996
+++ diff/world.qc	Mon Aug 12 12:59:52 1996
@@ -190,6 +190,64 @@
 	precache_sound ("misc/h2ohit1.wav");		// landing splash
 
 // setup precaches allways needed
+
+// Dog stuff
+	precache_model ("progs/h_dog.mdl");
+	precache_model ("progs/dog.mdl");
+
+	precache_sound ("dog/dattack1.wav");
+	precache_sound ("dog/ddeath.wav");
+	precache_sound ("dog/dpain1.wav");
+	precache_sound ("dog/dsight.wav");
+	precache_sound ("dog/idle.wav");
+// End dog stuff 
+
+// Soldier stuff
+	precache_model ("progs/soldier.mdl");
+	precache_model ("progs/h_guard.mdl");
+	precache_model ("progs/gib1.mdl");
+	precache_model ("progs/gib2.mdl");
+	precache_model ("progs/gib3.mdl");
+
+	precache_sound ("soldier/death1.wav");
+	precache_sound ("soldier/idle.wav");
+	precache_sound ("soldier/pain1.wav");
+	precache_sound ("soldier/pain2.wav");
+	precache_sound ("soldier/sattck1.wav");
+	precache_sound ("soldier/sight1.wav");
+
+	precache_sound ("player/udeath.wav");		// gib death
+// End of soldier stuff
+
+// Demon stuff
+	precache_model ("progs/demon.mdl");
+	precache_model ("progs/h_demon.mdl");
+
+	precache_sound ("demon/ddeath.wav");
+	precache_sound ("demon/dhit2.wav");
+	precache_sound ("demon/djump.wav");
+	precache_sound ("demon/dpain1.wav");
+	precache_sound ("demon/idle1.wav");
+	precache_sound ("demon/sight2.wav");
+// End of demon
+
+// Shambler
+	precache_model ("progs/shambler.mdl");
+	precache_model ("progs/s_light.mdl");
+	precache_model ("progs/h_shams.mdl");
+	precache_model ("progs/bolt.mdl");
+	
+	precache_sound ("shambler/sattck1.wav");
+	precache_sound ("shambler/sboom.wav");
+	precache_sound ("shambler/sdeath.wav");
+	precache_sound ("shambler/shurt2.wav");
+	precache_sound ("shambler/sidle.wav");
+	precache_sound ("shambler/ssight.wav");
+	precache_sound ("shambler/melee1.wav");
+	precache_sound ("shambler/melee2.wav");
+	precache_sound ("shambler/smack.wav");
+// End of shambler
+
 	precache_sound ("items/itembk2.wav");		// item respawn sound
 	precache_sound ("player/plyrjmp8.wav");		// player jump
 	precache_sound ("player/land.wav");			// player landing
