PROGRAM Threads;

{****************************************************************************
*                                                                           *
*                Speed-386 Sample program "Threads"                         *
*                                                                           *
*           (C) 1993,94 Rene Nrnberger. All rights reserved.               *
*                                                                           *
*                                                                           *
*  This sample program starts two threads which are executed simultaneously *
*                                                                           *
*  This file can be compiled in text or graphic mode.                       *
*  Select target with options/linker                                        *
*                                                                           *
****************************************************************************}


USES BseDos;  {Bind base OS/2 API functions}

PROCEDURE ThreadFunction1(l : LongWord);CDECL;
VAR
  q : Integer;
BEGIN
  FOR q := 1 TO l DO
  BEGIN
    {Give other threads the chance to execute...}
    DosSleep(100);
    {Put out a simple text}
    WriteLn('Thread function 1 currently executing.');
  END;
END;

PROCEDURE ThreadFunction2(l : LongWord);CDECL;
VAR
  q : Integer;
BEGIN
  FOR q := 1 TO l DO
  BEGIN
    {Give other threads the chance to execute...}
    DosSleep(100);
    {Put out a simple text}
    WriteLn('Thread function 2 currently executing.');
  END;
END;


VAR
  firstThreadID,
  secondThreadID : TID;
  result:LONG;

BEGIN
  WriteLn('Executing main thread.');

  {Create the first Thread}
  DosCreateThread(FirstThreadID,@ThreadFunction1,POINTER(1000),0,32768);

  {Create the second thread}
  DosCreateThread(SecondThreadID,@ThreadFunction2,POINTER(1000),0,32768);

  {Wait a while...}
  DosSleep(5000);

  {When calling DosKillThread extrem care is recommended}
  result:=1;
  {We try to kill thread 1 until it is no longer busy}
  WHILE result<>0 DO result:=DosKillThread(FirstThreadID);

  {When calling DosKillThread extrem care is recommended}
  result:=1;
  {We try to kill thread 2 until it is no longer busy}
  WHILE result<>0 DO result:=DosKillThread(SecondThreadID);

  {Beep to indicate end of the two threads}
  beep(1300,400);
  {Wait a while...}
  DosSleep(100);
  {Clear the screen}
  ClrScr;
  Writeln('The two threads were killed !');
  {That's all !}
  Writeln('The end');
  readkey;
END.
