PROGRAM Steps08;

{***************************************************************************
 *                                                                         *
 *  OPML Steps program                                                     *
 *                                                                         *
 * The STEPXX programs showing PM programming step by step                 *
 *                                                                         *
 * This program simply opens a PM window by using OPML                     *
 *                                                                         *
 * This program allows the user to select a line width via the menu bar.   *
 *                                                                         *
 ***************************************************************************}


USES PmWin,PmGPI,PmStdDlg,ObjectPM,ODialogs;

{$r steps08}

CONST
     {Menu bar message ids}
     CM_PENWIDTH  =1;
     CM_PENCOLOR  =2;


TYPE
    TMyApplication=OBJECT(TApplication)
                        PROCEDURE InitMainWindow;VIRTUAL;
                   END;

    PDesktopWindow=^TDesktopWindow;
    TDesktopWindow=OBJECT(TWindow)
                         LButtonDown:BOOLEAN;
                         DragPS:HPS;
                         PenWidth:LONGWORD;

                         CONSTRUCTOR Init(AParent:PWindowsObject;
                                          ATitle:STRING);
                         PROCEDURE WMButton1Down(VAR Msg:TMessage);
                             VIRTUAL WM_FIRST+WM_BUTTON1DOWN;
                         PROCEDURE WMButton1Up(VAR Msg:TMessage);
                             VIRTUAL WM_FIRST+WM_BUTTON1UP;
                         PROCEDURE WMButton2Down(VAR Msg:TMessage);
                             VIRTUAL WM_FIRST+WM_BUTTON2DOWN;
                         PROCEDURE WMMouseMove(VAR Msg:TMessage);
                             VIRTUAL WM_FIRST+WM_MOUSEMOVE;
                   END;

    PStepWindow=^TStepWindow;
    TStepWindow=OBJECT(TWindow)
                  DrawArea:PDesktopWindow;
                  FUNCTION InitializeDesktop(ParentWin:PWindowsObject):
                                         PWindow;VIRTUAL;

                  PROCEDURE CMNew(VAR Msg:TMessage);
                             VIRTUAL CM_FIRST+CM_NEW;
                  PROCEDURE CMOpen(VAR Msg:TMessage);
                             VIRTUAL CM_FIRST+CM_OPEN;
                  PROCEDURE CMSave(VAR Msg:TMessage);
                             VIRTUAL CM_FIRST+CM_SAVE;
                  PROCEDURE CMSaveAs(VAR Msg:TMessage);
                             VIRTUAL CM_FIRST+CM_SAVEAS;
                  PROCEDURE CMPenWidth(VAR Msg:TMessage);
                             VIRTUAL CM_USER+CM_PENWIDTH;
                  PROCEDURE CMPenColor(VAR Msg:TMessage);
                             VIRTUAL CM_USER+CM_PENCOLOR;
                END;

    TPenWidthDialog=OBJECT(TDialog)
                         PROCEDURE WMInitDlg(VAR Msg:TMessage);
                               VIRTUAL WM_FIRST+WM_INITDLG;
                         PROCEDURE CMOk(VAR Msg:TMessage);
                               VIRTUAL CM_FIRST+CM_OK;
                    END;

{***************************************************************************
 *                                                                         *
 *   Object TPenWidthDialog                                                *
 *                                                                         *
 *                                                                         *
 ***************************************************************************}

VAR TempPenWidth:WORD;

PROCEDURE TPenWidthDialog.WMInitDlg(VAR Msg:TMessage);
VAR
   Dlg:HWND;
BEGIN
     Inherited.WMInitDlg(Msg);
     Dlg:=Msg.Receiver;
     CASE TempPenWidth OF
        1:SetRadioButtonState(Dlg,100,1);
        ELSE SetRadioButtonState(Dlg,101,1);
     END; {case}
END;

PROCEDURE TPenWidthDialog.CMOk(VAR Msg:TMessage);
VAR
   Dlg:HWND;
BEGIN
     Dlg:=Msg.Receiver;
     IF GetRadioButtonState(Dlg,100)<>0 THEN TempPenWidth:=1
     ELSE TempPenWidth:=2;
END;

{**************************************************************************
 *                                                                        *
 *                                                                        *
 * Object TDesktopWindow                                                  *
 *                                                                        *
 *                                                                        *
 **************************************************************************}

CONSTRUCTOR TDesktopWindow.Init(AParent:PWindowsObject;ATitle:STRING);
BEGIN
     Inherited.Init(AParent,ATitle);
     PenWidth:=LINEWIDTH_NORMAL;
END;

PROCEDURE TDesktopWindow.WMButton1Down(VAR Msg:TMessage);
VAR
   ahps:HPS;
   pts:POINTS;
   pt:POINTL;
   s:STRING;
BEGIN
     Inherited.WMButton1Down(Msg);
     LButtonDown:=TRUE;
     DragPS:=WinGetPS(HWindow);
     pts:=POINTS(Msg.Param1);
     pt.x:=pts.x;
     pt.y:=pts.y;
     GpiMove(DragPS,pt);
     GpiSetLineWidth(DragPS,PenWidth);
     Capture(FALSE);
END;

PROCEDURE TDesktopWindow.WMButton1Up(VAR Msg:TMessage);
BEGIN
     Inherited.WMButton1Up(Msg);
     IF LButtonDown THEN
     BEGIN
          LButtonDown:=FALSE;
          WinReleasePS(DragPS);
          Capture(TRUE);
     END;
END;

PROCEDURE TDesktopWindow.WMButton2Down(VAR Msg:TMessage);
BEGIN
     Inherited.WMButton2Down(Msg);
     WinInvalidateRect(HWindow,NIL,TRUE);
END;

PROCEDURE TDesktopWindow.WMMouseMove(VAR Msg:TMessage);
VAR
   pts:POINTS;
   pt:POINTL;
BEGIN
     IF LButtonDown THEN
     BEGIN
          pts:=POINTS(Msg.Param1);
          pt.x:=pts.x;
          pt.y:=pts.y;
          GpiLine(DragPS,pt);
     END;
END;

{**************************************************************************
 *                                                                        *
 *                                                                        *
 * Object TStepWindow                                                     *
 *                                                                        *
 *                                                                        *
 **************************************************************************}


FUNCTION TStepWindow.InitializeDesktop(ParentWin:PWindowsObject):PWindow;
VAR
   Desktop:PWindow;
BEGIN
     Desktop:=New(PDesktopWindow,Init(ParentWin,''));
     DrawArea:=Desktop;
     InitializeDesktop:=Desktop;
END;

PROCEDURE TStepWindow.CMNew(VAR Msg:TMessage);
BEGIN
     MessageBox('Menu Bar Message Dispatched','Feature not implemented !');
END;

PROCEDURE TStepWindow.CMOpen(VAR Msg:TMessage);
BEGIN
     MessageBox('Menu Bar Message Dispatched','Feature not implemented !');
END;

PROCEDURE TStepWindow.CMSave(VAR Msg:TMessage);
BEGIN
     MessageBox('Menu Bar Message Dispatched','Feature not implemented !');
END;

PROCEDURE TStepWindow.CMSaveAs(VAR Msg:TMessage);
BEGIN
     MessageBox('Menu Bar Message Dispatched','Feature not implemented !');
END;

PROCEDURE TStepWindow.CMPenWidth(VAR Msg:TMessage);
VAR
   PenWidthDlg:TPenWidthDialog;
   r:LONGWORD;
BEGIN
     CASE DrawArea^.PenWidth OF
        LINEWIDTH_NORMAL:TempPenWidth:=1;
        ELSE TempPenWidth:=2;
     END; {case}
     PenWidthDlg.Init(1,Application^.MainWindow^.HWindowFrame,0,2000,NIL);
     r:=PenWidthDlg.ExecDialog;
     PenWidthDlg.Done;
     IF r=CM_FIRST+CM_OK THEN
     BEGIN
          CASE TempPenWidth OF
              1:DrawArea^.PenWidth:=LINEWIDTH_NORMAL;
              ELSE DrawArea^.PenWidth:=LINEWIDTH_THICK;
          END; {case}
     END;
END;

PROCEDURE TStepWindow.CMPenColor(VAR Msg:TMessage);
BEGIN
     MessageBox('Menu Bar Message Dispatched','Feature not implemented !');
END;


{**************************************************************************
 *                                                                        *
 *                                                                        *
 * Object TMyApplication                                                  *
 *                                                                        *
 *                                                                        *
 **************************************************************************}


PROCEDURE TMyApplication.InitMainWindow;
BEGIN
     MainWindow:=New(PStepWindow,Init(NIL,'Steps08'));
     MainWindow^.Attr.HasMenu:=TRUE;
     MainWindow^.Attr.ResourceID:=1000;
     MainWindow^.Attr.WindowID:=1000;
END;

VAR
    MyApp:TMyApplication;

{**************************************************************************
 *                                                                        *
 *                                                                        *
 * MAIN program                                                           *
 *                                                                        *
 *                                                                        *
 **************************************************************************}


BEGIN
     MyApp.Init('Steps08');
     MyApp.Run;
     MyApp.Done;
END.
