PROGRAM Steps04;

{***************************************************************************
 *                                                                         *
 *  OPML Steps program                                                     *
 *                                                                         *
 * The STEPXX programs showing PM programming step by step                 *
 *                                                                         *
 * This program simply opens a PM window by using OPML                     *
 *                                                                         *
 * Each time the user presses the left button, the actual mouse position   *
 * is displayed.                                                           *
 * Each time the user presses the right mouse button the window is cleared *
 * since the window doesnt know yet how to paint itself                    *
 *                                                                         *
 ***************************************************************************}


USES PmWin,PmGPI,ObjectPM;

TYPE
    TMyApplication=OBJECT(TApplication)
                        PROCEDURE InitMainWindow;VIRTUAL;
                   END;

    PStepWindow=^TStepWindow;
    TStepWindow=OBJECT(TWindow)
                  FUNCTION InitializeDesktop(ParentWin:PWindowsObject):
                                         PWindow;VIRTUAL;
                END;

    PDesktopWindow=^TDesktopWindow;
    TDesktopWindow=OBJECT(TWindow)
                         PROCEDURE WMButton1Down(VAR Msg:TMessage);
                             VIRTUAL WM_FIRST+WM_BUTTON1DOWN;
                         PROCEDURE WMButton2Down(VAR Msg:TMessage);
                             VIRTUAL WM_FIRST+WM_BUTTON2DOWN;
                   END;

{**************************************************************************
 *                                                                        *
 *                                                                        *
 * Object TDesktopWindow                                                  *
 *                                                                        *
 *                                                                        *
 **************************************************************************}

PROCEDURE TDesktopWindow.WMButton1Down(VAR Msg:TMessage);
VAR
   ahps:HPS;
   pts:POINTS;
   pt:POINTL;
   s:STRING;
BEGIN
     Inherited.WMButton1Down(Msg);
     ahps:=WinGetPS(HWindow);
     pts:=POINTS(Msg.Param1);
     s:='('+tostr(pts.x)+','+tostr(pts.y)+')';
     pt.x:=pts.x;
     pt.y:=pts.y;
     GpiCharStringAt(ahps,pt,length(s),s[1]);
     WinReleasePS(ahps);
END;

PROCEDURE TDesktopWindow.WMButton2Down(VAR Msg:TMessage);
BEGIN
     Inherited.WMButton2Down(Msg);
     WinInvalidateRect(HWindow,NIL,TRUE);
END;

{**************************************************************************
 *                                                                        *
 *                                                                        *
 * Object TStepWindow                                                     *
 *                                                                        *
 *                                                                        *
 **************************************************************************}


FUNCTION TStepWindow.InitializeDesktop(ParentWin:PWindowsObject):PWindow;
VAR
   Desktop:PWindow;
BEGIN
     Desktop:=New(PDesktopWindow,Init(ParentWin,''));
     InitializeDesktop:=Desktop;
END;

{**************************************************************************
 *                                                                        *
 *                                                                        *
 * Object TMyApplication                                                  *
 *                                                                        *
 *                                                                        *
 **************************************************************************}


PROCEDURE TMyApplication.InitMainWindow;
BEGIN
     MainWindow:=New(PStepWindow,Init(NIL,'Steps04'));
END;

VAR
    MyApp:TMyApplication;

{**************************************************************************
 *                                                                        *
 *                                                                        *
 * MAIN program                                                           *
 *                                                                        *
 *                                                                        *
 **************************************************************************}


BEGIN
     MyApp.Init('Steps04');
     MyApp.Run;
     MyApp.Done;
END.
