PROGRAM PMTool;


{***************************************************************************
*                                                                          *
*                Speed-Pascal/2 Sample program "PMTool"                    *
*                                                                          *
*           (C) 1993,94 Rene Nrnberger. All rights reserved.              *
*                                                                          *
*                                                                          *
*  This program can be used as a template for your own MDI                 *
*  Applications. It's equal to PmMDI but provides additionaly a Toolbar    *
*  and a Statusline.                                                       *
*                                                                          *
****************************************************************************}


USES ObjectPm,Crt,PmWin;    {bind Units used}


RESOURCE PMTOOL;  {bind external Resources}

TYPE
    TMyApp=OBJECT(TApplication)
                         CONSTRUCTOR Init(AName:STRING);
                         DESTRUCTOR Done; VIRTUAL;
                         PROCEDURE InitMainWindow;VIRTUAL;
                         PROCEDURE RunFailed(Code:BYTE);VIRTUAL;
            END;

     PMyWindow=^TMyWindow;
     TMyWindow=OBJECT(TWindow)
                 CONSTRUCTOR Init(AParent:PWindowsObject; ATitle:STRING);
                 DESTRUCTOR Done;VIRTUAL;
                 PROCEDURE SetupWindow;VIRTUAL;
                 PROCEDURE SetupMenu;VIRTUAL;

                 PROCEDURE CMNew(VAR Msg:TMessage);
                                     VIRTUAL CM_FIRST+CM_NEW;
               END;

{**************************************************************************
*                                                                         *
*  Object TMyWindow                                                       *
*                                                                         *
***************************************************************************}


CONSTRUCTOR TMyWindow.Init(AParent:PWindowsObject; ATitle:STRING);
BEGIN
     Inherited.Init(AParent,ATitle);
END;


DESTRUCTOR TMyWindow.Done;
BEGIN
     Inherited.Done;
END;

PROCEDURE TMyWindow.SetupWindow;
BEGIN
     Inherited.SetupWindow;
     WinBackColor:=CLR_DARKGRAY;
     CreateToolBar(30);
     ToolBarInsertButton(CM_FIRST+CM_NEW,2000,10,3,28,24);
     ToolBarInsertButton(CM_FIRST+CM_TILE,2001,45,3,28,24);
     ToolBarInsertButton(CM_FIRST+CM_CASCADE,2002,80,3,28,24);
     CreateStatusBar(30);
     StatusBarInsertItem(1,10,3,0,21,FALSE);
END;


PROCEDURE TMyWindow.SetupMenu;
BEGIN
     Inherited.SetupMenu;
     InsertMenuHelp(1,65535,'',-1);  {Default menu help}
     InsertMenuHelp(1,CM_FIRST+CM_NEW,'Create a new MDI child window',-1);
     InsertMenuHelp(1,CM_FIRST+CM_CLOSE,'Close the active MDI child window',-1);
     InsertMenuHelp(1,CM_FIRST+CM_CLOSEALL,'Close all MDI child windows',-1);
     InsertMenuHelp(1,CM_FIRST+CM_TILE,'Arrange MDI child windows by tiling',-1);
     InsertMenuHelp(1,CM_FIRST+CM_CASCADE,'Arrange MDI child windows by cascading',-1);
     InsertMenuHelp(1,CM_FIRST+CM_NEXT,'Display next MDI child window',-1);
END;

PROCEDURE TMyWindow.CMNew(VAR Msg:TMessage);
VAR
    Child:PWindow;
BEGIN
     Child:=New(PWindow,Init(Application^.MainWindow^.DesktopWin,
                'Child window'));
     Child^.WinBackColor:=CLR_WHITE;
     Child^.Create;
END;


{*************************************************************************
 *                                                                       *
 *   Object TMyApp                                                       *
 *                                                                       *
 *************************************************************************}

PROCEDURE TMyApp.InitMainWindow;
BEGIN
     Inherited.InitMainWindow;
     MainWindow:=New(PMyWindow,Init(NIL,ApplicationName));
     MainWindow^.Attr.HasMenu:=TRUE;
     MainWindow^.Attr.ResourceID:=1000;
     MainWindow^.Attr.WindowID:=1000;
END;

CONSTRUCTOR TMyApp.Init(AName:STRING);
VAR t:BYTE;
BEGIN
     Inherited.Init(AName);
END;


DESTRUCTOR TMyApp.Done;
BEGIN
     Inherited.Done;
END;

PROCEDURE TMyApp.RunFailed(Code:BYTE);
BEGIN
     ErrorBox(MB_ICONHAND,'Error',
        'Application failed to initialize program windows');
END;


VAR
   MyApp:TMyApp;

BEGIN
     MyApp.Init('SPEED-PMTool Demo Application');
     MyApp.Run;
     MyApp.Done;
END.

