PROGRAM PmMenus;

{***************************************************************************
*                                                                          *
*                Speed-Pascal/2 Sample program "PMMenus"                   *
*                                                                          *
*           (C) 1993,94 Rene Nrnberger. All rights reserved.              *
*                                                                          *
*                                                                          *
*  This program illustrates how to use Menus with Object-PM                *
*                                                                          *
*                                                                          *
****************************************************************************}



USES ObjectPm,Crt,PMWin;  {bind Units used}

RESOURCE PMMenus;     {bind External resources}

{define Menu commands}
CONST
     CM_ITEM1=1;
     CM_ITEM2=2;
     CM_ITEM3=3;
     CM_ITEM4=4;
     CM_SUBITEM1=5;
     CM_SUBITEM2=6;
     CM_SUBITEM3=7;
     CM_BITMAP1=8;
     CM_BITMAP2=9;
     CM_CHECKED=10;
     CM_HIGHLIGHTED=11;
     CM_DISABLED=12;


TYPE
     TMyApp=OBJECT(TApplication)
                          CONSTRUCTOR Init(AName:STRING);
                          DESTRUCTOR Done; VIRTUAL;
                          PROCEDURE InitMainWindow;VIRTUAL;
                          PROCEDURE RunFailed(Code:BYTE);VIRTUAL;
            END;

     PMyWindow=^TMyWindow;
     TMyWindow=OBJECT(TWindow)
                 CONSTRUCTOR Init(AParent:PWindowsObject; ATitle:STRING);
                 DESTRUCTOR Done;VIRTUAL;

                 PROCEDURE CMItem1(VAR Msg:TMessage);
                               VIRTUAL CM_USER+CM_ITEM1;
                 PROCEDURE CMItem2(VAR Msg:TMessage);
                               VIRTUAL CM_USER+CM_ITEM2;
                 PROCEDURE CMItem3(VAR Msg:TMessage);
                               VIRTUAL CM_USER+CM_ITEM3;
                 PROCEDURE CMItem4(VAR Msg:TMessage);
                               VIRTUAL CM_USER+CM_ITEM4;
                 PROCEDURE CMSubItem1(VAR Msg:TMessage);
                               VIRTUAL CM_USER+CM_SUBITEM1;
                 PROCEDURE CMSubItem2(VAR Msg:TMessage);
                               VIRTUAL CM_USER+CM_SUBITEM2;
                 PROCEDURE CMSubItem3(VAR Msg:TMessage);
                               VIRTUAL CM_USER+CM_SUBITEM3;
                 PROCEDURE CMBitmap1(VAR Msg:TMessage);
                               VIRTUAL CM_USER+CM_BITMAP1;
                 PROCEDURE CMBitmap2(VAR Msg:TMessage);
                               VIRTUAL CM_USER+CM_BITMAP2;
                 PROCEDURE CMChecked(VAR Msg:TMessage);
                               VIRTUAL CM_USER+CM_CHECKED;
                 PROCEDURE CMHighlighted(VAR Msg:TMessage);
                               VIRTUAL CM_USER+CM_HIGHLIGHTED;
                 PROCEDURE CMDisabled(VAR Msg:TMessage);
                               VIRTUAL CM_USER+CM_DISABLED;
               END;

VAR
   MyApp:TMyApp;

{*************************************************************************
 *                                                                       *
 *   Object TMyWindow                                                    *
 *                                                                       *
 *************************************************************************}

CONSTRUCTOR TMyWindow.Init(AParent:PWindowsObject; ATitle:STRING);
BEGIN
     Inherited.Init(AParent,ATitle);
END;

DESTRUCTOR TMyWindow.Done;
BEGIN
     Inherited.Done;
END;

PROCEDURE TMyWindow.CMItem1(VAR Msg:TMessage);
BEGIN
     MessageBox('Menu command','Item1 selected');
END;

PROCEDURE TMyWindow.CMItem2(VAR Msg:TMessage);
BEGIN
     MessageBox('Menu command','Item2 selected');
END;

PROCEDURE TMyWindow.CMItem3(VAR Msg:TMessage);
BEGIN
     MessageBox('Menu command','Item3 selected');
END;

PROCEDURE TMyWindow.CMItem4(VAR Msg:TMessage);
BEGIN
     MessageBox('Menu command','Item4 selected');
END;

PROCEDURE TMyWindow.CMSubItem1(VAR Msg:TMessage);
BEGIN
     MessageBox('Menu command','SubItem1 selected');
END;

PROCEDURE TMyWindow.CMSubItem2(VAR Msg:TMessage);
BEGIN
     MessageBox('Menu command','SubItem2 selected');
END;

PROCEDURE TMyWindow.CMSubItem3(VAR Msg:TMessage);
BEGIN
     MessageBox('Menu command','SubItem3 selected');
END;

PROCEDURE TMyWindow.CMBitmap1(VAR Msg:TMessage);
BEGIN
     MessageBox('Menu command','Bitmap1 selected');
END;

PROCEDURE TMyWindow.CMBitmap2(VAR Msg:TMessage);
BEGIN
     MessageBox('Menu command','Bitmap2 selected');
END;

PROCEDURE TMyWindow.CMChecked(VAR Msg:TMessage);
BEGIN
     MessageBox('Menu command','Checked entry selected');
END;

PROCEDURE TMyWindow.CMHighlighted(VAR Msg:TMessage);
BEGIN
     MessageBox('Menu command','Highlighted entry selected');
END;

PROCEDURE TMyWindow.CMDisabled(VAR Msg:TMessage);
BEGIN
     MessageBox('Menu command','disabled entry selected');  {cannot be}
END;


{*************************************************************************
 *                                                                       *
 *   Object TMyApp                                                       *
 *                                                                       *
 *************************************************************************}

PROCEDURE TMyApp.InitMainWindow;
BEGIN
     Inherited.InitMainWindow;
     MainWindow:=New(PMyWindow,Init(NIL,ApplicationName));
     MainWindow^.Attr.HasMenu:=TRUE;
     MainWindow^.Attr.HasIcon:=TRUE;
     MainWindow^.Attr.ResourceID:=1000;
     MainWindow^.Attr.WindowID:=1000;
END;


CONSTRUCTOR TMyApp.Init(AName:STRING);
BEGIN
     Inherited.Init(AName);
END;


DESTRUCTOR TMyApp.Done;
BEGIN
     Inherited.Done;
END;

PROCEDURE TMyApp.RunFailed(Code:BYTE);
BEGIN
     ErrorBox(MB_ICONHAND,'Error',
        'Application failed to initialize program windows');
END;

BEGIN
     MyApp.Init('SPEED-PMMenus Demo Application');
     MyApp.Run;
     MyApp.Done;
END.
