PROGRAM PMMdi;


{***************************************************************************
*                                                                          *
*                Speed-Pascal/2 Sample program "PMMdi"                     *
*                                                                          *
*           (C) 1993,94 Rene Nrnberger. All rights reserved.              *
*                                                                          *
*                                                                          *
*  This sample program can be used as a template for your own MDI          *
*  Applications !                                                          *
*                                                                          *
*                                                                          *
****************************************************************************}


USES ObjectPM,Crt,PmWin;    {bind Units used}


RESOURCE PMMDI;  {bind external Resources}

TYPE
    TMyApp=OBJECT(TApplication)
                         CONSTRUCTOR Init(AName:STRING);
                         DESTRUCTOR Done; VIRTUAL;
                         PROCEDURE InitMainWindow;VIRTUAL;
                         PROCEDURE RunFailed(Code:BYTE);VIRTUAL;
            END;

     PMyWindow=^TMyWindow;
     TMyWindow=OBJECT(TWindow)
                 CONSTRUCTOR Init(AParent:PWindowsObject; ATitle:STRING);
                 DESTRUCTOR Done;VIRTUAL;

                 PROCEDURE CMNew(VAR Msg:TMessage);
                                     VIRTUAL CM_FIRST+CM_NEW;
               END;

{**************************************************************************
*                                                                         *
*  Object TMyWindow                                                       *
*                                                                         *
***************************************************************************}


CONSTRUCTOR TMyWindow.Init(AParent:PWindowsObject; ATitle:STRING);
BEGIN
     Inherited.Init(AParent,ATitle);
END;


DESTRUCTOR TMyWindow.Done;
BEGIN
     Inherited.Done;
END;

PROCEDURE TMyWindow.CMNew(VAR Msg:TMessage);
VAR
    Child:PWindow;
BEGIN
     Child:=New(PWindow,Init(Application^.MainWindow^.DesktopWin,
                'Child window'));
     Child^.WinBackColor:=CLR_WHITE;
     Child^.Create;
END;


{*************************************************************************
 *                                                                       *
 *   Object TMyApp                                                       *
 *                                                                       *
 *************************************************************************}

PROCEDURE TMyApp.InitMainWindow;
BEGIN
     Inherited.InitMainWindow;
     MainWindow:=New(PMyWindow,Init(NIL,ApplicationName));
     MainWindow^.Attr.HasMenu:=TRUE;
     MainWindow^.Attr.ResourceID:=1000;
     MainWindow^.Attr.WindowID:=1000;
END;

CONSTRUCTOR TMyApp.Init(AName:STRING);
VAR t:BYTE;
BEGIN
     Inherited.Init(AName);
END;


DESTRUCTOR TMyApp.Done;
BEGIN
     Inherited.Done;
END;

PROCEDURE TMyApp.RunFailed(Code:BYTE);
BEGIN
     ErrorBox(MB_ICONHAND,'Error',
        'Application failed to initialize program windows');
END;


VAR
   MyApp:TMyApp;

BEGIN
     MyApp.Init('SPEED-PMMDI Demo Application');
     MyApp.Run;
     MyApp.Done;
END.
