PROGRAM Mdi;

{***********************************************************************************
 *                                                                                 *
 *                                                                                 *
 * Speed Pascal/2 Sample file showing how to create a multiple                     *
 * document application and subclass window procedures                             *
 *                                                                                 *
 *                                                                                 *
 ***********************************************************************************}

USES PMWin,PMGpi,Crt;

RESOURCE MDI;

VAR
   ahab:HAB;
   ahmq:HMQ;
   aqmsg:QMSG;
   hwndFrame,hwndClient,ActiveChild:HWND;
   hptr1,hptr2,hptr3,hptrClient:HPOINTER;

   OldMenuWndProc:FUNCTION (ahwnd:HWND;Msg:ULONG;mp1,mp2:MPARAM):MRESULT; CDECL;
   OldSysMenuWndProc:FUNCTION (ahwnd:HWND;Msg:ULONG;mp1,mp2:MPARAM):MRESULT; CDECL;
   OldTitleBarWndProc:FUNCTION (ahwnd:HWND;Msg:ULONG;mp1,mp2:MPARAM):MRESULT; CDECL;


CONST
   flFrameFlags:ULONG= FCF_TITLEBAR OR FCF_SYSMENU OR FCF_SIZEBORDER OR
                       FCF_ICON OR FCF_MINMAX OR FCF_MENU OR FCF_SHELLPOSITION
                       OR FCF_TASKLIST;
   flChildFrameFlags:ULONG=FCF_TITLEBAR OR FCF_SYSMENU OR FCF_NOBYTEALIGN OR
                           FCF_SIZEBORDER OR FCF_MINMAX;

   szClientClass:STRING='Client window';
   szChildClass:STRING='Child window';
   szTitle:STRING='MDI Application';

   NumChildren:BYTE=0;


//Creation of a Child window
PROCEDURE CreateChildWindow(Parent:HWND);
VAR
   hwndChild,hwndChildFrame:HWND;
   szTitle:STRING;
   x,y:WORD;
BEGIN
     hwndChildFrame:=WinCreateStdWindow(Parent,0,flChildFrameFlags,szChildClass,
                                        '',0,0,0,hwndChild);

     //Set the owner window
     WinSetOwner(hwndChild,hwndChildFrame);

     //Set the title
     szTitle:='Child window no '+tostr(NumChildren);
     WinSetWindowText(hwndChildFrame,szTitle);

     //Set position of the child window
     x:=10 + NumChildren*10;
     y:=10 + NumChildren*10;
     WinSetWindowPos(hwndChildFrame,0,x,y,250,250,
                     SWP_MOVE OR SWP_SHOW OR SWP_SIZE OR SWP_ACTIVATE);
END;


//Window Procedure for child window
FUNCTION ChildWndProc(ahwnd:HWND;Msg:ULONG;mp1,mp2:MPARAM):MRESULT; CDECL;
VAR
   ahps:HPS;
   rc:RECTL;
BEGIN
     CASE msg OF
         WM_CREATE:
         BEGIN
              inc(NumChildren);
              ChildWndProc:=0;
         END;
         WM_PAINT:
         BEGIN
              //Redraw contents of window
              ahps:=WinBeginPaint(ahwnd,0,NIL);
              WinQueryWindowRect(ahwnd,rc);
              WinFillRect(ahps,rc,CLR_BLUE);
              WinEndPaint(ahps);
              ChildWndProc:=0;
         END;
         WM_ACTIVATE:
         BEGIN
              ActiveChild:=ahwnd;
              ChildWndProc:=0;
         END;
         WM_CLOSE:
         BEGIN
              WinDestroyWindow(WinQueryWindow(ahwnd,QW_PARENT));
              ChildWndProc:=0;
         END;
         WM_DESTROY:
         BEGIN
              dec(NumChildren);
              IF NumChildren=0 THEN ActiveChild:=0;
              ChildWndProc:=0;
         END;
         ELSE ChildWndProc:=WinDefWindowProc(ahwnd,msg,mp1,mp2);
     END; {case}
END;

//Window Procedure for main window
FUNCTION ClientWndProc(ahwnd:HWND;Msg:ULONG;mp1,mp2:MPARAM):MRESULT; CDECL;
VAR
   ahps:HPS;
   rc:RECTL;
BEGIN
     CASE msg OF
         WM_CREATE:
         BEGIN
              //Load mouse cursor pointers
              hptr1:=WinLoadPointer(HWND_DESKTOP,0,100);
              hptr2:=WinLoadPointer(HWND_DESKTOP,0,101);
              hptr3:=WinLoadPointer(HWND_DESKTOP,0,102);
              hptrClient:=WinLoadPointer(HWND_DESKTOP,0,103);
              ClientWndProc:=0;
         END;
         WM_MOUSEMOVE:
         BEGIN
              //Set Client mouse pointer
              WinSetPointer(HWND_DESKTOP,hptrClient);
              ClientWndProc:=0;
         END;
         WM_PAINT:
         BEGIN
              //Redraw contents of window
              ahps:=WinBeginPaint(ahwnd,0,NIL);
              WinQueryWindowRect(ahwnd,rc);
              WinFillRect(ahps,rc,CLR_YELLOW);
              WinEndPaint(ahps);
              ClientWndProc:=0;
         END;
         WM_COMMAND:
         BEGIN
              //Handle menubar messages
              CASE lo(mp1) OF
                  200: CreateChildWindow(ahwnd);
                  201: IF ActiveChild<>0 THEN
                           WinDestroyWindow(WinQueryWindow(ActiveChild,QW_PARENT));
                  202: WinPostMsg(ahwnd,WM_QUIT,0,0);
              END; {case}
              ClientWndProc:=0;
         END;
         WM_DESTROY:
         BEGIN
              //Destroy mouse cursor pointers
              WinDestroyPointer(hptr1);
              WinDestroyPointer(hptr2);
              WinDestroyPointer(hptr3);
              WinDestroyPointer(hptrClient);
              ClientWndProc:=0;
         END;
         ELSE ClientWndProc:=WinDefWindowProc(ahwnd,Msg,mp1,mp2);
     END; {case}
END;

//Window Procedure for subclassed menu
FUNCTION NewMenuWndProc(ahwnd:HWND;Msg:ULONG;mp1,mp2:MPARAM):MRESULT; CDECL;
BEGIN
     IF msg=WM_CONTROLPOINTER THEN NewMenuWndProc:=hptr3
     ELSE NewMenuWndProc:=OldMenuWndProc(ahwnd,msg,mp1,mp2);
END;

//Window Procedure for subclassed System menu
FUNCTION NewSysMenuWndProc(ahwnd:HWND;Msg:ULONG;mp1,mp2:MPARAM):MRESULT; CDECL;
BEGIN
     IF msg=WM_CONTROLPOINTER THEN NewSysMenuWndProc:=hptr2
     ELSE NewSysMenuWndProc:=OldSysMenuWndProc(ahwnd,msg,mp1,mp2);
END;

//Window Procedure for subclassed Titlebar
FUNCTION NewTitleBarWndProc(ahwnd:HWND;Msg:ULONG;mp1,mp2:MPARAM):MRESULT; CDECL;
BEGIN
     CASE msg OF
        WM_MOUSEMOVE:
        BEGIN
             WinSetPointer(HWND_DESKTOP,hptr1);
             NewTitleBarWndProc:=0;
        END;
        ELSE NewTitleBarWndProc:=OldTitleBarWndProc(ahwnd,msg,mp1,mp2);
     END; {case}
END;

BEGIN
     ahab:=WinInitialize(0);
     ahmq:=WinCreateMsgQueue(ahab,0);

     //Register main window class
     WinRegisterClass(ahab,szClientClass,@ClientWndProc,0,0);

     //Register child window class
     WinRegisterClass(ahab,szChildClass,@ChildWndProc,0,0);

     //Create main window
     hwndFrame:=WinCreateStdWindow(HWND_DESKTOP,0,flFrameFlags,szClientClass,
                                   szTitle,0,0,1000,hwndClient);

     //Subclass portions of the window
     OldMenuWndProc:=WinSubClassWindow(WinWindowFromID(hwndFrame,FID_MENU),
                                       @NewMenuWndProc);
     OldSysMenuWndProc:=WinSubClassWindow(WinWindowFromID(hwndFrame,FID_SYSMENU),
                                          @NewSysMenuWndProc);
     OldTitleBarWndProc:=WinSubClassWindow(WinWindowFromID(hwndFrame,FID_TITLEBAR),
                                           @NewTitleBarWndProc);

     WinShowWindow(hWndFrame,TRUE);

     WHILE WinGetMsg(ahab,aqmsg,0,0,0) DO WinDispatchMsg(ahab,aqmsg);

     WinDestroyWindow(hwndFrame);
     WinDestroyMsgQueue(ahmq);
     WinTerminate(ahab);
END.
