PROGRAM Hallo2;

{***************************************************************************
*                                                                          *
*                Speed-Pascal/2 Sample program "Hallo2"                    *
*                                                                          *
*           (C) 1993,94 Rene Nrnberger. All rights reserved.              *
*                                                                          *
*                                                                          *
*  This program extends the sample program "Hallo1" by a MenuBar           *
*                                                                          *
*                                                                          *
****************************************************************************}


USES Crt,PmWin;  {bind Units used}


{Bind external resources}
RESOURCE Hallo2;


CONST
    CM_MYABOUT=110;

VAR
    HalloClass:STRING; {Window-Class of the main window}
    WindowStyle:ULONG; {Style of the main window}
    Frame,Win:HWND;    {Handles of the main Window}
    Title:STRING;      {Title of the main window}
    _qmsg:QMSG;        {Message queue}


{Dialog procedure for the Dialog "About". Handles messages.
 Messages not processed will be given to the Standard Dialog-Procedure
 (WinDefDlgProc).
 This function must be CDECL because PM calls this in C-Manner}
FUNCTION DlgWinProc(Dlg:HWND;Msg:ULONG;Para1,Para2:ULONG):LONGWORD;CDECL;
VAR
    result:LONGWORD;
BEGIN
     result:=WinDefDlgProc(dlg,msg,Para1,Para2);
     DlgWinProc:=result;
END;

{Window procedure for the Window-Class "Hallo". Handles messages.
 Messages not processed will be given to the Standard Window-Procedure
 (WinDefWndProc).
 This function must be CDECL because PM calls this in C-Manner}
FUNCTION WindowProc(Win:HWND;Msg:ULONG;Para1,Para2:ULONG):POINTER;CDECL;
VAR Handled:BOOLEAN;
    result:ULONG;

    command:WORD;
    Dlg:HWND;
BEGIN
     Handled:=TRUE;
     result:=0;
     CASE Msg OF
         WM_ERASEBACKGROUND:result:=1;
         WM_CLOSE:WinPostMsg(Win,WM_QUIT,0,0);
         WM_COMMAND:
         BEGIN
              command:=WORD(para1);
              CASE command OF
                  CM_MYABOUT:
                  BEGIN
                        Dlg:=WinLoadDlg(HWND_DESKTOP,Frame,@DlgWinProc,0,2000,
                                        NIL);
                        WinProcessDlg(Dlg);
                        WinDestroyWindow(Dlg);
                  END;
                  ELSE Handled:=FALSE;
              END; {case}
         END;
         ELSE Handled:=FALSE;
     END; {Case}
     IF not Handled THEN result:=WinDefWindowProc(Win,Msg,Para1,Para2);
     WindowProc:=POINTER(result);
END;

BEGIN {Main}
     {register Window class}
     HalloClass:='Hallo';
     WinRegisterClass(AppHandle,Halloclass,@WindowProc,CS_SIZEREDRAW,0);

     {ddefine main window}
     WindowStyle:=FCF_TITLEBAR OR FCF_SYSMENU OR FCF_MINMAX OR FCF_TASKLIST
                  OR FCF_SIZEBORDER OR FCF_ICON OR FCF_MENU;
     Title:='Hallo2 Sample Application';
     Frame:=WinCreateStdWindow(HWND_DESKTOP,0,WindowStyle,HalloClass,
                               Title,0,0,1000,Win);

     {Set position and show main window}
     WinSetWindowPos(Frame,HWND_TOP,100,100,300,200,
                     SWP_SHOW OR SWP_ACTIVATE OR SWP_MOVE OR SWP_SIZE);

     {Handle message queue}
     WHILE WinGetMsg(AppHandle,_qmsg,0,0,0) DO
            WinDispatchMsg(AppHandle,_qmsg);

     {Destroy main window}
     WinDestroyWindow(Frame);
END.

