PROGRAM Hallo1;

{***************************************************************************
*                                                                          *
*                Speed-Pascal/2 Sample program "Hallo1"                    *
*                                                                          *
*           (C) 1993,94 Rene Nrnberger. All rights reserved.              *
*                                                                          *
*                                                                          *
*  This program puts out the text "Hrllo world" into a PM window.          *
*                                                                          *
*                                                                          *
****************************************************************************}


USES Crt,PmWin,PmGpi;  {bind Units used}


VAR
    HalloClass:STRING; {Window class for main window}
    pHalloClass:PChar;
    WindowStyle:ULONG; {Style of the main window}
    Frame,Win:HWND;    {Handles of the main window}
    Title:STRING;      {Title of the main window}
    _qmsg:QMSG;        {Message Queue}
    hdcClient:HDC;
    hpsClient:HPS;
    sizlMaxClient:SIZEL;
    hpsPaint:HPS;

    hrgnInvalid:HRGN;


{Window procedure for the Window-Class "Hallo". Handles messages.
 Messages not processed will be given to the Standard Window-Procedure
 (WinDefWndProc).
 This function must be CDECL because PM calls this in C-Manner}
FUNCTION WindowProc(Win:HWND;Msg:ULONG;Para1,Para2:ULONG):ULONG;CDECL;
VAR Handled:BOOLEAN;
    result:ULONG;
    _hps:HPS;
    rec:RECTL;
    point:POINTL;
    s:STRING;
BEGIN
     Handled:=TRUE;
     result:=0;
     CASE Msg OF
         WM_ERASEBACKGROUND:result:=1;
         WM_BUTTON1DOWN,WM_BUTTON1DBLCLK:
         BEGIN
              IF Win<>WinQueryFocus( HWND_DESKTOP) THEN
                WinSetFocus( HWND_DESKTOP, Win);
              WinSetCapture(HWND_DESKTOP,Win);
         END;
         WM_BUTTON1UP:
         BEGIN
              WinSetCapture(HWND_DESKTOP,0);
         END;
         WM_PAINT:
         BEGIN
              _hps:=WinBeginPaint(Win,0,rec);
              GpiSetBackColor(_hps,CLR_BACKGROUND);
              GpiSetColor(_hps,CLR_NEUTRAL);
              GpiSetBackMix(_hps,BM_OVERPAINT);
              point.x:=50;
              point.y:=100;
              s:='Hello my PM world...';
              GpiCharStringAt(_hps,point,length(s),s[1]);
              WinEndPaint(_hps);

         END;
         WM_CLOSE:WinPostMsg(Win,WM_QUIT,0,0);
         WM_MOUSEMOVE:beep(50,50);
         ELSE Handled:=FALSE;
     END; {Case}
     IF not Handled THEN result:=WinDefWindowProc(Win,Msg,Para1,Para2);
     WindowProc:=result;
END;

BEGIN {Main}
     {Initialize PM}
     WinShowPointer( HWND_DESKTOP, TRUE);

     {register Window-Class}
     HalloClass:='Hallo';
     WinRegisterClass(AppHandle,HalloClass,@WindowProc,CS_SIZEREDRAW,0);


     {define main application window}
     WindowStyle:=FCF_TITLEBAR OR FCF_SYSMENU OR FCF_MINMAX OR FCF_TASKLIST
                  OR FCF_SIZEBORDER;
      Title:='Hallo1 Sample Application';
     Frame:=WinCreateStdWindow(HWND_DESKTOP,0,WindowStyle,HalloClass,Title,
                               0,0,0,Win);

     {Set position and show main window}
     WinSetWindowPos(Frame,HWND_TOP,100,100,300,200,SWP_SHOW OR SWP_ACTIVATE
                     OR SWP_MOVE OR SWP_SIZE);

     sizlMaxClient.cx := WinQuerySysValue( HWND_DESKTOP, SV_CXFULLSCREEN);
     sizlMaxClient.cy := WinQuerySysValue( HWND_DESKTOP, SV_CYFULLSCREEN);

     hdcClient := WinOpenWindowDC(Win);
     hpsClient := GpiCreatePS( AppHandle,hdcClient, sizlMaxClient
                              , GPIA_ASSOC OR PU_PELS );

     hpsPaint := GpiCreatePS( AppHandle, NULLHANDLE, sizlMaxClient, PU_PELS);

     hrgnInvalid := GpiCreateRegion( hpsClient, 0, NIL);

     {Handle message queue}
     WHILE WinGetMsg(AppHandle,_qmsg,0,0,0) DO
       WinDispatchMsg(AppHandle,_qmsg);

     {Delete main window}
     WinDestroyWindow(Frame);
END.










