program Excpt;

{***************************************************************************
 *                                                                         *
 *  SPEED-PASCAL/2 Sample Program Excpt                                    *
 *                                                                         *
 *  This program demonstrates exception management from within a function  *
 *  to check the integity of a pointer argument                            *
 *                                                                         *
 ***************************************************************************}

USES BseExcpt,BseDos;

TYPE regrec=RECORD
                pnext:POINTER;
                pfnHandler:POINTER;
                jmpWorker:jmp_buf;
            END;


{The exception handler. Incoming exceptions will come here first}
FUNCTION Handler(VAR p1:EXCEPTIONREPORTRECORD;
                 VAR p2:REGREC;
                 VAR p3:CONTEXTRECORD;
                 pv:POINTER):ULONG;CDECL;
BEGIN
     {Jump to the label set by setjmp}
     longjmp(p2.jmpWorker,p1.ExceptionNum);
END;

FUNCTION WorkerFunction(pch:^BYTE):BYTE;
VAR aregrec:REGREC;
    ulException:ULONG;
    result:BYTE;
BEGIN
     {register the exception handler}
     aregrec.pfnHandler:=@Handler;
     DosSetExceptionHandler(EXCEPTIONREGISTRATIONRECORD(aregrec));
     ulException:=setjmp(aregrec.jmpWorker);
     {Check if we come from longjmp ???}
     IF ulException<>0 THEN
     BEGIN
          Writeln('Exception','Nr:'+tohex(ulException)+' occured');
          result:=0;  {return 0 to indicate failure}
     END
     ELSE
     BEGIN
          pch^:=1;    {Exception here if pointer invalid}
          result:=1;  {Return 1 to indicate that everything is ok}
     END;
     {Unset the exception handler}
     DosUnSetExceptionHandler(EXCEPTIONREGISTRATIONRECORD(aregrec));
     WorkerFunction:=result;  {Set function result}
END;

VAR pb:^BYTE;
    rc:BYTE;

BEGIN
     {Clear the screen}
     ClrScr;

     {Call with valid pointer --> everything ok}
     Writeln('Calling WorkerFunction with a valid argument');
     New(pb);
     rc:=WorkerFunction(pb);
     Writeln('WorkerFunction returned:',rc);

     {No call with NIL pointer --> Exception}
     Writeln('Calling WorkerFunction with an invalid argument');
     rc:=WorkerFunction(NIL);
     Writeln('WorkerFunction returned:',rc);

     Writeln('Excpt Sample program terminated');
     Writeln('Press any key...');
     readkey;
END.