PROGRAM Steps12;

{***************************************************************************
 *                                                                         *
 *  OPML Steps program                                                     *
 *                                                                         *
 * The STEPXX programs showing PM programming step by step                 *
 *                                                                         *
 * This program simply opens a PM window by using OPML                     *
 *                                                                         *
 * This program uses paths to draw the line - This makes thicker lines     *
 * possible since geometric lines are used instead of cosmetic ones.       *
 *                                                                         *
 ***************************************************************************}


USES Crt,PmWin,PmGPI,PmStdDlg,ObjectPM,ODialogs;

{$r steps12}

CONST
     {Menu bar message ids}
     CM_PENWIDTH  =1;
     CM_PENCOLOR  =2;

     {Pen width values}
     PEN_THIN     =1;
     PEN_MEDIUM   =4;
     PEN_THICK    =12;

TYPE
    TMyApplication=OBJECT(TApplication)
                        PROCEDURE InitMainWindow;VIRTUAL;
                   END;

    PPointList=^TPointList;
    TPointList=RECORD
                     Point:POINTL;
                     PenWidth:LONGWORD;
                     PenColor:LONGINT;
                     Nested:PPointList;
                     Next:PPointList;
               END;

    PDesktopWindow=^TDesktopWindow;
    TDesktopWindow=OBJECT(TWindow)
                         LButtonDown:BOOLEAN;
                         DragPS:HPS;
                         PenWidth:LONGWORD;
                         PenColor:LONGINT;
                         DrawingChanged:BOOLEAN;
                         PointList,LastPoint:PPointList;

                         PROCEDURE Redraw(VAR ahps:HPS;
                                          VAR rc:RECTL);VIRTUAL;

                         FUNCTION NewPoint(VAR List:PPointList;
                                           VAR pt:POINTL):PPointList;
                         PROCEDURE ClearPointList(VAR List:PPointList);

                         CONSTRUCTOR Init(AParent:PWindowsObject;
                                          ATitle:STRING);
                         PROCEDURE WMButton1Down(VAR Msg:TMessage);
                             VIRTUAL WM_FIRST+WM_BUTTON1DOWN;
                         PROCEDURE WMButton1Up(VAR Msg:TMessage);
                             VIRTUAL WM_FIRST+WM_BUTTON1UP;
                         PROCEDURE WMMouseMove(VAR Msg:TMessage);
                             VIRTUAL WM_FIRST+WM_MOUSEMOVE;
                   END;

    PStepWindow=^TStepWindow;
    TStepWindow=OBJECT(TWindow)
                  DrawArea:PDesktopWindow;
                  FUNCTION InitializeDesktop(ParentWin:PWindowsObject):
                                         PWindow;VIRTUAL;
                  FUNCTION CanClose:BOOLEAN;VIRTUAL;

                  PROCEDURE CMNew(VAR Msg:TMessage);
                             VIRTUAL CM_FIRST+CM_NEW;
                  PROCEDURE CMOpen(VAR Msg:TMessage);
                             VIRTUAL CM_FIRST+CM_OPEN;
                  PROCEDURE CMSave(VAR Msg:TMessage);
                             VIRTUAL CM_FIRST+CM_SAVE;
                  PROCEDURE CMSaveAs(VAR Msg:TMessage);
                             VIRTUAL CM_FIRST+CM_SAVEAS;
                  PROCEDURE CMPenWidth(VAR Msg:TMessage);
                             VIRTUAL CM_USER+CM_PENWIDTH;
                  PROCEDURE CMPenColor(VAR Msg:TMessage);
                             VIRTUAL CM_USER+CM_PENCOLOR;
                END;

    TPenWidthDialog=OBJECT(TDialog)
                         PROCEDURE WMInitDlg(VAR Msg:TMessage);
                               VIRTUAL WM_FIRST+WM_INITDLG;
                         PROCEDURE CMOk(VAR Msg:TMessage);
                               VIRTUAL CM_FIRST+CM_OK;
                    END;

    TPenColorDialog=OBJECT(TDialog)
                         PROCEDURE WMInitDlg(VAR Msg:TMessage);
                               VIRTUAL WM_FIRST+WM_INITDLG;
                         PROCEDURE CMOk(VAR Msg:TMessage);
                               VIRTUAL CM_FIRST+CM_OK;
                    END;


{***************************************************************************
 *                                                                         *
 *   Object TPenWidthDialog                                                *
 *                                                                         *
 *                                                                         *
 ***************************************************************************}

VAR TempPenWidth:WORD;

PROCEDURE TPenWidthDialog.WMInitDlg(VAR Msg:TMessage);
VAR
   Dlg:HWND;
BEGIN
     Inherited.WMInitDlg(Msg);
     Dlg:=Msg.Receiver;
     CASE TempPenWidth OF
        1:SetRadioButtonState(Dlg,100,1);
        2:SetRadioButtonState(Dlg,102,1);
        ELSE SetRadioButtonState(Dlg,101,1);
     END; {case}
END;

PROCEDURE TPenWidthDialog.CMOk(VAR Msg:TMessage);
VAR
   Dlg:HWND;
BEGIN
     Dlg:=Msg.Receiver;
     IF GetRadioButtonState(Dlg,100)<>0 THEN TempPenWidth:=1
     ELSE IF GetRadioButtonState(Dlg,102)<>0 THEN TempPenWidth:=2
          ELSE TempPenWidth:=3;
END;

{***************************************************************************
 *                                                                         *
 *   Object TPenColorDialog                                                *
 *                                                                         *
 *                                                                         *
 ***************************************************************************}

VAR TempPenColor:LONGINT;

PROCEDURE TPenColorDialog.WMInitDlg(VAR Msg:TMessage);
VAR
   Dlg:HWND;
   ValueSet:HWND;
   x,y:BYTE;
   c:INTEGER;
   ax,ay:BYTE;
BEGIN
     Inherited.WMInitDlg(Msg);
     Dlg:=Msg.Receiver;
     ValueSet:=WinWindowFromID(Dlg,100);
     c:=-1;
     ax:=1;
     ay:=1;
     FOR y:=1 TO 4 DO
       FOR x:=1 TO 4 DO
       BEGIN
           WinSendMsg(ValueSet,VM_SETITEM,(x SHL 16)+y,c);
           IF TempPenColor=c THEN
           BEGIN
                ax:=x;
                ay:=y;
           END;
           inc(c);  {Next color index}
       END;
     WinSendMsg(ValueSet,VM_SELECTITEM,(ax SHL 16)+ay,0);
END;

PROCEDURE TPenColorDialog.CMOk(VAR Msg:TMessage);
VAR
   Dlg:HWND;
   ValueSet:HWND;
   r:LONGWORD;
BEGIN
     Dlg:=Msg.Receiver;
     ValueSet:=WinWindowFromID(Dlg,100);
     r:=WinSendMsg(ValueSet,VM_QuerySelectedItem,0,0);
     TempPenColor:=WinSendMsg(ValueSet,VM_QueryItem,r,0);
END;


{**************************************************************************
 *                                                                        *
 *                                                                        *
 * Object TDesktopWindow                                                  *
 *                                                                        *
 *                                                                        *
 **************************************************************************}

CONSTRUCTOR TDesktopWindow.Init(AParent:PWindowsObject;ATitle:STRING);
BEGIN
     Inherited.Init(AParent,ATitle);
     PenWidth:=PEN_THIN;
     PenColor:=CLR_BLACK;
     DrawingChanged:=FALSE;
     PointList:=NIL;
END;


FUNCTION TDesktopWindow.NewPoint(VAR List:PPointList;VAR pt:POINTL):PPointList;
VAR
   dummy:PPointList;
BEGIN
     IF List=NIL THEN
     BEGIN
          New(List);
          dummy:=List;
     END
     ELSE
     BEGIN
          dummy:=List;
          WHILE dummy^.Next<>NIL DO dummy:=dummy^.Next;
          New(Dummy^.Next);
          dummy:=dummy^.Next;
     END;
     dummy^.Point:=pt;
     dummy^.PenWidth:=PenWidth;
     dummy^.PenColor:=PenColor;
     dummy^.Nested:=NIL;
     dummy^.Next:=NIL;
     NewPoint:=dummy;
END;


PROCEDURE TDesktopWindow.ClearPointList(VAR List:PPointList);
VAR
   dummy,next:PPointList;
BEGIN
     {Clear the point list}
     dummy:=List;
     WHILE dummy<>NIL DO
     BEGIN
          next:=dummy^.next;
          IF dummy^.nested<>NIL THEN ClearPointList(dummy^.nested);
          Dispose(dummy);
          dummy:=next;
     END;
     List:=NIL;
END;


PROCEDURE TDesktopWindow.WMButton1Down(VAR Msg:TMessage);
VAR
   ahps:HPS;
   pts:POINTS;
   pt:POINTL;
   s:STRING;
   lbnd:LINEBUNDLE;
BEGIN
     Inherited.WMButton1Down(Msg);
     LButtonDown:=TRUE;
     DrawingChanged:=TRUE;
     DragPS:=WinGetPS(HWindow);
     pts:=POINTS(Msg.Param1);
     pt.x:=pts.x;
     pt.y:=pts.y;
     GpiMove(DragPS,pt);
     LastPoint:=NewPoint(PointList,pt);

     GpiSetLineWidthGeom(DragPS,PenWidth);
     GpiSetLineJoin(DragPS,LINEJOIN_ROUND);
     GpiSetLineEnd(DragPS,LINEEND_ROUND);
     GpiSetColor(DragPS,PenColor);
     GpiBeginPath(DragPS,1);
     Capture(FALSE);
END;


PROCEDURE TDesktopWindow.WMButton1Up(VAR Msg:TMessage);
BEGIN
     Inherited.WMButton1Up(Msg);
     IF LButtonDown THEN
     BEGIN
          LButtonDown:=FALSE;
          GpiEndPath(DragPS);
          GpiStrokePath(DragPS,1,0);
          WinReleasePS(DragPS);
          Capture(TRUE);
     END;
END;

PROCEDURE TDesktopWindow.WMMouseMove(VAR Msg:TMessage);
VAR
   pts:POINTS;
   pt:POINTL;
BEGIN
     IF LButtonDown THEN
     BEGIN
          pts:=POINTS(Msg.Param1);
          pt.x:=pts.x;
          pt.y:=pts.y;
          GpiLine(DragPS,pt);
          GpiEndPath(DragPS);
          GpiStrokePath(DragPS,1,0);
          GpiBeginPath(DragPS,1);
          NewPoint(LastPoint^.Nested,pt);
          DrawingChanged:=TRUE;
     END;
END;

PROCEDURE TDesktopWindow.Redraw(VAR ahps:HPS;VAR rc:RECTL);
VAR
   DrawPS:HPS;
   dummy,nested:PPointList;
BEGIN
     DrawPS:=WinGetPS(HWindow);
     dummy:=PointList;

     WHILE dummy<>NIL DO
     BEGIN
          GpiSetLineWidthGeom(DrawPS,dummy^.PenWidth);
          GpiSetLineJoin(DrawPS,LINEJOIN_ROUND);
          GpiSetLineEnd(DrawPS,LINEEND_ROUND);
          GpiSetColor(DrawPS,dummy^.PenColor);
          GpiBeginPath(DrawPS,1);

          GpiMove(DrawPS,dummy^.Point);
          nested:=dummy^.nested;
          WHILE nested<>NIL DO
          BEGIN
               GpiLine(DrawPS,nested^.Point);
               nested:=nested^.next;
          END;

          GpiEndPath(DrawPS);
          GpiStrokePath(DrawPS,1,0);
          dummy:=dummy^.next;
     END;

     WinReleasePS(DrawPS);
END;

{**************************************************************************
 *                                                                        *
 *                                                                        *
 * Object TStepWindow                                                     *
 *                                                                        *
 *                                                                        *
 **************************************************************************}


FUNCTION TStepWindow.InitializeDesktop(ParentWin:PWindowsObject):PWindow;
VAR
   Desktop:PWindow;
BEGIN
     Desktop:=New(PDesktopWindow,Init(ParentWin,''));
     DrawArea:=Desktop;
     InitializeDesktop:=Desktop;
END;

FUNCTION TStepWindow.CanClose:BOOLEAN;
VAR
   msg,text:STRING;
   result:BOOLEAN;
   r:ULONG;
BEGIN
     result:=TRUE;
     IF DrawArea^.DrawingChanged THEN
     BEGIN
          msg:='Drawing has changed !';
          text:='Save drawing to file ?';
          r:=WinMessageBox(HWND_DESKTOP,HWND_DESKTOP,
                           text,msg,0,
                           MB_YESNOCANCEL OR MB_MOVEABLE OR MB_QUERY);
          CASE r OF
              MBID_YES:
              BEGIN
                  {Perfirm some action --> done later}
              END;
              MBID_CANCEL:result:=FALSE; {dont close window}
          END; {case}
     END;
     CanClose:=result;
END;

PROCEDURE TStepWindow.CMNew(VAR Msg:TMessage);
VAR
   dummy,next:PPointList;
BEGIN
     {Clear the point list}
     DrawArea^.ClearPointList(DrawArea^.PointList);
     {Invalidate Window and force repaint}
     DrawArea^.PenWidth:=PEN_THIN;
     DrawArea^.PenColor:=CLR_BLACK;
     DrawArea^.DrawingChanged:=FALSE;
     WinInvalidateRect(DesktopWin^.HWindow,NIL,TRUE);
END;

PROCEDURE TStepWindow.CMOpen(VAR Msg:TMessage);
BEGIN
     MessageBox('Menu Bar Message Dispatched','Feature not implemented !');
END;

PROCEDURE TStepWindow.CMSave(VAR Msg:TMessage);
BEGIN
     MessageBox('Menu Bar Message Dispatched','Feature not implemented !');
END;

PROCEDURE TStepWindow.CMSaveAs(VAR Msg:TMessage);
BEGIN
     MessageBox('Menu Bar Message Dispatched','Feature not implemented !');
END;

PROCEDURE TStepWindow.CMPenWidth(VAR Msg:TMessage);
VAR
   PenWidthDlg:TPenWidthDialog;
   r:LONGWORD;
BEGIN
     CASE DrawArea^.PenWidth OF
        PEN_THIN:TempPenWidth:=1;
        PEN_MEDIUM:TempPenWidth:=2;
        ELSE TempPenWidth:=3;
     END; {case}
     PenWidthDlg.Init(1,Application^.MainWindow^.HWindowFrame,0,2000,NIL);
     r:=PenWidthDlg.ExecDialog;
     PenWidthDlg.Done;
     IF r=CM_FIRST+CM_OK THEN
     BEGIN
          CASE TempPenWidth OF
              1:DrawArea^.PenWidth:=PEN_THIN;
              2:DrawArea^.PenWidth:=PEN_MEDIUM;
              ELSE DrawArea^.PenWidth:=PEN_THICK;
          END; {case}
     END;
END;

PROCEDURE TStepWindow.CMPenColor(VAR Msg:TMessage);
VAR
   PenColorDlg:TPenColorDialog;
   r:LONGWORD;
BEGIN
     TempPenColor:=DrawArea^.PenColor;
     PenColorDlg.Init(1,Application^.MainWindow^.HWindowFrame,0,2001,NIL);
     r:=PenColorDlg.ExecDialog;
     PenColorDlg.Done;
     IF r=CM_FIRST+CM_OK THEN DrawArea^.PenColor:=TempPenColor;
END;


{**************************************************************************
 *                                                                        *
 *                                                                        *
 * Object TMyApplication                                                  *
 *                                                                        *
 *                                                                        *
 **************************************************************************}


PROCEDURE TMyApplication.InitMainWindow;
BEGIN
     MainWindow:=New(PStepWindow,Init(NIL,'Steps12'));
     MainWindow^.Attr.HasMenu:=TRUE;
     MainWindow^.Attr.ResourceID:=1000;
     MainWindow^.Attr.WindowID:=1000;
END;

VAR
    MyApp:TMyApplication;

{**************************************************************************
 *                                                                        *
 *                                                                        *
 * MAIN program                                                           *
 *                                                                        *
 *                                                                        *
 **************************************************************************}


BEGIN
     MyApp.Init('Steps12');
     MyApp.Run;
     MyApp.Done;
END.
