PROGRAM Steps07;

{***************************************************************************
 *                                                                         *
 *  OPML Steps program                                                     *
 *                                                                         *
 * The STEPXX programs showing PM programming step by step                 *
 *                                                                         *
 * This program simply opens a PM window by using OPML                     *
 *                                                                         *
 * This program answers messages from the menu bar                         *
 *                                                                         *
 ***************************************************************************}


USES PmWin,PmGPI,ObjectPM;

{$r steps07}

CONST
     {Menu bar message ids}
     CM_PENWIDTH  =1;
     CM_PENCOLOR  =2;


TYPE
    TMyApplication=OBJECT(TApplication)
                        PROCEDURE InitMainWindow;VIRTUAL;
                   END;

    PDesktopWindow=^TDesktopWindow;
    TDesktopWindow=OBJECT(TWindow)
                         LButtonDown:BOOLEAN;
                         DragPS:HPS;
                         CONSTRUCTOR Init(AParent:PWindowsObject;
                                          ATitle:STRING);
                         PROCEDURE WMButton1Down(VAR Msg:TMessage);
                             VIRTUAL WM_FIRST+WM_BUTTON1DOWN;
                         PROCEDURE WMButton1Up(VAR Msg:TMessage);
                             VIRTUAL WM_FIRST+WM_BUTTON1UP;
                         PROCEDURE WMButton2Down(VAR Msg:TMessage);
                             VIRTUAL WM_FIRST+WM_BUTTON2DOWN;
                         PROCEDURE WMMouseMove(VAR Msg:TMessage);
                             VIRTUAL WM_FIRST+WM_MOUSEMOVE;
                   END;


    PStepWindow=^TStepWindow;
    TStepWindow=OBJECT(TWindow)
                  DrawArea:PDesktopWindow;
                  FUNCTION InitializeDesktop(ParentWin:PWindowsObject):
                                         PWindow;VIRTUAL;

                  PROCEDURE CMNew(VAR Msg:TMessage);
                             VIRTUAL CM_FIRST+CM_NEW;
                  PROCEDURE CMOpen(VAR Msg:TMessage);
                             VIRTUAL CM_FIRST+CM_OPEN;
                  PROCEDURE CMSave(VAR Msg:TMessage);
                             VIRTUAL CM_FIRST+CM_SAVE;
                  PROCEDURE CMSaveAs(VAR Msg:TMessage);
                             VIRTUAL CM_FIRST+CM_SAVEAS;
                  PROCEDURE CMPenWidth(VAR Msg:TMessage);
                             VIRTUAL CM_USER+CM_PENWIDTH;
                  PROCEDURE CMPenColor(VAR Msg:TMessage);
                             VIRTUAL CM_USER+CM_PENCOLOR;
                END;


{**************************************************************************
 *                                                                        *
 *                                                                        *
 * Object TDesktopWindow                                                  *
 *                                                                        *
 *                                                                        *
 **************************************************************************}

CONSTRUCTOR TDesktopWindow.Init(AParent:PWindowsObject;
                                ATitle:STRING);
BEGIN
     Inherited.Init(AParent,ATitle);
     LButtonDown:=FALSE;
END;

PROCEDURE TDesktopWindow.WMButton1Down(VAR Msg:TMessage);
VAR
   ahps:HPS;
   pts:POINTS;
   pt:POINTL;
   s:STRING;
BEGIN
     Inherited.WMButton1Down(Msg);
     LButtonDown:=TRUE;
     DragPS:=WinGetPS(HWindow);
     pts:=POINTS(Msg.Param1);
     pt.x:=pts.x;
     pt.y:=pts.y;
     GpiMove(DragPS,pt);
     Capture(FALSE);
END;

PROCEDURE TDesktopWindow.WMButton1Up(VAR Msg:TMessage);
BEGIN
     Inherited.WMButton1Up(Msg);
     IF LButtonDown THEN
     BEGIN
         LButtonDown:=FALSE;
         WinReleasePS(DragPS);
         Capture(TRUE);
     END;
END;

PROCEDURE TDesktopWindow.WMButton2Down(VAR Msg:TMessage);
BEGIN
     Inherited.WMButton2Down(Msg);
     WinInvalidateRect(HWindow,NIL,TRUE);
END;

PROCEDURE TDesktopWindow.WMMouseMove(VAR Msg:TMessage);
VAR
   pts:POINTS;
   pt:POINTL;
BEGIN
     IF LButtonDown THEN
     BEGIN
          pts:=POINTS(Msg.Param1);
          pt.x:=pts.x;
          pt.y:=pts.y;
          GpiLine(DragPS,pt);
     END;
END;

{**************************************************************************
 *                                                                        *
 *                                                                        *
 * Object TStepWindow                                                     *
 *                                                                        *
 *                                                                        *
 **************************************************************************}


FUNCTION TStepWindow.InitializeDesktop(ParentWin:PWindowsObject):PWindow;
VAR
   Desktop:PWindow;
BEGIN
     Desktop:=New(PDesktopWindow,Init(ParentWin,''));
     DrawArea:=Desktop;
     InitializeDesktop:=Desktop;
END;

PROCEDURE TStepWindow.CMNew(VAR Msg:TMessage);
BEGIN
     MessageBox('Menu Bar Message Dispatched','Feature not implemented !');
END;

PROCEDURE TStepWindow.CMOpen(VAR Msg:TMessage);
BEGIN
     MessageBox('Menu Bar Message Dispatched','Feature not implemented !');
END;

PROCEDURE TStepWindow.CMSave(VAR Msg:TMessage);
BEGIN
     MessageBox('Menu Bar Message Dispatched','Feature not implemented !');
END;

PROCEDURE TStepWindow.CMSaveAs(VAR Msg:TMessage);
BEGIN
     MessageBox('Menu Bar Message Dispatched','Feature not implemented !');
END;

PROCEDURE TStepWindow.CMPenWidth(VAR Msg:TMessage);
BEGIN
     MessageBox('Menu Bar Message Dispatched','Feature not implemented !');
END;

PROCEDURE TStepWindow.CMPenColor(VAR Msg:TMessage);
BEGIN
     MessageBox('Menu Bar Message Dispatched','Feature not implemented !');
END;


{**************************************************************************
 *                                                                        *
 *                                                                        *
 * Object TMyApplication                                                  *
 *                                                                        *
 *                                                                        *
 **************************************************************************}


PROCEDURE TMyApplication.InitMainWindow;
BEGIN
     MainWindow:=New(PStepWindow,Init(NIL,'Steps07'));
     MainWindow^.Attr.HasMenu:=TRUE;
     MainWindow^.Attr.ResourceID:=1000;
     MainWindow^.Attr.WindowID:=1000;
END;

VAR
    MyApp:TMyApplication;

{**************************************************************************
 *                                                                        *
 *                                                                        *
 * MAIN program                                                           *
 *                                                                        *
 *                                                                        *
 **************************************************************************}


BEGIN
     MyApp.Init('Steps07');
     MyApp.Run;
     MyApp.Done;
END.
