PROGRAM Steps06;

{***************************************************************************
 *                                                                         *
 *  OPML Steps program                                                     *
 *                                                                         *
 * The STEPXX programs showing PM programming step by step                 *
 *                                                                         *
 * This program simply opens a PM window by using OPML                     *
 *                                                                         *
 * This program adds a menu bar to the steps program                       *
 *                                                                         *
 ***************************************************************************}


USES PmWin,PmGPI,ObjectPM;

{$r steps06}

TYPE
    TMyApplication=OBJECT(TApplication)
                        PROCEDURE InitMainWindow;VIRTUAL;
                   END;

    PDesktopWindow=^TDesktopWindow;
    TDesktopWindow=OBJECT(TWindow)
                         LButtonDown:BOOLEAN;
                         DragPS:HPS;
                         CONSTRUCTOR Init(AParent:PWindowsObject;
                                          ATitle:STRING);

                         PROCEDURE WMButton1Down(VAR Msg:TMessage);
                             VIRTUAL WM_FIRST+WM_BUTTON1DOWN;
                         PROCEDURE WMButton1Up(VAR Msg:TMessage);
                             VIRTUAL WM_FIRST+WM_BUTTON1UP;
                         PROCEDURE WMButton2Down(VAR Msg:TMessage);
                             VIRTUAL WM_FIRST+WM_BUTTON2DOWN;
                         PROCEDURE WMMouseMove(VAR Msg:TMessage);
                             VIRTUAL WM_FIRST+WM_MOUSEMOVE;
                   END;

    PStepWindow=^TStepWindow;
    TStepWindow=OBJECT(TWindow)
                  DrawArea:PDesktopWindow;
                  FUNCTION InitializeDesktop(ParentWin:PWindowsObject):
                                         PWindow;VIRTUAL;
                END;



{**************************************************************************
 *                                                                        *
 *                                                                        *
 * Object TDesktopWindow                                                  *
 *                                                                        *
 *                                                                        *
 **************************************************************************}

CONSTRUCTOR TDesktopWindow.Init(AParent:PWindowsObject;
                                ATitle:STRING);
BEGIN
     Inherited.Init(AParent,ATitle);
     LButtonDown:=FALSE;
END;

PROCEDURE TDesktopWindow.WMButton1Down(VAR Msg:TMessage);
VAR
   ahps:HPS;
   pts:POINTS;
   pt:POINTL;
   s:STRING;
BEGIN
     Inherited.WMButton1Down(Msg);
     LButtonDown:=TRUE;
     DragPS:=WinGetPS(HWindow);
     pts:=POINTS(Msg.Param1);
     pt.x:=pts.x;
     pt.y:=pts.y;
     GpiMove(DragPS,pt);
     Capture(FALSE);
END;

PROCEDURE TDesktopWindow.WMButton1Up(VAR Msg:TMessage);
BEGIN
     Inherited.WMButton1Up(Msg);
     IF LButtonDown THEN
     BEGIN
          LButtonDown:=FALSE;
          WinReleasePS(DragPS);
          Capture(TRUE);
     END;
END;

PROCEDURE TDesktopWindow.WMButton2Down(VAR Msg:TMessage);
BEGIN
     Inherited.WMButton2Down(Msg);
     WinInvalidateRect(HWindow,NIL,TRUE);
END;

PROCEDURE TDesktopWindow.WMMouseMove(VAR Msg:TMessage);
VAR
   pts:POINTS;
   pt:POINTL;
BEGIN
     IF LButtonDown THEN
     BEGIN
          pts:=POINTS(Msg.Param1);
          pt.x:=pts.x;
          pt.y:=pts.y;
          GpiLine(DragPS,pt);
     END;
END;

{**************************************************************************
 *                                                                        *
 *                                                                        *
 * Object TStepWindow                                                     *
 *                                                                        *
 *                                                                        *
 **************************************************************************}


FUNCTION TStepWindow.InitializeDesktop(ParentWin:PWindowsObject):PWindow;
VAR
   Desktop:PWindow;
BEGIN
     Desktop:=New(PDesktopWindow,Init(ParentWin,''));
     DrawArea:=Desktop;
     InitializeDesktop:=Desktop;
END;

{**************************************************************************
 *                                                                        *
 *                                                                        *
 * Object TMyApplication                                                  *
 *                                                                        *
 *                                                                        *
 **************************************************************************}


PROCEDURE TMyApplication.InitMainWindow;
BEGIN
     MainWindow:=New(PStepWindow,Init(NIL,'Steps06'));
     MainWindow^.Attr.HasMenu:=TRUE;
     MainWindow^.Attr.ResourceID:=1000;
     MainWindow^.Attr.WindowID:=1000;
END;

VAR
    MyApp:TMyApplication;

{**************************************************************************
 *                                                                        *
 *                                                                        *
 * MAIN program                                                           *
 *                                                                        *
 *                                                                        *
 **************************************************************************}


BEGIN
     MyApp.Init('Steps06');
     MyApp.Run;
     MyApp.Done;
END.
