PROGRAM Steps05;

{***************************************************************************
 *                                                                         *
 *  OPML Steps program                                                     *
 *                                                                         *
 * The STEPXX programs showing PM programming step by step                 *
 *                                                                         *
 * This program simply opens a PM window by using OPML                     *
 *                                                                         *
 * Each time the user presses the left button, and then moves the mouse    *
 * a line is drawn as long as the left button is pressed.                  *
 * Each time the user presses the right mouse button the window is cleared *
 * since the window doesnt know yet how to paint itself                    *
 *                                                                         *
 ***************************************************************************}


USES PmWin,PmGPI,ObjectPM;

TYPE
    TMyApplication=OBJECT(TApplication)
                        PROCEDURE InitMainWindow;VIRTUAL;
                   END;

    PDesktopWindow=^TDesktopWindow;
    TDesktopWindow=OBJECT(TWindow)
                         LButtonDown:BOOLEAN;
                         DragPS:HPS;
                         CONSTRUCTOR Init(AParent:PWindowsObject;
                                          ATitle:STRING);


                         PROCEDURE WMButton1Down(VAR Msg:TMessage);
                             VIRTUAL WM_FIRST+WM_BUTTON1DOWN;
                         PROCEDURE WMButton1Up(VAR Msg:TMessage);
                             VIRTUAL WM_FIRST+WM_BUTTON1UP;
                         PROCEDURE WMButton2Down(VAR Msg:TMessage);
                             VIRTUAL WM_FIRST+WM_BUTTON2DOWN;
                         PROCEDURE WMMouseMove(VAR Msg:TMessage);
                             VIRTUAL WM_FIRST+WM_MOUSEMOVE;
                   END;

    PStepWindow=^TStepWindow;
    TStepWindow=OBJECT(TWindow)
                  DrawArea:PDesktopWindow;
                  FUNCTION InitializeDesktop(ParentWin:PWindowsObject):
                                         PWindow;VIRTUAL;
                END;



{**************************************************************************
 *                                                                        *
 *                                                                        *
 * Object TDesktopWindow                                                  *
 *                                                                        *
 *                                                                        *
 **************************************************************************}

CONSTRUCTOR TDesktopWindow.Init(AParent:PWindowsObject;
                                ATitle:STRING);
BEGIN
     Inherited.Init(AParent,ATitle);
     LButtonDown:=FALSE;
END;

PROCEDURE TDesktopWindow.WMButton1Down(VAR Msg:TMessage);
VAR
   ahps:HPS;
   pts:POINTS;
   pt:POINTL;
   s:STRING;
BEGIN
     Inherited.WMButton1Down(Msg);
     LButtonDown:=TRUE;
     DragPS:=WinGetPS(HWindow);
     pts:=POINTS(Msg.Param1);
     pt.x:=pts.x;
     pt.y:=pts.y;
     GpiMove(DragPS,pt);
     Capture(FALSE);
END;

PROCEDURE TDesktopWindow.WMButton1Up(VAR Msg:TMessage);
BEGIN
     Inherited.WMButton1Up(Msg);
     IF LButtonDown THEN
     BEGIN
          LButtonDown:=FALSE;
          WinReleasePS(DragPS);
          Capture(TRUE);
     END;
END;

PROCEDURE TDesktopWindow.WMButton2Down(VAR Msg:TMessage);
BEGIN
     Inherited.WMButton2Down(Msg);
     WinInvalidateRect(HWindow,NIL,TRUE);
END;

PROCEDURE TDesktopWindow.WMMouseMove(VAR Msg:TMessage);
VAR
   pts:POINTS;
   pt:POINTL;
BEGIN
     IF LButtonDown THEN
     BEGIN
          pts:=POINTS(Msg.Param1);
          pt.x:=pts.x;
          pt.y:=pts.y;
          GpiLine(DragPS,pt);
     END;
END;

{**************************************************************************
 *                                                                        *
 *                                                                        *
 * Object TStepWindow                                                     *
 *                                                                        *
 *                                                                        *
 **************************************************************************}


FUNCTION TStepWindow.InitializeDesktop(ParentWin:PWindowsObject):PWindow;
VAR
   Desktop:PWindow;
BEGIN
     Desktop:=New(PDesktopWindow,Init(ParentWin,''));
     DrawArea:=Desktop;
     InitializeDesktop:=Desktop;
END;

{**************************************************************************
 *                                                                        *
 *                                                                        *
 * Object TMyApplication                                                  *
 *                                                                        *
 *                                                                        *
 **************************************************************************}


PROCEDURE TMyApplication.InitMainWindow;
BEGIN
     MainWindow:=New(PStepWindow,Init(NIL,'Steps05'));
END;

VAR
    MyApp:TMyApplication;

{**************************************************************************
 *                                                                        *
 *                                                                        *
 * MAIN program                                                           *
 *                                                                        *
 *                                                                        *
 **************************************************************************}


BEGIN
     MyApp.Init('Steps05');
     MyApp.Run;
     MyApp.Done;
END.
