PROGRAM Steps03;

{***************************************************************************
 *                                                                         *
 *  OPML Steps program                                                     *
 *                                                                         *
 * The STEPXX programs showing PM programming step by step                 *
 *                                                                         *
 * This program simply opens a PM window by using OPML                     *
 * It uses a self defined object class TStepWindow instead of TWindow.     *
 * Each time the user presses the left or right mouse button a message     *
 * box appears.                                                            *
 * If the mouse is moved within the desktop area a short beep is generated *
 *                                                                         *
 ***************************************************************************}


USES PmWin,PmGPI,ObjectPM;

TYPE
    TMyApplication=OBJECT(TApplication)
                        PROCEDURE InitMainWindow;VIRTUAL;
                   END;

    PStepWindow=^TStepWindow;
    TStepWindow=OBJECT(TWindow)
                  FUNCTION InitializeDesktop(ParentWin:PWindowsObject):
                                         PWindow;VIRTUAL;
                END;

    PDesktopWindow=^TDesktopWindow;
    TDesktopWindow=OBJECT(TWindow)
                         PROCEDURE WMButton1Down(VAR Msg:TMessage);
                             VIRTUAL WM_FIRST+WM_BUTTON1DOWN;
                         PROCEDURE WMButton2Down(VAR Msg:TMessage);
                             VIRTUAL WM_FIRST+WM_BUTTON2DOWN;
                         PROCEDURE WMMouseMove(VAR Msg:TMessage);
                             VIRTUAL WM_FIRST+WM_MOUSEMOVE;
                   END;

{**************************************************************************
 *                                                                        *
 *                                                                        *
 * Object TDesktopWindow                                                  *
 *                                                                        *
 *                                                                        *
 **************************************************************************}

PROCEDURE TDesktopWindow.WMButton1Down(VAR Msg:TMessage);
BEGIN
     MessageBox('Message Dispatched','You have pressed the left mouse button !');
     Inherited.WMButton1Down(Msg);
END;

PROCEDURE TDesktopWindow.WMButton2Down(VAR Msg:TMessage);
BEGIN
     MessageBox('Message Dispatched','You have pressed the right mouse button !');
     Inherited.WMButton2Down(Msg);
END;

PROCEDURE TDesktopWindow.WMMouseMove(VAR Msg:TMessage);
BEGIN
     Beep(50,50);
END;

{**************************************************************************
 *                                                                        *
 *                                                                        *
 * Object TStepWindow                                                     *
 *                                                                        *
 *                                                                        *
 **************************************************************************}


FUNCTION TStepWindow.InitializeDesktop(ParentWin:PWindowsObject):PWindow;
VAR
   Desktop:PWindow;
BEGIN
     Desktop:=New(PDesktopWindow,Init(ParentWin,''));
     InitializeDesktop:=Desktop;
END;

{**************************************************************************
 *                                                                        *
 *                                                                        *
 * Object TMyApplication                                                  *
 *                                                                        *
 *                                                                        *
 **************************************************************************}


PROCEDURE TMyApplication.InitMainWindow;
BEGIN
     MainWindow:=New(PStepWindow,Init(NIL,'Steps03'));
END;

VAR
    MyApp:TMyApplication;

{**************************************************************************
 *                                                                        *
 *                                                                        *
 * MAIN program                                                           *
 *                                                                        *
 *                                                                        *
 **************************************************************************}


BEGIN
     MyApp.Init('Steps03');
     MyApp.Run;
     MyApp.Done;
END.
