PROGRAM PmEdit;

{***************************************************************************
*                                                                          *
*                Speed-Pascal/2 Sample program "PMEdit"                    *
*                                                                          *
*           (C) 1993,94 Rene Nrnberger. All rights reserved.              *
*                                                                          *
*                                                                          *
*  This program implements a small text-Editor which can be extended       *
*  easily (it's the same editor the IDE has)                               *
*                                                                          *
*                                                                          *
****************************************************************************}

{$m 128000}    {Set stack size}

USES ObjectPM,ODialogs,OEditors,Dos,Crt,PmWin;

RESOURCE PmEdit;

TYPE
    PMyEditorWindow=^TMyEditorWindow;
    TMyEditorWindow=OBJECT(TEditorWindow)
                         CONSTRUCTOR Init(AParent:PWindowsObject; ATitle,
                                      AFileName:STRING);
                         PROCEDURE   UpdateEditorStatus;VIRTUAL;
                         PROCEDURE   FindText(s:STRING;w:WORD);VIRTUAL;
                         PROCEDURE   ReplaceText(s,s1:STRING;w:WORD);VIRTUAL;

                         PROCEDURE   WMClose(VAR Msg:TMessage);
                                     VIRTUAL WM_FIRST+WM_CLOSE;
                    END;


    PMyWindow=^TMyWindow;
    TMyWindow=OBJECT(TWindow)
                 CONSTRUCTOR Init(AParent:PWindowsObject; ATitle:STRING);
                 DESTRUCTOR Done;VIRTUAL;
                 PROCEDURE SetupMenu;VIRTUAL;
                 PROCEDURE SetupWindow;VIRTUAL;

                 PROCEDURE NewFile(VAR Msg:TMessage);
                                   VIRTUAL CM_FIRST+CM_NEW;
                 PROCEDURE Open(VAR Msg:TMessage);
                                   VIRTUAL CM_FIRST+CM_OPEN;
                 PROCEDURE SaveAFileAs(VAR Msg:TMessage);
                                   VIRTUAL CM_FIRST+CM_SAVEAS;
                 PROCEDURE SaveAFile(VAR Msg:TMessage);
                                   VIRTUAL CM_FIRST+CM_SAVE;
                 PROCEDURE SaveAllFiles(VAR Msg:TMessage);
                                   VIRTUAL CM_FIRST+CM_SAVEALL;
                 PROCEDURE CMClose(VAR Msg:TMessage);
                                   VIRTUAL CM_FIRST+CM_CLOSE;
                 PROCEDURE AboutThis(VAR Msg:TMessage);
                                   VIRTUAL CM_FIRST+CM_ABOUT;
                 PROCEDURE Find(VAR Msg:TMessage);
                                   VIRTUAL CM_FIRST+CM_FIND;
                 PROCEDURE Replace(VAR Msg:TMessage);
                                   VIRTUAL CM_FIRST+CM_REPLACE;
                 PROCEDURE SearchAgain(VAR Msg:TMessage);
                                   VIRTUAL CM_FIRST+CM_SEARCHAGAIN;
                 PROCEDURE GotoALine(VAR Msg:TMessage);
                                   VIRTUAL CM_FIRST+CM_GOTO;
              END;

    PMyApp=^TMyApp;
    TMyApp=OBJECT(TApplication)
                 CONSTRUCTOR Init(AName:STRING);
                 DESTRUCTOR Done; VIRTUAL;
                 PROCEDURE InitMainWindow;VIRTUAL;
                 PROCEDURE RunFailed(Code:BYTE);VIRTUAL;
    END;



VAR
    MyApp:TMyApp;

{***************************************************************************
*                                                                          *
*              FIND Dialog                                                 *
*                                                                          *
*                                                                          *
****************************************************************************}

VAR
   resultstr:STRING;
   replstr:STRING;
   findopt:LONGWORD;

CONST
   EOD_SearchCursorText = 16;

TYPE TFindDialog=OBJECT(TDialog)
                       PROCEDURE WMInitDlg(VAR Msg:TMessage);
                                           VIRTUAL WM_FIRST+WM_INITDLG;
                       PROCEDURE CMOk(VAR Msg:TMessage);
                                           VIRTUAL CM_FIRST+CM_OK;
                 END;


PROCEDURE TFindDialog.WMInitDlg(VAR Msg:TMessage);
VAR
   Dlg:HWND;
BEGIN
     Inherited.WMInitDlg(Msg);
     Dlg:=Msg.Receiver;
     SetTextLimit(Dlg,1012,128);
     DialogSetText(Dlg,1012,ResultStr);
     SetCheckBoxState(Dlg,1013,FindOpt AND FRD_CaseSensitiv);
     SetCheckBoxState(Dlg,1014,FindOpt AND FRD_FromCursor);
     SetCheckBoxState(Dlg,1015,FindOpt AND FRD_Forward);
     Msg.Handled:=TRUE;
END;

PROCEDURE TFindDialog.CMOk(VAR Msg:TMessage);
VAR
   Dlg:HWND;
BEGIN
     Dlg:=Msg.Receiver;
     DialogGetText(Dlg,1012,ResultStr,40);
     FindOpt:=0;
     IF GetCheckBoxState(Dlg,1013)<>0 THEN
       FindOpt:=FindOpt OR FRD_CaseSensitiv;
     IF GetCheckBoxState(Dlg,1014)<>0 THEN
       FindOpt:=FindOpt OR FRD_FromCursor;
     IF GetCheckBoxState(Dlg,1015)<>0 THEN
       FindOpt := FindOpt OR FRD_Forward;
END;


FUNCTION FindDialog(VAR s:String;VAR Options:WORD):BOOLEAN;
VAR FindDlg:TFindDialog;
    r:LONGWORD;
    res:BOOLEAN;
BEGIN
     ResultStr := s;
     FindOpt := Options;
     FindDlg.Init(1,Application^.MainWindow^.HWindowFrame,0,1011,NIL);
     r:=FindDlg.ExecDialog;
     FindDlg.Done;
     res:=FALSE;
     IF r=CM_FIRST+CM_OK THEN  {CM_OK}
     BEGIN
          s:=ResultStr;
          Options:=FindOpt;
          res:=TRUE;
     END
     ELSE s:='';
     FindDialog:=res;
END;



{***************************************************************************
*                                                                          *
*              REPLACE Dialog                                              *
*                                                                          *
*                                                                          *
****************************************************************************}

TYPE TReplaceDialog=OBJECT(TDialog)
                       PROCEDURE WMInitDlg(VAR Msg:TMessage);
                                           VIRTUAL WM_FIRST+WM_INITDLG;
                       PROCEDURE CMOk(VAR Msg:TMessage);
                                           VIRTUAL CM_FIRST+CM_OK;
                 END;


PROCEDURE TReplaceDialog.WMInitDlg(VAR Msg:TMessage);
VAR
   Dlg:HWND;
BEGIN
     Inherited.WMInitDlg(Msg);
     Dlg:=Msg.Receiver;
     SetTextLimit(Dlg,1015,128);
     SetTextLimit(Dlg,1017,128);
     DialogSetText(Dlg,1015,ResultStr);
     SetCheckBoxState(Dlg,1018,FindOpt AND FRD_CaseSensitiv);
     SetCheckBoxState(Dlg,1019,FindOpt AND FRD_Confirm);
     SetCheckBoxState(Dlg,1020,FindOpt AND FRD_FromCursor);
     SetCheckBoxState(Dlg,1021,FindOpt AND FRD_Forward);
     SetCheckBoxState(Dlg,1022,FindOpt AND FRD_ReplaceAll);
     Msg.Handled:=TRUE;
END;

PROCEDURE TReplaceDialog.CMOk(VAR Msg:TMessage);
VAR
   Dlg:HWND;
BEGIN
     Dlg:=Msg.Receiver;
     DialogGetText(Dlg,1015,ResultStr,40);
     DialogGetText(Dlg,1017,ReplStr,40);
     FindOpt:=0;
     IF GetCheckBoxState(Dlg,1018)<>0 THEN
       FindOpt:=FindOpt OR FRD_CaseSensitiv;
     IF GetCheckBoxState(Dlg,1019)<>0 THEN
       FindOpt:=FindOpt OR FRD_Confirm;
     IF GetCheckBoxState(Dlg,1020)<>0 THEN
       FindOpt:=FindOpt OR FRD_FromCursor;
     IF GetCheckBoxState(Dlg,1021)<>0 THEN
       FindOpt:=FindOpt OR FRD_Forward;
     IF GetCheckBoxState(Dlg,1022)<>0 THEN
       FindOpt:=FindOpt OR FRD_ReplaceAll;
END;


FUNCTION ReplaceDialog(VAR s,s1:STRING;VAR Options:WORD):BOOLEAN;
VAR ReplDlg:TReplaceDialog;
    r:LONGWORD;
    res:BOOLEAN;
BEGIN
     ResultStr := s;
     FindOpt := Options;
     ReplDlg.Init(1,Application^.MainWindow^.HWindowFrame,0,1012,NIL);
     r:=ReplDlg.ExecDialog;
     ReplDlg.Done;
     res:=FALSE;
     IF r=CM_FIRST+CM_OK THEN  {CM_OK}
     BEGIN
          s:=ResultStr;
          s1:=ReplStr;
          Options:=FindOpt;
          res:=TRUE;
     END
     ELSE s:='';
     ReplaceDialog:=res;
END;

{***************************************************************************
*                                                                          *
*              GOTO Dialog                                                 *
*                                                                          *
*                                                                          *
****************************************************************************}


TYPE TGotoDialog=OBJECT(TDialog)
                       PROCEDURE CMOk(VAR Msg:TMessage);
                                           VIRTUAL CM_FIRST+CM_OK;
                 END;

PROCEDURE TGotoDialog.CMOk(VAR Msg:TMessage);
VAR
   Dlg:HWND;
BEGIN
    Dlg:=Msg.Receiver;
    DialogGetText(Dlg,1012,ResultStr,40); {Ok}
END;


FUNCTION GotoDialog(VAR line:WORD):BOOLEAN;
VAR GotoDlg:TGotoDialog;
    r:LONGWORD;
    i:LONGINT;
    c:INTEGER;
    ok:BOOLEAN;
BEGIN
     GotoDlg.Init(1,Application^.MainWindow^.HWindowFrame,0,1013,NIL);
     r:=GotoDlg.ExecDialog;
     GotoDlg.Done;
     ok:=FALSE;
     IF r=CM_FIRST+CM_OK THEN {Ok}
     BEGIN
          Val(ResultStr,i,c);
          IF c=0 THEN
          BEGIN
               line:=i;
               ok:=TRUE;
          END
          ELSE ErrorBox(MB_ICONHAND,'Error','Illegal numeric format');
     END;
     GotoDialog:=ok;
END;

{**************************************************************************
*                                                                         *
*  Object TMyEditorWindow                                                 *
*                                                                         *
***************************************************************************}



CONSTRUCTOR TMyEditorWindow.Init(AParent:PWindowsObject; ATitle,
                                 AFileName:STRING);
BEGIN
     Inherited.Init(AParent,ATitle);
     StdExt := '*.*';
     WinColor := CLR_BLACK;
     WinBackColor := CLR_CYAN;
     Create;
END;

PROCEDURE TMyEditorWindow.UpdateEditorStatus;
VAR  xs,ys:STRING;
BEGIN
     STR(FileCursorX:3,xs);
     STR(FileCursorY:6,ys);
     Application^.MainWindow^.StatusBarSetText(1,ys+':'+xs,CLR_BLACK);
     IF (EditOptions AND EOD_InsertMode) <> 0 THEN
        Application^.MainWindow^.StatusBarSetText(2,'Insert',CLR_BLACK)
     ELSE Application^.MainWindow^.StatusBarSetText(2,'Overwrite',CLR_BLACK);
     IF Modified THEN
        Application^.MainWindow^.StatusbarSetText(3,'Modified',CLR_BLACK)
     ELSE Application^.MainWindow^.StatusBarSetText(3,'',CLR_BLACK);
END;

PROCEDURE TMyEditorWindow.WMClose(VAR Msg:TMessage);
BEGIN
     Application^.MainWindow^.StatusBarSetText(1,'',CLR_BLACK);
     Application^.MainWindow^.StatusBarSetText(2,'',CLR_BLACK);
     Application^.MainWindow^.StatusbarSetText(3,'',CLR_BLACK);
     Application^.MainWindow^.StatusbarSetText(4,'',CLR_BLACK);
     Inherited.WMClose(msg);
END;

PROCEDURE TMyEditorWindow.FindText(s : STRING; w : WORD);
BEGIN
     IF (EditOptions AND EOD_SearchCursorText) <> 0
     THEN s := GetTextFromCursor
     ELSE s := '';
     w := FindOptions;
     IF FindDialog(s,w) THEN inherited.FindText(s,w);
END;


PROCEDURE TMyEditorWindow.ReplaceText(s,s1 : STRING; w : WORD);
BEGIN
     IF (EditOptions AND EOD_SearchCursorText) <> 0
     THEN s := GetTextFromCursor
     ELSE s := '';
     w := ReplOptions;
     IF ReplaceDialog(s,s1,w) THEN inherited.ReplaceText(s,s1,w);
END;

{**************************************************************************
*                                                                         *
*  Object TMyWindow                                                       *
*                                                                         *
***************************************************************************}


CONSTRUCTOR TMyWindow.Init(AParent:PWindowsObject; ATitle:STRING);
BEGIN
     Inherited.Init(AParent,ATitle);
     WinBackColor := CLR_DARKGRAY;
     aSearchString := '';
     aReplaceString := '';
     FindOptions := FRD_Forward;
     ReplOptions := FRD_Forward;
     EditOptions := EOD_InsertMode OR EOD_AutoIndentMode OR
                    EOD_SearchCursorText OR $8000000;
END;


DESTRUCTOR TMyWindow.Done;
BEGIN
     Inherited.Done;
END;

PROCEDURE TMyWindow.SetupWindow;
BEGIN
     Inherited.SetupWindow;
     WinBackColor:=CLR_DARKGRAY;
     CreateToolBar(30);
     CreateStatusBar(30);
     ToolBarInsertButton(CM_FIRST+CM_OPEN,2001,10,3,28,24);
     ToolBarInsertButton(CM_FIRST+CM_SAVE,2000,45,3,28,24);
     ToolBarInsertButton(CM_FIRST+CM_FIND,2002,80,3,28,24);
     ToolBarInsertButton(CM_FIRST+CM_REPLACE,2003,115,3,28,24);

     StatusBarInsertItem(1,5,4,85,21,FALSE);
     StatusBarInsertItem(2,95,4,66,21,FALSE);
     StatusBarInsertItem(3,166,4,59,21,FALSE);
     StatusBarInsertItem(4,5,4,0,21,TRUE);
     StatusBarInsertItem(5,230,4,0,21,FALSE);
END;


PROCEDURE TMyWindow.SetupMenu;
VAR
   Dlg:TDialog;
   s:STRING;
   r:BYTE;
   Msg:TMessage;
   Child:PMyEditorWindow;
BEGIN
     Inherited.SetupMenu;
     InsertMenuHelp(4,65535,'',-1);  {Default menu help}
     InsertMenuHelp(4,CM_FIRST+CM_OPEN,'Locate and open a file in an Edit window',-1);
     InsertMenuHelp(4,CM_FIRST+CM_NEW,'Create a new file in a new Edit window',-1);
     InsertMenuHelp(4,CM_FIRST+CM_SAVE,'Save the file in the active Edit window',-1);
     InsertMenuHelp(4,CM_FIRST+CM_SAVEAS,
       'Save the current file under a different name, directory or drive',-1);
     InsertMenuHelp(4,CM_FIRST+CM_SAVEALL,'Save all modified files in all Edit windows',-1);
     InsertMenuHelp(4,CM_FIRST+CM_TILE,'Arrange windows on desktop by tiling',-1);
     InsertMenuHelp(4,CM_FIRST+CM_CASCADE,'Arrange windows on desktop by cascading',-1);
     InsertMenuHelp(4,CM_FIRST+CM_CLOSE,'Close the active window',-1);
     InsertMenuHelp(4,CM_FIRST+CM_CLOSEALL,'Close all windows on the desktop',-1);
     InsertMenuHelp(4,CM_FIRST+CM_GOTO,'Move the cursor to a specified line number',-1);
     InsertMenuHelp(4,CM_FIRST+CM_FIND,'Search for specified text',-1);
     InsertMenuHelp(4,CM_FIRST+CM_REPLACE,'Search for text and replace it with new text',-1);
     InsertMenuHelp(4,CM_FIRST+CM_ABOUT,'Display Copyright notice',-1);
     InsertMenuHelp(4,CM_FIRST+CM_NEXT,'Make the next Edit window active',-1);
END;

PROCEDURE TMyWindow.NewFile(VAR Msg:TMessage);
VAR
    Child:PMyEditorWindow;
BEGIN
     Child:=New(PMyEditorWindow,Init(Application^.MainWindow^.DesktopWin,
                                      'Noname',''));
     Child^.SetEditorPtr(2009,0);  {Mauszeiger setzen}
END;


PROCEDURE TMyWindow.Open(VAR Msg:TMessage);
VAR
   s:STRING;
   dir:DirStr;
   Name:NameStr;
   Ext:ExtStr;
   ch:CHAR;
   Drive:BYTE;
   Child:PMyEditorWindow;
BEGIN
     IF FileOpenDialog(Application^.MainWindow^.HWindow,s) THEN
     BEGIN
          Child:=New(PMyEditorWindow,Init(Application^.MainWindow^.DesktopWin,
                                           s,s));
          IF Child<>NIL THEN
          BEGIN
              Child^.LoadFile(s);
              Child^.SetEditorPtr(2009,0);  {Mauszeiger setzen}
          END;
     END;
END;


PROCEDURE TMyWindow.SaveAFile(VAR Msg:TMessage);
VAR
    Editor:PMyEditorWindow;
BEGIN
     Editor:=DesktopWin^.ActiveChild;
     IF Editor=NIL THEN exit;
     Editor^.SaveFile;
END;


PROCEDURE TMyWindow.SaveAFileAs(VAR Msg:TMessage);
VAR
    Editor:PMyEditorWindow;
BEGIN
     Editor:=DesktopWin^.ActiveChild;
     IF Editor=NIL THEN Exit;
     Editor^.SaveAsFile;
END;


PROCEDURE SaveThisFile(Editor:PMyEditorWindow);
BEGIN
     IF ((Editor^.Modified) OR (Editor^.Untitled)) THEN
       Editor^.SaveFile;  {Only if Modified or Untitled}
END;


PROCEDURE TMyWindow.SaveAllFiles(VAR Msg:TMessage);
BEGIN
     DesktopWin^.ForEach(@SaveThisFile);
END;


PROCEDURE TMyWindow.AboutThis(VAR Msg:TMessage);
VAR
   Dlg:TDialog;
BEGIN
     Dlg.Init(1,Application^.MainWindow^.HWindowFrame,0,1004,NIL);
     Dlg.ExecDialog;
     Dlg.Done;
END;



PROCEDURE TMyWindow.CMClose(VAR Msg:TMessage);
VAR  Child:PMyEditorWindow;
BEGIN
     Child:=Application^.MainWindow^.DesktopWin^.ActiveChild;
     IF Child = NIL THEN exit;
     Child^.CloseWindow;
END;


PROCEDURE TMyWindow.Find(VAR Msg:TMessage);
VAR  e:PMyEditorWindow;
BEGIN
     e:=DesktopWin^.ActiveChild;
     IF e=NIL THEN exit;
     e^.FindText(aSearchString,0);
END;


PROCEDURE TMyWindow.Replace(VAR Msg:TMessage);
VAR  e:PMyEditorWindow;
BEGIN
     e:=DesktopWin^.ActiveChild;
     IF e=NIL THEN exit;
     e^.ReplaceText(aSearchString,aReplaceString,0);
END;


PROCEDURE TMyWindow.SearchAgain(VAR Msg:TMessage);
VAR  e : PMyEditorWindow;
BEGIN
     e:=DesktopWin^.ActiveChild;
     IF e=NIL THEN exit;
     e^.SearchTextAgain;
END;


PROCEDURE TMyWindow.GotoALine(VAR Msg:TMessage);
VAR
   w:WORD;
   e:PMyEditorWindow;
BEGIN
   e:=DesktopWin^.ActiveChild;
   IF e = NIL THEN exit;
   IF GotoDialog(w) THEN
     IF NOT e^.GotoLine(w,1) THEN
       ErrorBox(MB_ICONHAND,'Error','Illegal range for goto');
END;

{*************************************************************************
 *                                                                       *
 *   Object TMyApp                                                       *
 *                                                                       *
 *************************************************************************}

PROCEDURE TMyApp.InitMainWindow;
VAR
   s:STRING;
   Dir:DirStr;
   Name:NameStr;
   Ext:ExtStr;
BEGIN
     Inherited.InitMainWindow;
     MainWindow:=New(PMyWindow,Init(NIL,ApplicationName));
     MainWindow^.Attr.HasMenu:=TRUE;
     MainWindow^.Attr.HasIcon:=TRUE;
     MainWindow^.Attr.HasAccelTable:=TRUE;
     MainWindow^.Attr.ResourceID:=1000;
     MainWindow^.Attr.WindowID:=1000;
END;


CONSTRUCTOR TMyApp.Init(AName:STRING);
VAR t:BYTE;
BEGIN
     Inherited.Init(AName);
     FileOpenDlgWildCards:='*.*';
     FilesaveDlgWildCards:='*.*';
END;


DESTRUCTOR TMyApp.Done;
BEGIN
     Inherited.Done;
END;

PROCEDURE TMyApp.RunFailed(Code:BYTE);
BEGIN
     ErrorBox(MB_ICONHAND,'Error',
        'Application failed to initialize program windows');
END;



BEGIN
     MyApp.Init('Speed-386 Sample Application PMEdit');
     MyApp.Run;
     MyApp.Done;
END.

