PROGRAM Bitmap;

{***************************************************************************
*                                                                          *
*                Speed-Pascal/2 Sample program "PMBitmap"                  *
*                                                                          *
*           (C) 1993,94 Rene Nrnberger. All rights reserved.              *
*                                                                          *
*                                                                          *
*  This program demonstrates how to use a bitmap as the desktop            *
*  background.                                                             *
*                                                                          *
****************************************************************************}



{$M 65535}  {preserve stack space}

USES ObjectPm,Crt,Odialogs,pmwin,pmgpi,pmbitmap,pmdev,os2def,dos;

CONST
     PICTURE_CREATE=1;
     PICTURE_UPDATE=0;

RESOURCE Bitmap;


TYPE
    PMyWindow=^TMyWindow;
    TMyWindow=OBJECT(TWindow)
                 CONSTRUCTOR Init(AParent:PWindowsObject; ATitle:STRING);
                 DESTRUCTOR Done;VIRTUAL;
                 PROCEDURE SetupDesktop;VIRTUAL;
                 PROCEDURE SetupWindow;VIRTUAL;
                 FUNCTION InitializeDesktop(ParentWin:PWindowsObject):PWindow;VIRTUAL;

                 FUNCTION ReadBitmap(VAR f:FILE):BOOLEAN;
                 PROCEDURE OpenBitMap(s:STRING);

                 PROCEDURE CMLoad(VAR msg:TMessage);
                            VIRTUAL CM_FIRST+CM_OPEN;
              END;

    PMyDesktop=^TMyDesktop;
    TMyDesktop=OBJECT(TWindow)
                 CONSTRUCTOR Init(AParent:PWindowsObject; ATitle:STRING);
                 DESTRUCTOR Done;VIRTUAL;

                 PROCEDURE WMPaint(VAR Msg:TMessage);
                                   VIRTUAL WM_FIRST+WM_PAINT;
               END;


    PMyApp=^TMyApp;
    TMyApp=OBJECT(TApplication)
                 CONSTRUCTOR Init(AName:STRING);
                 DESTRUCTOR Done; VIRTUAL;
                 PROCEDURE InitMainWindow;VIRTUAL;
                 PROCEDURE RunFailed(Code:BYTE);VIRTUAL;
    END;

{**************************************************************************
 *                                                                        *
 *    OBJECT TMyWindow                                                    *
 *                                                                        *
 **************************************************************************}

VAR
    BitmapApp:TMyApp;
    BitmapWidth,BitmapHeight:LONGWORD;
    hwndFrame:HWND;       { frame control handle }
    hwndClient:HWND;      { client area handle }
    hdcClient:HDC;        { window dc handle }
    hpsClient:HPS;        { client area Gpi ps handle }
    sizlMaxClient:SIZEL;  { max client area size }
    hpsBitmapFile:HPS;    { bitmap straight from the file }
    hdcBitmapFile:HDC;
    hbmBitmapFile:HBITMAP;
    lByteAlignX, lByteAlignY:LONG;  { memory alignment constants     }
    dop:DEVOPENSTRUC;
    bmp2BitMapFile:BITMAPINFOHEADER2;
    pbmp2BitMapFile:PBITMAPINFOHEADER2;


FUNCTION TMyWindow.ReadBitmap(VAR f:FILE):BOOLEAN;
VAR pFileBegin:^BYTE;
    cScans,cScansRet:ULONG;
    pbfh2:PBITMAPFILEHEADER2;
    pbmp2:PBITMAPINFOHEADER2;
    tfh:PBITMAPARRAYFILEHEADER2;
    bih:PBITMAPINFOHEADER;
    l:ULONG;
    Temp:^BYTE;
    bi2:PBITMAPINFO2;
LABEL ll;
BEGIN
     l:=FileSize(f);
     getmem(pFileBegin,l);
     BlockRead(f,pFileBegin^,l);

     pbfh2 := POINTER(pFileBegin);
     pbmp2 := NIL;     { only set this when we validate type }

     CASE pbfh2^.usType OF
         BFT_BITMAPARRAY:
         BEGIN
            tfh:=POINTER(pFileBegin);
            pbfh2 := @tfh^.bfh2;
            pbmp2 := @pbfh2^.bmp2;  { pointer to info header (readability) }
         END;
         BFT_BMAP:pbmp2 := @pbfh2^.bmp2; { pointer to info header (readability) }
      END; {case}

      IF pbmp2 = NIL THEN
      BEGIN
ll:
           ErrorBox(MB_ICONHAND,'Error','Could not load Desktop Bitmap !');
           hpsBitmapFile:=0;
           ReadBitMap:=FALSE;
           FreeMem(pFileBegin,l);
           exit;
      END;

      IF pbmp2^.cbFix = sizeof(BITMAPINFOHEADER) THEN   { old format? }
      BEGIN
           bih:=POINTER(pbmp2);
           cScans := bih^.cy;
      END
      ELSE  { new PM format, Windows, or other }
         cScans := pbmp2^.cy;

      BitmapWidth:=pbmp2^.cx;
      BitmapHeight:=pbmp2^.cy;

      Move(pbmp2^,pbmp2BitMapFile^,pbmp2^.cbFix); { copy bitmap info into
                                                   global structure }
      hbmBitmapFile :=GpiCreateBitmap( hpsBitmapFile,pbmp2BitmapFile^,
                                       0,NIL,NIL);
      IF hbmBitmapFile=0 THEN goto ll;

      IF GpiSetBitmap( hpsBitmapFile, hbmBitmapFile) = BMB_ERROR THEN
         goto ll;

      Temp:=POINTER(pFileBegin);
      inc(Temp,pbfh2^.offBits);
      bi2:=POINTER(pbmp2);
      cScansRet := GpiSetBitmapBits(hpsBitmapFile, 0,cScans,Temp^,bi2^);

      IF cScansRet <> cScans THEN  { original # of scans? }
         goto ll;

      FreeMem(pFileBegin,l);

      ReadBitMap:=TRUE;
END;


PROCEDURE TMyWindow.OpenBitMap(s:STRING);
VAR
   f:FILE;
   szWindowText:PSZ;
BEGIN
     assign(f,s);
     reset(f,1);
     IF ioresult<>0 THEN
     BEGIN
          ErrorBox(MB_ICONHAND,'Error','Desktop Bitmap not found !'+#13+
                    '('+s+')');
          hpsBitmapFile:=0;
          exit;
     END;

     IF not ReadBitmap(f) THEN hpsBitmapFile:=0;
     close(f);

     InvalidateWindow;  {force redraw}
END;



FUNCTION TMyWindow.InitializeDesktop(ParentWin:PWindowsObject):PWindow;
VAR
   Desktop:PWindow;
BEGIN
     Desktop:=New(PMyDesktop,Init(ParentWin,''));
     Desktop^.WinBackColor:=CLR_DARKGRAY;
     InitializeDesktop:=Desktop;
END;


PROCEDURE TMyWindow.CMLoad(VAR msg:TMessage);
VAR s:STRING;
BEGIN
     IF FileOpenDialog(HWindow,s) THEN OpenBitmap(s);
END;

CONSTRUCTOR TMyWindow.Init(AParent:PWindowsObject; ATitle:STRING);
BEGIN
     Inherited.Init(AParent,ATitle);
     SetFlags(WF_WITHDESKTOP,TRUE);
END;


PROCEDURE TMyWindow.SetupDesktop;
VAR
   sizl:SIZEL;
   s:STRING;
BEGIN
     Inherited.SetupDesktop;

     hwndClient:=Application^.MainWindow^.DesktopWin^.HWindow;

     sizlMaxClient.cx := WinQuerySysValue( HWND_DESKTOP, SV_CXFULLSCREEN);
     sizlMaxClient.cy := WinQuerySysValue( HWND_DESKTOP, SV_CYFULLSCREEN);

     lByteAlignX := WinQuerySysValue( HWND_DESKTOP, SV_CXBYTEALIGN);
     lByteAlignY := WinQuerySysValue( HWND_DESKTOP, SV_CYBYTEALIGN);

     s:='*';
     hdcBitMapFile := DevOpenDC(AppHandle,OD_MEMORY,s,3,dop,0);
     IF hdcBitMapFile=0 THEN exit;

     sizl.cx := 1;
     sizl.cy := 1;
     hpsBitMapFile := GpiCreatePS(AppHandle,hdcBitMapFile,sizl,
                        PU_PELS OR GPIA_ASSOC OR GPIT_MICRO);
     IF hpsBitMapFile= GPI_ERROR THEN hpsBitmapFile:=0;
END;


PROCEDURE TMyWindow.Setupwindow;
VAR
   sizl:SIZEL;
BEGIN
     Inherited.SetupWindow;
END;


DESTRUCTOR TMyWindow.Done;
BEGIN
     Inherited.Done;
END;

{**************************************************************************
 *                                                                        *
 * Object TMyDesktop                                                      *
 *                                                                        *
 **************************************************************************}


CONSTRUCTOR TMyDesktop.Init(AParent:PWindowsObject; ATitle:STRING);
BEGIN
     Inherited.Init(AParent,ATitle);
END;


DESTRUCTOR TMyDesktop.Done;
BEGIN
     Inherited.Done;
END;


PROCEDURE TMyDesktop.WMPaint(VAR Msg:TMessage);
VAR
    pt:POINTL;
    aptr:RECTL;
    rc:RECTL;
    ahps:HPS;
    Win:HWND;
    cx,cy:LONGWORD;
BEGIN
     Win:=Msg.Receiver;
     IF hpsBitmapFile<>0 THEN
     BEGIN
          ahps:=WinBeginPaint(Win,0,rc);
          WinQueryWindowRect(Win,aptr);  {Fill whole window}
          WinFillRect(ahps,aptr,WinBackColor);
          {Center the bitmap if required}
          pt.x:=0;
          pt.y:=0;
          cx:=aptr.xright-aptr.xleft;
          cy:=aptr.yTop-aptr.yBottom;
          IF BitmapWidth<cx THEN pt.x:=(cx-BitmapWidth) DIV 2;
          IF BitmapHeight<cy THEN pt.y:=(cy-BitmapHeight) DIV 2;
          WinDrawBitMap(ahps,hbmBitMapfile,NIL,pt,CLR_RED,CLR_BLUE,
                        DBM_NORMAL);
          WinEndPaint(ahps);
     END
     ELSE Inherited.WMPaint(Msg);  {Paint desktop}
END;


{*************************************************************************
 *                                                                       *
 *   Object TMyApp                                                       *
 *                                                                       *
 *************************************************************************}

PROCEDURE TMyApp.InitMainWindow;
VAR
   s:STRING;
   Dir:DirStr;
   Name:NameStr;
   Ext:ExtStr;
BEGIN
     Inherited.InitMainWindow;
     MainWindow:=New(PMyWindow,Init(NIL,ApplicationName));
     MainWindow^.Attr.HasMenu:=TRUE;
     MainWindow^.Attr.HasIcon:=TRUE;
     MainWindow^.Attr.ResourceID:=1000;
     MainWindow^.Attr.WindowID:=1000;
END;


CONSTRUCTOR TMyApp.Init(AName:STRING);
VAR t:BYTE;
BEGIN
     Inherited.Init(AName);

     {For bitmap}
     hbmBitmapFile:=0;
     New(pbmp2BitMapFile);

     FillChar(dop,sizeof(DEVOPENSTRUC),0);
     dop.pszDriverName:=@'DISPLAY';
     FileOpenDlgWildCards:='*.BMP';
     FilesaveDlgWildCards:='*.BMP';
END;


DESTRUCTOR TMyApp.Done;
BEGIN
     Inherited.Done;
END;

PROCEDURE TMyApp.RunFailed(Code:BYTE);
BEGIN
     ErrorBox(MB_ICONHAND,'Error',
        'Application failed to initialize program windows');
END;


BEGIN
     BitmapApp.Init('SPEED-Bitmap sample program');
     BitmapApp.Run;
     BitmapApp.Done;
END.


