diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/foo.pl soulswp/foo.pl
--- v101qc/foo.pl	Wed Dec 31 18:00:00 1969
+++ soulswp/foo.pl	Sat Aug 24 20:44:38 1996
@@ -0,0 +1,3 @@
+#!/usr/bin/perl -n
+($a, $b) = split;
+print "$a = other.$b; other.$b = self.$b; self.$b = $a;\n"
Binary files v101qc/progs/null.spr and soulswp/progs/null.spr differ
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/progs.src soulswp/progs.src
--- v101qc/progs.src	Wed Jul 31 21:15:26 1996
+++ soulswp/progs.src	Sat Aug 24 20:54:03 1996
@@ -6,6 +6,7 @@
 ai.qc
 combat.qc
 items.qc
+w-soulsw.qc
 weapons.qc
 world.qc
 client.qc
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/w-soulsw.qc soulswp/w-soulsw.qc
--- v101qc/w-soulsw.qc	Wed Dec 31 18:00:00 1969
+++ soulswp/w-soulsw.qc	Sat Aug 24 21:48:08 1996
@@ -0,0 +1,123 @@
+//  Soul swap weapon, by Jeff Epler
+// jepler@inetnebr.com
+//
+// Insert this file in progs.src before weapons.qc, and add
+// a way in weapons.qc to call SoulSwapFire.  I suggest putting it on
+// an impulse
+
+void(vector org) spawn_tfog;
+
+//void() SoulSwapPrecache = {
+//	precache_model("progs/null.spr");
+//};
+
+void(void() g) SoulSwapTouch = { // 'g' is a hack, local function vars
+// don't seem to exist
+	local float f;
+	local entity e;
+	local vector v;
+	local entity o, s;
+	local string c;
+
+	o=other; s=self.owner;
+	
+	if(o.classname != "player") { remove(self); return; }
+	if(s.health <= 0) { remove(self); return; }
+	if(o.health <= 0) { remove(self); return; }
+
+	spawn_tfog(s.origin + 20 * v_forward);
+	spawn_tfog(o.origin + 20 * v_forward);
+
+
+f = o.health; o.health = s.health; s.health = f;
+
+f = o.ammo_shells; o.ammo_shells = s.ammo_shells; s.ammo_shells = f;
+f = o.ammo_nails; o.ammo_nails = s.ammo_nails; s.ammo_nails = f;
+f = o.ammo_rockets; o.ammo_rockets = s.ammo_rockets; s.ammo_rockets = f;
+f = o.ammo_cells; o.ammo_cells = s.ammo_cells; s.ammo_cells = f;
+f = o.currentammo; o.currentammo = s.currentammo; s.currentammo = f;
+f = o.weapon; o.weapon = s.weapon; s.weapon = f;
+c = o.weaponmodel; o.weaponmodel = s.weaponmodel; s.weaponmodel = c;
+f = o.items; o.items = s.items; s.items = f;
+
+f = o.armortype; o.armortype = s.armortype; s.armortype = f;
+f = o.armorvalue; o.armorvalue = s.armorvalue; s.armorvalue = f;
+
+f = o.flags; o.flags = s.flags; s.flags = f;
+f = o.effects; o.effects = s.effects; s.effects = f;
+
+// f = o.attack_finished; o.attack_finished = s.attack_finished; s.attack_finished = f;
+s.attack_finished = o.attack_finished; // Don't penalize attacked
+
+f = o.pain_finished; o.pain_finished = s.pain_finished; s.pain_finished = f;
+
+f = o.invincible_finished; o.invincible_finished = s.invincible_finished; s.invincible_finished = f;
+f = o.invisible_finished; o.invisible_finished = s.invisible_finished; s.invisible_finished = f;
+f = o.super_damage_finished; o.super_damage_finished = s.super_damage_finished; s.super_damage_finished = f;
+f = o.radsuit_finished; o.radsuit_finished = s.radsuit_finished; s.radsuit_finished = f;
+
+f = o.invincible_time; o.invincible_time = s.invincible_time; s.invincible_time = f;
+f = o.invincible_sound; o.invincible_sound = s.invincible_sound; s.invincible_sound = f;
+
+f = o.invisible_time; o.invisible_time = s.invisible_time; s.invisible_time = f;
+f = o.invisible_sound; o.invisible_sound = s.invisible_sound; s.invisible_sound = f;
+
+f = o.super_time; o.super_time = s.super_time; s.super_time = f;
+f = o.super_sound; o.super_sound = s.super_sound; s.super_sound = f;
+
+f = o.rad_time; o.rad_time = s.rad_time; s.rad_time = f;
+
+f = o.jump_flag; o.jump_flag = s.jump_flag; s.jump_flag = f;
+f = o.swim_flag; o.swim_flag = s.swim_flag; s.swim_flag = f;
+f = o.air_finished; o.air_finished = s.air_finished; s.air_finished = f;
+f = o.bubble_count; o.bubble_count = s.bubble_count; s.bubble_count = f;
+c = o.deathtype; o.deathtype = s.deathtype; s.deathtype = c;
+
+f = o.nextthink; o.nextthink = s.nextthink; s.nextthink = f;
+g = o.think; o.think = s.think; s.think = g;
+
+v = o.origin; o.origin = s.origin; s.origin = v;
+v = o.v_angle; o.v_angle = s.v_angle; s.v_angle = v;
+v = o.view_ofs; o.view_ofs = s.view_ofs; s.view_ofs = v;
+v = o.velocity; o.velocity = s.velocity; s.velocity = v;
+v = o.angles; o.angles = s.angles; s.angles = v;
+v = o.avelocity; o.avelocity = s.avelocity; s.avelocity = v;
+v = o.punchangle; o.punchangle = s.punchangle; s.punchangle = v;
+
+	s.fixangle = 1;
+	s.teleport_time = time + 0.1;
+	if(s.flags & FL_ONGROUND)
+		s.flags = s.flags - FL_ONGROUND;
+
+	o.fixangle = 1;
+	o.teleport_time = time + 0.1;
+	if(o.flags & FL_ONGROUND)
+		o.flags = o.flags - FL_ONGROUND;
+
+	remove(self);
+};
+
+void() SoulSwapFire = {
+	local entity missile;
+
+	sound (self, CHAN_WEAPON, "weapons/sgun1.wav", 1, ATTN_NORM);
+	self.attack_finished = time + 8;
+	missile = spawn();
+	missile.owner = self;
+	missile.solid = SOLID_BBOX;
+	missile.movetype = MOVETYPE_FLYMISSILE;
+	setmodel(missile, "progs/s_spike.mdl");
+	missile.effects = EF_DIMLIGHT | EF_BRIGHTFIELD;
+	
+	missile.touch = SoulSwapTouch;
+	missile.think = SUB_Remove;
+	missile.nextthink = time + 4;
+
+	makevectors (self.v_angle);
+	missile.velocity = aim(self, 1000);
+	missile.velocity = 400 * missile.velocity;
+	missile.angles = vectoangles(missile.velocity);
+
+	setsize (missile, '0 0 0', '0 0 0');
+	setorigin (missile, self.origin + v_forward*8 + '0 0 16');
+};
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/weapons.qc soulswp/weapons.qc
--- v101qc/weapons.qc	Thu Jul 25 01:51:24 1996
+++ soulswp/weapons.qc	Sat Aug 24 21:21:42 1996
@@ -22,6 +22,8 @@
 	precache_sound ("weapons/grenade.wav");	// grenade launcher
 	precache_sound ("weapons/bounce.wav");		// grenade bounce
 	precache_sound ("weapons/shotgn2.wav");	// super shotgun
+
+	//SoulSwapPrecache();
 };
 
 float() crandom =
@@ -1169,6 +1171,9 @@
 		CycleWeaponCommand ();
 	if (self.impulse == 11)
 		ServerflagsCommand ();
+
+	if(self.impulse == 12)
+		SoulSwapFire();
 
 	if (self.impulse == 255)
 		QuadCheat ();
