#define STRICT
#define WIN32_LEAN_AND_MEAN
#include <wingnuc.h>
#include <windows.h>
#include <stdio.h>
#include "enumw.h"

#define IDC_LIST 500

static OLDFONTENUMPROC lpfnEnumFonts;
static WNDENUMPROC lpfnEnumWindows;
static FONTENUMPROC lpfnEnumFontFam;

static char szAppname[]="enumw";
static HWND hWindow;
static HWND hListWnd;
static HINSTANCE hInstance;


LOGFONT logFont = {
    12,
    0,
    NULL,
    NULL,
    400,
    FALSE,
    FALSE,
    FALSE,
    OEM_CHARSET,
    OUT_DEFAULT_PRECIS,
    CLIP_DEFAULT_PRECIS,
    DEFAULT_QUALITY,
    FIXED_PITCH | FF_MODERN,
    ""
};

char * font_name = & logFont.lfFaceName;

int CALLBACK EnumFontsProc (
    const LOGFONT * lpFont,
    const TEXTMETRIC * lpTM,
    int style,
    LPARAM str)
{
    if (lpTM->tmPitchAndFamily & TMPF_FIXED_PITCH)
        SendMessage(hListWnd, LB_ADDSTRING, 0, (LPARAM) lpFont->lfFaceName);
    return 1;

} RETURN_CALLBACK(4);

int CALLBACK EnumFontFamProc (
    const ENUMLOGFONT *lpFont,
    const NEWTEXTMETRIC *lpTM,
    int type,
    LPARAM str)
{
    if (type & TRUETYPE_FONTTYPE)
        SendMessage(hListWnd, LB_ADDSTRING, 0, (LPARAM)lpFont->elfFullName);

    return 1;
} RETURN_CALLBACK(4);

void display_window(HWND hWnd, int level)
{
    static char text[256];
    static char class[256];
    RECT r;
    char *buf;
    int i;

    buf = text;

    for (i=0; i<(int)level; i++) {
	*buf++ = ' ';
	*buf++ = ' ';
	*buf++ = ' ';
	*buf++ = ' ';
    }
    sprintf(buf, "%04X    ", hWnd);
    buf = text + strlen(text);

    if (GetClassName(hWnd, class, 256)) {
	sprintf(buf, "[%s]    ", class);
	buf = text + strlen(text);
    }
    GetWindowRect(hWnd, &r);
    sprintf(buf, "(%d,%d,%d,%d)    ", r.left, r.top, r.right, r.bottom);
    buf = text + strlen(text);
    if (GetWindowText(hWnd, class, 256)) {
	sprintf(buf, "<%s>", class);
	buf = text + strlen(text);
    }
    if (level == 0)
    {
        HINSTANCE hInst = (HINSTANCE) GetWindowLong(hWnd, GWL_HINSTANCE);
	if (GetModuleFileName(hInst, class, 256))
	    sprintf(buf,"    %s", class);
    }

    /* we must convert 32bit flat pointer to 16bit far pointer */
    SendMessage(hListWnd, LB_ADDSTRING, 0, (LPARAM)text);
}

BOOL CALLBACK EnumWindowsProc(HWND hWnd, LPARAM level)
{
    static HWND seen[1024] = {0};
    HWND *ps;
    int i;
    static int num_wnd = 0;

    /* cheap check for duplicates */
    for (i=0, ps=seen; i<num_wnd; i++, ps++)
	if (hWnd == *ps)
	    return 1;
    if (num_wnd < 1024)
	seen[num_wnd++] = hWnd;

    display_window(hWnd, level);
    EnumChildWindows(hWnd, lpfnEnumWindows, level+1);
    return 1;	/* keep going */

} RETURN_CALLBACK(2)

doPaint(HWND hwnd)
{
    HFONT hFont, hOldFont;
    HDC hdc;

    hdc = GetDC(hwnd);
    TextOut(hdc, 0, 0, "          ", 10);
    hFont = CreateFontIndirect(&logFont);
    hOldFont= SelectObject(hdc, hFont);
    TextOut(hdc, 0, 0, "Hallo", 5);
    SelectObject(hdc, hOldFont);
    DeleteObject(hFont);
    ReleaseDC(hwnd, hdc);
}

static void do_enumfonts(HWND hwnd)
{
    HDC hdc;

    SendMessage(hListWnd,LB_RESETCONTENT,0,0);
    SendMessage(hListWnd,WM_SETREDRAW,0,0);

    hdc = GetDC(hwnd);
    if (! EnumFonts(hdc, NULL, lpfnEnumFonts, NULL))
        MessageBox(hwnd, "EnumFonts failed", NULL, MB_OK);
    ReleaseDC(hwnd, hdc);

    InvalidateRect(hListWnd,NULL,TRUE);
    SendMessage(hListWnd,WM_SETREDRAW,1,0);
    UpdateWindow(hListWnd);
}

static void do_enumfontfam(HWND hwnd)
{
    HDC hdc;

    SendMessage(hListWnd,LB_RESETCONTENT,0,0);
    SendMessage(hListWnd,WM_SETREDRAW,0,0);

    hdc = GetDC(hwnd);
    if (! EnumFontFamilies(hdc, NULL, lpfnEnumFontFam, NULL))
        MessageBox(hwnd, "EnumFontFam failed", NULL, MB_OK);
    ReleaseDC(hwnd, hdc);

    InvalidateRect(hListWnd,NULL,TRUE);
    SendMessage(hListWnd,WM_SETREDRAW,1,0);
    UpdateWindow(hListWnd);
}

static void do_enumwindows(HWND hwnd)
{
    SendMessage(hListWnd,LB_RESETCONTENT,0,0);
    SendMessage(hListWnd,WM_SETREDRAW,0,0);
    if (! EnumWindows(lpfnEnumWindows, 0))
        MessageBox(hwnd, "EnumWindows failed", NULL, MB_OK);
    InvalidateRect(hListWnd,NULL,TRUE);
    SendMessage(hListWnd,WM_SETREDRAW,1,0);
    UpdateWindow(hListWnd);
}

LRESULT CALLBACK WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch (message)
    {
	case WM_SIZE:
            MoveWindow(hListWnd,0,0,LOWORD(lParam),HIWORD(lParam),TRUE);
            return 0;

	case WM_CREATE:
	    lpfnEnumFonts = (OLDFONTENUMPROC)
		    MakeProcInstance((FARPROC) EnumFontsProc, hInstance);
	    lpfnEnumFontFam = (FONTENUMPROC)
		    MakeProcInstance((FARPROC) EnumFontFamProc, hInstance);
	    lpfnEnumWindows = (WNDENUMPROC)
		    MakeProcInstance((FARPROC) EnumWindowsProc, hInstance);
            return 0;

	case WM_DESTROY:
            SendMessage(hListWnd,LB_RESETCONTENT,0,0);
	    FreeProcInstance((FARPROC)lpfnEnumFonts);
	    FreeProcInstance((FARPROC)lpfnEnumFontFam);
	    FreeProcInstance((FARPROC)lpfnEnumWindows);
	    PostQuitMessage(0);
            return 0;

	case WM_COMMAND:
	    switch (wParam) {
		case IDM_FONTS:
                    do_enumfonts(hwnd);
                    return 0;
		case IDM_FONTFAM:
                    do_enumfontfam(hwnd);
                    return 0;
		case IDM_WINDOWS:
                    do_enumwindows(hwnd);
                    return 0;
		case IDM_ABOUT:
		    MessageBox(hwnd, "EnumW 1.0", szAppname, MB_OK);
                    return 0;
		case IDC_LIST:
                    if (HIWORD(lParam) != LBN_DBLCLK)
			break;
		    else {
			WPARAM index = SendMessage(
			    hListWnd,
			    LB_GETCURSEL,
                            0,0);
			SendMessage(
			    hListWnd,
			    LB_GETTEXT,
			    index,
			    (DWORD)(LPSTR) font_name);
			doPaint(hwnd);
                        return 0;
                    }
                break;
            } /* switch wparam */

    } /* switch message */

    return DefWindowProc(hwnd, message, wParam, lParam);

} RETURN_CALLBACK(4);


BOOL InitApplication(HINSTANCE hInstance)
{
    WNDCLASS wc;

    wc.style = NULL;
    wc.lpfnWndProc = WndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon(hInstance, szAppname);
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName =  szAppname;
    wc.lpszClassName = szAppname;

    return RegisterClass(&wc);
}

BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
    RECT Rect;
    HANDLE hFont;

    hWindow = CreateWindow(
	szAppname,
	"ENUM TEST",
	WS_OVERLAPPEDWINDOW,
	CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
	NULL, NULL,
	hInstance,
	NULL);

    if (!hWindow)
	return (NULL);

    GetClientRect(hWindow, &Rect);

    hListWnd =
        CreateWindow (
	"Listbox",
	NULL ,
	(LBS_STANDARD & ~LBS_SORT) | LBS_HASSTRINGS | LBS_NOREDRAW |
	WS_VISIBLE | WS_BORDER | WS_VSCROLL | WS_CHILD,
        0, 0, Rect.right-Rect.left, Rect.bottom-Rect.top,
	hWindow,
	IDC_LIST,    //IDC
	hInstance,
	NULL);

    if (!hListWnd) {
	DestroyWindow(hWindow);
	return (NULL);
    }

    ShowWindow(hWindow, nCmdShow);
    UpdateWindow(hWindow);

    hFont=GetStockObject(SYSTEM_FIXED_FONT);
    SendMessage(hListWnd, WM_SETFONT, (WPARAM) hFont, TRUE);

    return TRUE;
}

int WINAPI WinMain (
    HINSTANCE hInst,
    HINSTANCE hPrevInst,
    LPSTR lpszCmdParam,
    int nCmdShow)
{
    MSG msg;

    hInstance = hInst;
    if (!InitApplication(hInstance)) {
	MessageBox(NULL,"register class",NULL,MB_OK);
	return (FALSE);
    }
    if (!InitInstance(hInstance, nCmdShow)) {
	MessageBox(NULL,"create window",NULL,MB_OK);
	return (FALSE);
    }

    while (GetMessage(&msg, NULL, 0, 0)) {
	TranslateMessage(&msg);
	DispatchMessage(&msg);
    }
    return msg.wParam;
}
