--------------------------------------------------------------------------------
INSTALL.TXT	    DPMI-RSX  (c) Rainer Schnitker		     03/1995
--------------------------------------------------------------------------------

This file contains information about:

	* Hardware Requirements
	* Software Requirements
	* Create more DPMI memory
	* Install for EMX
	* Install for DJGPP
	* RSX, the DPMI extender
	* Command line switches like EMX (changed!)
	* Command line switches for RSX (changed!)
	* enable gcc -pipe
	* emtex TeX386 / stack faults
	* Major bugs in tested DPMI-hosts
	* Patch for next EMX-Update
	* Error messages from RSX



    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.



--------------------------------------------------------------------------------



Hardware Requirements:
----------------------

- RSX requires a 386SX-CPU (or higher)

  (A 387 coprocessor is not necessary, because RSX emulates it)




Software Requirements:
----------------------

- A DPMI 0.9/1.0 - Server like:

	MS-Windows 3.1 enhanced mode

	QEMM386 + QDPMI

	386MAX 6.x, 7.x

	OS/2 2.x, 3.0 (Warp)

	MS-Windows NT

	CWSDPMI (free, with source code)


  To use the 387-emulator the DPMI-server must provide DPMI 1.0 floating-point
  extensions (most 0.9 server support this).

  ** Otherwise (on crashes), you should use the -Re0 option **


- DOS 3.3+ or DOS box emulation

- A GNU-C port for DOS (EMX 0.8 or DJGPP 1.xx)

  or any EMX program that should run under DPMI (like TeX386 beta11).




Create more DPMI memory:
------------------------

If your GCC program (TeX386, gcc.exe) runs out of memory,
you should read this section.

(Now there is also a RSX option '-Rm' to prealloc memory)


MS-Windows 3.1:
    If you have enough memory or a permanent swapfile and you run Windows
    a long time, try to restart Windows. Perhaps other programs destroy
    memory blocks.

    1) Increase or install a *permanent* Swapfile (Control Panel / 386).

    Without a permanent Swapfile, you can't run TeX386 from emTeX, if you
    have only 4 MB physical memory. (TeX message "DYN: out of memory").
    Also Windows uses more virtuel memory with '32bit access'.

    If you can't increase the swapfile, you can set the value PageOverCommit
    in the system.ini [386Enh] section, insert
	PageOverCommit=8
    the default value is 4. Restart Windows.
    After that, you should increase the permanent Swapfile again.

      [ PageOverCommit=value:
      Specifies the multiplier for determining the amount of linear address
      space. The amount of linear address space is computed by rounding up the
      amount of available physical memory to the nearest 4 megabytes and then
      by multiplying that value to the value specified for this setting. ]

    2) Also you can create a smaller DOS-Box. PIF-settings:
	- 350 KB DOS memory maximum
	- EMS=0 ; XMS=0 ; no High-Memory-Area


386MAX 7.0:
    To increase memory you must have a SWAPFILE line in your 386MAX.PRO file
	SWAPFILE=C:\386MAX\386MAX.swp /S=8192
    This creates a 8 MB swapfile. The size of the virtual swapfile is the
    amount of virtual memory available to your applications.

QEMM + QDPMI:
    Set the environment QDPMI to something like
	QDPMI=SWAPFILE c:\tmp\qdpmi.swp 8192
    This creates a 8 MB swapfile. The sum of the value of availble memory and
    the size of the virtual swapfile is the amount of virtual memory available
    to your applications.

OS/2:
    DOS settings:
    DPMI_DOS_API	AUTO		(default: auto)
    DPMI_MEMORY_LIMIT	8-16 MB 	(default: only 4 MB (Warp V3))
    EMS,XMS		is not needed
    DOS FILES		40-100		(default: only 20)

    You should increase DPMI_MEMORY_LIMIT.



INSTALL for EMX programs:
-------------------------

    Set the environment varaible RSX to:
	RSX = C:\RSX\BIN\RSX.EXE.

    If the EMX program stub detects only DPMI (Windows and OS/2 DOS box),
    it must find rsx.exe in the PATH statement or the environment variable RSX.

    If the emx stub finds a VCPI server (himem.sys + emm386, qemm386, max)
    it tries to run emx.exe. You should set the EMX environment.
	EMX = C:\EMX\BIN\EMX.EXE

    This works with the emx stub (emxl.exe) from EMX version 0.8h or higher.

    If there is no coprocessor, rsx emulates all coprocessor instructions
    by default. You can overide this with the '-Re' option.

    That's it!


Notes:
    (a)
	If you always want to run rsx.exe instead of emx.exe, you should set
	EMX to RSX:
	    RSX = C:\RSX\BIN\RSX.EXE.
	    EMX = C:\RSX\BIN\RSX.EXE.

	If you have no coprocessor and you want run the gcc compiler
	this method is recommend. Also you can use the stub
	\rsx\bin\emxldpmi.exe.	This stub runs always RSX, if there
	is a DPMI-server.

    (b)
	Note that the default stack is 256 KB. If you need more space, use
	the -s option to grow the stack, or set a environment-var RSXOPT.
	Example: RSXOPT=-Rs512 sets the stack to 512 Kbytes.
	(see * Command line switches for RSX)



INSTALL for DJGPP:
------------------

1)  Bound executable must find RSX.EXE in the PATH or current directory.
    Copy the binary files from \rsx\bin to your \djgpp\bin directory.
    Or change the PATH to \rsx\bin.

3)  Creating bound executable:
    a) For go32 version 1.11 you can use the tools coff2exe, stubedit.
    To create a gcc compiler for RSX.EXE do this:
	C:\GCC\BIN> xcopy gcc.exe gccdpmi.exe
	C:\GCC\BIN> stubedit gccdpmi.exe extender=rsx

    b) for older versions:
    You must use the new stub STUBDJ.EXE to create bound executable. The
    program BINDDJ puts a stub and the a.out program together:

	> BINDDJ stubdj.exe myfile myfile.exe

    Stubdj executes RSX if a DPMI-server is there, and go32.exe if there is no
    DPMI-server. To change the gcc compiler exe-stub, use EXE2AOUT from djgpp
    to get the a.out file and use the BINDDJ command to create the new stub.

    Example:
	C:\GCC\BIN> exe2aout gcc.exe
	C:\GCC\BIN> binddj stubdj.exe gcc gccd.exe (copy stubdj+gcc gccd.exe)


[4] LIBRSX.A
    If you want to use signals(), ptrace(), wait(), etc. you must copy
    the library 'librsx.a' from \rsx\source\djlibrsx to your \djgpp\lib.

    Read the file 'readme' in the \rsx\source\djlibrsx to build and install
    this futures.



RSX the DPMI extender:
----------------------

RSX is compiled with EMX+GCC and doesn't use the EMX C-Library.
Also RSX is linked with the FPU-EMU.

In the previous version rsx.exe was a 16bit program and rsx32.exe
the 32bit program. The names are changed.
The 16bit executable was deleted.



Command line switches for RSX:
------------------------------

Syntax:
	RSX [options] a.out-file

You can put command-line switches in the RSXOPT environment variable.

    Example:  SET RSXOPT=-c -h60
	    This disables writing a core file
	    and sets DOS handles

Also RSX reads options from emxbind (rsxopt).

    Example:
	    emxbind -a gcc.exe -Rx
	    rsxopt -a gcc.exe -Rx
	This enable RSX pipe/schedule futures (for 'gcc -pipe')


Most switches are EMX compatible. Special RSX switches can be used
with '-R'. The emxbind version (EMX 0.9) will support '-R'.

There is also a new program called 'rsxopt', which writes options
in the bound emx-exe file.



Command line switches like EMX:
-------------------------------

This options can be used with emxbind (rsxopt).


-a[cmwi] enable some DOS features (like EMX):
     -ac makes data and the stack executable (default now, RSX 4)
     -am enable _memaccess() (for writing 0xA0000h-0xFFFFFh)
	 This option destroy protection under RSX with DPMI 0.9
	 (see source sysemx.c/loadprg.c)
	 Under DPMI 1.0 the first DOS megabyte is mapped after
	 the stack space.
     -aw enables write access to all areas
	 DPMI 0.9 don't allow write protection
     -ai enables _portaccess() for EMX,
	 RSX ignore this (DPMI-Server allow/emulate this)


-c   disable core dumps


-h#  set DOS file handle limit to #.


-p   for EMX: don't use all low DOS memory (ignored for rsx).



others (not emxbind):

-e   !!Changed!! Disabling the FPU emulator needs -Re.

-V   Display RSX version




Command line switches for RSX:
------------------------------


All RSX options must begin with -R.

Syntax:
	a)  -Ropt1opt2opt3	      (short form)
	b)  -R,opt1,opt2,opt3	      (',' are ignored)
	c)  -Ropt1 -Ropt2 -Ropt3      (repeat -R)

	method (c) cannot used with emxbind, use rsxopt instead


Examples:
	RSX -Re0x
	RSX -R,e0,m1024,x
	RSX -R9 -Rx -Rs


RSX options:

a   Don't use expand-down stacksegment, ss = data segment.

    RSX uses expand-down stack-segments to control the stack. But some
    gcc-programs uses the EBP register for a pointer in the data-segment.
    This causes a stack-fault. Don't use gcc -fomit-frame-pointer.

    RSX default program layout:

    |-------|---code---|---data/bss---|----<<stack-------|--heap--
	 <no access esp,ebp>	      ^lower limit expand-down


    TeX386 must use the -Ra option.
    Example:
	emxbind -a tex386.exe -Ra
	rsxopt	-a tex386.exe -Ra


e    Don't use 387 emulation / don't change FPU status with coprocessor.

     Under RSX this disables loading 387 emulation if you have no coprocessor.
     On floating point instructions, the program will terminated with signal
     SIGFPE (this is like -e2).

     With a coprocessor the status is not saved between processes.
     There are no DPMI calls for the 387 (for buggy dpmi host).


e[0-3]

     force the fpu-status:

     Bit     Significance
     0	     new value of MPv bit for client's virtual CR0
	     0 = disable numeric coprocessor for this client
	     1 = enable numeric coprocessor for this client
     1	     new value of EMv bit for client's virtual CR0
	     0 = client will not supply coprocessor emulation
	     1 = client will supply coprocessor emulation

     This means for RSX:

     e1: enable FPU, don'emulate                    [if you have a 387,487,..]
     e2: disable FPU, but catch FPU instructions    [set if no 387 is present]
     e3: enable FPU, emulate FPU instructions	    [emulate all FPU instr]

     e0: RSX does nothing, the default DPMI-host FPU status is used.

	If your DPMI-host crash after terminating the emx-program, try -Re0
	(Novell DOS 7.0 EMM386, reported from QEMM 7.x)

	This option should also used, if the host does not support
	to set the FPU status.


s#   set stack size in KB

     default:  256 KB under DPMI 0.9

     Under DPMI 1.0 the stack grows from 60 MB to the heap
     The stack size is ignored.



m#
    Prealloc memory for heap. This option is useful for:

	- reduce realloc heap calls to DPMI host

	- if DPMI realloc is buggy
	  perhaps for problems with emtex386 in the Windows DOS box

	- memaccess()
	  Growing the heap can change the base address of the program (OS/2).
	  Then the memaccess() pointer is *not* valid.
	  Prealloc enough memory.
	  There is a default prealloc value (128 KB), if you use
	  use the 'enable memaccess' option.

    Example:  -Rm1024 (prealloc 1 MB heap)


x   enable scheduler, needed for 'gcc -pipe'

O   set OS/2 bit; needed for pipe with emx0.8x


z   Zero the heap. Memory from malloc() in not filled with zeros by default.

9   Force DPMI 0.9 services
    If you have problems with your DPMI 1.0 server, use this option

1   Use also DPMI 1.0 services
    Only 386MAX 7 support this option


Debug/testing options:

F   print all output in a file called RSX.LOG
    Also useful for graphic programs.

I   print all int 0x21 calls

P   print some extra information
    print registers after exception

K   kernel debug mode (see also KRNLDEB.TXT)
    It is possible to debug RSX (32bit) with GDB



Enable gcc -pipe:
-----------------

You can use emxbind (emx 0.9) or rsxopt:

    Example:
	    emxbind -a gcc.exe -Rx
	    rsxopt -a gcc.exe -Rx
	This enable RSX pipe/schedule futures (for 'gcc -pipe')

This option (-Rx) is beta. Please report bugs to the author.

Also you can set:
	RSXOPT=-Rx

It's better to bind the option into the exefile. The RSXOPT environment
variable will be used for all programs and perhaps one program does not
run with '-Rx'.

If you run the 0.8x emx package you must also set set OS/2 flag for gcc
    '-RO' : set OS/2 environment flag



emtex TeX386 / stack faults:
----------------------------

RSX controls the stack with a expand-down stack segment.
TeX386 versions were compiled with the gcc option '-fomit-frame-pointer'.
This option can cause a stack fault, if gcc uses the frame pointer for
a normal pointer.

There are two options for RSX:
    * -Ra    (set ss=ds, no expand-down)
    * -Rs#   (set stack size. If stack_size <= 60, the fault does not happen)

You can use rsxopt to put the first option in the tex386 file (emxrt 0.9).
    Example:
	    rsxopt -a \emtex\tex386.exe -Ra




Major bugs in tested hosts :
----------------------------

    MS-Windows 3.1
	- problems with TeX386 memory calls (-Rm option)
	- debug handler different (but RSX can handle this)

    386MAX 7.00 (DPMI1.0 server: support demand paging with rsx)
	- ResizeLinearMemory bug (RSX don't use this)

    386MAX 6.00
	- RSX Control-C handler will never called
	- (no virtuel memory)

    QEMM + QDPMI 1.01  [ QEMM 7.xx not tested ]
	- page faults terminates program
	- QDPMI virtuel memory error after memory resize fails (page fault)
	  (happened in GDB.EXE)

    Novell DOS 7.0 EMM386
	- crash on DPMI 1.0 calls -> 387 emulation is not possible
	  you *must* use the '-e0' option

    OS/2 2.x / Warp V3
	- DPMI int 0x31 doesn't switch stacks (bad for RSX version <= 3)
	- problems with memaccess()	    (use option -Rm)
	- system crash for some dpmi 1.0 calls

    NT (not tested, TeX386b11 should run)
	- you must use the '-e0' or '-e' option



Patch for next EMX-Update:
--------------------------

If you upgrade a new EMX version (maybe emx0.9b ?), you always get a warning
message, if you run the rsx.exe file.

Now you can patch the RSX.EXE file:

	Take a good hexdump-editor
	Load RSX.EXE
	Search for reversed version number "a9.0"
	Change this value
	Save RSX.EXE



Error messages from RSX:
------------------------

"No DPMI-host found!"
    There is no DPMI-server. Use EMX instead.

"32bit programs not supported"
    The DPMI-server supports only 16-bit programs. You can't use RSX.

"Can't alloc memory for the DPMI-host-stack"
    The DPMI-server needs some DOS memory for RSX.
    Do you have enough DOS memory?

"can't switch to Protected Mode"
    DPMI-server can't switch RSX in Protected Mode.
    Do you have enough extended memory?

"No DPMI-server 387 support", "use -e option"
    DPMI-server doesn't support a coprocessor. Use 'RSX -e0 prog' or set
    the environment 'RSXOPT=-e0'.

"error:can't get int21", "error:can't set int21"
    RSX can't change the interrupt vector 0x21.

"error: not a valid PSP option -/xxxx/\n"
    EMXBIND error in bound executable.

"Can't find RSX387"
    Set the environment RSX387 like RSX387=c:\rsx\fpu-emu\rsx387

"Can't load emu: "
    Not enough memory for 387 emulator. Try -p option or increase DOS
    memory.

"rsx_32 loader error:"
    The rsx stub can't load the 32bit extender (RSX.EXE).
    Possible errors:
	"No DPMI-host found!"
	"Can't alloc memory for the DPMI-host-stack"
	"can't switch to Protected Mode"
	"realloc memory error"

for emTeX386 users: "DYN: out of memory"
    is a TeX message, increase your DPMI memory (section 3).
    Since TeX386 uses a big heap (3-4 MB), a permanent swapfile in Windows
    is recommend with only 4MB installed.

