@ECHO OFF
REM PlanMap II Multi-ship battle simulation batch file.
REM A.M. van den Bos, July 1994. Version 2.02.

IF EXIST PLANETS.EXE GOTO LABEL1
ECHO Error: The default directory must be your VGA Planets directory.
PAUSE
GOTO EXIT

:LABEL1
IF EXIST sim\base\GEN.HST GOTO LABEL2
ECHO                        PlanMap II Battle Simulation
ECHO:
ECHO This batch file must be run from MS Windows and requires MS DOS 6.
ECHO Simulation directories SIM and SIM\BASE will be created.
ECHO MASTER.EXE will be runned to setup the SIM\BASE directory.
ECHO Select 'wandering tribes' and the default races.
PAUSE
MD SIM
MD SIM\BASE
ECHO y | DEL SIM\BASE >NUL
MASTER SIM\BASE
GOTO LABEL2

:REPEAT
ECHO y | DEL SIM >NUL
XCopy SIM\BASE SIM >NUL
Copy  SIM\BASE\SHIP.TMP SIM\SHIP.HST >NUL
ECHO:
GOTO LABEL3

:LABEL2
ECHO y | DEL SIM >NUL
CLS
XCOPY SIM\BASE SIM >NUL
ECHO                        PlanMap II Battle Simulation
ECHO:
ECHO Press Alt-TAB to switch to MS Windows. Run PlanMap, set the HOST-directory to
ECHO SIM and enter the PlanMap HOST-mode. Select and save the desired ships and
ECHO return to this bath file (Alt-TAB). Be aware of the friendly codes, IDs and
ECHO race advantages. Be sure about the HOST version and the HOST options.
ECHO Remove ships that don't participate in the battle.
ECHO:
PAUSE
ECHO:
Copy SIM\SHIP.HST SIM\BASE\SHIP.TMP >NUL

:LABEL3
If NOT EXIST COPYXY.EXE GOTO RUNHOST
ECHO Update galaxy...
COPYXY SIM
:RUNHOST
ECHO Running HOST.EXE .......
HOST SIM >NUL

REM  Use VPUTIL if possible
IF EXIST VPUTIL.EXE GOTO UNPACK1
UNPACK  SIM >NUL
GOTO UNPACK2
:UNPACK1
ECHO Unpacking result files using VPUTIL.......
VPUTIL un -wSim >NUL
:UNPACK2
PLANETS SIM
CLS

CHOICE /C:RYN "Another simulation (Y/N) or repeat simulation (R) "
IF ERRORLEVEL 3 GOTO EXIT
IF ERRORLEVEL 2 GOTO LABEL2
IF ERRORLEVEL 1 GOTO REPEAT

:EXIT
