/***********************************************************************\
 *                                 PC2.c                               *
 *          Copyright (C) by Stangl Roman, 1993, 1994, 1995            *
 *                                                                     *
 * This Code may be freely distributed, provided the Copyright isn't   *
 * removed.                                                            *
 *                                                                     *
 * Install.cmd  Installation batch file.                               *
 *                                                                     *
\***********************************************************************/

/* static char RCSID[]="@(#) $Header: Install.cmd Version 1.90 05,1995 $ (LBL)" */

                                        /* Register REXX APIs */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

Call On Halt Name SignalHandler         /* CTRL+BREAK signal handler that just ignores any
                                           CTRL+BREAK signal */


                                        /* Get optional commandline parameters */
Parse Upper Arg Arg1 Arg2 Arg3 Arg4 Arg5 .
                                        /* Get the full qualified path of our installation
                                           we are running now */
Parse Upper Source . . InstallationFileName
                                        /* Now extract drive and path info terminated
                                           by a backslash */
SourceDirectory=FileSpec('Drive', InstallationFileName)||FileSpec('Path', InstallationFileName)
                                        /* Get \OS2\ directory of boot drive */
OS2Directory=FileSpec('Drive',Value('SYSTEM_INI', , 'OS2ENVIRONMENT'))||'\OS2\'

Call AnsiSetup                          /* Setup ANSI colors */
Say LWhi||BBlu'Abcd'                    /* Set highlighted white on blue */
'@Cls'                                  /* Clear screen to set new color */


                                        /* Ask user what he wants to do, or take
                                           the first commandline arguement when
                                           possible */
InstallationOption=Arg1
If InstallationOption\="I" & InstallationOption\="U" & InstallationOption\="D" & InstallationOption\="P"
    Then Do
    InstallationOption=InstallationMainPanel()
    End
Select
                                        /* If the user wants to quit exit */
    When InstallationOption="Q" Then
        Do
        End
                                        /* If the user wants to install/update PC/2
                                           then get the destination directory, prompt
                                           the user for PC/2, WPS 2 PC/2 or both, update
                                           the files and inform the user */
    When InstallationOption="I" Then
        Do
                                        /* Get the destination directory */
        DestinationDirectory=Arg2
        DestinationDirectory=GetDestinationDirectory(DestinationDirectory)
                                        /* If the user entered QUIT as the destination
                                           directory, because he has to deinstall a
                                           running version of PC/2 first exit */
        If DestinationDirectory="QUIT" Then
            Exit
                                            /* Add terminating backslash */
        DestinationDirectory=DestinationDirectory||"\"
                                        /* Now get the package of PC/2 to install,
                                           either PC/2 (P), WPS 2 PC/2 (W) or both (B) */
        SubPackageSelected=Arg3
        SubPackageSelected=GetSubPackage2Install(SubPackageSelected)
                                        /* Now copy files from current directory to
                                           destination directory */
        CopySuccess=InstallFiles(SubPackageSelected, SourceDirectory, DestinationDirectory, OS2Directory)
                                        /* Ask user for -SingleClickFlag */
        SingleClickFlag=Arg4
        SingleClickFlag=QueryOptions(SingleClickFlag)
                                        /* Now recreate WPS Objects */
        Ignore=CreateWPSObjects(InstallationOption, SubPackageSelected, DestinationDirectory, OS2Directory, SingleClickFlag)
                                        /* Inform user about some usefull things */
        FAQFlag=Arg5
        Ignore=DisplayHint(FAQFlag)
        End
                                        /* If the user wants to recreate the WPS
                                           Objects of the PC/2 package prompt user
                                           for PC/2, WPS 2 PC/2 or both */
    When InstallationOption="U" Then
        Do
                                        /* Now get the package of PC/2 to install,
                                           either PC/2 (P), WPS 2 PC/2 (W) or both (B) */
        SubPackageSelected=Arg3
        SubPackageSelected=GetSubPackage2Install(SubPackageSelected)
                                        /* Ask user for -SingleClickFlag */
        If (SubPackageSelected="P" | SubPackageSelected="B") Then
            Do
            SingleClickFlag=Arg4
            SingleClickFlag=QueryOptions(SingleClickFlag)
            End
        Else
            SingleClickFlag=""
                                        /* Now recreate WPS Objects */
        Ignore=CreateWPSObjects(InstallationOption, SubPackageSelected, SourceDirectory, OS2Directory, SingleClickFlag)
        End
                                        /* If the user wants to delete the WPS program Objects
                                           for PC/2 and WPS 2 PC/2 destroy them */
    When InstallationOption="D" Then
        Do
        Ignore=DeleteWPSObjects("B")
        End
                                        /* If the user wants to delete all files, delete them */
    When InstallationOption="P" Then
        Do
                                        /* Purge all PC/2 files in the current directory and all
                                           WPS 2 PC/2 files in the \OS2\ subdirectory */
        Ignore=PurgeFiles(SourceDirectory, OS2Directory)
        End
End
                                        /* Change to the drive where we installed from */
Command="@"Filespec("Drive", SourceDirectory)" >NUL"
Command
                                        /* Change in the directory */
Command="@CD "Strip(Filespec("Path", SourceDirectory), T, "\")" >NUL"
Command
Say LWhi
Say "   And now - enjoy!- And now - enjoy!- And now - enjoy!- And now - enjoy!"
Say Non||Whi||BBla
Exit

/*--------------------------------------------------------------------------------------*\
 * Setup ANSI colors                                                                    *
 * Req:                                                                                 *
 *      none                                                                            *
 * Returns:                                                                             *
 *      none                                                                            *
\*--------------------------------------------------------------------------------------*/
AnsiSetup:
                                        /* ANSI control */
Esc=d2c(27)d2c(91)
                                        /* Attributes */
Bli=esc'5m'
Hig=esc'1m'
Non=esc'0m'
                                        /* Foreground colors */
Bla=esc'30m'
Red=esc'31m'
Gre=esc'32m'
Bro=esc'33m'
Blu=esc'34m'
Cya=esc'35m'
Tur=esc'36m'
Whi=esc'37m'
LBla=Hig||esc'30m'
LRed=Hig||esc'31m'
LGre=Hig||esc'32m'
LBro=Hig||esc'33m'
LBlu=Hig||esc'34m'
LCya=Hig||esc'35m'
LTur=Hig||esc'36m'
LWhi=Hig||esc'37m'
                                        /* Background colors */
BBla=esc'40m'
BRed=esc'41m'
BGre=esc'42m'
BBro=esc'43m'
BBlu=esc'44m'
BCya=esc'45m'
BTur=esc'46m'
BWhi=esc'47m'
Return

/*--------------------------------------------------------------------------------------*\
 * Copy files from current directory to destination directory                           *
 * Req:                                                                                 *
 *      FileName ...... File to copy                                                    *
 *      CopyDirectory . Directory to copy to                                            *
 * Returns:                                                                             *
 *      Success ....... TRUE/FALSE                                                      *
\*--------------------------------------------------------------------------------------*/
FileCopy: Arg FileName, CopyDirectory1, CopyDirectory2
Success="TRUE"
Parse Value SysCurPos() with Row Col
If CopyDirectory2="" Then
    Do
    Say " Copying "FileName" to "CopyDirectory1
    Command='@Copy 'FileName' 'CopyDirectory1' /v >NUL 2>NUL'
    Command
    If rc\=0 Then
        Success="FALSE"
    End
Else
    Do
    Say " Copying "FileName" to "CopyDirectory1" , "CopyDirectory2
    Command='@Copy 'FileName' 'CopyDirectory1' /v >NUL 2>NUL'
    Command
    If rc\=0 Then
        Success="FALSE"
    Command='@Copy 'FileName' 'CopyDirectory2' /v >NUL 2>NUL'
    Command
    If rc\=0 Then
        Success="FALSE"
    End
Col=Col+60
Call SysCurPos Row, Col
If Success="TRUE" Then
    Say "Copied"
Else
    Say LBro"Failed"LWhi
Return Success

/*--------------------------------------------------------------------------------------*\
 * Delete files at the source directory.                                                *
 * Req:                                                                                 *
 *      FileName ...... File to delete                                                  *
 *      DeleteDirectory Directory to delete from                                        *
 * Returns:                                                                             *
 *      Success ....... TRUE/FALSE                                                      *
\*--------------------------------------------------------------------------------------*/
FileDelete: Arg FileName, DeleteDirectory1, DeleteDirectory2
Success="TRUE"
Parse Value SysCurPos() with Row Col
If DeleteDirectory2="" Then
    Do
    Say " Deleting "FileName" from "DeleteDirectory1
    Command='@Del 'DeleteDirectory1||FileName' >NUL 2>NUL'
    Command
    If rc\=0 Then
        Success="FALSE"
    End
Else
    Do
    Say " Deleting "FileName" from "DeleteDirectory1" , "DeleteDirectory2
    Command='@Del 'DeleteDirectory1||FileName' >NUL 2>NUL'
    Command
    If rc\=0 Then
        Success="FALSE"
    Command='@Del 'DeleteDirectory2||FileName' >NUL 2>NUL'
    Command
    If rc\=0 Then
        Success="FALSE"
    End
Col=Col+60
Call SysCurPos Row, Col
If Success="TRUE" Then
    Say "Deleted"
Else
    Say LBro"Failed"LWhi
Return Success

/*--------------------------------------------------------------------------------------*\
 * Display the logo lines                                                               *
 * Req:                                                                                 *
 *      none                                                                            *
 * Returns:                                                                             *
 *      none                                                                            *
\*--------------------------------------------------------------------------------------*/
DisplayLogo:
Say LWhi||BBlu
'@Cls'
Say
Say "                 "LRed"PC/2 - Program Commander/2 Version 1.90 for"LWhi
Say "                    "LRed"IBM OS/2 2.x, 3.x Presentation Manager"LWhi
Say "                    "LRed"Copyright (C) by Stangl Roman 05, 1995"LWhi
Return

/*--------------------------------------------------------------------------------------*\
 * Display the the main panel of PC/2's installation.                                   *
 * Req:                                                                                 *
 *      DisplayLogo                                                                     *
 * Returns:                                                                             *
 *      I/D/P/Q                                                                         *
\*--------------------------------------------------------------------------------------*/
InstallationMainPanel:
Do Until (InstallationOption="I" | InstallationOption="U" | InstallationOption="D" | InstallationOption="P" | InstallationOption="Q")
    Call DisplayLogo
    Say
    Say " "LGre"I"LWhi" ... Select this choice to install a new version, or to update an existing"
    Say "       version of the "LRed"PC/2"LWhi" package (containing the subpackages "LRed"PC/2"LWhi" and "
    Say "       "LRed"WPS 2 PC/2"LWhi") on your system."
    Say
    Say " "LGre"U"LWhi" ... Select this option to recreate accidentially deleted WPS program"
    Say "       Objects for "LRed"PC/2"LWhi" and/or "LRed"WPS 2 PC/2"LWhi" programs on your Desktop."
    Say
    Say " "LGre"D"LWhi" ... Select this choice to delete the WPS Objects created by the "LRed"PC/2"LWhi
    Say "       Installation program. After deleting these Objects some files are locked"
    Say "       until the next reboot. Therefore after the next reboot you may want to"
    Say "       continue with the "LGre"P"LWhi"urge option, to completely remove the files from"
    Say "       your disk."
    Say
    Say " "LGre"P"LWhi" ... Select this choice to delete all files of the "LRed"PC/2"LWhi" package from your"
    Say "       disk."
    Say
    Say " "LGre"Q"LWhi" ... Quit Installation without any changes."
    Say
    Parse Value SysCurPos() with Row Col
    Say " Please enter your selection and press the Enter key:"LGre
                                            /* Prompt the user for a selection and
                                               return it */
    Col=Col+54
    Call SysCurPos Row, Col
    Pull InstallationOption
End
Return InstallationOption

/*--------------------------------------------------------------------------------------*\
 * Request the directory to install PC/2 into and create it.                            *
 * Req:                                                                                 *
 *      DisplayLogo                                                                     *
 * Returns:                                                                             *
 *      Directory to copy PC/2's files into                                             *
\*--------------------------------------------------------------------------------------*/
GetDestinationDirectory: Arg DestinationDirectory
If DestinationDirectory\="" Then
    Do
                                            /* Test for installation directory */
    Call SysFileTree DestinationDirectory, FileDirectory, 'D'
    If FileDirectory.0='0' Then
        Do
                                            /* Make the installation directory */
        Rc=SysMkDir(DestinationDirectory)
        If Rc\=0 Then
            DestinationDirectory=""
        End
    End
Do While DestinationDirectory=""
    Call DisplayLogo
    Say
    Say " You selected to install a new version, or update and existing version of "LRed"PC/2"LWhi"."
    Say
    Say " If a version of "LRed"PC/2"LWhi" is currently running, then please close it now."
    Say " If you have already installed "LRed"WPS 2 PC/2"LWhi" please run the deinstallation"
    Say " process of that version. These steps are required, because otherwise files"
    Say " that are going to be updated are locked."
    Say
    Say " If you are ready to continue installation, please enter the destination "
    Say " directory to install "LRed"PC/2"LWhi" into, or enter "LGre"Quit"LWhi" to abort installation."
    Say
    Say " As "LRed"PC/2"LWhi" does not require any changes in Config.sys, a unique directory is"
    Say " suggested."
    Say
    Say " Example for destination directory: "LGre"C:\PMAPPS\PC2"LWhi
    Say
    Parse Value SysCurPos() with Row Col
    Say " Please input destination directory: "LGre
    Col=Col+37
    Call SysCurPos Row, Col
    Pull DestinationDirectory
                                            /* Test for installation directory */
    Call SysFileTree DestinationDirectory, FileDirectory, 'D'
    If FileDirectory.0='0' Then
        Do
                                            /* Make the installation directory */
        Rc=SysMkDir(DestinationDirectory)
        If Rc\=0 Then
            Do
            Say LBro
            Say " "LBro"Sorry, the desired directory couldn't be created, please correct your"
            Parse Value SysCurPos() with Row Col
            Say " input! Press any key to retry."
            Col=Col+32
            Call SysCurPos Row, Col
            Pull Ignore
            DestinationDirectory=""
            End
    End
End
Return DestinationDirectory

/*--------------------------------------------------------------------------------------*\
 * Prompt the user for the PC/2 subpackage to install/recreate. This may be PC/2,       *
 * WPS 2 PC/2 or both.                                                                  *
 * Req:                                                                                 *
 *      DisplayLogo                                                                     *
 * Returns:                                                                             *
 *      P/W/B                                                                           *
\*--------------------------------------------------------------------------------------*/
GetSubPackage2Install: Arg SubPackageSelected
Call DisplayLogo
Do While (SubPackageSelected\="P" & SubPackageSelected\="W" & SubPackageSelected\="B")
    Call DisplayLogo
    Say
    Say " "LGre"P"LWhi" ... Install or update "LRed"PC/2"LWhi
    Say
    Say "       Select this choice to install/recreate the "LRed"PC/2"LWhi" WPS program"
    Say "       Object of the "LRed"PC/2"LWhi" package."
    Say
    Say " "LGre"W"LWhi" ... Install or update "LRed"WPS 2 PC/2"LWhi
    Say
    Say "       Select this choice to install/recreate the "LRed"WPS 2 PC2"LWhi" WPS"
    Say "       program Object of the WPS of the "LRed"PC/2"LWhi" package."
    Say
    Say " "LGre"B"LWhi" ... Install or update both programs"
    Say
    Say "       Select this choice to install/recreate both program objects onto the"
    Say "       WPS."
    Say
    Parse Value SysCurPos() with Row Col
    Say " Please enter your selection and press the Enter key:"LGre
                                            /* Prompt the user for a selection and
                                               return it */
    Col=Col+54
    Call SysCurPos Row, Col
    Pull SubPackageSelected
End
Return SubPackageSelected

/*--------------------------------------------------------------------------------------*\
 * Copy all required files to the installation destination directory, Take care not to  *
 * overwrite a PC2.cfg configuration file.                                              *
 * Req:                                                                                 *
 *      DisplayLogo                                                                     *
 * Returns:                                                                             *
 *      Success ....... TRUE/FALSE                                                      *
\*--------------------------------------------------------------------------------------*/
InstallFiles: Arg SubPackageSelected, SourceDirectory, DestinationDirectory, OS2Directory
CopySuccess="TRUE"
                                        /* Now copy files */
Call DisplayLogo
Say
Say " Now copying files..."
Say
If (SubPackageSelected="P" | SubPackageSelected="B") Then
    Do
    If FileCopy(PC2.EXE, DestinationDirectory)="FALSE" Then
        CopySuccess="FALSE"
    If FileCopy(PC2SLOW.EXE, DestinationDirectory)="FALSE" Then
        CopySuccess="FALSE"
    If FileCopy(PC2HOOK.DLL, DestinationDirectory)="FALSE" Then
        CopySuccess="FALSE"
    If FileCopy(PC2SPOOL.DLL, DestinationDirectory)="FALSE" Then
        CopySuccess="FALSE"
    If FileCopy(PC2.HLP, DestinationDirectory)="FALSE" Then
        CopySuccess="FALSE"
    If FileCopy(PC2.DOC, DestinationDirectory)="FALSE" Then
        CopySuccess="FALSE"
    If FileCopy(PC2.FAQ, DestinationDirectory)="FALSE" Then
        CopySuccess="FALSE"
    If FileCopy(INSTALL.CMD, DestinationDirectory)="FALSE" Then
        CopySuccess="FALSE"
    If FileCopy(SMALLFNT.CMD, DestinationDirectory)="FALSE" Then
        CopySuccess="FALSE"
    If FileCopy(SYSLEVEL.PC2, DestinationDirectory)="FALSE" Then
        CopySuccess="FALSE"
    If FileCopy(DEMOCFG.ZIP, DestinationDirectory)="FALSE" Then
        CopySuccess="FALSE"
    If FileCopy(SOURCE.ZIP, DestinationDirectory)="FALSE" Then
        CopySuccess="FALSE"
                                        /* Test for existing PC2.cfg */
    Call SysFileTree DestinationDirectory||"PC2.cfg", File, 'F'
    If File.0='0' Then
        Do
        If FileCopy(PC2.cfg, DestinationDirectory)="FALSE" Then
            CopySuccess="FALSE"
        End
    Else
        Do
        Parse Value SysCurPos() with Row Col
        Say " Found existing PC2.CFG at "DestinationDirectory
        Col=Col+60
        Call SysCurPos Row, Col
        Say LBro"Skipped"LWhi
        End
                                        /* Test for existing PC2.ini */
    Call SysFileTree DestinationDirectory||"PC2.ini", File, 'F'
    If File.0='0' Then
        Do
        If FileCopy(PC2.ini, DestinationDirectory)="FALSE" Then
            CopySuccess="FALSE"
        End
    Else
        Do
        Parse Value SysCurPos() with Row Col
        Say " Found existing PC2.INI at "DestinationDirectory
        Col=Col+60
        Call SysCurPos Row, Col
        Say LBro"Skipped"LWhi
        End
    End
If (SubPackageSelected="W" | SubPackageSelected="B") Then
    Do
    If FileCopy(WPS2PC2.DLL, DestinationDirectory, OS2Directory||"DLL\")="FALSE" Then
        CopySuccess="FALSE"
    If FileCopy(WPS2PC2.HLP, DestinationDirectory, OS2Directory||"HELP\")="FALSE" Then
        CopySuccess="FALSE"
    End
                                        /* On error wait for user acknowledgement */
If CopySuccess="FALSE" Then
    Do
    Say
    Parse Value SysCurPos() with Row Col
    Say " Press any key to continue..."
    Col=Col+30
    Call SysCurPos Row, Col
    Pull Ignore
    End
Return CopySuccess

/*--------------------------------------------------------------------------------------*\
 * Ask the user for the -SingleClick flag instead of the default DoubleClick.           *
 * Req:                                                                                 *
 *      DisplayLogo                                                                     *
 * Returns:                                                                             *
 *      SingleClickFlag Y/N                                                             *
\*--------------------------------------------------------------------------------------*/
                                        /* Now ask the user for -SingleClick flag */
QueryOptions: Arg SingleClickFlag
Do While (SingleClickFlag\="Y" & SingleClickFlag\="N")
    Call DisplayLogo
    Say
                                        /* Ask the user if he wants to display the Popup-
                                           Menu after a single-click instead of a double-
                                           click with mouse button 1 */
    Say " Do you want the "LRed"PC/2"LWhi"'s Popup-Menu displayed after a single-click with mouse"
    Parse Value SysCurPos() with Row Col
    Say " button 1 instead of the default double click? [Y/y/N/n]: "LGre
    Col=Col+58
    Call SysCurPos Row, Col
    Pull SingleClickFlag
End
Return SingleClickFlag

/*--------------------------------------------------------------------------------------*\
 * Create the WPS Objects of PC/2 and/or WPS 2 PC/2.                                    *
 * Req:                                                                                 *
 *      DisplayLogo                                                                     *
 * Returns:                                                                             *
 *      Success ....... TRUE/FALSE                                                      *
\*--------------------------------------------------------------------------------------*/
CreateWPSObjects: Arg InstallationOption, SubPackageSelected, RunDirectory, OS2Directory, SingleClickFlag
                                        /* Form PC/2 setup string */
If SingleClickFlag='Y' | SingleClickFlag='y' Then
    Do
                                        /* Add -SingleClick to the parameters field */
    PC2SetupString="EXENAME="RunDirectory"\PC2.EXE;STARTUPDIR="RunDirectory";PARAMETERS=-SingleClick;OBJECTID=<WP_PC2>"
    End
Else
    Do
                                        /* Add -DoubleClick to the parameters field */
    PC2SetupString="EXENAME="RunDirectory"\PC2.EXE;STARTUPDIR="RunDirectory";PARAMETERS=-DoubleClick;OBJECTID=<WP_PC2>"
    End
                                        /* Now create/recreate WPS Objects */
Call DisplayLogo
If InstallationOption\="U" Then
    Do
    Say
    Say " Now starting "LRed"PC/2"LWhi" from "RunDirectory"..."
    Say
                                        /* Change to the drive where we installed from */
    Command="@"Filespec("Drive", RunDirectory)" >NUL"
    Command
                                        /* Change in the directory */
    Command="@CD "||Strip(Filespec("Path", RunDirectory), T, "\")||" >NUL"
    Command
                                        /* Now we start PC/2 with help, but check for
                                           the clicking method */
    If SingleClickFlag='Y' Then
        Do
        Command="@Start PC2.exe -SingleClick -INSTALL >NUL"
        End
    Else
        Do
        Command="@Start PC2.exe -INSTALL >NUL"
        End
    Command
    If rc\=0 Then
        Do
        Say " Sorry, I couldn't start "LRed"PC/2"LWhi" for you..."
        End
    Else
        Do
        Say " After you have finished reading all help panels exit "LRed"PC/2"LWhi" and restart it by"
        Say " clicking on the Desktop with mouse button 1. You will notice that the back-"
        Say " ground behind the icon changed its color and shape if "LRed"PC/2"LWhi" is started."
        End
    Say
    Parse Value SysCurPos() with Row Col
    Say " Press any key to continue..."
    Col=Col+30
    Call SysCurPos Row, Col
    Pull Ignore
End
Say
Say " Now creating WPS Objects for "LRed"PC/2"LWhi" and/or "LRed"WPS 2 PC/2"LWhi"..."
Say
Success="TRUE"
                                        /* Create PC/2 Object */
If (SubPackageSelected="P" | SubPackageSelected="B") Then
    Do
    Parse Value SysCurPos() with Row Col
    Call SysCurPos Row, Col
    Say " Installing WPS Object of "LRed"PC/2"LWhi
    Col=Col+40
    Call SysCurPos Row, Col
                                        /* Now create the PC/2 object on the Desktop */
    Rc=SysCreateObject('WPProgram','PC/2','<WP_DESKTOP>',PC2SetupString)
    if Rc<>1 Then
        Do
        Say "SysCreateObject failed"
        Row=Row+1
        Success="FALSE"
        End
    Else
        Do
        Say "SysCreateObject ok"
        Row=Row+1
        End
    Say
    End
                                        /* Create/recreate WPS 2 PC/2 Object */
If (SubPackageSelected="W" | SubPackageSelected="B") Then
    Do
    If FileCopy(WPS2PC2.DLL, OS2Directory||"DLL\")="FALSE" Then
        CopySuccess="FALSE"
    If FileCopy(WPS2PC2.HLP, OS2Directory||"HELP\")="FALSE" Then
        CopySuccess="FALSE"
                                        /* We have to rename WPS 2 PC/2's DLL otherwise
                                           it will be locked (by WPS or WPS2PC2.dll itself ?) */
    Command="@Ren WPS2PC2.dll WPS2PC2.dl_"
    Command
    Command="@Ren WPS2PC2.hlp WPS2PC2.hl_"
    Command
    Say
    Parse Value SysCurPos() with Row Col
    Say " Installing WPS Object of "LRed"WPS 2 PC/2"LWhi
    Call SysCurPos Row, Col
    Col=Col+40
    Call SysCurPos Row, Col
    Rc=SysRegisterObjectClass('Wps2Pc2', OS2Directory||'\DLL\WPS2PC2.DLL');
    If Rc<>1 Then
        Do
        Say "SysRegisterObjectClass failed"
        Row=Row+1
        Success="FALSE"
        End
    Else
        Do
        Say "SysRegisterObjectClass ok"
        Row=Row+1
        End
    Call SysCurPos Row, Col
    SetupString='OBJECTID=<WP_WPS2PC2>;'
    Rc=SysCreateObject('Wps2Pc2', 'WPS 2 PC/2', '<WP_DESKTOP>', SetupString, 'ReplaceIfExists')
    if Rc<>1 Then
        Do
        Say "SysCreateObject failed"
        Row=Row+1
        Success="FALSE"
        End
    Else
        Do
        Say "SysCreateObject ok"
        Row=Row+1
        End
                                        /* Rename WPS 2 PC/2's DLL to original name */
    Command="@Ren WPS2PC2.dl_ WPS2PC2.dll"
    Command
    Command="@Ren WPS2PC2.hl_ WPS2PC2.hlp"
    Command
    End
                                        /* On error wait for user acknowledgement */
If Success="FALSE" Then
    Do
    Say
    Parse Value SysCurPos() with Row Col
    Say " Press any key to continue..."
    Col=Col+30
    Call SysCurPos Row, Col
    Pull Ignore
    End
Return Success

/*--------------------------------------------------------------------------------------*\
 * Deletes the WPS Objects of PC/2 and/or WPS 2 PC/2.                                   *
 * Req:                                                                                 *
 *      DisplayLogo                                                                     *
 * Returns:                                                                             *
 *      Success ....... TRUE/FALSE                                                      *
\*--------------------------------------------------------------------------------------*/
DeleteWPSObjects: Arg SubPackageSelected
                                        /* Now delete WPS Objects */
Call DisplayLogo
Say
Say " Now deregistering WPS Objects..."
Say
Success="TRUE"
                                        /* Delete PC/2 Object */
If (SubPackageSelected="P" | SubPackageSelected="B") Then
    Do
    Parse Value SysCurPos() with Row Col
    Call SysCurPos Row, Col
    Say " Deinstalling WPS Object of "LRed"PC/2"LWhi
    Col=Col+40
    Call SysCurPos Row, Col
    Rc=SysDestroyObject('<WP_PC2>');
    if Rc<>1 Then
        Do
        Say "SysDestroyObject failed"
        Row=Row+1
        Success="FALSE"
        End
    Else
        Do
        Say "SysDestroyObject ok"
        Row=Row+1
        End
    Say
    End
                                        /* Delete WPS 2 PC/2 Object */
If (SubPackageSelected="W" | SubPackageSelected="B") Then
    Do
    Parse Value SysCurPos() with Row Col
    Call SysCurPos Row, Col
    Say " Deinstalling WPS Object of "LRed"WPS 2 PC/2"LWhi
    Col=Col+40
    Call SysCurPos Row, Col
    Rc=SysDestroyObject('<WP_WPS2PC2>');
    if Rc<>1 Then
        Do
        Say "SysDestroyObject failed"
        Row=Row+1
        Success="FALSE"
        End
    Else
        Do
        Say "SysDestroyObject ok"
        Row=Row+1
        End
    Call SysCurPos Row, Col
    Rc=SysDeregisterObjectClass('Wps2Pc2');
    If Rc<>1 Then
        Do
        Say "SysDeregisterObjectClass failed"
        Row=Row+1
        Success="FALSE"
        End
    Else
        Do
        Say "SysDeregisterObjectClass ok"
        Row=Row+1
        End
    End
                                        /* On error wait for user acknowledgement */
If Success="FALSE" Then
    Do
    Say
    Say " Because automatic deletion faild, please try to delete the WPS Objects for"
    Say " "LRed"PC/2"LWhi" and "LRed"WPS 2 PC/2"LWhi" manually, by either selecting the Delete option from the"
    Say " WPS Object's context menu, or by dragging them into the Shredder."
    Say
    Parse Value SysCurPos() with Row Col
    Say " Press any key to continue..."
    Col=Col+30
    Call SysCurPos Row, Col
    Pull Ignore
    End
Return Success

/*--------------------------------------------------------------------------------------*\
 * Deletes all files of PC/2 in the current directory and all WPS 2 PC/2 files in the   *
 * \OS2\ directory on the boot drive.                                                   *
 * Req:                                                                                 *
 *      DisplayLogo                                                                     *
 * Returns:                                                                             *
 *      Success ....... TRUE/FALSE                                                      *
\*--------------------------------------------------------------------------------------*/
PurgeFiles: Arg SourceDirectory, OS2Directory
                                        /* Now purge files */
Call DisplayLogo
Say
Say " Now deleting files..."
Say
DeleteSuccess="TRUE"
If FileDelete(PC2.EXE, SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete(PC2SLOW.EXE, SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete(PC2HOOK.DLL, SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete(PC2SPOOL.DLL, SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete(PC2.HLP, SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete(PC2.DOC, SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete(PC2.FAQ, SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete(INSTALL.CMD, SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete(SMALLFNT.CMD, SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete(SYSLEVEL.PC2, SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete(DEMOCFG.ZIP, SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete(SOURCE.ZIP, SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete(PC2.CFG, SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete(PC2.INI, SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete(WPS2PC2.DLL, SourceDirectory, OS2Directory||"DLL\")="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete(WPS2PC2.HLP, SourceDirectory, OS2Directory||"HELP\")="FALSE" Then
    DeleteSuccess="FALSE"
If DeleteSuccess="FALSE" Then
    Do
    Say
    Parse Value SysCurPos() with Row Col
    Say " Press any key to continue..."
    Col=Col+30
    Call SysCurPos Row, Col
    Pull Ignore
    End
Return DeleteSuccess

/*--------------------------------------------------------------------------------------*\
 * Display hints for user of PC/2 (about SmallFnt.cmd, STARTUPFOLDERSONLY and           *
 * RUNWORKPLACE statements, and the FAQ file).                                          *
 * Req:                                                                                 *
 *      DisplayLogo                                                                     *
 * Returns:                                                                             *
 *      Success ....... TRUE/FALSE                                                      *
\*--------------------------------------------------------------------------------------*/
DisplayHint: Arg FAQFlag
                                        /* Now inform user about SMALLFNT.CMD */
Call DisplayLogo
Say
Say
Say " "LRed"PC/2"LWhi" also ships a small batch file called "LBro"SmallFnt.cmd"LWhi" which you may use to "
Say " replace the default Proportional System font with a smaller 8 pts. Helv font. "
Say " This batch files modifies your "LBro"OS2.INI"Lwhi" file so that after the next reboot "
Say " most dialogs will be much smaller and more information fits on your screen. "
Say " You may also use the Font Palette to drop the 8 pts. Helv font over the "
Say " titlebar and menu of any application while you hold the ALT-key to make this "
Say " font the default on titlebars and menues.. "
Say
Parse Value SysCurPos() with Row Col
Say " Press any key to continue..."
Col=Col+30
Call SysCurPos Row, Col
Pull Ignore
                                        /* Now inform user about STARTUPFOLDERSONLY */
Call DisplayLogo
Say
                                        /* Search for CONFIG.SYS and the statement
                                           SET RESTARTOBJECTS=STARTUPFOLDERSONLY. Thanks
                                           to Stefan Hora for giving me a drive independent
                                           way to get data from actual CONFIG.SYS */
FoundConfig=FALSE
WorkPlace=strip(Value("RESTARTOBJECTS", , "OS2ENVIRONMENT"))
if POS('STARTUPFOLDERSONLY', WorkPlace)\=0 Then Do
    FoundConfig=TRUE
End
                                        /* Inform the user about CONFIG.SYS */
If FoundConfig=TRUE Then Do
    Say " You have the statement "LBro"SET RESTARTOBJECTS=STARTUPFOLDERSONLY"LWhi" in your"
    Say " "LBro"CONFIG.SYS"LWhi". To enable OS/2 to start "LRed"PC/2"LWhi" during boot, you have to create"
    Say " a shadow of "LRed"PC/2"LWhi" and move it into your startup folder."
End
Else Do
    Say " You don't have the statement "LBro"SET RESTARTOBJECTS=STARTUPFOLDERSONLY"LWhi" in ypur"
    Say " "LBro"CONFIG.SYS"LWhi". OS/2 will start automatically "LRed"PC/2"LWhi" during next boot, if "LRed"PC/2"LWhi" is"
    Say " active before you Shutdown your System."
End
Say
Parse Value SysCurPos() with Row Col
Say " Press any key to continue..."
Col=Col+30
Call SysCurPos Row, Col
Pull Ignore
                                        /* Now inform user about RUNWORKPLACE */
Call DisplayLogo
Say
                                        /* Now search for CONFIG.SYS and the statement
                                           SET RUNWORKPLACE=C:\OS2\PMSHELL.EXE. Again thanks
                                           to Stefan Hora for his drive independent approach */
FoundConfig=FALSE
WorkPlace=strip(Value("RUNWORKPLACE", , "OS2ENVIRONMENT"))
if POS('PMSHELL.EXE', WorkPlace)\=0 Then Do
    FoundConfig=TRUE
End
                                        /* Inform the user about CONFIG.SYS */
If FoundConfig=TRUE Then Do
    Say " You have the statement "LBro"SET RUNWORKPLACE=C:\OS2\PMSHELL.EXE"LWhi" in your"
    Say " "LBro"CONFIG.SYS"LWhi". You may replace the "LBro"WPS"LWhi" by "LRed"PC/2"LWhi", please look into the online"
    Say " help panels of "LRed"PC/2"LWhi" for further information."
End
Else Do
    Say " It seems that you don't run the "LBro"WPS"LWhi" ("LBro"WorkPlace Shell"LWhi"). You may use "LRed"PC/2"LWhi" as"
    Say " a replacement for the WPS by adding to or modifying your "LBro"CONFIG.SYS"LWhi":"
    Say " "LGre"SET RUNWORKPLACE="DestinationDirectory"\PC2.EXE"LWhi
    Say " But be sure that "LRed"PC2HOOK.DLL"LWhi", "LRed"PC2SPOOL.DLL"LWhi" and "LRed"PC2.HLP"LWhi" are in the directory"
    Say " you started "LRed"PC/2"LWhi" from."
    Say " Please look into the online help panels of "LRed"PC/2"LWhi" for further information."
End
Say
Parse Value SysCurPos() with Row Col
Say " Press any key to continue..."
Col=Col+30
Call SysCurPos Row, Col
Pull Ignore
                                        /* Now inform user about FAQ */
If FAQFlag="" Then
    Do
    Call DisplayLogo
    Say
                                        /* Inform the user about safety */
    Say " Don't forget to backup your configuration file regularily to avoid possible"
    Say " damages to your configuration file."
    Say " If you drag a shadow of "LRed"PC/2"LWhi" into the startup folder and have not set"
    Say " "LBro"SET RESTARTOBJECTS=STARTUPFOLDERSONLY"LWhi" in your "LBro"CONFIG.SYS"LWhi" ensure that during"
    Say " loading of the "LBro"WPS"LWhi" "LRed"PC/2"LWhi" is only started by the startup folder to avoid an"
    Say " informational message."
    Say
    Say " If you find this utility useful and want to honor many weeks of work, you are"
    Say " welcome to send me a small donation. Please read the online documentation for"
    Say " further information - Thank you!"
    Say
    Parse Value SysCurPos() with Row Col
    Say " Do you want to read the FAQ (Frequently Asked Questions) list? [Y/y/N/n]: "LGre
                                        /* Ask the user if he wants to read the FAQ */
    Col=Col+75
    Call SysCurPos Row, Col
    Pull FAQFlag
    End
If FAQFlag='Y' Then Do
    Call DisplayLogo
    Command="@Type PC2.faq |more"
    Command
    Say
    Say LWhi"   And now - enjoy! - And now - enjoy! - And now - enjoy! - And Now - enjoy!"
    End
Return "TRUE"

/*--------------------------------------------------------------------------------------*\
 * The CTRL+Break signal handler just ignores CTRL+BREAK.                               *
 * Req:                                                                                 *
 *      none                                                                            *
 * Returns:                                                                             *
 *      none                                                                            *
\*--------------------------------------------------------------------------------------*/
SignalHandler:
Return "TRUE"

