@echo off
cls
echo.
echo        *************************************************************
echo        *                   WINDOWS INSTALLATION                    *
echo        *                                                           *
echo        *  This batch file will install Pieter's 1997 Carset v2.1   *
echo        *                                                           *
echo        *            The carset will change GP2.EXE!                *
echo        *    If you don't want to continue now, press CTRL-BREAK.   *
echo        *                                                           *
echo        *         Read readme.txt for more information              *
echo        *                                                           *
echo        *     Copyright (c) 1996 PK Arnall & Pieter van Dieren      *
echo        *                                                           *
echo        *************************************************************
echo.
echo.
pause
cls

rem Checking if the files are in the right directory --------------------

if not exist ..\gp2.exe goto wrong_dir

rem Backing up the cockpit and wheels -----------------------------------

copy ..\bitmaps\cpitlow.pcx
copy ..\gamejams\b1ftr.jam
copy ..\gamejams\b1rtr.jam
copy ..\gamejams\b2ftr.jam
copy ..\gamejams\b2rtr.jam

rem Moving GP2JAM -------------------------------------------------------

move gp2jam.exe   ..\gamejams
move 32rtm.exe    ..\gamejams
move dpmi32vm.ovl ..\gamejams

rem Creating new wheels -------------------------------------------------

..\gamejams\GP2JAM -y -bb1ftrgld.BMP -j..\gamejams\b1ftr.JAM
..\gamejams\GP2JAM -y -bb1rtrgld.BMP -j..\gamejams\b1rtr.JAM
..\gamejams\GP2JAM -y -bb2ftrgld.BMP -j..\gamejams\b2ftr.JAM
..\gamejams\GP2JAM -y -bb2rtrgld.BMP -j..\gamejams\b2rtr.JAM

rem Patching the game and creating new cars -----------------------------

gp2edexp p97cs21.gpe ..

goto ready

:wrong_dir
echo.
echo        *************************************************************
echo        *                                                           *
echo        *    You did not copy the files to the right directory!     *
echo        *  Make sure the files are in the GP2/97CARSET directory.   *
echo        *                                                           *
echo        *      Read README.TXT how to install the 1997 carset.      *
echo        *                                                           *
echo        *************************************************************
echo.
goto end

:ready
cls
echo.
echo.
echo        *************************************************************
echo        *                                                           *
echo        *                 All files are now installed!              *
echo        *                                                           *
echo        *                                                           *
echo        * Remember: You will probably have to change some things    *
echo        *           within the game again.                          *
echo        *           (E.g. controller setup, graphics options etc.)  *
echo        *                                                           *
echo        *                                                           *
echo        *                    Have a great race!                     *
echo        *                                                           *
echo        *************************************************************
echo.
echo.
echo.
echo.
:end