diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/client.qc morph/client.qc
--- v101qc/client.qc	Thu Jul 25 01:51:22 1996
+++ morph/client.qc	Thu Aug 22 17:02:32 1996
@@ -2,7 +2,7 @@
 // prototypes
 void () W_WeaponFrame;
 void() W_SetCurrentAmmo;
-void() player_pain;
+void(entity attacker, float take) player_pain;
 void() player_stand1;
 void (vector org) spawn_tfog;
 void (vector org, entity death_owner) spawn_tdeath;
@@ -53,6 +53,7 @@
 	parm7 = self.ammo_cells;
 	parm8 = self.weapon;
 	parm9 = self.armortype * 100;
+	parm10 = self.morphnum;
 };
 
 void() SetNewParms =
@@ -66,6 +67,7 @@
 	parm6 = 0;
 	parm8 = 1;
 	parm9 = 0;
+	parm10 = 0; // Human morph
 };
 
 void() DecodeLevelParms =
@@ -85,6 +87,7 @@
 	self.ammo_cells = parm7;
 	self.weapon = parm8;
 	self.armortype = parm9 * 0.01;
+	self.impulse =  parm10;
 };
 
 /*
@@ -468,6 +471,19 @@
 	self.invincible_time = 0;
 
 	DecodeLevelParms ();
+
+	self._stand=SUB_Null;
+	self._pain=SUB_Null;
+	self._run=SUB_Null;
+	self._impulse=SUB_Null;
+	self._attack=SUB_Null;
+	self._jump=SUB_Null;
+	self._jump2=SUB_Null;
+	self._can_get_p=SUB_True;
+	self._killmsg=SUB_Null;
+	self._killmsg2=SUB_Null;
+
+	self.health_modifier = 1.0;
 	
 	W_SetCurrentAmmo ();
 
@@ -491,6 +507,7 @@
 
 	setmodel (self, "progs/player.mdl");
 	modelindex_player = self.modelindex;
+	self.modelindex_morph=modelindex_player;
 
 	setsize (self, VEC_HULL_MIN, VEC_HULL_MAX);
 	
@@ -752,6 +769,11 @@
 {
 	local vector start, end;
 	
+	if (self._jump != SUB_Null) { // Should be after these checks?
+		self._jump();
+		return;
+	}
+
 	if (self.flags & FL_WATERJUMP)
 		return;
 	
@@ -788,6 +810,8 @@
 	self.flags = self.flags - FL_ONGROUND;	// don't stairwalk
 	
 	self.button2 = 0;
+
+	if(self._jump2 != SUB_Null) { self._jump2(); return; }
 // player jumping sound
 	sound (self, CHAN_BODY, "player/plyrjmp8.wav", 1, ATTN_NORM);
 	self.velocity_z = self.velocity_z + 270;
@@ -1015,7 +1039,7 @@
 		self.modelindex = modelindex_eyes;
 	}
 	else
-		self.modelindex = modelindex_player;	// don't use eyes
+		self.modelindex = self.modelindex_morph;	// don't use eyes
 
 // invincibility
 	if (self.invincible_finished)
@@ -1266,59 +1290,64 @@
 			{
 				attacker.frags = attacker.frags + 1;
 
-				rnum = attacker.weapon;
-				if (rnum == IT_AXE)
-				{
-					deathstring = " was ax-murdered by ";
-					deathstring2 = "\n";
-				}
-				if (rnum == IT_SHOTGUN)
-				{
-					deathstring = " chewed on ";
-					deathstring2 = "'s boomstick\n";
-				}
-				if (rnum == IT_SUPER_SHOTGUN)
-				{
-					deathstring = " ate 2 loads of ";
-					deathstring2 = "'s buckshot\n";
-				}
-				if (rnum == IT_NAILGUN)
-				{
-					deathstring = " was nailed by ";
-					deathstring2 = "\n";
-				}
-				if (rnum == IT_SUPER_NAILGUN)
-				{
-					deathstring = " was punctured by ";
-					deathstring2 = "\n";
-				}
-				if (rnum == IT_GRENADE_LAUNCHER)
-				{
-					deathstring = " eats ";
-					deathstring2 = "'s pineapple\n";
-					if (targ.health < -40)
+				if (attacker._killmsg != SUB_Null) {
+					deathstring = attacker._killmsg(targ, attacker);
+					deathstring2 = attacker._killmsg2(targ, attacker);
+				} else {
+					rnum = attacker.weapon;
+					if (rnum == IT_AXE)
 					{
-						deathstring = " was gibbed by ";
-						deathstring2 = "'s grenade\n";
+						deathstring = " was ax-murdered by ";
+						deathstring2 = "\n";
 					}
-				}
-				if (rnum == IT_ROCKET_LAUNCHER)
-				{
-					deathstring = " rides ";
-					deathstring2 = "'s rocket\n";
-					if (targ.health < -40)
+					if (rnum == IT_SHOTGUN)
 					{
-						deathstring = " was gibbed by ";
-						deathstring2 = "'s rocket\n" ;
+						deathstring = " chewed on ";
+						deathstring2 = "'s boomstick\n";
+					}
+					if (rnum == IT_SUPER_SHOTGUN)
+					{
+						deathstring = " ate 2 loads of ";
+						deathstring2 = "'s buckshot\n";
+					}
+					if (rnum == IT_NAILGUN)
+					{
+						deathstring = " was nailed by ";
+						deathstring2 = "\n";
+					}
+					if (rnum == IT_SUPER_NAILGUN)
+					{
+						deathstring = " was punctured by ";
+						deathstring2 = "\n";
+					}
+					if (rnum == IT_GRENADE_LAUNCHER)
+					{
+						deathstring = " eats ";
+						deathstring2 = "'s pineapple\n";
+						if (targ.health < -40)
+						{
+							deathstring = " was gibbed by ";
+							deathstring2 = "'s grenade\n";
+						}
+					}
+					if (rnum == IT_ROCKET_LAUNCHER)
+					{
+						deathstring = " rides ";
+						deathstring2 = "'s rocket\n";
+						if (targ.health < -40)
+						{
+							deathstring = " was gibbed by ";
+							deathstring2 = "'s rocket\n" ;
+						}
+					}
+					if (rnum == IT_LIGHTNING)
+					{
+						deathstring = " accepts ";
+						if (attacker.waterlevel > 1)
+							deathstring2 = "'s discharge\n";
+						else
+							deathstring2 = "'s shaft\n";
 					}
-				}
-				if (rnum == IT_LIGHTNING)
-				{
-					deathstring = " accepts ";
-					if (attacker.waterlevel > 1)
-						deathstring2 = "'s discharge\n";
-					else
-						deathstring2 = "'s shaft\n";
 				}
 				bprint (targ.netname);
 				bprint (deathstring);
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/defs.qc morph/defs.qc
--- v101qc/defs.qc	Thu Jul 25 01:51:22 1996
+++ morph/defs.qc	Thu Aug 22 17:03:01 1996
@@ -690,4 +690,16 @@
 
 float(entity targ, entity inflictor) CanDamage;
 
-
+.void() _stand;
+.void(entity attacker, float take) _pain;
+.void() _run;
+.void() _impulse;
+.void() _attack;
+.void() _jump;
+.void() _jump2;
+.float morphnum;
+.float(entity what, entity you) _can_get_p;
+.float modelindex_morph;
+.float health_modifier;
+.string(entity targ, entity attacker) _killmsg;
+.string(entity targ, entity attacker) _killmsg2;
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/items.qc morph/items.qc
--- v101qc/items.qc	Thu Jul 25 01:51:23 1996
+++ morph/items.qc	Thu Aug 15 07:46:19 1996
@@ -82,15 +82,15 @@
 {
 	if (e.health <= 0)
 		return 0;
-	if ((!ignore) && (e.health >= other.max_health))
+	if ((!ignore) && (e.health >= other.max_health * other.health_modifier))
 		return 0;
 	healamount = ceil(healamount);
 
 	e.health = e.health + healamount;
-	if ((!ignore) && (e.health >= other.max_health))
-		e.health = other.max_health;
+	if ((!ignore) && (e.health >= other.max_health * other.health_modifier))
+		e.health = other.max_health * other.health_modifier;
 		
-	if (e.health > 250)
+	if (e.health > 2.5 * other.max_health * e.health_modifier)
 		e.health = 250;
 	return 1;
 };
@@ -154,11 +154,12 @@
 	
 	if (other.classname != "player")
 		return;
+	// if (!other._can_get_p(self,other)) return; // We can always get health
 	
 	if (self.healtype == 2) // Megahealth?  Ignore max_health...
 	{
-		if (other.health >= 250)
-			return;
+		//if (other.health >= 250)
+		//	return;
 		if (!T_Heal(other, self.healamount, 1))
 			return;
 	}
@@ -207,7 +208,7 @@
 {
 	other = self.owner;
 	
-	if (other.health > other.max_health)
+	if (other.health > other.max_health * other.health_modifier)
 	{
 		other.health = other.health - 1;
 		self.nextthink = time + 1;
@@ -243,6 +244,7 @@
 		return;
 	if (other.classname != "player")
 		return;
+	if (!other._can_get_p(self,other)) return;
 
 	if (self.classname == "item_armor1")
 	{
@@ -397,6 +399,7 @@
 
 	if (!(other.flags & FL_CLIENT))
 		return;
+	if (!other._can_get_p(self,other)) return;
 
 // if the player was using his best weapon, change up to the new one if better		
 	stemp = self;
@@ -598,11 +601,14 @@
 {
 local entity	stemp;
 local float		best;
+local float cgp;
 
 	if (other.classname != "player")
 		return;
 	if (other.health <= 0)
 		return;
+	cgp=other._can_get_p(self,other);
+	if (!cgp) return;
 
 // if the player was using his best weapon, change up to the new one if better		
 	stemp = self;
@@ -654,21 +660,21 @@
 
 // change to a better weapon if appropriate
 
-	if ( other.weapon == best )
+	if ( (cgp == 1) && (other.weapon == best ))
 	{
 		stemp = self;
 		self = other;
 		self.weapon = W_BestWeapon();
 		W_SetCurrentAmmo ();
 		self = stemp;
-	}
 
 // if changed current ammo, update it
-	stemp = self;
-	self = other;
-	W_SetCurrentAmmo();
-	self = stemp;
+		stemp = self;
+		self = other;
+		W_SetCurrentAmmo();
+		self = stemp;
 
+	}
 // remove it in single player, or setup for respawning in deathmatch
 	self.model = string_null;
 	self.solid = SOLID_NOT;
@@ -878,6 +884,7 @@
 		return;
 	if (other.items & self.items)
 		return;
+	// if (!other._can_get_p(self,other)) return; // Always allow key getting
 
 	sprint (other, "You got the ");
 	sprint (other, self.netname);
@@ -1012,6 +1019,7 @@
 		return;
 	if (other.health <= 0)
 		return;
+	// if (!other._can_get_p(self,other)) return; // Always allow rune getting
 
 	centerprint (other, "You got the rune!");
 
@@ -1085,6 +1093,7 @@
 		return;
 	if (other.health <= 0)
 		return;
+	// if (!other._can_get_p(self,other)) return; // We can always get powerups
 
 	sprint (other, "You got the ");
 	sprint (other, self.netname);
@@ -1232,11 +1241,14 @@
 	local string	s;
 	local	float	best;
 	local		entity	stemp;
+	local float	cgp;
 	
 	if (other.classname != "player")
 		return;
 	if (other.health <= 0)
 		return;
+	cgp=other._can_get_p(self,other);
+	if (!cgp) return;
 		
 // if the player was using his best weapon, change up to the new one if better		
 	stemp = self;
@@ -1287,19 +1299,17 @@
 	stuffcmd (other, "bf\n");
 
 // change to a better weapon if appropriate
-	if ( other.weapon == best )
+	if ( other.weapon == best && cgp == 1)
 	{
 		stemp = self;
 		self = other;
 		self.weapon = W_BestWeapon();
+		W_SetCurrentAmmo ();
 		self = stemp;
 	}
 
 	
 	remove(self);
-	
-	self = other;
-	W_SetCurrentAmmo ();
 };
 
 /*
@@ -1337,4 +1347,51 @@
 	
 	item.nextthink = time + 120;	// remove after 2 minutes
 	item.think = SUB_Remove;
+};
+
+void() BackpackSolidify = {
+	self.solid = SOLID_TRIGGER;
+	self.touch = BackpackTouch;
+	self.nextthink = time + 900; // 15 minutes
+	self.think = SUB_Remove;
+	setmodel (self, "progs/backpack.mdl");
+	setsize (self, '-16 -16 0', '16 16 56');
+};
+
+void() DropBackpack2 =
+{
+	local entity	item;
+
+	if (!(self.ammo_shells + self.ammo_nails + self.ammo_rockets + self.ammo_cells))
+		return;	// nothing in it
+
+	item = spawn();
+	item.origin = self.origin - '0 0 24';
+	
+	item.items = self.weapon;
+
+	item.ammo_shells = self.ammo_shells;
+	item.ammo_nails = self.ammo_nails;
+	item.ammo_rockets = self.ammo_rockets;
+	item.ammo_cells = self.ammo_cells;
+
+	self.ammo_shells=0;
+	self.ammo_nails=0;
+	self.ammo_rockets=0;
+	self.ammo_cells=0;
+
+	item.velocity_z = 300;
+	item.velocity_x = -100 + (random() * 200);
+	item.velocity_y = -100 + (random() * 200);
+	
+	item.flags = FL_ITEM;
+	item.solid = SOLID_NOT;
+	item.movetype = MOVETYPE_TOSS;
+	setmodel (item, "progs/backpack.mdl");
+	setsize (item, '-16 -16 0', '16 16 56');
+	// item.touch = BackpackTouch;
+	
+	item.nextthink = time + 2;	// solidify in two seconds
+	item.think = BackpackSolidify;
+	item.owner = world;
 };
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/m-demon.qc morph/m-demon.qc
--- v101qc/m-demon.qc	Wed Dec 31 18:00:00 1969
+++ morph/m-demon.qc	Thu Aug 22 17:08:25 1996
@@ -0,0 +1,171 @@
+/*
+==============================================================================
+
+DEMON
+
+==============================================================================
+*/
+
+$cd /raid/quake/id1/models/demon3
+$scale	0.8
+$origin 0 0 24
+$base base
+$skin base
+
+$frame stand1 stand2 stand3 stand4 stand5 stand6 stand7 stand8 stand9
+$frame stand10 stand11 stand12 stand13
+
+$frame walk1 walk2 walk3 walk4 walk5 walk6 walk7 walk8
+
+$frame run1 run2 run3 run4 run5 run6
+
+$frame leap1 leap2 leap3 leap4 leap5 leap6 leap7 leap8 leap9 leap10
+$frame leap11 leap12
+
+$frame pain1 pain2 pain3 pain4 pain5 pain6
+
+$frame death1 death2 death3 death4 death5 death6 death7 death8 death9
+
+$frame attacka1 attacka2 attacka3 attacka4 attacka5 attacka6 attacka7 attacka8
+$frame attacka9 attacka10 attacka11 attacka12 attacka13 attacka14 attacka15
+
+void(float side) player_demon_melee = {
+        local   vector  source;
+        local   vector  org;
+        local   float   ldmg;
+
+        sound (self, CHAN_WEAPON, "weapons/ax1.wav", 1, ATTN_NORM);
+
+        source = self.origin + '0 0 4';
+        makevectors (self.angles);
+        traceline (source, source + v_forward*64, FALSE, self);
+        if (!trace_ent.takedamage)
+                traceline (source, source + v_forward*64 + v_right*30, FALSE, self);
+        if (!trace_ent.takedamage)
+                traceline (source, source + v_forward*64 - v_right*30, FALSE, self);
+
+        if (trace_fraction == 1.0)
+                return;
+
+        org = trace_endpos - v_forward*4;
+        if (trace_ent.takedamage)
+        {
+            sound (self, CHAN_WEAPON, "demon/dhit2.wav", 1, ATTN_NORM);
+                ldmg = 40 + 10*random();
+                T_Damage (trace_ent, self, self, ldmg);
+
+                SpawnMeatSpray (self.origin + v_forward*16, side * v_right);
+        }
+};
+
+void()  player_demon_attack = [$attacka1, player_demon_attack2 ] {self.attack_finished=time+1; self.view_ofs = '0 0 8';};
+void()  player_demon_attack2 = [$attacka2, player_demon_attack3 ] {self.view_ofs = '0 0 16';};
+void()  player_demon_attack3 = [$attacka3, player_demon_attack4 ] {self.view_ofs = '0 0 25';};
+void()  player_demon_attack4 = [$attacka4, player_demon_attack5 ] {self.view_ofs = '0 0 23';};
+void()  player_demon_attack5 = [$attacka5, player_demon_attack6 ] {self.view_ofs = '0 0 21'; player_demon_melee(200);};
+void()  player_demon_attack6 = [$attacka6, player_demon_attack7 ] {self.view_ofs = '0 0 23';};
+void()  player_demon_attack7 = [$attacka7, player_demon_attack8 ] {self.view_ofs = '0 0 24';};
+void()  player_demon_attack8 = [$attacka8, player_demon_attack9 ] {self.view_ofs = '0 0 25';};
+void()  player_demon_attack9 = [$attacka9, player_demon_attack10 ] {self.view_ofs = '0 0 24';};
+void()  player_demon_attack10 = [$attacka10, player_demon_attack11 ] {self.view_ofs = '0 0 23';};
+void()  player_demon_attack11 = [$attacka11, player_demon_attack12 ] {self.view_ofs = '0 0 21'; player_demon_melee(-200);};
+void()  player_demon_attack12 = [$attacka12, player_demon_attack13 ] {self.view_ofs = '0 0 16';};
+void()  player_demon_attack13 = [$attacka13, player_demon_attack14 ] {self.view_ofs = '0 0 12';};
+void()  player_demon_attack14 = [$attacka14, player_demon_attack15 ] {self.view_ofs = '0 0 8';};
+void()  player_demon_attack15 = [$attacka15, player_stand1 ] {self.view_ofs = '0 0 4';};
+
+void() player_demon_jumptouch =
+{
+        local float ldmg;
+
+        if(other.takedamage)
+        {
+                ldmg = 40 + 10*random();
+                T_Damage(other, self, self, ldmg);
+                SpawnMeatSpray (self.origin + v_forward*20,  100* v_forward);
+                SpawnMeatSpray (self.origin + v_forward*20,  50* v_forward);
+        }
+
+        self.touch = SUB_Null;
+};
+
+void() player_demon_jump1 = [ $leap1, player_demon_jump1 ] {
+        if (self.walkframe >= 12)
+                self.walkframe = 11;
+        self.frame = $leap1 + self.walkframe;
+        self.walkframe = self.walkframe + 1;
+        if (self.flags & FL_ONGROUND) {
+		self.touch = SUB_Null;
+                player_stand1();
+	}
+};
+
+void() player_demon_jump = {
+	makevectors(self.v_angle);
+	self.origin_z = self.origin_z + 1;
+	self.velocity = v_forward * 800 + '0 0 350';
+	sound(self, CHAN_BODY, "demon/djump.wav", 1, ATTN_NORM);
+	self.touch = player_demon_jumptouch;
+	player_demon_jump1();
+};
+
+void() player_demon_stand = [ $stand1, player_stand1 ] {
+	if(self.walkframe >= 13)
+		self.walkframe=0;
+	self.frame = $stand1 + self.walkframe;
+	self.walkframe = self.walkframe + 1;
+};
+
+void() player_demon_run = [ $run1, player_run ] {
+	if(self.walkframe >= 6)
+		self.walkframe = 0;
+	self.frame = $run1 + self.walkframe;
+	self.walkframe = self.walkframe + 1;
+};
+
+void() player_demon_pain = [       $pain5, player_demon_pain1    ]
+{
+        self.walkframe = 1;
+        PainSound();
+        self.weaponframe = 0;
+        self.frame = $pain5;
+};
+
+void()  player_demon_pain1 =  [      $pain1, player_demon_pain1    ]
+{
+        if (self.walkframe >=10)
+                player_stand1();
+        if (self.walkframe < 6)
+                self.frame = $pain5 + self.walkframe;
+        else self.frame = $pain5 + (10 - self.walkframe);
+        self.walkframe = self.walkframe + 1;
+};
+
+string() player_demon_killmsg = { return " was slashed by "; };
+string() player_demon_killmsg2 = { return "\n"; };
+
+void() player_demon_become = {
+	bprint(self.netname);
+	bprint(" has become a fiend.\n");
+	self._stand=player_demon_stand;
+	self._run=player_demon_run;	
+	self._pain=player_demon_pain;
+	self._jump=SUB_Null;
+	self._jump2=player_demon_jump;
+	self._attack=player_demon_attack;
+	self._impulse=SUB_Nop;
+	self._can_get_p=SUB_False;
+	self._killmsg=player_demon_killmsg;
+	self._killmsg2=player_demon_killmsg2;
+	setmodel(self,"progs/demon.mdl");
+	self.modelindex_morph=self.modelindex;
+	self.weaponmodel="";
+	self.view_ofs = '0 0 22';
+	if(!deathmatch) setsize (self, VEC_HULL_MIN, VEC_HULL_MAX);
+	else setsize (self, '-16 -16 -24', '16 16 40');
+	self.health = self.health * 5.00 / self.health_modifier;
+	self.health_modifier = 5.00;
+	makevectors(self.v_angle);
+	spawn_tfog(self.origin + 20 * v_forward);
+	DropBackpack2();
+};
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/m-hknigh.qc morph/m-hknigh.qc
--- v101qc/m-hknigh.qc	Wed Dec 31 18:00:00 1969
+++ morph/m-hknigh.qc	Thu Aug 22 17:08:29 1996
@@ -0,0 +1,260 @@
+/*
+==============================================================================
+
+KNIGHT
+
+==============================================================================
+*/
+
+$cd /raid/quake/id1/models/knight2
+$origin 0 0 24
+$base base
+$skin skin
+
+$frame stand1 stand2 stand3 stand4 stand5 stand6 stand7 stand8 stand9
+
+$frame walk1 walk2 walk3 walk4 walk5 walk6 walk7 walk8 walk9
+$frame walk10 walk11 walk12 walk13 walk14 walk15 walk16 walk17
+$frame walk18 walk19 walk20
+
+$frame run1 run2 run3 run4 run5 run6 run7 run8
+
+$frame pain1 pain2 pain3 pain4 pain5
+
+$frame death1 death2 death3 death4 death5 death6 death7 death8
+$frame death9 death10 death11 death12
+
+$frame deathb1 deathb2 deathb3 deathb4 deathb5 deathb6 deathb7 deathb8
+$frame deathb9
+
+$frame char_a1 char_a2 char_a3 char_a4 char_a5 char_a6 char_a7 char_a8
+$frame char_a9 char_a10 char_a11 char_a12 char_a13 char_a14 char_a15 char_a16
+
+$frame magica1 magica2 magica3 magica4 magica5 magica6 magica7 magica8
+$frame magica9 magica10 magica11 magica12 magica13 magica14
+
+$frame magicb1 magicb2 magicb3 magicb4 magicb5 magicb6 magicb7 magicb8
+$frame magicb9 magicb10 magicb11 magicb12 magicb13
+
+$frame char_b1 char_b2 char_b3 char_b4 char_b5 char_b6
+
+$frame slice1 slice2 slice3 slice4 slice5 slice6 slice7 slice8 slice9 slice10
+
+$frame smash1 smash2 smash3 smash4 smash5 smash6 smash7 smash8 smash9 smash10
+$frame smash11
+
+$frame w_attack1 w_attack2 w_attack3 w_attack4 w_attack5 w_attack6 w_attack7 
+$frame w_attack8 w_attack9 w_attack10 w_attack11 w_attack12 w_attack13 w_attack14
+$frame w_attack15 w_attack16 w_attack17 w_attack18 w_attack19 w_attack20 
+$frame w_attack21 w_attack22 
+
+$frame magicc1 magicc2 magicc3 magicc4 magicc5 magicc6 magicc7 magicc8
+$frame magicc9 magicc10 magicc11
+
+void() player_hknight_stand = [ $stand1, player_stand1 ] {
+	if(self.walkframe >= 9)	
+		self.walkframe = 0;
+	self.frame = $stand1 + self.walkframe;
+	self.walkframe = self.walkframe + 1;
+};
+
+void() player_hknight_run = [ $run1, player_run ] {
+	if (self.walkframe >= 8)
+		self.walkframe = 0;
+	self.frame = $run1 + self.walkframe;
+	self.walkframe = self.walkframe + 1;
+};
+
+////////////////////////////////////////////
+// 5 frames of pain for player_hknight, going to player_stand1
+////////////////////////////////////////////
+
+void() player_hknight_pain1 = [ $pain1, player_hknight_pain2 ] { };
+void() player_hknight_pain2 = [ $pain2, player_hknight_pain3 ] { };
+void() player_hknight_pain3 = [ $pain3, player_hknight_pain4 ] { };
+void() player_hknight_pain4 = [ $pain4, player_hknight_pain5 ] { };
+void() player_hknight_pain5 = [ $pain5, player_stand1 ] { };
+
+void() player_hknight_pain = {
+	if(self.pain_finished > time) return;
+	self.pain_finished = time + 1;
+	player_hknight_pain1();
+};
+
+void(float offset) player_hknight_shot =
+{
+	local	vector	offang;
+	local	vector	org, vec;
+	
+	offang = self.v_angle;
+	offang_y = offang_y + offset * 6;
+	
+	makevectors (offang);
+
+	org = self.origin + self.mins + self.size*0.5 + v_forward * 20;
+
+// set missile speed
+	vec = normalize (v_forward);
+	vec_z = vec_z + (random() - 0.5)*0.1;
+	
+	launch_spike (org, vec);
+	newmis.classname = "knightspike";
+	setmodel (newmis, "progs/k_spike.mdl");
+	setsize (newmis, VEC_ORIGIN, VEC_ORIGIN);		
+	newmis.velocity = vec*300;
+	sound (self, CHAN_WEAPON, "hknight/attack1.wav", 1, ATTN_NORM);
+};
+
+void() player_hknight_sword = {
+	local	vector	source;
+	local	vector	org;
+
+	source = self.origin + '0 0 16';
+	traceline (source, source + v_forward*96, FALSE, self);
+	if (trace_fraction == 1.0)
+		return;
+	
+	org = trace_endpos - v_forward*4;
+
+	if (trace_ent.takedamage)
+	{
+		trace_ent.axhitme = 1;
+		SpawnBlood (org, '0 0 0', 20);
+		T_Damage (trace_ent, self, self, 20);
+	}
+	else
+	{	// hit wall
+		sound (self, CHAN_WEAPON, "player/axhit2.wav", 1, ATTN_NORM);
+		WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
+		WriteByte (MSG_BROADCAST, TE_GUNSHOT);
+		WriteCoord (MSG_BROADCAST, org_x);
+		WriteCoord (MSG_BROADCAST, org_y);
+		WriteCoord (MSG_BROADCAST, org_z);
+	}
+};
+////////////////////////////////////////////
+// 10 frames of slice for player_hknight, going to player_stand1
+////////////////////////////////////////////
+
+void() player_hknight_slice1 = [ $slice1, player_hknight_slice2 ] { };
+void() player_hknight_slice2 = [ $slice2, player_hknight_slice3 ] { };
+void() player_hknight_slice3 = [ $slice3, player_hknight_slice4 ] { };
+void() player_hknight_slice4 = [ $slice4, player_hknight_slice5 ] { player_hknight_sword(); };
+void() player_hknight_slice5 = [ $slice5, player_hknight_slice6 ] { };
+void() player_hknight_slice6 = [ $slice6, player_hknight_slice7 ] { player_hknight_sword(); };
+void() player_hknight_slice7 = [ $slice7, player_hknight_slice8 ] { };
+void() player_hknight_slice8 = [ $slice8, player_hknight_slice9 ] { };
+void() player_hknight_slice9 = [ $slice9, player_hknight_slice10 ] { };
+void() player_hknight_slice10 = [ $slice10, player_stand1 ] { };
+
+////////////////////////////////////////////
+// 11 frames of smash for player_hknight, going to player_stand1
+////////////////////////////////////////////
+
+void() player_hknight_smash1 = [ $smash1, player_hknight_smash2 ] { };
+void() player_hknight_smash2 = [ $smash2, player_hknight_smash3 ] { };
+void() player_hknight_smash3 = [ $smash3, player_hknight_smash4 ] { };
+void() player_hknight_smash4 = [ $smash4, player_hknight_smash5 ] { };
+void() player_hknight_smash5 = [ $smash5, player_hknight_smash6 ] { player_hknight_sword(); };
+void() player_hknight_smash6 = [ $smash6, player_hknight_smash7 ] { };
+void() player_hknight_smash7 = [ $smash7, player_hknight_smash8 ] { player_hknight_sword(); };
+void() player_hknight_smash8 = [ $smash8, player_hknight_smash9 ] { };
+void() player_hknight_smash9 = [ $smash9, player_hknight_smash10 ] { player_hknight_sword(); };
+void() player_hknight_smash10 = [ $smash10, player_hknight_smash11 ] { };
+void() player_hknight_smash11 = [ $smash11, player_stand1 ] { };
+
+////////////////////////////////////////////
+// 14 frames of magica for player_hknight, going to player_stand1
+////////////////////////////////////////////
+
+void() player_hknight_magica1 = [ $magica1, player_hknight_magica2 ] { };
+void() player_hknight_magica2 = [ $magica2, player_hknight_magica3 ] { };
+void() player_hknight_magica3 = [ $magica3, player_hknight_magica4 ] { };
+void() player_hknight_magica4 = [ $magica4, player_hknight_magica5 ] { };
+void() player_hknight_magica5 = [ $magica5, player_hknight_magica6 ] { };
+void() player_hknight_magica6 = [ $magica6, player_hknight_magica7 ] { };
+void() player_hknight_magica7 = [ $magica7, player_hknight_magica8 ] { player_hknight_shot(-2);};
+void() player_hknight_magica8 = [ $magica8, player_hknight_magica9 ] { player_hknight_shot(-1);};
+void() player_hknight_magica9 = [ $magica9, player_hknight_magica10 ] { player_hknight_shot(0);};
+void() player_hknight_magica10 = [ $magica10, player_hknight_magica11 ] { player_hknight_shot(1);};
+void() player_hknight_magica11 = [ $magica11, player_hknight_magica12 ] { player_hknight_shot(2);};
+void() player_hknight_magica12 = [ $magica12, player_hknight_magica13 ] { player_hknight_shot(3);};
+void() player_hknight_magica13 = [ $magica13, player_hknight_magica14 ] { };
+void() player_hknight_magica14 = [ $magica14, player_stand1 ] { };
+
+////////////////////////////////////////////
+// 13 frames of magicb for player_hknight, going to player_stand1
+////////////////////////////////////////////
+
+void() player_hknight_magicb1 = [ $magicb1, player_hknight_magicb2 ] { };
+void() player_hknight_magicb2 = [ $magicb2, player_hknight_magicb3 ] { };
+void() player_hknight_magicb3 = [ $magicb3, player_hknight_magicb4 ] { };
+void() player_hknight_magicb4 = [ $magicb4, player_hknight_magicb5 ] { };
+void() player_hknight_magicb5 = [ $magicb5, player_hknight_magicb6 ] { };
+void() player_hknight_magicb6 = [ $magicb6, player_hknight_magicb7 ] { };
+void() player_hknight_magicb7 = [ $magicb7, player_hknight_magicb8 ] { player_hknight_shot(2);};
+void() player_hknight_magicb8 = [ $magicb8, player_hknight_magicb9 ] { player_hknight_shot(1);};
+void() player_hknight_magicb9 = [ $magicb9, player_hknight_magicb10 ] { player_hknight_shot(0);};
+void() player_hknight_magicb10 = [ $magicb10, player_hknight_magicb11 ] { player_hknight_shot(-1);};
+void() player_hknight_magicb11 = [ $magicb11, player_hknight_magicb12 ] { player_hknight_shot(-2);};
+void() player_hknight_magicb12 = [ $magicb12, player_hknight_magicb13 ] { player_hknight_shot(-3);};
+void() player_hknight_magicb13 = [ $magicb13, player_stand1 ] { };
+
+
+
+void() player_hknight_attack = {
+// FIXME: What about w_attack?
+	self.attack_finished=time+1; // (eh, or so)
+	if(self.weapon == IT_AXE) {
+		// A sword attack
+		sound (self, CHAN_WEAPON, "weapons/ax1.wav", 1, ATTN_NORM);
+		if (random() > 0.66) player_hknight_slice1();
+		else player_hknight_smash1();
+	} else {
+		// A magic attack
+		if (random() > 0.5) player_hknight_magica1();
+		else player_hknight_magicb1();
+	}
+};
+
+void() player_hknight_impulse = {
+	if(self.impulse == 1) self.weapon = IT_AXE;
+	else self.weapon = IT_EXTRA_WEAPON;
+};
+
+string(entity targ, entity attacker) player_hknight_killmsg = {
+	if(attacker.weapon & IT_AXE)
+		return " was slashed by ";
+	else
+		return " was fried by ";
+};
+
+string(entity targ, entity attacker) player_hknight_killmsg2 = {
+	return ".\n";
+};
+
+void() player_hknight_become = {
+	bprint(self.netname);
+	bprint(" has become a hell knight.\n");
+	self._stand=player_hknight_stand;
+	self._run=player_hknight_run;
+	self._pain=player_hknight_pain;
+	self._jump=SUB_Null; // Default player jump
+	self._jump2=SUB_Null;
+	self._attack=player_hknight_attack;
+	self._impulse=player_hknight_impulse;
+	self._can_get_p=SUB_False;
+	self._killmsg=player_hknight_killmsg;
+	self._killmsg2=player_hknight_killmsg2;
+	setmodel(self,"progs/hknight.mdl");
+	self.modelindex_morph=self.modelindex;
+	self.weaponmodel="";
+	self.view_ofs = '0 0 22';
+	if(!deathmatch) setsize (self, VEC_HULL_MIN, VEC_HULL_MAX);
+	else 	setsize (self, '-16 -16 -24', '16 16 40');
+	self.health = self.health * 2.50 / self.health_modifier;
+	self.health_modifier = 2.50;
+	makevectors(self.v_angle);
+	spawn_tfog(self.origin + 20 * v_forward);
+	DropBackpack2();
+};
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/m-human.qc morph/m-human.qc
--- v101qc/m-human.qc	Wed Dec 31 18:00:00 1969
+++ morph/m-human.qc	Thu Aug 22 17:08:33 1996
@@ -0,0 +1,24 @@
+void() player_human_become = {
+	bprint(self.netname);
+	bprint(" has become a human.\n");
+	self._stand=SUB_Null;
+	self._run=SUB_Null;
+	self._pain=SUB_Null;
+	self._jump=SUB_Null;
+	self._jump2=SUB_Null;
+	self._attack=SUB_Null;
+	self._impulse=SUB_Null;
+	self.health = self.health * 1.0 / self.health_modifier;
+	self.health_modifier = 1.0;
+	self._can_get_p=SUB_True;
+	self._killmsg=SUB_Null;
+	self._killmsg2=SUB_Null;
+	setmodel(self,"progs/player.mdl");
+	self.weapon = W_BestWeapon ();
+	W_SetCurrentAmmo ();
+	self.modelindex_morph=self.modelindex;
+	setsize (self, VEC_HULL_MIN, VEC_HULL_MAX);
+	self.view_ofs = '0 0 22';
+	makevectors(self.v_angle);
+	spawn_tfog(self.origin + 20 * v_forward);
+};
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/m-ogre.qc morph/m-ogre.qc
--- v101qc/m-ogre.qc	Wed Dec 31 18:00:00 1969
+++ morph/m-ogre.qc	Thu Aug 22 17:08:36 1996
@@ -0,0 +1,235 @@
+/*
+==============================================================================
+
+OGRE
+
+==============================================================================
+*/
+
+$cd /raid/quake/id1/models/ogre_c
+$origin 0 0 24
+$base base		
+$skin base
+
+$frame	stand1 stand2 stand3 stand4 stand5 stand6 stand7 stand8 stand9
+
+$frame walk1 walk2 walk3 walk4 walk5 walk6 walk7
+$frame walk8 walk9 walk10 walk11 walk12 walk13 walk14 walk15 walk16
+
+$frame run1 run2 run3 run4 run5 run6 run7 run8
+
+$frame swing1 swing2 swing3 swing4 swing5 swing6 swing7
+$frame swing8 swing9 swing10 swing11 swing12 swing13 swing14
+
+$frame smash1 smash2 smash3 smash4 smash5 smash6 smash7
+$frame smash8 smash9 smash10 smash11 smash12 smash13 smash14
+
+$frame shoot1 shoot2 shoot3 shoot4 shoot5 shoot6
+
+$frame pain1 pain2 pain3 pain4 pain5
+
+$frame painb1 painb2 painb3
+
+$frame painc1 painc2 painc3 painc4 painc5 painc6
+
+$frame paind1 paind2 paind3 paind4 paind5 paind6 paind7 paind8 paind9 paind10
+$frame paind11 paind12 paind13 paind14 paind15 paind16
+
+$frame paine1 paine2 paine3 paine4 paine5 paine6 paine7 paine8 paine9 paine10
+$frame paine11 paine12 paine13 paine14 paine15
+
+$frame death1 death2 death3 death4 death5 death6
+$frame death7 death8 death9 death10 death11 death12
+$frame death13 death14
+
+$frame bdeath1 bdeath2 bdeath3 bdeath4 bdeath5 bdeath6
+$frame bdeath7 bdeath8 bdeath9 bdeath10
+
+$frame pull1 pull2 pull3 pull4 pull5 pull6 pull7 pull8 pull9 pull10 pull11
+
+void() player_ogre_stand = [ $stand1, player_stand1 ] {
+	if(self.walkframe >= 9)
+		self.walkframe = 0;
+	self.frame = $stand1 + self.walkframe;
+	self.walkframe = self.walkframe = 1;
+};
+
+void() player_ogre_run = [ $run1, player_run ] {
+	if(self.walkframe >= 8)
+		self.walkframe = 0;
+	self.frame = $run1 + self.walkframe;
+	self.walkframe = self.walkframe + 1;
+};
+ 
+////////////////////////////////////////////
+// 5 frames of pain for player_ogre, going to player_stand1
+////////////////////////////////////////////
+
+void() player_ogre_pain1 = [ $pain1, player_ogre_pain2 ] { self.pain_finished = time + 3; sound(self, CHAN_VOICE, "ogre/ogpain1.wav", 1, ATTN_NORM); };
+void() player_ogre_pain2 = [ $pain2, player_ogre_pain3 ] { };
+void() player_ogre_pain3 = [ $pain3, player_ogre_pain4 ] { };
+void() player_ogre_pain4 = [ $pain4, player_ogre_pain5 ] { };
+void() player_ogre_pain5 = [ $pain5, player_stand1 ] { };
+
+void(float side) player_chainsaw =
+{
+local vector	delta;
+local float 	ldmg;
+
+	makevectors(self.v_angle);
+
+	traceline(self.origin, self.origin + v_forward * 100, FALSE, self);
+	if(trace_fraction == 1.0)
+		return;
+	
+	if(!trace_ent.takedamage) {
+		// Clank!
+		sound (self, CHAN_WEAPON, "player/axhit2.wav", 1, ATTN_NORM);
+		return;
+	}
+		
+	ldmg = (random() + random() + random()) * 4;
+	T_Damage (trace_ent, self, self, ldmg);
+	
+	if (side)
+	{
+		makevectors (self.angles);
+		if (side == 1)
+			SpawnMeatSpray (self.origin + v_forward*16, crandom() * 100 * v_right);
+		else
+			SpawnMeatSpray (self.origin + v_forward*16, side * v_right);
+	}
+};
+
+void() player_ogre_swing1	=[	$swing1,		player_ogre_swing2	] {
+sound (self, CHAN_WEAPON, "ogre/ogsawatk.wav", 1, ATTN_NORM);
+};
+void() player_ogre_swing2	=[	$swing2,		player_ogre_swing3	] {};
+void() player_ogre_swing3	=[	$swing3,		player_ogre_swing4	] {};
+void() player_ogre_swing4	=[	$swing4,		player_ogre_swing5	] {};
+void() player_ogre_swing5	=[	$swing5,		player_ogre_swing6	] { player_chainsaw(0);self.angles_y = self.angles_y + random()*25;};
+void() player_ogre_swing6	=[	$swing6,		player_ogre_swing7	] {player_chainsaw(200);self.angles_y = self.angles_y + random()* 25;};
+void() player_ogre_swing7	=[	$swing7,		player_ogre_swing8	] {player_chainsaw(0);self.angles_y = self.angles_y + random()* 25;};
+void() player_ogre_swing8	=[	$swing8,		player_ogre_swing9	] {player_chainsaw(0);self.angles_y = self.angles_y + random()* 25;};
+void() player_ogre_swing9	=[	$swing9,		player_ogre_swing10 ] {player_chainsaw(0);self.angles_y = self.angles_y + random()* 25;};
+void() player_ogre_swing10	=[	$swing10,		player_ogre_swing11 ] {player_chainsaw(-200);self.angles_y = self.angles_y + random()* 25;};
+void() player_ogre_swing11	=[	$swing11,		player_ogre_swing12 ] {player_chainsaw(0);self.angles_y = self.angles_y + random()* 25;};
+void() player_ogre_swing12	=[	$swing12,		player_ogre_swing13 ] {};
+void() player_ogre_swing13	=[	$swing13,		player_ogre_swing14 ] {};
+void() player_ogre_swing14	=[	$swing14,		player_stand1	] {};
+
+void() player_ogre_smash1	=[	$smash1,	        player_stand1 ] {
+sound (self, CHAN_WEAPON, "ogre/ogsawatk.wav", 1, ATTN_NORM);
+};
+void() player_ogre_smash2	=[	$smash2,		player_ogre_smash3	] {};
+void() player_ogre_smash3	=[	$smash3,		player_ogre_smash4	] {};
+void() player_ogre_smash4	=[	$smash4,		player_ogre_smash5	] {};
+void() player_ogre_smash5	=[	$smash5,		player_ogre_smash6	] {};
+void() player_ogre_smash6	=[	$smash6,		player_ogre_smash7	] { player_chainsaw(0);};
+void() player_ogre_smash7	=[	$smash7,		player_ogre_smash8	] { player_chainsaw(0);};
+void() player_ogre_smash8	=[	$smash8,		player_ogre_smash9	] { player_chainsaw(0);};
+void() player_ogre_smash9	=[	$smash9,		player_ogre_smash10 ] { player_chainsaw(0);};
+void() player_ogre_smash10	=[	$smash10,		player_ogre_smash11 ] {player_chainsaw(1);};
+void() player_ogre_smash11	=[	$smash11,		player_ogre_smash12 ] { player_chainsaw(0);};
+
+void() player_ogre_smash12	=[	$smash12,		player_ogre_smash13 ] {};
+void() player_ogre_smash13	=[	$smash13,		player_ogre_smash14 ] {};
+void() player_ogre_smash14	=[	$smash14,		player_stand1 ] {};
+
+////////////////////////////////////////////
+// 6 frames of shoot for player_ogre, going to player_stand1
+////////////////////////////////////////////
+
+void() player_ogre_shoot1 = [ $shoot1, player_ogre_shoot2 ] { };
+void() player_ogre_shoot2 = [ $shoot2, player_ogre_shoot3 ] { };
+void() player_ogre_shoot3 = [ $shoot3, player_ogre_shoot4 ] { W_FireGrenade();
+		if(self.ammo_rockets==0) { // When we're out, we fire reeeealllly slow
+			self.attack_finished = time + 3.0;
+			self.ammo_rockets=self.currentammo=1;
+		}
+};
+void() player_ogre_shoot4 = [ $shoot4, player_ogre_shoot5 ] { };
+void() player_ogre_shoot5 = [ $shoot5, player_ogre_shoot6 ] { };
+void() player_ogre_shoot6 = [ $shoot6, player_stand1 ] { };
+
+void() player_ogre_attack = {
+	if(self.weapon == IT_AXE) {
+//		if(random()>0.66) {
+//			self.attack_finished = time + 1.2;
+//			player_ogre_smash1();
+//		} else {
+		self.attack_finished = time + 1.0;
+		player_ogre_swing1();
+//		}
+	} else {
+		player_ogre_shoot1();
+		self.attack_finished = time + 0.8;
+		if(self.ammo_rockets==0) {
+			self.attack_finished = time + 3.0;
+			self.ammo_rockets=self.currentammo=1;
+		}
+	}
+};
+
+string(entity targ, entity attacker) player_ogre_killmsg = {
+	if(self.weapon == IT_AXE) return " was sawed to death by ";
+	else return " eats ";
+};
+	
+string(entity targ, entity attacker) player_ogre_killmsg2 = {
+	if(self.weapon == IT_AXE) return "\n";
+	else return "'s pineapple\n";
+};
+
+void() player_ogre_impulse = {
+	if(self.impulse == 1)
+		self.weapon = IT_AXE;
+	else	self.weapon = IT_GRENADE_LAUNCHER;
+};
+
+void(entity s, entity o) player_ogre_can_get_p = {
+	if(o.touch == ammo_touch && o.weapon==3) {
+		s.currentammo=s.currentammo+o.aflag;
+		if(s.currentammo>100) s.currentammo=100;
+		return 2;
+	}	
+	else if(o.touch == BackpackTouch && o.ammo_rockets) {
+		s.currentammo=s.currentammo+o.ammo_rockets;
+		if(s.currentammo>100) s.currentammo=100;
+		o.ammo_shells=o.ammo_nails=o.ammo_cells=0; // He throws 'em away
+		return 2;
+	}
+	else return 0;
+};
+
+void() player_ogre_become = {
+	local float temprockets;
+	bprint(self.netname);
+	bprint(" has become an ogre.\n");
+	self._stand=player_ogre_stand;
+	self._run=player_ogre_run;	
+	self._pain=player_ogre_pain1;
+	self._jump = SUB_Null;
+	self._jump2 = SUB_Null;
+	self._attack=player_ogre_attack;
+	self._impulse=player_ogre_impulse;
+	self._can_get_p=player_ogre_can_get_p;
+	self._killmsg=player_ogre_killmsg;
+	self._killmsg2=player_ogre_killmsg2;
+	setmodel(self,"progs/ogre.mdl");
+	self.modelindex_morph=self.modelindex;
+	self.weaponmodel="";
+	self.view_ofs = '0 0 32';
+	if(!deathmatch) setsize (self, VEC_HULL_MIN, VEC_HULL_MAX);
+	else 	setsize (self, '-16 -16 -24', '16 16 40');
+	self.health = self.health * 2.75 / self.health_modifier;
+	self.health_modifier = 2.75;
+	makevectors(self.v_angle);
+	spawn_tfog(self.origin + 20 * v_forward);
+	temprockets=self.ammo_rockets;
+	self.ammo_rockets=0;
+	DropBackpack2();
+	self.ammo_rockets=temprockets;
+	self.currentammo=0;
+	self.weapon=IT_AXE;
+};
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/m-shalra.qc morph/m-shalra.qc
--- v101qc/m-shalra.qc	Wed Dec 31 18:00:00 1969
+++ morph/m-shalra.qc	Thu Aug 22 17:12:35 1996
@@ -0,0 +1,166 @@
+/*
+==============================================================================
+
+SHAL-RATH
+
+==============================================================================
+*/
+$cd /raid/quake/id1/models/shalrath
+$origin 0 0 24
+$base base
+$skin skin
+$scale 0.7
+
+$frame attack1 attack2 attack3 attack4 attack5 attack6 attack7 attack8
+$frame attack9 attack10 attack11
+
+$frame pain1 pain2 pain3 pain4 pain5 
+
+$frame death1 death2 death3 death4 death5 death6 death7
+
+$frame	walk1 walk2 walk3 walk4 walk5 walk6 walk7 walk8 walk9 walk10
+$frame	walk11 walk12
+
+void() player_shalrath_stand = [ $walk1, player_stand1 ] { };
+void() player_shalrath_run = {
+	if(self.walkframe >= 12)
+		self.walkframe = 0;
+	self.frame = $walk1 + self.walkframe;
+	self.walkframe = self.walkframe + 1;
+};
+
+void() player_shalrath_pain1 = [ $pain1, player_shalrath_pain2 ] {sound (self, CHAN_VOICE, "shalrath/pain.wav", 1, ATTN_NORM);};
+void() player_shalrath_pain2 = [ $pain1, player_shalrath_pain3 ] {};
+void() player_shalrath_pain3 = [ $pain1, player_shalrath_pain4 ] {};
+void() player_shalrath_pain4 = [ $pain1, player_shalrath_pain5 ] {};
+void() player_shalrath_pain5 = [ $pain1, player_stand1 ] {};
+
+// void() player_shalrath_jump = { self.velocity_z=10; };
+
+void() player_ShalMissileTouch =
+{
+	if (other == self.owner)
+		return;		// don't explode on owner
+
+	if (other.classname == "monster_zombie")
+		T_Damage (other, self, self, 110);	
+	T_RadiusDamage (self, self.owner, 80, world);
+	sound (self, CHAN_WEAPON, "weapons/r_exp3.wav", 1, ATTN_NORM);
+
+	WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
+	WriteByte (MSG_BROADCAST, TE_EXPLOSION);
+	WriteCoord (MSG_BROADCAST, self.origin_x);
+	WriteCoord (MSG_BROADCAST, self.origin_y);
+	WriteCoord (MSG_BROADCAST, self.origin_z);
+
+	self.velocity = '0 0 0';
+	self.touch = SUB_Null;
+	setmodel (self, "progs/s_explod.spr");
+	self.solid = SOLID_NOT;
+	s_explode1 ();
+};
+/*
+================
+player_ShalMissile
+================
+*/
+void() ShalHome;
+void() player_ShalMissile =
+{
+	local	entity 	missile;
+
+	makevectors(self.v_angle);
+
+	self.effects = self.effects | EF_MUZZLEFLASH;
+	sound (self, CHAN_WEAPON, "shalrath/attack2.wav", 1, ATTN_NORM);
+
+	missile = spawn ();
+	missile.owner = self;
+
+	missile.solid = SOLID_BBOX;
+	missile.movetype = MOVETYPE_FLYMISSILE;
+	setmodel (missile, "progs/v_spike.mdl");
+
+	setsize (missile, '0 0 0', '0 0 0');		
+
+	makevectors (self.v_angle);
+	if(self.enemy.classname == "worldspawn") {
+		traceline (self.origin, self.origin + v_forward * 2048, FALSE, self);
+		self.enemy=trace_ent;
+	}
+	missile.velocity = v_forward;
+	if(self.enemy.classname == "worldspawn") {
+		missile.enemy = world;
+		//missile.velocity = v_forward;
+	} else {
+		missile.enemy = self.enemy;
+		//missile.velocity = normalize(self.enemy.origin - self.origin);
+	}
+
+	missile.velocity = missile.velocity * 400;
+	missile.angles = vectoangles(missile.velocity);
+
+	missile.origin = self.origin + '0 0 10';
+	missile.avelocity = '300 300 300';
+	missile.nextthink = 0.4 + time;
+	missile.think = ShalHome;
+	missile.touch = player_ShalMissileTouch;
+};
+
+void() player_shalrath_attack1 = [ $attack1, player_shalrath_attack2 ] {
+	local vector v;
+	sound (self, CHAN_VOICE, "shalrath/attack.wav", 1, ATTN_NORM);
+	self.attack_finished=time+1;
+	makevectors(self.v_angle);
+	v=aim(self, 2048);
+	traceline(self.origin+ self.view_ofs, self.origin+v * 2048 + self.view_ofs, FALSE, self);
+	if((trace_ent.classname != "worldspawn") && (trace_ent.takedamage & DAMAGE_AIM)) {
+		self.enemy = trace_ent;
+	} else if(self.enemy) {
+		if(!visible(self.enemy)) self.enemy=world;
+		if(!infront(self.enemy)) self.enemy=world;
+		if(self.enemy.health <=0) self.enemy=world;
+		if(self.enemy.takedamage != DAMAGE_AIM) self.enemy=world;
+	}
+};
+void() player_shalrath_attack2 = [ $attack2, player_shalrath_attack3 ] {};
+void() player_shalrath_attack3 = [ $attack4, player_shalrath_attack4 ] {};
+void() player_shalrath_attack4 = [ $attack8, player_shalrath_attack5 ] {};
+void() player_shalrath_attack5 = [ $attack10, player_stand1 ] {player_ShalMissile(); };
+	
+
+string() player_shalrath_killmsg = {
+	return " was exploded by ";
+};
+
+string() player_shalrath_killmsg2 = {
+	return ".\n";
+};
+
+void() player_shalrath_become = {
+	bprint(self.netname);
+	bprint(" has become a vore.\n");
+	self._stand=player_shalrath_stand;
+	self._run=player_shalrath_run;
+	self._pain=player_shalrath_pain1;
+	self._jump=SUB_Null;
+	self._jump2=SUB_Null;
+	self._attack=player_shalrath_attack1;
+	self._impulse=SUB_Nop;
+	self._can_get_p=SUB_False;
+	self._killmsg=player_shalrath_killmsg;
+	self._killmsg2=player_shalrath_killmsg2;
+	setmodel(self,"progs/shalrath.mdl");
+	self.modelindex_morph=self.modelindex;
+	self.weaponmodel="";
+	self.view_ofs = '0 0 22';
+	//setsize (self, VEC_HULL2_MIN, VEC_HULL2_MAX);
+	if(!deathmatch) setsize (self, VEC_HULL_MIN, VEC_HULL_MAX);
+	else 	setsize (self, VEC_HULL2_MIN, VEC_HULL2_MAX);
+	
+	self.health = self.health * 3.0 / self.health_modifier;
+	self.health_modifier = 3.0;
+	makevectors(self.v_angle);
+	spawn_tfog(self.origin + 20 * v_forward);
+	DropBackpack2();
+};
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/m-shambl.qc morph/m-shambl.qc
--- v101qc/m-shambl.qc	Wed Dec 31 18:00:00 1969
+++ morph/m-shambl.qc	Thu Aug 22 17:08:42 1996
@@ -0,0 +1,278 @@
+/*
+==============================================================================
+
+SHAMBLER
+
+==============================================================================
+*/
+
+$cd /raid/quake/id1/models/shams
+$origin 0 0 24
+$base base		
+$skin base
+
+$frame stand1 stand2 stand3 stand4 stand5 stand6 stand7 stand8 stand9
+$frame stand10 stand11 stand12 stand13 stand14 stand15 stand16 stand17
+
+$frame walk1 walk2 walk3 walk4 walk5 walk6 walk7 
+$frame walk8 walk9 walk10 walk11 walk12
+
+$frame	run1 run2 run3 run4 run5 run6
+
+$frame smash1 smash2 smash3 smash4 smash5 smash6 smash7 
+$frame smash8 smash9 smash10 smash11 smash12
+
+$frame swingr1 swingr2 swingr3 swingr4 swingr5 
+$frame swingr6 swingr7 swingr8 swingr9
+
+$frame swingl1 swingl2 swingl3 swingl4 swingl5 
+$frame swingl6 swingl7 swingl8 swingl9
+
+$frame magic1 magic2 magic3 magic4 magic5 
+$frame magic6 magic7 magic8 magic9 magic10 magic11 magic12
+
+$frame pain1 pain2 pain3 pain4 pain5 pain6
+
+$frame death1 death2 death3 death4 death5 death6 
+$frame death7 death8 death9 death10 death11
+
+void() player_shambler_stand = [ $stand1, player_stand1 ] {
+	if(self.walkframe >=  17)
+		self.walkframe = 0;
+	self.frame = $stand1 + self.walkframe;
+	self.walkframe = self.walkframe + 1;
+};
+	 
+void() player_shambler_run = [ $run1, player_run ] {
+	if(self.walkframe >= 6) 
+		self.walkframe = 0;
+	self.frame = $run1 + self.walkframe;
+	self.walkframe = self.walkframe + 1;
+};
+
+////////////////////////////////////////////
+// 5 frames of pain for player_shambler, going to player_stand1
+////////////////////////////////////////////
+
+void() player_shambler_pain1 = [ $pain1, player_shambler_pain2 ] { };
+void() player_shambler_pain2 = [ $pain2, player_shambler_pain3 ] { };
+void() player_shambler_pain3 = [ $pain3, player_shambler_pain4 ] { };
+void() player_shambler_pain4 = [ $pain4, player_shambler_pain5 ] { };
+void() player_shambler_pain5 = [ $pain5, player_stand1 ] { };
+
+void(entity attacker, float damage)	player_shambler_pain =
+{
+	sound (self, CHAN_VOICE, "shambler/shurt2.wav", 1, ATTN_NORM);
+
+	if (self.health <= 0)
+		return;		// allready dying, don't go into pain frame
+
+	if (random()*400 > damage)
+		return;		// didn't flinch
+
+	if (self.pain_finished > time)
+		return;
+	self.pain_finished = time + 2;
+		
+	player_shambler_pain1 ();
+};
+
+void() player_CastLightning =
+{
+	local	vector	org, dir;
+	
+	self.effects = self.effects | EF_MUZZLEFLASH;
+
+	if(self.waterlevel > 1) {
+		T_RadiusDamage(self, self, self.health, world); /* We all die! */
+		return;
+	}
+
+	org = self.origin + '0 0 40';
+
+	makevectors (self.v_angle);
+	dir = normalize (v_forward);
+
+	traceline (org, self.origin + dir*4096, TRUE, self);
+
+	WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
+	WriteByte (MSG_BROADCAST, TE_LIGHTNING1);
+	WriteEntity (MSG_BROADCAST, self);
+	WriteCoord (MSG_BROADCAST, org_x);
+	WriteCoord (MSG_BROADCAST, org_y);
+	WriteCoord (MSG_BROADCAST, org_z);
+	WriteCoord (MSG_BROADCAST, trace_endpos_x);
+	WriteCoord (MSG_BROADCAST, trace_endpos_y);
+	WriteCoord (MSG_BROADCAST, trace_endpos_z);
+
+	LightningDamage (org, trace_endpos, self, 10);
+};
+
+void() player_shambler_magic1     =[      $magic1,       player_shambler_magic2    ] {
+	sound (self, CHAN_WEAPON, "shambler/sattck1.wav", 1, ATTN_NORM);
+	self.attack_finished=time+1.1;
+};
+void() player_shambler_magic2     =[      $magic2,       player_shambler_magic3    ] {};
+void() player_shambler_magic3     =[      $magic3,       player_shambler_magic4    ] {
+	local entity o;
+	self.effects = self.effects | EF_MUZZLEFLASH;
+	self.owner = spawn();
+	o = self.owner;
+	setmodel (o, "progs/s_light.mdl");
+	setorigin (o, self.origin);
+	o.angles = self.angles;
+	o.nextthink = time + 0.7;
+	o.think = SUB_Remove;
+};
+void() player_shambler_magic4     =[      $magic4,       player_shambler_magic5    ]
+{ self.effects = self.effects | EF_MUZZLEFLASH; self.owner.frame = 1; };
+void() player_shambler_magic5     =[      $magic5,       player_shambler_magic6    ]
+{ self.effects = self.effects | EF_MUZZLEFLASH; self.owner.frame = 2; };
+void() player_shambler_magic6     =[      $magic6,       player_shambler_magic9    ] {
+	remove (self.owner);
+	player_CastLightning();
+	sound (self, CHAN_WEAPON, "shambler/sboom.wav", 1, ATTN_NORM);
+};
+void() player_shambler_magic9     =[      $magic9,       player_shambler_magic10   ]
+{player_CastLightning();};
+void() player_shambler_magic10    =[      $magic10,      player_shambler_magic11   ]
+{player_CastLightning();};
+void() player_shambler_magic11    =[      $magic11,      player_shambler_magic12   ]
+{player_CastLightning();};
+void() player_shambler_magic12    =[      $magic12,      player_stand1	   ] {};
+
+void() player_shambler_swingr1;
+
+void(float side) player_ShamClaw =
+{
+
+	local	vector	source;
+	local	vector	org;
+	local float 	ldmg;
+
+	sound (self, CHAN_VOICE, "shambler/smack.wav", 1, ATTN_NORM);
+
+	source = self.origin + '0 0 16';
+	traceline (source, source + v_forward*128, FALSE, self);
+	if (trace_fraction == 1.0)
+		return;
+	
+	org = trace_endpos - v_forward*4;
+
+	if (trace_ent.takedamage)
+	{
+		trace_ent.axhitme = 1;
+		SpawnBlood (org, '0 0 0', 20);
+		if (side)
+		{
+			makevectors (self.angles);
+			SpawnMeatSpray (self.origin + v_forward*16, side * v_right);
+		}
+		ldmg = (random() + random() + random()) * 20;
+		T_Damage (trace_ent, self, self, ldmg);
+	}
+	else
+	{	// hit wall
+		sound (self, CHAN_WEAPON, "player/axhit2.wav", 1, ATTN_NORM);
+		WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
+		WriteByte (MSG_BROADCAST, TE_GUNSHOT);
+		WriteCoord (MSG_BROADCAST, org_x);
+		WriteCoord (MSG_BROADCAST, org_y);
+		WriteCoord (MSG_BROADCAST, org_z);
+	}
+
+};
+
+void() player_shambler_smash1     =[      $smash1,       player_shambler_smash2    ] {
+sound (self, CHAN_VOICE, "shambler/melee1.wav", 1, ATTN_NORM);
+};
+void() player_shambler_smash2     =[      $smash2,       player_shambler_smash3    ] {};
+void() player_shambler_smash3     =[      $smash3,       player_shambler_smash4    ] {};
+void() player_shambler_smash4     =[      $smash4,       player_shambler_smash5    ] {};
+void() player_shambler_smash5     =[      $smash5,       player_shambler_smash6    ] {};
+void() player_shambler_smash6     =[      $smash6,       player_shambler_smash7    ] {};
+void() player_shambler_smash7     =[      $smash7,       player_shambler_smash8    ] {};
+void() player_shambler_smash8     =[      $smash8,       player_shambler_smash9    ] {};
+void() player_shambler_smash9     =[      $smash9,       player_shambler_smash10   ] {player_ShamClaw(150); };
+void() player_shambler_smash10    =[      $smash10,      player_shambler_smash11   ] {player_ShamClaw(150);};
+void() player_shambler_smash11    =[      $smash11,      player_shambler_smash12   ] {player_ShamClaw(150);};
+void() player_shambler_smash12    =[      $smash12,      player_run	   ] {};
+
+void() player_shambler_swingl1	=[      $swingl1,      player_shambler_swingl2   ] {
+sound (self, CHAN_VOICE, "shambler/melee2.wav", 1, ATTN_NORM);
+};
+void() player_shambler_swingl2 =[      $swingl2,      player_shambler_swingl3   ] {};
+void() player_shambler_swingl3 =[      $swingl3,      player_shambler_swingl4   ] {};
+void() player_shambler_swingl4 =[      $swingl4,      player_shambler_swingl5   ] {};
+void() player_shambler_swingl5 =[      $swingl5,      player_shambler_swingl6   ] {};
+void() player_shambler_swingl6 =[      $swingl6,      player_shambler_swingl7   ] {};
+void() player_shambler_swingl7 =[      $swingl7,      player_shambler_swingl8   ] { player_ShamClaw(250);};
+void() player_shambler_swingl8 =[      $swingl8,      player_shambler_swingl9   ] {};
+void() player_shambler_swingl9 =[      $swingl9,      player_run  ] {};
+
+void() player_shambler_swingr1	=[      $swingr1,      player_shambler_swingr2   ] {
+sound (self, CHAN_VOICE, "shambler/melee1.wav", 1, ATTN_NORM);
+};
+void() player_shambler_swingr2	=[      $swingr2,      player_shambler_swingr3   ] {};
+void() player_shambler_swingr3 =[      $swingr3,      player_shambler_swingr4   ] {};
+void() player_shambler_swingr4 =[      $swingr4,      player_shambler_swingr5   ] {};
+void() player_shambler_swingr5 =[      $swingr5,      player_shambler_swingr6   ] {};
+void() player_shambler_swingr6 =[      $swingr6,      player_shambler_swingr7   ] {};
+void() player_shambler_swingr7 =[      $swingr7,      player_shambler_swingr8   ] { player_ShamClaw(-250);};
+void() player_shambler_swingr8 =[      $swingr8,      player_shambler_swingr9   ] {};
+void() player_shambler_swingr9 =[      $swingr9,      player_run  ] { };
+
+void() player_shambler_attack = {
+	if(self.weapon == IT_AXE) {
+		if(random()>0.9) {
+			self.attack_finished = time + 1.1;
+			player_shambler_smash1();
+		} else if(random()>0.5) {
+			self.attack_finished = time + 0.8;
+			player_shambler_swingl1();
+		} else {
+			self.attack_finished = time + 0.8;
+			player_shambler_swingr1();
+		}
+	} else {
+		player_shambler_magic1();
+	}
+};
+
+void() player_shambler_impulse = {
+	if(self.impulse == 1) self.weapon = IT_AXE;
+	else self.weapon = IT_EXTRA_WEAPON;
+};
+
+string(entity targ, entity attacker) player_shambler_killmsg = {
+	if(attacker.weapon == IT_AXE) return " was smashed by ";
+	else return " was zapped by ";
+};
+
+string() player_shambler_killmsg2 = { return "\n"; };
+
+void() player_shambler_become = {
+	bprint(self.netname);
+	bprint(" has become a shambler.\n");
+	self._stand=player_shambler_stand;
+	self._run=player_shambler_run;
+	self._pain=player_shambler_pain1;
+	self._jump=SUB_Null;
+	self._jump2=SUB_Null;
+	self._attack=player_shambler_attack;
+	self._impulse=player_shambler_impulse;
+	self._can_get_p=SUB_False;
+	self._killmsg=player_shambler_killmsg;
+	self._killmsg2=player_shambler_killmsg2;
+	setmodel(self,"progs/shambler.mdl");
+	self.modelindex_morph=self.modelindex;
+	self.weaponmodel = "";
+	if(!deathmatch) setsize (self, VEC_HULL_MIN, VEC_HULL_MAX);
+	else 	setsize (self, VEC_HULL2_MIN, VEC_HULL2_MAX);
+	self.view_ofs = '0 0 32';
+	self.health = self.health * 4.0 / self.health_modifier;
+	self.health_modifier = 4.0;
+	makevectors(self.v_angle);
+	spawn_tfog(self.origin + 20 * v_forward);
+	DropBackpack2();
+};
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/m-template.qc morph/m-template.qc
--- v101qc/m-template.qc	Wed Dec 31 18:00:00 1969
+++ morph/m-template.qc	Thu Aug 22 17:08:45 1996
@@ -0,0 +1,81 @@
+/// This is a template for adding a new morph.
+///
+/// Complete the fields you want to change from the base player
+///
+/// Add appropriate pre-caching for any sounds/models you use in this morph
+///
+/// Then add some way (an item, impulse, or anything else) to call
+/// player_XXX_become
+///
+/// The various fields you can set are:
+/// Functions:
+///
+/// _stand:  We want to show the standing animation
+/// _run:    We want to show the running/moving animation
+///          (You could check if the vlen(self.velocity) is large or small,
+///           and show either a running animation or a walking animation,
+///           since both are present in many monsters)
+/// _pain:   We just got hurt.  Maybe show a pain animation, make a sound, ...
+/// _jump, _jump2:   Player pressed the jump button.  Checks (in water, on ground)
+///          are _not_ made before _jump is called, but are made before _jump2 is
+///          called.  _jump2 is not called if _jump is not SUB_Null.
+/// _attack: time > self.attack_finished and we are pressing fire
+///          show attack animation, fire projectiles, set self.attack_finished
+///          Maybe check self.weapon, which can be set from _impulse
+/// _impulse: An impulse command from 1..9 was pressed.  Switch  weapon or do
+///          whatever else is appropriate 
+/// _can_get_p: Return true if player can get the item, or false if not.
+///          Note that 'self' is _not_ the player in _can_get_p.
+///          SUB_True and SUB_False can be used here.
+///          Currently, morphed players can _always_ get health
+///          Return 0 for 'not get', return 1 for 'can get'.
+///          In the case of ammo, return '2' for 'get, but don't update weapon'
+///          (I should add SUB_get_powerups/SUB_get_ammo, ...
+///           Or maybe make a bitfield, FL_GET_AMMO, FL_GET_WEAPON, ... ?)
+/// _killmsg, _killmsg2: Return the message that should be printed,
+///          similarly to the code in client.qc.  Again, self is not player
+///
+/// SUB_Null means to use the default player action,
+/// SUB_Nop means that the action does nothing (such as jump for the zombie)
+///
+///
+/// Variables:
+/// modelindex_morph: setmodel to the new model for player, then
+///          self.modelindex_morph=self.modelindex
+/// weaponmode, view_ofs: regular meaning
+/// health_modifier: the amount that health should be divided by when
+///          changing to another morph.  Generally, you multiply by this
+///          same number when becoming that morph
+///
+/// Call DropBackpack2() if it is inappropriate for the player to carry
+/// ammo in his new morph
+///
+/// If it's necessary to add a new behaviours, make sure you amend 
+/// the other player_*_become() to set it back the way it was
+
+void() player_template_become = {
+	bprint(self.netname);
+	bprint(" has become a template.\n");
+
+	self._stand=player_template_stand;
+	self._run=player_template_run;	
+	self._pain=player_template_pain;
+	self._jump=player_template_jump;
+	self._jump2=player_template_jump2;
+	self._attack=player_template_attack;
+	self._impulse=player_template_impulse;
+	self._can_get_p=player_template_can_get_p;
+	self._killmsg=player_template_killmsg;
+	self._killmsg2=player_template_killmsg2;
+	setmodel(self,"progs/template.mdl");
+	self.modelindex_morph=self.modelindex;
+	self.weaponmodel="";
+	self.view_ofs = '0 0 22';
+	if(!deathmatch) setsize (self, VEC_HULL_MIN, VEC_HULL_MAX);
+	else 	setsize (self, '-16 -16 -24', '16 16 40');
+	self.health = self.health * 0.75 / self.health_modifier;
+	self.health_modifier = 0.75;
+	makevectors(self.v_angle);
+	spawn_tfog(self.origin + 20 * v_forward);
+	DropBackpack2();
+};
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/m-wizard.qc morph/m-wizard.qc
--- v101qc/m-wizard.qc	Wed Dec 31 18:00:00 1969
+++ morph/m-wizard.qc	Thu Aug 22 17:09:08 1996
@@ -0,0 +1,151 @@
+
+/*
+==============================================================================
+
+WIZARD
+
+==============================================================================
+*/
+
+$cd /raid/quake/id1/models/a_wizard
+$origin 0 0 24
+$base wizbase	
+$skin wizbase
+
+$frame hover1 hover2 hover3 hover4 hover5 hover6 hover7 hover8
+$frame hover9 hover10 hover11 hover12 hover13 hover14 hover15
+
+$frame fly1 fly2 fly3 fly4 fly5 fly6 fly7 fly8 fly9 fly10
+$frame fly11 fly12 fly13 fly14
+
+$frame attack1 attack2 attack3 attack4 attack5 attack6 attack7
+$frame attack8 attack9 attack10 attack11 attack12 attack13
+
+$frame pain1 pain2 pain3 pain4
+
+$frame death1 death2 death3 death4 death5 death6 death7 death8
+
+void() player_wizard_stand = [ $hover1, player_stand1 ] {
+	if(self.walkframe >= 15)
+		self.walkframe = 0;
+	self.frame = $hover1 + self.walkframe;
+	self.walkframe = self.walkframe + 1;
+};
+
+void() player_wizard_run = [ $fly1, player_run ] {
+	if(self.walkframe >= 14)
+		self.walkframe=0;
+	self.frame = $fly1 + self.walkframe;
+	self.walkframe = self.walkframe + 1;
+};
+
+void() player_wizard_jump = {
+	self.velocity_z = 200;
+	Wiz_idlesound();
+};
+
+////////////////////////////////////////////
+// 4 frames of pain for player_wizard, going to player_stand1
+////////////////////////////////////////////
+
+void() player_wizard_pain1 = [ $pain1, player_wizard_pain2 ] {
+	sound (self, CHAN_VOICE, "wizard/wpain.wav", 1, ATTN_NORM);
+};
+void() player_wizard_pain2 = [ $pain2, player_wizard_pain3 ] { };
+void() player_wizard_pain3 = [ $pain3, player_wizard_pain4 ] { };
+void() player_wizard_pain4 = [ $pain4, player_stand1 ] { };
+
+void() player_Wiz_FastFire = {
+	local float offset;
+	local entity missile;
+	local vector dir;
+
+	if(random()>0.75) offset=0;
+	else if(random()>0.5) offset=0-(random()*10);
+	else offset=random()*10;
+
+	dir=self.v_angle;
+	dir_y=dir_y+offset;
+
+//	self.punchangle_x = -2;
+
+	missile = spawn ();
+	missile.owner = self;
+	missile.movetype = MOVETYPE_FLYMISSILE;
+	missile.solid = SOLID_BBOX;
+		
+// set missile speed	
+
+	missile.origin = self.origin;
+	makevectors (dir);
+	// missile.velocity = aim(self, 600);
+	missile.velocity = normalize(v_forward);
+	missile.velocity = missile.velocity * 1000;
+	missile.angles = vectoangles(missile.velocity);
+	missile.classname = "wizspike";
+	setmodel(missile, "progs/w_spike.mdl");
+	setsize(missile, '0 0 0', '0 0 0');
+	missile.touch = spike_touch;
+};
+
+////////////////////////////////////////////
+// 13 frames of attack for player_wizard, going to player_stand1
+////////////////////////////////////////////
+
+/*
+void() player_wizard_attack1 = [ $attack1, player_wizard_attack2 ] { self.attack_finished = time + 1.5; };
+void() player_wizard_attack2 = [ $attack2, player_wizard_attack3 ] { };
+void() player_wizard_attack3 = [ $attack3, player_wizard_attack4 ] { };
+void() player_wizard_attack4 = [ $attack4, player_wizard_attack5 ] { };
+void() player_wizard_attack5 = [ $attack5, player_wizard_attack6 ] { };
+void() player_wizard_attack6 = [ $attack6, player_wizard_attack7 ] { };
+void() player_wizard_attack7 = [ $attack7, player_wizard_attack8 ] { };
+void() player_wizard_attack8 = [ $attack8, player_wizard_attack9 ] { };
+void() player_wizard_attack9 = [ $attack9, player_wizard_attack10 ] { };
+void() player_wizard_attack10 = [ $attack10, player_wizard_attack11 ] { };
+void() player_wizard_attack11 = [ $attack11, player_wizard_attack12 ] { sound(self, CHAN_WEAPON, "wizard/wattack.wav", 1, ATTN_NORM);};
+void() player_wizard_attack12 = [ $attack12, player_wizard_attack13 ] {player_Wiz_FastFire(-10); };
+void() player_wizard_attack13 = [ $attack13, player_stand1 ] { player_Wiz_FastFire(-10);};
+*/
+
+void() player_wizard_attack1 = [ $attack1, player_wizard_attack3 ] { self.attack_finished = time + 1.0; };
+void() player_wizard_attack2 = [ $attack3, player_wizard_attack3 ] { };
+void() player_wizard_attack3 = [ $attack5, player_wizard_attack4 ] { };
+void() player_wizard_attack4 = [ $attack7, player_wizard_attack5 ] { sound(self, CHAN_WEAPON, "wizard/wattack.wav", 1, ATTN_NORM); };
+void() player_wizard_attack5 = [ $attack9, player_wizard_attack6 ] { player_Wiz_FastFire(); };
+void() player_wizard_attack6 = [ $attack11, player_wizard_attack7 ] { player_Wiz_FastFire(); };
+void() player_wizard_attack7 = [ $attack13, player_stand1 ] { player_Wiz_FastFire();};
+
+string() player_wizard_killmsg = {
+	return " was scragged by ";
+};
+
+string() player_wizard_killmsg2 = {
+	return ".\n";
+};
+
+void() player_wizard_become = {
+	bprint(self.netname);
+	bprint(" has become a scrag.\n");
+	self._stand=player_wizard_stand;
+	self._run=player_wizard_run;
+	self._pain=player_wizard_pain1;
+	self._jump=player_wizard_jump;
+	self._jump2=player_wizard_jump;
+	self._attack=player_wizard_attack1;
+	self._impulse=SUB_Nop;
+	self._can_get_p=SUB_False;
+	self._killmsg=player_wizard_killmsg;
+	self._killmsg2=player_wizard_killmsg2;
+	setmodel(self,"progs/wizard.mdl");
+	self.modelindex_morph=self.modelindex;
+	self.weaponmodel = "";
+	if(!deathmatch) setsize (self, VEC_HULL_MIN, VEC_HULL_MAX);
+	else 	setsize (self, '-16 -16 -24', '16 16 40');
+	self.view_ofs = '0 0 22';
+	self.health = self.health * 2.0 / self.health_modifier;
+	self.health_modifier = 2.0;
+	makevectors(self.v_angle);
+	spawn_tfog(self.origin + 20 * v_forward);
+	DropBackpack2();
+};
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/m-zombie.qc morph/m-zombie.qc
--- v101qc/m-zombie.qc	Wed Dec 31 18:00:00 1969
+++ morph/m-zombie.qc	Thu Aug 22 17:09:17 1996
@@ -0,0 +1,347 @@
+$cd /raid/quake/id1/models/zombie
+
+$origin	0 0 24
+
+$base base
+$skin skin
+
+$frame stand1 stand2 stand3 stand4 stand5 stand6 stand7 stand8
+$frame stand9 stand10 stand11 stand12 stand13 stand14 stand15
+
+$frame walk1 walk2 walk3 walk4 walk5 walk6 walk7 walk8 walk9 walk10 walk11
+$frame walk12 walk13 walk14 walk15 walk16 walk17 walk18 walk19
+
+$frame run1 run2 run3 run4 run5 run6 run7 run8 run9 run10 run11 run12
+$frame run13 run14 run15 run16 run17 run18
+
+$frame atta1 atta2 atta3 atta4 atta5 atta6 atta7 atta8 atta9 atta10 atta11
+$frame atta12 atta13
+
+$frame attb1 attb2 attb3 attb4 attb5 attb6 attb7 attb8 attb9 attb10 attb11
+$frame attb12 attb13 attb14
+
+$frame attc1 attc2 attc3 attc4 attc5 attc6 attc7 attc8 attc9 attc10 attc11
+$frame attc12
+
+$frame paina1 paina2 paina3 paina4 paina5 paina6 paina7 paina8 paina9 paina10
+$frame paina11 paina12
+
+$frame painb1 painb2 painb3 painb4 painb5 painb6 painb7 painb8 painb9 painb10
+$frame painb11 painb12 painb13 painb14 painb15 painb16 painb17 painb18 painb19
+$frame painb20 painb21 painb22 painb23 painb24 painb25 painb26 painb27 painb28
+
+$frame painc1 painc2 painc3 painc4 painc5 painc6 painc7 painc8 painc9 painc10
+$frame painc11 painc12 painc13 painc14 painc15 painc16 painc17 painc18
+
+$frame paind1 paind2 paind3 paind4 paind5 paind6 paind7 paind8 paind9 paind10
+$frame paind11 paind12 paind13
+
+$frame paine1 paine2 paine3 paine4 paine5 paine6 paine7 paine8 paine9 paine10
+$frame paine11 paine12 paine13 paine14 paine15 paine16 paine17 paine18 paine19
+$frame paine20 paine21 paine22 paine23 paine24 paine25 paine26 paine27 paine28
+$frame paine29 paine30
+
+$frame cruc_1 cruc_2 cruc_3 cruc_4 cruc_5 cruc_6
+
+/* Morph to zombie */
+
+void() player_zombie_stand = [ $stand1, player_stand1 ] {
+	if(self.walkframe >= 15)
+		self.walkframe = 0;
+		if(self.health < 75) self.health = self.health + 1; // Zombies regenerate
+	self.frame = $stand1 + self.walkframe;
+	self.walkframe = self.walkframe + 1;
+};
+
+void() player_zombie_run = [ $run1, player_run ] {
+	if(self.walkframe >= 19)
+		self.walkframe = 0;
+	self.frame = $run1 + self.walkframe;
+	self.walkframe = self.walkframe + 1;
+};
+
+////////////////////////////////////////////
+// 12 frames of paina for player_zombie, going to stand
+////////////////////////////////////////////
+
+void() player_zombie_paina1 = [ $paina1, player_zombie_paina2 ] {self.attack_finished=time+10; self.movetype=MOVETYPE_NONE;};
+void() player_zombie_paina2 = [ $paina2, player_zombie_paina3 ] { };
+void() player_zombie_paina3 = [ $paina3, player_zombie_paina4 ] { };
+void() player_zombie_paina4 = [ $paina4, player_zombie_paina5 ] { };
+void() player_zombie_paina5 = [ $paina5, player_zombie_paina6 ] { };
+void() player_zombie_paina6 = [ $paina6, player_zombie_paina7 ] { };
+void() player_zombie_paina7 = [ $paina7, player_zombie_paina8 ] { };
+void() player_zombie_paina8 = [ $paina8, player_zombie_paina9 ] { };
+void() player_zombie_paina9 = [ $paina9, player_zombie_paina10 ] { };
+void() player_zombie_paina10 = [ $paina10, player_zombie_paina11 ] { };
+void() player_zombie_paina11 = [ $paina11, player_zombie_paina12 ] { };
+void() player_zombie_paina12 = [ $paina12, player_stand1 ] {self.attack_finished=time; self.movetype=MOVETYPE_WALK;};
+
+////////////////////////////////////////////
+// 28 frames of painb for player_zombie, going to stand
+////////////////////////////////////////////
+
+void() player_zombie_painb1 = [ $painb1, player_zombie_painb2 ] {self.attack_finished=time+10; self.movetype=MOVETYPE_NONE;};
+void() player_zombie_painb2 = [ $painb2, player_zombie_painb3 ] { };
+void() player_zombie_painb3 = [ $painb3, player_zombie_painb4 ] { };
+void() player_zombie_painb4 = [ $painb4, player_zombie_painb5 ] { };
+void() player_zombie_painb5 = [ $painb5, player_zombie_painb6 ] { };
+void() player_zombie_painb6 = [ $painb6, player_zombie_painb7 ] { };
+void() player_zombie_painb7 = [ $painb7, player_zombie_painb8 ] { };
+void() player_zombie_painb8 = [ $painb8, player_zombie_painb9 ] { };
+void() player_zombie_painb9 = [ $painb9, player_zombie_painb10 ] { };
+void() player_zombie_painb10 = [ $painb10, player_zombie_painb11 ] { };
+void() player_zombie_painb11 = [ $painb11, player_zombie_painb12 ] { };
+void() player_zombie_painb12 = [ $painb12, player_zombie_painb13 ] { };
+void() player_zombie_painb13 = [ $painb13, player_zombie_painb14 ] { };
+void() player_zombie_painb14 = [ $painb14, player_zombie_painb15 ] { };
+void() player_zombie_painb15 = [ $painb15, player_zombie_painb16 ] { };
+void() player_zombie_painb16 = [ $painb16, player_zombie_painb17 ] { };
+void() player_zombie_painb17 = [ $painb17, player_zombie_painb18 ] { };
+void() player_zombie_painb18 = [ $painb18, player_zombie_painb19 ] { };
+void() player_zombie_painb19 = [ $painb19, player_zombie_painb20 ] { };
+void() player_zombie_painb20 = [ $painb20, player_zombie_painb21 ] { };
+void() player_zombie_painb21 = [ $painb21, player_zombie_painb22 ] { };
+void() player_zombie_painb22 = [ $painb22, player_zombie_painb23 ] { };
+void() player_zombie_painb23 = [ $painb23, player_zombie_painb24 ] { };
+void() player_zombie_painb24 = [ $painb24, player_zombie_painb25 ] { };
+void() player_zombie_painb25 = [ $painb25, player_zombie_painb26 ] { };
+void() player_zombie_painb26 = [ $painb26, player_zombie_painb27 ] { };
+void() player_zombie_painb27 = [ $painb27, player_zombie_painb28 ] { };
+void() player_zombie_painb28 = [ $painb28, player_stand1 ] {self.attack_finished=time; self.movetype=MOVETYPE_WALK;};
+
+////////////////////////////////////////////
+// 18 frames of painc for player_zombie, going to stand
+////////////////////////////////////////////
+
+void() player_zombie_painc1 = [ $painc1, player_zombie_painc2 ] {self.attack_finished=time+10; self.movetype=MOVETYPE_NONE;};
+void() player_zombie_painc2 = [ $painc2, player_zombie_painc3 ] { };
+void() player_zombie_painc3 = [ $painc3, player_zombie_painc4 ] { };
+void() player_zombie_painc4 = [ $painc4, player_zombie_painc5 ] { };
+void() player_zombie_painc5 = [ $painc5, player_zombie_painc6 ] { };
+void() player_zombie_painc6 = [ $painc6, player_zombie_painc7 ] { };
+void() player_zombie_painc7 = [ $painc7, player_zombie_painc8 ] { };
+void() player_zombie_painc8 = [ $painc8, player_zombie_painc9 ] { };
+void() player_zombie_painc9 = [ $painc9, player_zombie_painc10 ] { };
+void() player_zombie_painc10 = [ $painc10, player_zombie_painc11 ] { };
+void() player_zombie_painc11 = [ $painc11, player_zombie_painc12 ] { };
+void() player_zombie_painc12 = [ $painc12, player_zombie_painc13 ] { };
+void() player_zombie_painc13 = [ $painc13, player_zombie_painc14 ] { };
+void() player_zombie_painc14 = [ $painc14, player_zombie_painc15 ] { };
+void() player_zombie_painc15 = [ $painc15, player_zombie_painc16 ] { };
+void() player_zombie_painc16 = [ $painc16, player_zombie_painc17 ] { };
+void() player_zombie_painc17 = [ $painc17, player_zombie_painc18 ] { };
+void() player_zombie_painc18 = [ $painc18, player_stand1 ] {self.attack_finished=time; self.movetype=MOVETYPE_WALK;};
+
+////////////////////////////////////////////
+// 13 frames of paind for player_zombie, going to stand
+////////////////////////////////////////////
+
+void() player_zombie_paind1 = [ $paind1, player_zombie_paind2 ] {self.attack_finished=time+10; self.movetype=MOVETYPE_NONE;};
+void() player_zombie_paind2 = [ $paind2, player_zombie_paind3 ] { };
+void() player_zombie_paind3 = [ $paind3, player_zombie_paind4 ] { };
+void() player_zombie_paind4 = [ $paind4, player_zombie_paind5 ] { };
+void() player_zombie_paind5 = [ $paind5, player_zombie_paind6 ] { };
+void() player_zombie_paind6 = [ $paind6, player_zombie_paind7 ] { };
+void() player_zombie_paind7 = [ $paind7, player_zombie_paind8 ] { };
+void() player_zombie_paind8 = [ $paind8, player_zombie_paind9 ] { };
+void() player_zombie_paind9 = [ $paind9, player_zombie_paind10 ] { };
+void() player_zombie_paind10 = [ $paind10, player_zombie_paind11 ] { };
+void() player_zombie_paind11 = [ $paind11, player_zombie_paind12 ] { };
+void() player_zombie_paind12 = [ $paind12, player_zombie_paind13 ] { };
+void() player_zombie_paind13 = [ $paind13, player_stand1 ] {self.attack_finished=time; self.movetype=MOVETYPE_WALK;};
+
+////////////////////////////////////////////
+// 30 frames of paine for player_zombie, going to stand
+////////////////////////////////////////////
+
+void() player_zombie_paine1 = [ $paine1, player_zombie_paine2 ] {self.attack_finished=time+10; self.movetype=MOVETYPE_NONE;};
+void() player_zombie_paine2 = [ $paine2, player_zombie_paine3 ] { };
+void() player_zombie_paine3 = [ $paine3, player_zombie_paine4 ] { };
+void() player_zombie_paine4 = [ $paine4, player_zombie_paine5 ] { };
+void() player_zombie_paine5 = [ $paine5, player_zombie_paine6 ] { };
+void() player_zombie_paine6 = [ $paine6, player_zombie_paine7 ] { };
+void() player_zombie_paine7 = [ $paine7, player_zombie_paine8 ] { };
+void() player_zombie_paine8 = [ $paine8, player_zombie_paine9 ] { };
+void() player_zombie_paine9 = [ $paine9, player_zombie_paine10 ] { };
+void() player_zombie_paine10 = [ $paine10, player_zombie_paine11 ] { };
+void() player_zombie_paine11 = [ $paine11, player_zombie_paine12 ] { };
+void() player_zombie_paine12 = [ $paine12, player_zombie_paine13 ] { };
+void() player_zombie_paine13 = [ $paine13, player_zombie_paine14 ] { };
+void() player_zombie_paine14 = [ $paine14, player_zombie_paine15 ] { };
+void() player_zombie_paine15 = [ $paine15, player_zombie_paine16 ] { };
+void() player_zombie_paine16 = [ $paine16, player_zombie_paine17 ] { };
+void() player_zombie_paine17 = [ $paine17, player_zombie_paine18 ] { };
+void() player_zombie_paine18 = [ $paine18, player_zombie_paine19 ] { };
+void() player_zombie_paine19 = [ $paine19, player_zombie_paine20 ] { };
+void() player_zombie_paine20 = [ $paine20, player_zombie_paine21 ] { };
+void() player_zombie_paine21 = [ $paine21, player_zombie_paine22 ] { };
+void() player_zombie_paine22 = [ $paine22, player_zombie_paine23 ] { };
+void() player_zombie_paine23 = [ $paine23, player_zombie_paine24 ] { };
+void() player_zombie_paine24 = [ $paine24, player_zombie_paine25 ] { };
+void() player_zombie_paine25 = [ $paine25, player_zombie_paine26 ] { };
+void() player_zombie_paine26 = [ $paine26, player_zombie_paine27 ] { };
+void() player_zombie_paine27 = [ $paine27, player_zombie_paine28 ] { };
+void() player_zombie_paine28 = [ $paine28, player_zombie_paine29 ] { };
+void() player_zombie_paine29 = [ $paine29, player_zombie_paine30 ] { };
+void() player_zombie_paine30 = [ $paine30, player_stand1 ] {self.attack_finished=time; self.movetype=MOVETYPE_WALK;};
+
+void(entity attacker, float take) player_zombie_pain = {
+	if(self.health < 70) self.health=70;
+	if(self.pain_finished > time) return;
+	self.pain_finished = time + 10;
+	if(random()>0.50) sound (self, CHAN_VOICE, "zombie/z_pain.wav", 1, ATTN_NORM);
+	else sound(self, CHAN_VOICE, "zombie/z_pain1.wav", 1, ATTN_NORM);
+	if(take > 60) {
+		if(random()>0.50) player_zombie_paine1();
+		else player_zombie_painb1();
+	} else {
+		if(random()>0.66) player_zombie_paina1();
+		else if(random()>0.50) player_zombie_painc1();
+		else player_zombie_paind1();
+	}
+};
+
+void() player_zombie_jump = {
+	// Zombies can't jump
+};
+
+void() player_ZombieFireGrenade =
+{
+	local	entity missile, mpuff;
+
+	sound (self, CHAN_WEAPON, "zombie/z_shot1.wav", 1, ATTN_NORM);
+
+	self.punchangle_x = -2;
+
+	missile = spawn ();
+	missile.owner = self;
+	missile.movetype = MOVETYPE_BOUNCE;
+	missile.solid = SOLID_BBOX;
+	missile.classname = "grenade";
+
+// set missile speed	
+
+	makevectors (self.v_angle);
+
+	if(self.v_angle_x)
+		missile.velocity = v_forward*600 + v_up * 200 + crandom()*v_right*10 + crandom()*v_up*10;
+	else {
+		missile.velocity = aim(self, 10000);
+		missile.velocity = missile.velocity * 600;
+		missile.velocity_z = 200;
+	}
+	
+	missile.avelocity = '3000 1000 2000';
+
+	missile.angles = vectoangles(missile.velocity);
+
+	missile.touch = ZombieGrenadeTouch;
+	
+// set missile duration
+	missile.nextthink = time + 2.5;
+	missile.think = SUB_Remove;
+
+	setmodel (missile, "progs/zom_gib.mdl");
+	setsize (missile, '0 0 0', '0 0 0');		
+	setorigin (missile, self.origin);
+};
+////////////////////////////////////////////
+// 13 frames of atta for player_zombie, going to stand
+////////////////////////////////////////////
+
+void() player_zombie_atta1 = [ $atta1, player_zombie_atta2 ] { };
+void() player_zombie_atta2 = [ $atta2, player_zombie_atta3 ] { };
+void() player_zombie_atta3 = [ $atta3, player_zombie_atta4 ] { };
+void() player_zombie_atta4 = [ $atta4, player_zombie_atta5 ] { };
+void() player_zombie_atta5 = [ $atta5, player_zombie_atta6 ] { };
+void() player_zombie_atta6 = [ $atta6, player_zombie_atta7 ] { };
+void() player_zombie_atta7 = [ $atta7, player_zombie_atta8 ] { };
+void() player_zombie_atta8 = [ $atta8, player_zombie_atta9 ] { };
+void() player_zombie_atta9 = [ $atta9, player_zombie_atta10 ] { };
+void() player_zombie_atta10 = [ $atta10, player_zombie_atta11 ] { };
+void() player_zombie_atta11 = [ $atta11, player_zombie_atta12 ] { };
+void() player_zombie_atta12 = [ $atta12, player_zombie_atta13 ] { };
+void() player_zombie_atta13 = [ $atta13, player_stand1 ] { player_ZombieFireGrenade(); self.attack_finished=time; };
+
+////////////////////////////////////////////
+// 14 frames of attb for player_zombie, going to stand
+////////////////////////////////////////////
+
+void() player_zombie_attb1 = [ $attb1, player_zombie_attb2 ] { };
+void() player_zombie_attb2 = [ $attb2, player_zombie_attb3 ] { };
+void() player_zombie_attb3 = [ $attb3, player_zombie_attb4 ] { };
+void() player_zombie_attb4 = [ $attb4, player_zombie_attb5 ] { };
+void() player_zombie_attb5 = [ $attb5, player_zombie_attb6 ] { };
+void() player_zombie_attb6 = [ $attb6, player_zombie_attb7 ] { };
+void() player_zombie_attb7 = [ $attb7, player_zombie_attb8 ] { };
+void() player_zombie_attb8 = [ $attb8, player_zombie_attb9 ] { };
+void() player_zombie_attb9 = [ $attb9, player_zombie_attb10 ] { };
+void() player_zombie_attb10 = [ $attb10, player_zombie_attb11 ] { };
+void() player_zombie_attb11 = [ $attb11, player_zombie_attb12 ] { };
+void() player_zombie_attb12 = [ $attb12, player_zombie_attb13 ] { };
+void() player_zombie_attb13 = [ $attb12, player_zombie_attb14 ] { };
+void() player_zombie_attb14 = [ $attb14, player_stand1 ] { player_ZombieFireGrenade(); self.attack_finished=time; };
+
+////////////////////////////////////////////
+// 12 frames of attc for player_zombie, going to stand
+////////////////////////////////////////////
+
+void() player_zombie_attc1 = [ $attc1, player_zombie_attc2 ] { };
+void() player_zombie_attc2 = [ $attc2, player_zombie_attc3 ] { };
+void() player_zombie_attc3 = [ $attc3, player_zombie_attc4 ] { };
+void() player_zombie_attc4 = [ $attc4, player_zombie_attc5 ] { };
+void() player_zombie_attc5 = [ $attc5, player_zombie_attc6 ] { };
+void() player_zombie_attc6 = [ $attc6, player_zombie_attc7 ] { };
+void() player_zombie_attc7 = [ $attc7, player_zombie_attc8 ] { };
+void() player_zombie_attc8 = [ $attc8, player_zombie_attc9 ] { };
+void() player_zombie_attc9 = [ $attc9, player_zombie_attc10 ] { };
+void() player_zombie_attc10 = [ $attc10, player_zombie_attc11 ] { };
+void() player_zombie_attc11 = [ $attc11, player_zombie_attc12 ] { };
+void() player_zombie_attc12 = [ $attc12, player_stand1 ] { player_ZombieFireGrenade(); self.attack_finished=time; };
+
+void() player_zombie_attack = {
+	self.attack_finished=time+10;
+	if(random()>0.66) player_zombie_atta1();
+	else if(random()>0.5) player_zombie_attb1();
+	else player_zombie_attc1();
+};
+
+void() player_zombie_impulse = {
+	// Zombie has only one weapon
+};
+
+string() player_zombie_killmsg = {
+	return " was splatted to death by ";
+};
+
+string() player_zombie_killmsg2 = {
+	return ".\n";
+};
+
+void() player_zombie_become = {
+	bprint(self.netname);
+	bprint(" has become a zombie.\n");
+	self._stand=player_zombie_stand;
+	self._run=player_zombie_run;
+	self._pain=player_zombie_pain;
+	self._jump=SUB_Nop;
+	self._jump2=SUB_Nop;
+	self._attack=player_zombie_attack;
+	self._impulse=player_zombie_impulse;
+	self._can_get_p=SUB_False;
+	self._killmsg=player_zombie_killmsg;
+	self._killmsg2=player_zombie_killmsg2;
+	setmodel(self,"progs/zombie.mdl");
+	self.modelindex_morph=self.modelindex;
+	self.weaponmodel="";
+	self.view_ofs = '0 0 22';
+	if(!deathmatch) setsize (self, VEC_HULL_MIN, VEC_HULL_MAX);
+	else 	setsize (self, '-16 -16 -24', '16 16 40');
+	self.health = self.health * 0.75 / self.health_modifier;
+	self.health_modifier = 0.75;
+	makevectors(self.v_angle);
+	spawn_tfog(self.origin + 20 * v_forward);
+	DropBackpack2();
+};
+
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/ogre.qc morph/ogre.qc
--- v101qc/ogre.qc	Thu Jul 25 01:51:23 1996
+++ morph/ogre.qc	Fri Aug 16 08:00:55 1996
@@ -449,6 +449,9 @@
 	self.th_missile = ogre_nail1;
 	self.th_pain = ogre_pain;
 	
+	self.weaponmodel="progs/ogre.mdl";
+	self.weaponframe=0;
+
 	walkmonster_start();
 };
 
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/player.qc morph/player.qc
--- v101qc/player.qc	Thu Jul 25 01:51:23 1996
+++ morph/player.qc	Wed Aug 14 07:45:38 1996
@@ -98,6 +98,8 @@
 		return;
 	}
 
+	if (self._stand != SUB_Null) { self._stand(); return; }
+
 	if (self.weapon == IT_AXE)
 	{
 		if (self.walkframe >= 12)
@@ -122,6 +124,7 @@
 		player_stand1();
 		return;
 	}
+	if (self._run != SUB_Null) { self._run(); return; }
 
 	if (self.weapon == IT_AXE)
 	{
@@ -334,8 +337,10 @@
 void()	player_axpain5 =	[	$axpain5,	player_axpain6	] {};
 void()	player_axpain6 =	[	$axpain6,	player_run	] {};
 
-void() player_pain =
+void(entity attacker, float take) player_pain =
 {
+	if (self._pain != SUB_Null) { self._pain(attacker, take); return; }
+
 	if (self.weaponframe)
 		return;
 
@@ -531,6 +536,8 @@
 	self.super_damage_finished = 0;
 	self.radsuit_finished = 0;
 	self.modelindex = modelindex_player;	// don't use eyes
+	setmodel(self,"progs/player.mdl"); // In case he was morphed
+	setsize (self, VEC_HULL_MIN, VEC_HULL_MAX);
 
 	if (deathmatch || coop)
 		DropBackpack();
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/progs.src morph/progs.src
--- v101qc/progs.src	Wed Jul 31 21:15:26 1996
+++ morph/progs.src	Wed Aug 14 15:13:23 1996
@@ -33,3 +33,12 @@
 shalrath.qc		// registered
 enforcer.qc		// registered
 oldone.qc		// registered
+
+m-zombie.qc		// Morphing
+m-ogre.qc	
+m-demon.qc
+m-human.qc
+m-shalra.qc
+m-wizard.qc
+m-hknigh.qc
+m-shambl.qc
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/shalrath.qc morph/shalrath.qc
--- v101qc/shalrath.qc	Thu Jul 25 01:51:23 1996
+++ morph/shalrath.qc	Wed Aug 14 23:52:12 1996
@@ -160,18 +160,24 @@
 {
 	local vector	dir, vtemp;
 	vtemp = self.enemy.origin + '0 0 10';
+	if (!self.enemy) {
+		return;
+	}
 	if (self.enemy.health < 1)
 	{
 		remove(self);
 		return;
 	}
+	self.nextthink = time + 0.2;
+	self.think = ShalHome;	
+	// Go where last seen if not now visible
+	// For player and nightmare real monsters
+	if (self.owner.classname == "player" || skill == 3) if(!visible(self.enemy)) return;
 	dir = normalize(vtemp - self.origin);
 	if (skill == 3)
 		self.velocity = dir * 350;
 	else
 		self.velocity = dir * 250;
-	self.nextthink = time + 0.2;
-	self.think = ShalHome;	
 };
 
 void() ShalMissileTouch =
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/subs.qc morph/subs.qc
--- v101qc/subs.qc	Thu Jul 25 01:51:24 1996
+++ morph/subs.qc	Tue Aug 13 13:45:52 1996
@@ -314,3 +314,9 @@
 	self.cnt = 1;
 	self.think = thinkst;
 };
+
+void() SUB_Nop = // Since SUB_Null is used as 'no function'
+{ };
+
+float() SUB_True = { return 1; }; // Return a true value
+float() SUB_False = { return 0; }; // Return a false value
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/weapons.qc morph/weapons.qc
--- v101qc/weapons.qc	Thu Jul 25 01:51:24 1996
+++ morph/weapons.qc	Thu Aug 22 17:03:53 1996
@@ -22,6 +22,112 @@
 	precache_sound ("weapons/grenade.wav");	// grenade launcher
 	precache_sound ("weapons/bounce.wav");		// grenade bounce
 	precache_sound ("weapons/shotgn2.wav");	// super shotgun
+
+//// Zombie morph
+        precache_model ("progs/zombie.mdl");
+        precache_model ("progs/h_zombie.mdl");
+        precache_model ("progs/zom_gib.mdl");
+
+        precache_sound ("zombie/z_idle.wav");
+        precache_sound ("zombie/z_idle1.wav");
+        precache_sound ("zombie/z_shot1.wav");
+        precache_sound ("zombie/z_gib.wav");
+        precache_sound ("zombie/z_pain.wav");
+        precache_sound ("zombie/z_pain1.wav");
+        precache_sound ("zombie/z_fall.wav");
+        precache_sound ("zombie/z_miss.wav");
+        precache_sound ("zombie/z_hit.wav");
+        precache_sound ("zombie/idle_w2.wav");
+//// 
+
+//// Shalrath morph
+	precache_model2 ("progs/shalrath.mdl");
+	precache_model2 ("progs/h_shal.mdl");
+	precache_model2 ("progs/v_spike.mdl");
+	
+	precache_sound2 ("shalrath/attack.wav");
+	precache_sound2 ("shalrath/attack2.wav");
+	precache_sound2 ("shalrath/death.wav");
+	precache_sound2 ("shalrath/idle.wav");
+	precache_sound2 ("shalrath/pain.wav");
+	precache_sound2 ("shalrath/sight.wav");
+////
+
+//// Wizard morph
+	precache_model ("progs/wizard.mdl");
+	precache_model ("progs/h_wizard.mdl");
+	precache_model ("progs/w_spike.mdl");
+
+	precache_sound ("wizard/hit.wav");		// used by c code
+	precache_sound ("wizard/wattack.wav");
+	precache_sound ("wizard/wdeath.wav");
+	precache_sound ("wizard/widle1.wav");
+	precache_sound ("wizard/widle2.wav");
+	precache_sound ("wizard/wpain.wav");
+	precache_sound ("wizard/wsight.wav");
+////
+
+//// Hell knight morph
+	precache_model2 ("progs/hknight.mdl");
+	precache_model2 ("progs/k_spike.mdl");
+	precache_model2 ("progs/h_hellkn.mdl");
+
+	
+	precache_sound2 ("hknight/attack1.wav");
+	precache_sound2 ("hknight/death1.wav");
+	precache_sound2 ("hknight/pain1.wav");
+	precache_sound2 ("hknight/sight1.wav");
+	precache_sound ("hknight/hit.wav");		// used by C code, so don't sound2
+	precache_sound2 ("hknight/slash1.wav");
+	precache_sound2 ("hknight/idle.wav");
+	precache_sound2 ("hknight/grunt.wav");
+
+	precache_sound ("knight/sword1.wav");
+	precache_sound ("knight/sword2.wav");
+////
+
+//// Shambler morph
+	precache_model ("progs/shambler.mdl");
+	precache_model ("progs/s_light.mdl");
+	precache_model ("progs/h_shams.mdl");
+	precache_model ("progs/bolt.mdl");
+	
+	precache_sound ("shambler/sattck1.wav");
+	precache_sound ("shambler/sboom.wav");
+	precache_sound ("shambler/sdeath.wav");
+	precache_sound ("shambler/shurt2.wav");
+	precache_sound ("shambler/sidle.wav");
+	precache_sound ("shambler/ssight.wav");
+	precache_sound ("shambler/melee1.wav");
+	precache_sound ("shambler/melee2.wav");
+	precache_sound ("shambler/smack.wav");
+////
+
+//// Demon morph
+	precache_model ("progs/demon.mdl");
+	precache_model ("progs/h_demon.mdl");
+
+	precache_sound ("demon/ddeath.wav");
+	precache_sound ("demon/dhit2.wav");
+	precache_sound ("demon/djump.wav");
+	precache_sound ("demon/dpain1.wav");
+	precache_sound ("demon/idle1.wav");
+	precache_sound ("demon/sight2.wav");
+////
+
+//// Ogre morph
+	precache_model ("progs/ogre.mdl");
+	precache_model ("progs/h_ogre.mdl");
+	precache_model ("progs/grenade.mdl");
+
+	precache_sound ("ogre/ogdrag.wav");
+	precache_sound ("ogre/ogdth.wav");
+	precache_sound ("ogre/ogidle.wav");
+	precache_sound ("ogre/ogidle2.wav");
+	precache_sound ("ogre/ogpain1.wav");
+	precache_sound ("ogre/ogsawatk.wav");
+	precache_sound ("ogre/ogwake.wav");
+////
 };
 
 float() crandom =
@@ -884,6 +990,10 @@
 {
 	local	float	r;
 
+	if (self._attack != SUB_Null) {
+		self._attack();
+		return;
+	}
 	if (!W_CheckNoAmmo ())
 		return;
 
@@ -1158,8 +1268,22 @@
 
 ============
 */
+void() player_zombie_become;
+void() player_shalrath_become;
+void() player_human_become;
+void() player_wizard_become;
+void() player_hknight_become;
+void() player_shambler_become;
+void() player_demon_become;
+void() player_ogre_become;
+
 void() ImpulseCommands =
 {
+	if (self.impulse >= 1 && self.impulse <= 10 && self._impulse != SUB_Null) {
+		self._impulse();
+		return;
+	}
+
 	if (self.impulse >= 1 && self.impulse <= 8)
 		W_ChangeWeapon ();
 
@@ -1170,6 +1294,16 @@
 	if (self.impulse == 11)
 		ServerflagsCommand ();
 
+	if(self.impulse > 90 && self.impulse < 98) self.morphnum=self.impulse;
+	if (self.impulse == 90) player_human_become();
+	if (self.impulse == 91) player_zombie_become();
+	if (self.impulse == 92) player_shalrath_become();
+	if (self.impulse == 93) player_wizard_become();
+	if (self.impulse == 94) player_hknight_become();
+	if (self.impulse == 95) player_shambler_become();
+	if (self.impulse == 96) player_demon_become();
+	if (self.impulse == 97) player_ogre_become();
+	
 	if (self.impulse == 255)
 		QuadCheat ();
 		
