;-----------------------------------------------------------------------------
; Example code for Flat-Real mode routines.
; By NiX / MASSiVE

; This routine loads a file form disk into XMS memory using flat real mode,
; you can't do this directly, you must you a buffer in conventional memory.

; !!!!!!!!!!!!
; Don't forget to change the filename before trying it!
; !!!!!!!!!!!!

; Not much error correction present....

STAPEL SEGMENT STACK USE16 'Stack'
dw 200 dup(?)
ENDS

CODE SEGMENT USE16
Assume cs:code, ss:stapel

include flatmem.inc     ; Flat Real Mode routines

V86mess         db      "Error: V86 Mode present!",7,13,10,"$"
Himemmess       db      "Error: No HIMEM.SYS found!",7,13,10,"$"
NoFreeMem       db      "Error: Not enough free XMS memory!",7,13,10,"$"
Filemess        db      "Error: File not found!",7,13,10,"$"

Filename        db      "FILENAME.EXT",0 ; Put filename to load here...
Filehandle      dw      ?       ; Handle for file
Handle          dw      ?       ; XMS-handle
Bufseg          dw      ?       ; Segment adress for buffer
Filelength      dd      ?       ; To store length of file
Start:          mov     ax,4a00h
                mov     bx,Lastseg
                mov     cx,ds
                sub     bx,cx
                int     21h

                call    Set4Gig          ; Swap to Flat Real Mode
                jc      V86Error         ; If V86-Mode present give an error

                mov     ax,cs
                mov     ds,ax

                call    Himem_Init       ; Initialize HIMEM.SYS
                jc      NoHimem          ; No Himempresent?

                mov     dx,offset filename
                mov     ax,3d00h
                int     21h              ; Openfile
                jc      Fileerr
                mov     cs:Filehandle,ax

                xor     cx,cx            ; Read lenght of file
                xor     dx,dx            ;
                mov     bx,cs:Filehandle ;
                mov     ax,4202h         ;
                int     21h              ;

                shl     edx,16           ; EDX = 32 bit file length
                mov     dx,ax            ;
                mov     cs:Filelength,edx

                shr     edx,10           ; Calculate file length in KB
                inc     dx               ;
                call    Alloc_XMS        ; Allocate memory
                jc      NoFreeMemerr
                mov     cs:Handle,dx

                mov     bx,32768/16      ; Allocate 32Kb buffer to load file
                mov     ax,4800h         ;
                int     21h              ;
                mov     cs:Bufseg,ax     ;
                
                xor     cx,cx            ; Reset file pointer
                xor     dx,dx            ;
                mov     bx,cs:Filehandle ;
                mov     ax,4200h         ;
                int     21h              ;
                
                mov     dx,cs:Handle
                call    GetLinearAddress ; Get XMS adress

                call    EnableA20        ; Enable the A20-line
                mov     edi,edx

                xor     ax,ax            ; Set segment register to 0
                mov     gs,ax            ;
                
                mov     ecx,cs:Filelength ; Calculate number of times
                shr     ecx,15            ; to load 32Kb
                inc     cx                ;

                mov     ds,cs:Bufseg

Loadloop:       push    cx                 ; Load 32Kb
                xor     dx,dx              ;
                mov     cx,32768           ;
                mov     bx,cs:Filehandle   ;
                mov     ax,3f00h           ;
                int     21h                ;

                mov     cx,ax              ; Number of bytes read
                or      cx,cx
                jz      Nodata             ; If nothing is read then quit

                xor     si,si              ; Start of buffer
                
Moveloop:       mov     al,ds:byte ptr [si]    ; Move CX bytes to XMS
                mov     gs:byte ptr [edi],al
                inc     edi
                inc     si
                dec     cx
                jnz     Moveloop

                pop     cx
                dec     cx
                jnz     Loadloop

Nodata:                                 ; File is loaded know


                mov     es,cs:Bufseg    ; Deallocate buffer
                mov     ax,4900h
                int     21h

                mov     dx,cs:Handle    ; Deallocate XMS
                call    DAlloc_XMS

                mov     bx,cs:Filehandle
                mov     ax,3e00h
                int     21h

                mov     ax,4c00h
                int     21h

;-------------------------------------------------------------
; Error routines
V86error:       mov     dx,offset V86Mess
                mov     ah,9
                int     21h
                mov     ax,4c00h
                int     21h

Nohimem:        mov     dx,offset Himemmess
                mov     ah,9
                int     21h
                mov     ax,4c00h
                int     21h

Nofreememerr:   mov     dx,offset Nofreemem
                mov     ah,9
                int     21h
                mov     ax,4c00h
                int     21h

Fileerr:        mov     dx,offset Filemess
                mov     ah,9
                int     21h
                mov     ax,4c00h
                int     21h

ENDS

Lastseg segment use16
ends

End Start






