/* userfunc.c
   User FSCtl functions.
*/

#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>

#include <stdlib.h>

#include "fsd.h"
#include "userfunc.h"
#include "MacFS/LibFuncs/macreadwriteres.h"

/* Get the length of the resource fork of a file */
unsigned short hfs_resfork_size(struct sffsi *psffsi,
				struct sffsd *psffsd,
				unsigned long *size)
{
  if(psffsd->cr->cdrType == CDR_FILE)
    *size = psffsd->cr->U.cdrFilRec.filRLgLen;
  else
    *size = 0;
  return NO_ERROR;
}

/* Read bytes from the resource fork. Note that bytes must be at most 64K. */
unsigned short hfs_read_resfork(struct vpfsd *pvpfsd,
				struct sffsi *psffsi,
				struct sffsd *psffsd,
				unsigned long start,
				unsigned long *bytes,
				char *buf)
{
  unsigned short rc;
  LONGWORD bytes_read;
  char *tmp;

  if(psffsd->cr->cdrType != CDR_FILE)
    return ERROR_ACCESS_DENIED;

  /* Buffer is inaccessible to Ring 0, so we must use a temporary buffer */
  tmp=(char *)malloc(*bytes);
  if(!tmp) return ERROR_ACCESS_DENIED;
  rc = mread_res(pvpfsd->mr, psffsd->cr, start, *bytes, tmp, &bytes_read);
  memcpy(buf, tmp, *bytes);
  free(tmp);
  *bytes = bytes_read;
  if(rc)
    return ERROR_READ_FAULT;
  return NO_ERROR;
}
