/* r0struct.h
   Ring 0 structures
*/

#ifndef _R0STRUCT_H
#define _R0STRUCT_H

typedef unsigned long SEM;

typedef struct cpdata {
   /* Ring 0 is messing with the buffers */
   SEM BufLock;

   /* A command is in the buffers */
   SEM CmdReady;

   /* The results of a command are in the buffers */
   SEM CmdComplete;

   /* Pointer to the shared operation buffer */
   OPDATA *OpData;

   /* Pointer to the shared data buffer */
   void *Buf;
} CPDATA;

/*
#define MAXCPRDYWAIT (10*1000)
#define MAXCPRESWAIT (10*1000)
*/

#define MAXCPRDYWAIT -1
#define MAXCPRESWAIT -1

#endif /* _R0STRUCT_H */